/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.RequiredTimeTable;
import org.unitime.timetable.webutil.WebInstructionalOfferingTableBuilder;

public class PdfInstructionalOfferingTableBuilder
extends WebInstructionalOfferingTableBuilder {
    protected PdfWriter iWriter = null;
    protected Document iDocument = null;
    protected PdfPTable iPdfTable = null;
    protected static String indent = "    ";
    protected static String LABEL = " ";
    protected static Color sBorderColor = Color.BLACK;
    protected static Color sBgColorClass = Color.WHITE;
    protected static Color sBgColorSubpart = new Color(225, 225, 225);
    protected static Color sBgColorConfig = new Color(200, 200, 200);
    protected static Color sBgColorOffering = new Color(200, 200, 200);
    protected static Color sBgColorHeader = Color.WHITE;
    protected Color iBgColor = Color.WHITE;
    protected Color sEnableColor = Color.BLACK;
    protected Color sDisableColor = Color.GRAY;

    public PdfPCell createCell() {
        PdfPCell cell = new PdfPCell();
        cell.setBorderColor(sBorderColor);
        cell.setPadding(3.0f);
        cell.setBorderWidth(0.0f);
        cell.setVerticalAlignment(4);
        cell.setHorizontalAlignment(1);
        cell.setBackgroundColor(this.iBgColor);
        return cell;
    }

    public void addText(PdfPCell cell, String text) {
        this.addText(cell, text, false, false, 0, this.sEnableColor, true);
    }

    public void addText(PdfPCell cell, String text, boolean bold, int orientation) {
        this.addText(cell, text, bold, false, orientation, this.sEnableColor, true);
    }

    public void addText(PdfPCell cell, String text, int orientation) {
        this.addText(cell, text, false, false, orientation, this.sEnableColor, true);
    }

    public void addText(PdfPCell cell, String text, boolean bold, boolean italic, int orientation, Color color, boolean newLine) {
        if (text == null) {
            return;
        }
        if (cell.getPhrase() == null) {
            Chunk ch = new Chunk(text, PdfFont.getFont(bold, italic, color));
            cell.setPhrase((Phrase)new Paragraph(ch));
            cell.setVerticalAlignment(4);
            cell.setHorizontalAlignment(orientation);
        } else {
            cell.getPhrase().add((Object)new Chunk((newLine ? "\n" : "") + text, PdfFont.getFont(bold, italic, color)));
        }
    }

    public int getNrColumns() {
        int ret = 0;
        if (this.isShowLabel()) {
            ++ret;
        }
        if (this.isShowDivSec()) {
            ++ret;
        }
        if (this.isShowDemand()) {
            ++ret;
        }
        if (this.isShowProjectedDemand()) {
            ++ret;
        }
        if (this.isShowLimit()) {
            ++ret;
        }
        if (this.isShowSnapshotLimit()) {
            ++ret;
        }
        if (this.isShowRoomRatio()) {
            ++ret;
        }
        if (this.isShowManager()) {
            ++ret;
        }
        if (this.isShowDatePattern()) {
            ++ret;
        }
        if (this.isShowMinPerWk()) {
            ++ret;
        }
        if (this.isShowTimePattern()) {
            ++ret;
        }
        if (this.isShowPreferences() || this.getDisplayInstructorPrefs()) {
            ret += this.getPreferenceColumns();
        }
        if (this.isShowInstructorAssignment()) {
            ++ret;
        }
        if (this.isShowInstructor()) {
            ++ret;
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            ret += 3;
        }
        if (this.isShowTitle()) {
            ++ret;
        }
        if (this.isShowCredit()) {
            ++ret;
        }
        if (this.isShowSubpartCredit()) {
            ++ret;
        }
        if (this.isShowConsent()) {
            ++ret;
        }
        if (this.isShowSchedulePrintNote()) {
            ++ret;
        }
        if (this.isShowNote()) {
            ++ret;
        }
        if (this.isShowExam()) {
            if (this.isShowExamName()) {
                ++ret;
            }
            if (this.isShowExamTimetable()) {
                ret += 2;
            }
        }
        return ret;
    }

    public float[] getWidths() {
        float[] width = new float[this.getNrColumns()];
        int idx = 0;
        if (this.isShowLabel()) {
            width[idx++] = 175.0f;
        }
        if (this.isShowDivSec()) {
            width[idx++] = 80.0f;
        }
        if (this.isShowDemand()) {
            width[idx++] = 60.0f;
        }
        if (this.isShowProjectedDemand()) {
            width[idx++] = 65.0f;
        }
        if (this.isShowLimit()) {
            width[idx++] = 50.0f;
        }
        if (this.isShowSnapshotLimit()) {
            width[idx++] = 50.0f;
        }
        if (this.isShowRoomRatio()) {
            width[idx++] = 50.0f;
        }
        if (this.isShowManager()) {
            width[idx++] = 75.0f;
        }
        if (this.isShowDatePattern()) {
            width[idx++] = 100.0f;
        }
        if (this.isShowMinPerWk()) {
            width[idx++] = 60.0f;
        }
        if (this.isShowTimePattern()) {
            width[idx++] = 80.0f;
        }
        if (this.isShowPreferences()) {
            width[idx++] = this.getGridAsText() ? 200.0f : 100.0f;
            width[idx++] = 150.0f;
            if (this.getDisplayDistributionPrefs()) {
                width[idx++] = 200.0f;
            }
            if (this.getDisplayInstructorPrefs()) {
                width[idx++] = 150.0f;
                width[idx++] = 150.0f;
            }
        } else if (this.getDisplayInstructorPrefs()) {
            width[idx++] = 150.0f;
            width[idx++] = 150.0f;
        }
        if (this.isShowInstructorAssignment()) {
            width[idx++] = 100.0f;
        }
        if (this.isShowInstructor()) {
            width[idx++] = 200.0f;
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            width[idx++] = 130.0f;
            width[idx++] = 100.0f;
            width[idx++] = 70.0f;
        }
        if (this.isShowTitle()) {
            width[idx++] = 200.0f;
        }
        if (this.isShowCredit()) {
            width[idx++] = 100.0f;
        }
        if (this.isShowSubpartCredit()) {
            width[idx++] = 100.0f;
        }
        if (this.isShowConsent()) {
            width[idx++] = 100.0f;
        }
        if (this.isShowSchedulePrintNote()) {
            width[idx++] = 150.0f;
        }
        if (this.isShowNote()) {
            width[idx++] = 300.0f;
        }
        if (this.isShowExam()) {
            if (this.isShowExamName()) {
                width[idx++] = 120.0f;
            }
            if (this.isShowExamTimetable()) {
                width[idx++] = 120.0f;
                width[idx++] = 80.0f;
            }
        }
        return width;
    }

    protected void pdfBuildTableHeader(Long sessionId) {
        PdfPCell c3;
        PdfPCell c2;
        PdfPCell c1;
        PdfPCell c;
        this.iBgColor = sBgColorHeader;
        if (this.isShowLabel()) {
            c = this.createCell();
            this.addText(c, LABEL, true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowDivSec()) {
            c = this.createCell();
            this.addText(c, MSG.columnExternalId(), true, 2);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowDemand()) {
            c = this.createCell();
            if (StudentClassEnrollment.sessionHasEnrollments(sessionId)) {
                this.addText(c, MSG.columnDemand(), true, 2);
            } else {
                this.addText(c, MSG.columnLastDemand(), true, 2);
            }
            this.iPdfTable.addCell(c);
        }
        if (this.isShowProjectedDemand()) {
            c = this.createCell();
            this.addText(c, MSG.columnProjectedDemand(), true, 2);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowLimit()) {
            c = this.createCell();
            this.addText(c, MSG.columnLimit(), true, 2);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowSnapshotLimit()) {
            c = this.createCell();
            this.addText(c, MSG.columnSnapshotLimit(), true, 2);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowRoomRatio()) {
            c = this.createCell();
            this.addText(c, MSG.columnRoomRatio(), true, 2);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowManager()) {
            c = this.createCell();
            this.addText(c, MSG.columnManager(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowDatePattern()) {
            c = this.createCell();
            this.addText(c, MSG.columnDatePattern(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowMinPerWk()) {
            c = this.createCell();
            ClassDurationType dtype = ClassDurationType.findDefaultType(sessionId, null);
            this.addText(c, dtype == null ? MSG.columnMinPerWk() : dtype.getLabel(), true, 2);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowTimePattern()) {
            c = this.createCell();
            this.addText(c, MSG.columnTimePattern(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowPreferences() || this.getDisplayInstructorPrefs()) {
            c = this.createCell();
            c.setColspan(this.getPreferenceColumns());
            this.addText(c, "----" + MSG.columnPreferences() + "----", true, 1);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowInstructorAssignment()) {
            c = this.createCell();
            this.addText(c, MSG.columnTeachingLoad(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowInstructor()) {
            c = this.createCell();
            this.addText(c, MSG.columnInstructor(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            c = this.createCell();
            c.setColspan(3);
            this.addText(c, "--------" + MSG.columnTimetable() + "--------", true, 1);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowTitle()) {
            c = this.createCell();
            this.addText(c, MSG.columnTitle(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowCredit()) {
            c = this.createCell();
            this.addText(c, MSG.columnOfferingCredit(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowSubpartCredit()) {
            c = this.createCell();
            this.addText(c, MSG.columnSubpartCredit(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowConsent()) {
            c = this.createCell();
            this.addText(c, MSG.columnConsent(), true, 1);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowSchedulePrintNote()) {
            c = this.createCell();
            this.addText(c, MSG.columnSchedulePrintNote(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowNote()) {
            c = this.createCell();
            this.addText(c, MSG.columnNote(), true, 0);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowExam()) {
            c = this.createCell();
            c.setColspan((this.isShowExamName() ? 1 : 0) + (this.isShowExamTimetable() ? 2 : 0));
            this.addText(c, "--------" + MSG.columnExam() + "--------", true, 1);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowLabel()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowDivSec()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowDemand()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowProjectedDemand()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowLimit()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowSnapshotLimit()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowRoomRatio()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowManager()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowDatePattern()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowMinPerWk()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowTimePattern()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowPreferences()) {
            c1 = this.createCell();
            c1.setBorderWidthBottom(1.0f);
            this.addText(c1, MSG.columnTimePref(), true, 0);
            this.iPdfTable.addCell(c1);
            c2 = this.createCell();
            c2.setBorderWidthBottom(1.0f);
            this.addText(c2, MSG.columnAllRoomPref(), true, 0);
            this.iPdfTable.addCell(c2);
            if (this.getDisplayDistributionPrefs()) {
                c3 = this.createCell();
                c3.setBorderWidthBottom(1.0f);
                this.addText(c3, MSG.columnDistributionPref(), true, 0);
                this.iPdfTable.addCell(c3);
            }
        }
        if (this.getDisplayInstructorPrefs()) {
            PdfPCell c4 = this.createCell();
            c4.setBorderWidthBottom(1.0f);
            this.addText(c4, MSG.columnInstructorAttributePref(), true, 0);
            this.iPdfTable.addCell(c4);
            PdfPCell c5 = this.createCell();
            c5.setBorderWidthBottom(1.0f);
            this.addText(c5, MSG.columnInstructorPref(), true, 0);
            this.iPdfTable.addCell(c5);
        }
        if (this.isShowInstructorAssignment()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowInstructor()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            c1 = this.createCell();
            c1.setBorderWidthBottom(1.0f);
            this.addText(c1, MSG.columnAssignedTime(), true, 0);
            this.iPdfTable.addCell(c1);
            c2 = this.createCell();
            c2.setBorderWidthBottom(1.0f);
            this.addText(c2, MSG.columnAssignedRoom(), true, 0);
            this.iPdfTable.addCell(c2);
            c3 = this.createCell();
            c3.setBorderWidthBottom(1.0f);
            this.addText(c3, MSG.columnAssignedRoomCapacity(), true, 0);
            this.iPdfTable.addCell(c3);
        }
        if (this.isShowTitle()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowCredit()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowSubpartCredit()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowConsent()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowSchedulePrintNote()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowNote()) {
            c = this.createCell();
            c.setBorderWidthBottom(1.0f);
            this.iPdfTable.addCell(c);
        }
        if (this.isShowExam()) {
            if (this.isShowExamName()) {
                c = this.createCell();
                c.setBorderWidthBottom(1.0f);
                this.addText(c, MSG.columnExamName(), true, 0);
                this.iPdfTable.addCell(c);
            }
            if (this.isShowExamTimetable()) {
                c = this.createCell();
                c.setBorderWidthBottom(1.0f);
                this.addText(c, MSG.columnExamPeriod(), true, 0);
                this.iPdfTable.addCell(c);
                c = this.createCell();
                c.setBorderWidthBottom(1.0f);
                this.addText(c, MSG.columnExamRoom(), true, 0);
                this.iPdfTable.addCell(c);
            }
        }
        this.iPdfTable.setHeaderRows(2);
    }

    private PdfPCell pdfSubjectAndCourseInfo(InstructionalOffering io, CourseOffering co) {
        InstructionalMethod im;
        PdfPCell cell = this.createCell();
        this.addText(cell, co != null ? co.getSubjectAreaAbbv() + " " + co.getCourseNbr() : "", true, false, 0, co.isIsControl() != false ? this.sEnableColor : this.sDisableColor, true);
        InstructionalMethod instructionalMethod = im = co != null && co.getInstructionalOffering().getInstrOfferingConfigs().size() == 1 ? co.getInstructionalOffering().getInstrOfferingConfigs().iterator().next().getInstructionalMethod() : null;
        if (im != null) {
            if (co.getCourseType() != null) {
                this.addText(cell, " (" + co.getCourseType().getReference() + ", " + im.getReference() + ")", false, false, 0, co.isIsControl() != false ? this.sEnableColor : this.sDisableColor, false);
            } else {
                this.addText(cell, " (" + im.getReference() + ")", false, false, 0, co.isIsControl() != false ? this.sEnableColor : this.sDisableColor, false);
            }
        } else if (co.getCourseType() != null) {
            this.addText(cell, " (" + co.getCourseType().getReference() + ")", false, false, 0, co.isIsControl() != false ? this.sEnableColor : this.sDisableColor, false);
        }
        for (CourseOffering tempCo : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
            this.addText(cell, indent + "" + tempCo.getSubjectAreaAbbv() + " " + tempCo.getCourseNbr() + " " + (tempCo.getCourseType() != null ? " (" + tempCo.getCourseType().getReference() + ")" : ""), false, false, 0, this.sDisableColor, true);
        }
        return cell;
    }

    protected PdfPCell pdfBuildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, String indentSpaces, boolean isEditable, String prevLabel) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        String label = prefGroup.toString();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            label = aClass.getClassLabel(co);
        }
        if (prevLabel != null && label.equals(prevLabel)) {
            label = "";
        }
        PdfPCell cell = this.createCell();
        this.addText(cell, indentSpaces + label, false, false, 0, color, true);
        return cell;
    }

    protected PdfPCell pdfBuildDatePatternCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Assignment a = null;
        AssignmentPreferenceInfo p = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
                p = classAssignment.getAssignmentInfo((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        DatePattern dp = a != null ? a.getDatePattern() : prefGroup.effectiveDatePattern();
        PdfPCell cell = this.createCell();
        if (dp != null) {
            Color color = isEditable ? this.sEnableColor : this.sDisableColor;
            this.addText(cell, dp.getName(), false, false, 1, color, true);
            if (dp.getType() == 4 && isEditable) {
                boolean hasReq = false;
                for (Preference pref : prefGroup.effectivePreferences(DatePatternPref.class)) {
                    if (!PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog())) continue;
                    hasReq = true;
                    break;
                }
                for (Preference pref : prefGroup.effectivePreferences(DatePatternPref.class)) {
                    if (hasReq && !PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog())) continue;
                    this.addText(cell, pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText(), false, false, 1, !isEditable ? color : (p == null ? pref.getPrefLevel().awtPrefcolor() : PreferenceLevel.int2awtColor(p.getDatePatternPref(), color)), true);
                }
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildTimePatternCell(PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        for (TimePattern tp : prefGroup.effectiveTimePatterns()) {
            this.addText(cell, tp.getName(), false, false, 1, color, true);
        }
        if (prefGroup instanceof Class_ && prefGroup.effectiveTimePatterns().isEmpty()) {
            Class_ clazz = (Class_)prefGroup;
            DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            Integer ah = dm.getArrangedHours(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern());
            if (ah == null) {
                this.addText(cell, "Arr Hrs", false, false, 1, color, true);
            } else {
                this.addText(cell, "Arr " + ah + " Hrs", false, false, 1, color, true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildTimePrefCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        Assignment a = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        PdfPCell cell = this.createCell();
        for (TimePref tp : prefGroup.effectivePreferences(TimePref.class)) {
            RequiredTimeTable rtt = tp.getRequiredTimeTable(a == null ? null : a.getTimeLocation());
            if (this.getGridAsText()) {
                this.addText(cell, rtt.getModel().toString().replaceAll(", ", "\n"), false, false, 0, color, true);
                continue;
            }
            try {
                rtt.getModel().setDefaultSelection(this.getDefaultTimeGridSize());
                if (rtt.getModel().isExactTime()) {
                    this.addText(cell, rtt.exactTime(false), false, false, 0, color, true);
                    continue;
                }
                BufferedImage awtImage = rtt.createBufferedImage(this.getTimeVertival());
                Image img = Image.getInstance((java.awt.Image)awtImage, (Color)Color.WHITE);
                Chunk ck = new Chunk(img, 0.0f, 0.0f);
                if (cell.getPhrase() == null) {
                    cell.setPhrase((Phrase)new Paragraph(ck));
                    cell.setVerticalAlignment(4);
                    cell.setHorizontalAlignment(0);
                    continue;
                }
                cell.getPhrase().add((Object)ck);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildPreferenceCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, Class prefType, boolean isEditable) {
        Color color;
        if (!isEditable) {
            return this.createCell();
        }
        Color color2 = color = isEditable ? this.sEnableColor : this.sDisableColor;
        if (TimePref.class.equals((Object)prefType)) {
            return this.pdfBuildTimePrefCell(classAssignment, prefGroup, isEditable);
        }
        if (DistributionPref.class.equals((Object)prefType)) {
            PdfPCell cell = this.createCell();
            for (DistributionPref pref : prefGroup.effectivePreferences(prefType)) {
                this.addText(cell, pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText(true, true, " (", ", ", ")").replaceAll("&lt;", "<").replaceAll("&gt;", ">"), false, false, 0, !isEditable ? color : pref.getPrefLevel().awtPrefcolor(), true);
            }
            return cell;
        }
        PdfPCell cell = this.createCell();
        if (!prefGroup.isInstructorAssignmentNeeded() && (InstructorPref.class.equals((Object)prefType) || InstructorAttributePref.class.equals((Object)prefType))) {
            return cell;
        }
        for (Preference pref : prefGroup.effectivePreferences(prefType)) {
            this.addText(cell, pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText(), false, false, 0, !isEditable ? color : pref.getPrefLevel().awtPrefcolor(), true);
        }
        return cell;
    }

    private PdfPCell pdfBuildPreferenceCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, Class[] prefTypes, boolean isEditable) {
        if (!isEditable) {
            return this.createCell();
        }
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        boolean noRoomPrefs = false;
        if (prefGroup instanceof Class_ && ((Class_)prefGroup).getNbrRooms() == 0) {
            noRoomPrefs = true;
        }
        if (prefGroup instanceof SchedulingSubpart && ((SchedulingSubpart)prefGroup).getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            noRoomPrefs = true;
        }
        for (int i = 0; i < prefTypes.length; ++i) {
            Class prefType = prefTypes[i];
            if (noRoomPrefs && (prefType.equals(RoomGroupPref.class) || prefType.equals(RoomFeaturePref.class) || prefType.equals(BuildingPref.class))) continue;
            for (Preference pref : prefGroup.effectivePreferences(prefType)) {
                this.addText(cell, pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText(), false, false, 0, !isEditable ? color : pref.getPrefLevel().awtPrefcolor(), true);
            }
        }
        if (noRoomPrefs && cell.getPhrase() == null) {
            this.addText(cell, "N/A", false, true, 0, color, true);
        }
        return cell;
    }

    private PdfPCell pdfBuildPrefGroupDemand(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        if (prefGroup instanceof Class_ && StudentClassEnrollment.sessionHasEnrollments((c = (Class_)prefGroup).getSessionId())) {
            PdfPCell tc = this.createCell();
            if (c.getEnrollment() != null) {
                this.addText(tc, c.getEnrollment().toString());
            } else {
                this.addText(tc, "0");
            }
            tc.setHorizontalAlignment(2);
            return tc;
        }
        return this.createCell();
    }

    private PdfPCell pdfBuildPrefGroupProjectedDemand(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        SectioningInfo i;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_ && (i = (c = (Class_)prefGroup).getSectioningInfo()) != null && i.getNbrExpectedStudents() != null) {
            this.addText(cell, String.valueOf(Math.round(Math.max(0.0, (double)c.getEnrollment().intValue() + i.getNbrExpectedStudents()))));
            cell.setHorizontalAlignment(2);
        }
        return cell;
    }

    private PdfPCell pdfBuildLimit(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Class_ aClass;
        boolean unlimited;
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart ss = (SchedulingSubpart)prefGroup;
            boolean unlimited2 = ss.getInstrOfferingConfig().isUnlimitedEnrollment();
            if (!unlimited2) {
                int maxExpCap;
                int limit = ss.getLimit() == null ? 0 : ss.getLimit();
                if (limit == (maxExpCap = ss.getMaxExpectedCapacity())) {
                    this.addText(cell, String.valueOf(limit), false, false, 2, color, true);
                } else {
                    this.addText(cell, limit + "-" + maxExpCap, false, false, 2, color, true);
                }
            }
        } else if (prefGroup instanceof Class_ && !(unlimited = (aClass = (Class_)prefGroup).getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue())) {
            String limitString = null;
            Assignment a = null;
            try {
                if (classAssignment != null) {
                    a = classAssignment.getAssignment(aClass);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (a == null) {
                if (aClass.getExpectedCapacity() != null) {
                    limitString = aClass.getExpectedCapacity().toString();
                    if (aClass.getMaxExpectedCapacity() != null && !aClass.getMaxExpectedCapacity().equals(aClass.getExpectedCapacity())) {
                        limitString = limitString + "-" + aClass.getMaxExpectedCapacity().toString();
                    }
                } else {
                    limitString = "0";
                    if (aClass.getMaxExpectedCapacity() != null && aClass.getMaxExpectedCapacity() != 0) {
                        limitString = limitString + "-" + aClass.getMaxExpectedCapacity().toString();
                    }
                }
            } else {
                limitString = "" + aClass.getClassLimit(classAssignment);
            }
            this.addText(cell, limitString, false, false, 2, color, true);
        }
        return cell;
    }

    private PdfPCell pdfBuildSnapshotLimit(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ aClass;
        boolean unlimited;
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_ && !(unlimited = (aClass = (Class_)prefGroup).getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue())) {
            String limitString = null;
            limitString = aClass.getSnapshotLimit() == null ? "" : aClass.getSnapshotLimit().toString();
            this.addText(cell, limitString, false, false, 2, color, true);
        }
        return cell;
    }

    private PdfPCell pdfBuildDivisionSection(CourseOffering co, PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_) {
            String divSec;
            Class_ aClass = (Class_)prefGroup;
            String string = divSec = this.isShowOriginalDivSecs() ? aClass.getClassSuffix() : aClass.getClassSuffix(co);
            if (divSec != null) {
                this.addText(cell, divSec, false, false, 2, color, true);
            }
        }
        return cell;
    }

    protected PdfPCell pdfBuildInstructorAssignment(PreferenceGroup prefGroup, boolean isEditable) {
        SchedulingSubpart ss;
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_) {
            Class_ c = (Class_)prefGroup;
            if (c.isInstructorAssignmentNeeded()) {
                this.addText(cell, (c.effectiveNbrInstructors() > 1 ? c.effectiveNbrInstructors() + " \u00d7 " : "") + Formats.getNumberFormat("0.##").format(Float.valueOf(c.effectiveTeachingLoad())) + " " + MSG.teachingLoadUnits(), false, false, 2, color, false);
            } else if (c.getSchedulingSubpart().isInstructorAssignmentNeeded()) {
                this.addText(cell, MSG.cellNoInstructorAssignment(), false, false, 2, color, false);
            }
        } else if (prefGroup instanceof SchedulingSubpart && (ss = (SchedulingSubpart)prefGroup).isInstructorAssignmentNeeded()) {
            this.addText(cell, (ss.getNbrInstructors() > 1 ? ss.getNbrInstructors() + " \u00d7 " : "") + Formats.getNumberFormat("0.##").format(Float.valueOf(ss.getTeachingLoad())) + " " + MSG.teachingLoadUnits(), false, false, 2, color, false);
        }
        return cell;
    }

    protected PdfPCell pdfBuildInstructor(PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(new InstructorComparator());
            sortedInstructors.addAll(aClass.getClassInstructors());
            for (ClassInstructor ci : sortedInstructors) {
                String label = ci.getInstructor().getName(this.getInstructorNameFormat());
                if (ci.getResponsibility() != null && ci.getResponsibility().getAbbreviation() != null && !ci.getResponsibility().getAbbreviation().isEmpty()) {
                    label = label + " (" + ci.getResponsibility().getAbbreviation() + ")";
                }
                boolean italic = aClass.isDisplayInstructor() == false;
                boolean bold = ci.isLead();
                this.addText(cell, label, bold, italic, 0, color, true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildCredit(PreferenceGroup prefGroup, boolean isEditable) {
        SchedulingSubpart ss;
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof SchedulingSubpart && (ss = (SchedulingSubpart)prefGroup).getCredit() != null) {
            this.addText(cell, ss.getCredit().creditAbbv(), false, false, 0, color, true);
        }
        return cell;
    }

    private PdfPCell pdfBuildSchedulePrintNote(PreferenceGroup prefGroup, boolean isEditable, UserContext user) {
        Class_ c;
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_ && (c = (Class_)prefGroup).getSchedulePrintNote() != null) {
            String note = c.getSchedulePrintNote().replaceAll("\\<.*?\\>", "");
            if (note.length() <= 20 || user == null || CommonValues.NoteAsFullText.eq(user.getProperty(UserProperty.SchedulePrintNoteDisplay))) {
                this.addText(cell, note, false, false, 0, color, true);
            } else {
                this.addText(cell, note.substring(0, 20) + "...", false, false, 0, color, true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildSchedulePrintNote(InstructionalOffering io, boolean isEditable, UserContext user) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        StringBuffer note = new StringBuffer("");
        Set<CourseOffering> s = io.getCourseOfferings();
        for (CourseOffering coI : s) {
            String n;
            if (coI.getScheduleBookNote() == null || coI.getScheduleBookNote().trim().length() <= 0) continue;
            if (note.length() > 0) {
                note.append("\n");
            }
            if ((n = coI.getScheduleBookNote().replaceAll("\\<.*?\\>", "")).length() <= 20 || Constants.showCrsOffrAsFullText(user)) {
                note.append(n);
                continue;
            }
            note.append(n.substring(0, 20) + "...");
        }
        this.addText(cell, note.toString(), false, false, 0, color, true);
        return cell;
    }

    protected PdfPCell pdfBuildNote(PreferenceGroup prefGroup, boolean isEditable, UserContext user) {
        Class_ c;
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_ && (c = (Class_)prefGroup).getNotes() != null) {
            String note = c.getNotes().replaceAll("\\<.*?\\>", "");
            if (note.length() <= 30 || user == null || CommonValues.NoteAsFullText.eq(user.getProperty(UserProperty.ManagerNoteDisplay))) {
                this.addText(cell, note, false, false, 0, color, true);
            } else {
                this.addText(cell, note.substring(0, 30) + "...", false, false, 0, color, true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildNote(InstructionalOffering c, boolean isEditable, UserContext user) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (c.getNotes() != null) {
            String note = c.getNotes().replaceAll("\\<.*?\\>", "");
            if (note.length() <= 30 || user == null || CommonValues.NoteAsFullText.eq(user.getProperty(UserProperty.ManagerNoteDisplay))) {
                this.addText(cell, note, false, false, 0, color, true);
            } else {
                this.addText(cell, note.substring(0, 30) + "...", false, false, 0, color, true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildManager(PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        Department managingDept = null;
        if (prefGroup instanceof Class_) {
            managingDept = ((Class_)prefGroup).getManagingDept();
        } else if (prefGroup instanceof SchedulingSubpart) {
            managingDept = ((SchedulingSubpart)prefGroup).getManagingDept();
        }
        if (managingDept != null) {
            this.addText(cell, managingDept.getShortLabel(), false, false, 0, color, true);
        }
        return cell;
    }

    private PdfPCell pdfBuildMinPerWeek(PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            String suffix = "";
            ClassDurationType dtype = aClass.getSchedulingSubpart().getInstrOfferingConfig().getEffectiveDurationType();
            if (dtype != null && !dtype.equals(aClass.getSchedulingSubpart().getSession().getDefaultClassDurationType())) {
                suffix = " " + dtype.getAbbreviation();
            }
            this.addText(cell, aClass.getSchedulingSubpart().getMinutesPerWk() + suffix, false, false, 2, color, true);
        } else if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart aSchedulingSubpart = (SchedulingSubpart)prefGroup;
            String suffix = "";
            ClassDurationType dtype = aSchedulingSubpart.getInstrOfferingConfig().getEffectiveDurationType();
            if (dtype != null && !dtype.equals(aSchedulingSubpart.getSession().getDefaultClassDurationType())) {
                suffix = " " + dtype.getAbbreviation();
            }
            this.addText(cell, aSchedulingSubpart.getMinutesPerWk() + suffix, false, false, 2, color, true);
        }
        return cell;
    }

    private PdfPCell pdfBuildRoomLimit(PreferenceGroup prefGroup, boolean isEditable, boolean classLimitDisplayed) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            if (aClass.getNbrRooms() != null && aClass.getNbrRooms() != 1) {
                if (aClass.getNbrRooms() == 0) {
                    this.addText(cell, "N/A", false, true, 2, color, true);
                } else {
                    String text = aClass.getNbrRooms().toString();
                    text = text + " at ";
                    text = aClass.getRoomRatio() != null ? text + sRoomRatioFormat.format(aClass.getRoomRatio().floatValue()) : text + "0";
                    this.addText(cell, text, false, false, 2, color, true);
                }
            } else if (aClass.getRoomRatio() != null) {
                if (classLimitDisplayed && aClass.getRoomRatio().equals(new Float(1.0))) {
                    this.addText(cell, "", false, false, 2, color, true);
                } else {
                    this.addText(cell, sRoomRatioFormat.format(aClass.getRoomRatio().floatValue()), false, false, 2, color, true);
                }
            } else if (aClass.getExpectedCapacity() == null) {
                this.addText(cell, "", false, false, 2, color, true);
            } else {
                this.addText(cell, "0", false, false, 2, color, true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildAssignedTime(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            AssignmentPreferenceInfo p = null;
            try {
                a = classAssignment.getAssignment(aClass);
                p = classAssignment.getAssignmentInfo((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                Integer firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
                for (int i = 0; i < CONSTANTS.shortDays().length; ++i) {
                    int idx;
                    int n = idx = firstDay == null ? i : (i + firstDay) % 7;
                    if ((Constants.DAY_CODES[idx] & a.getTimeLocation().getDayCode()) == 0) continue;
                    sb.append(CONSTANTS.shortDays()[idx]);
                }
                sb.append(" ");
                sb.append(a.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()));
                sb.append("-");
                sb.append(a.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()));
                this.addText(cell, sb.toString(), false, false, 0, p == null || !isEditable ? color : PreferenceLevel.int2awtColor(p.getTimePreference(), color), true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildAssignedRoom(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            AssignmentPreferenceInfo p = null;
            try {
                a = classAssignment.getAssignment(aClass);
                p = classAssignment.getAssignmentInfo((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                Iterator<Location> it2 = a.getRooms().iterator();
                while (it2.hasNext()) {
                    Location room = it2.next();
                    sb.append(room.getLabel());
                    if (!it2.hasNext()) continue;
                    sb.append("\n");
                }
                this.addText(cell, sb.toString(), false, false, 0, p == null || !isEditable ? color : PreferenceLevel.int2awtColor(p.getTimePreference(), color), true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildAssignedRoomCapacity(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            try {
                a = classAssignment.getAssignment(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                Iterator<Location> it2 = a.getRooms().iterator();
                while (it2.hasNext()) {
                    sb.append(it2.next().getCapacity());
                    if (!it2.hasNext()) continue;
                    sb.append("\n");
                }
                this.addText(cell, sb.toString(), false, false, 0, color, true);
            }
        }
        return cell;
    }

    private PdfPCell pdfBuildExamName(TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            sb.append(exam.getLabel());
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        this.addText(cell, sb.toString(), false, false, 0, color, true);
        return cell;
    }

    private PdfPCell pdfBuildExamPeriod(ExamAssignmentProxy examAssignment, TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment ea = examAssignment.getAssignment(exam.getUniqueId());
                if (ea == null && !this.isShowExamName()) continue;
                sb.append(ea == null ? "" : ea.getPeriodAbbreviation());
            } else {
                if (exam.getAssignedPeriod() == null && !this.isShowExamName()) continue;
                sb.append(exam.getAssignedPeriod() == null ? "" : exam.getAssignedPeriod().getAbbreviation());
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        this.addText(cell, sb.toString(), false, false, 0, color, true);
        return cell;
    }

    private PdfPCell pdfBuildExamRoom(ExamAssignmentProxy examAssignment, TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment ea = examAssignment.getAssignment(exam.getUniqueId());
                if (ea == null && !this.isShowExamName()) continue;
                sb.append(ea == null ? "" : ea.getRoomsName(", "));
            } else {
                if (exam.getAssignedPeriod() == null && !this.isShowExamName()) continue;
                Iterator<Location> j = new TreeSet<Location>(exam.getAssignedRooms()).iterator();
                while (j.hasNext()) {
                    Location location = j.next();
                    sb.append(location.getLabel());
                    if (!j.hasNext()) continue;
                    sb.append(", ");
                }
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        this.addText(cell, sb.toString(), false, false, 0, color, true);
        return cell;
    }

    protected void pdfBuildClassOrSubpartRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, PreferenceGroup prefGroup, String indentSpaces, boolean isEditable, String prevLabel, SessionContext context) {
        boolean classLimitDisplayed = false;
        if (this.isShowLabel()) {
            this.iPdfTable.addCell(this.pdfBuildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, prevLabel));
        }
        if (this.isShowDivSec()) {
            this.iPdfTable.addCell(this.pdfBuildDivisionSection(co, prefGroup, isEditable));
        }
        if (this.isShowDemand()) {
            this.iPdfTable.addCell(this.pdfBuildPrefGroupDemand(prefGroup, isEditable));
        }
        if (this.isShowProjectedDemand()) {
            this.iPdfTable.addCell(this.pdfBuildPrefGroupProjectedDemand(prefGroup, isEditable));
        }
        if (this.isShowLimit()) {
            classLimitDisplayed = true;
            this.iPdfTable.addCell(this.pdfBuildLimit(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowSnapshotLimit()) {
            classLimitDisplayed = true;
            this.iPdfTable.addCell(this.pdfBuildSnapshotLimit(prefGroup, isEditable));
        }
        if (this.isShowRoomRatio()) {
            this.iPdfTable.addCell(this.pdfBuildRoomLimit(prefGroup, isEditable, classLimitDisplayed));
        }
        if (this.isShowManager()) {
            this.iPdfTable.addCell(this.pdfBuildManager(prefGroup, isEditable));
        }
        if (this.isShowDatePattern()) {
            this.iPdfTable.addCell(this.pdfBuildDatePatternCell(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowMinPerWk()) {
            this.iPdfTable.addCell(this.pdfBuildMinPerWeek(prefGroup, isEditable));
        }
        if (this.isShowTimePattern()) {
            this.iPdfTable.addCell(this.pdfBuildTimePatternCell(prefGroup, isEditable));
        }
        if (this.isShowPreferences()) {
            this.iPdfTable.addCell(this.pdfBuildPreferenceCell(classAssignment, prefGroup, TimePref.class, isEditable));
            this.iPdfTable.addCell(this.pdfBuildPreferenceCell(classAssignment, prefGroup, new Class[]{RoomPref.class, BuildingPref.class, RoomFeaturePref.class, RoomGroupPref.class}, isEditable));
            if (this.getDisplayDistributionPrefs()) {
                this.iPdfTable.addCell(this.pdfBuildPreferenceCell(classAssignment, prefGroup, DistributionPref.class, isEditable));
            }
        }
        if (this.getDisplayInstructorPrefs()) {
            this.iPdfTable.addCell(this.pdfBuildPreferenceCell(classAssignment, prefGroup, InstructorAttributePref.class, isEditable));
            this.iPdfTable.addCell(this.pdfBuildPreferenceCell(classAssignment, prefGroup, InstructorPref.class, isEditable));
        }
        if (this.isShowInstructorAssignment()) {
            this.iPdfTable.addCell(this.pdfBuildInstructorAssignment(prefGroup, isEditable));
        }
        if (this.isShowInstructor()) {
            this.iPdfTable.addCell(this.pdfBuildInstructor(prefGroup, isEditable));
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            this.iPdfTable.addCell(this.pdfBuildAssignedTime(classAssignment, prefGroup, isEditable));
            this.iPdfTable.addCell(this.pdfBuildAssignedRoom(classAssignment, prefGroup, isEditable));
            this.iPdfTable.addCell(this.pdfBuildAssignedRoomCapacity(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowTitle()) {
            this.iPdfTable.addCell(this.createCell());
        }
        if (this.isShowCredit()) {
            this.iPdfTable.addCell(this.createCell());
        }
        if (this.isShowSubpartCredit()) {
            this.iPdfTable.addCell(this.pdfBuildCredit(prefGroup, isEditable));
        }
        if (this.isShowConsent()) {
            this.iPdfTable.addCell(this.createCell());
        }
        if (this.isShowSchedulePrintNote()) {
            this.iPdfTable.addCell(this.pdfBuildSchedulePrintNote(prefGroup, isEditable, context.getUser()));
        }
        if (this.isShowNote()) {
            this.iPdfTable.addCell(this.pdfBuildNote(prefGroup, isEditable, context.getUser()));
        }
        if (this.isShowExam()) {
            TreeSet exams = new TreeSet();
            if (prefGroup instanceof Class_) {
                exams = this.getExams((Class_)prefGroup);
            }
            Iterator i = exams.iterator();
            while (i.hasNext()) {
                if (context.hasPermission(i.next(), Right.ExaminationView)) continue;
                i.remove();
            }
            if (this.isShowExamName()) {
                this.iPdfTable.addCell(this.pdfBuildExamName(exams, isEditable));
            }
            if (this.isShowExamTimetable()) {
                this.iPdfTable.addCell(this.pdfBuildExamPeriod(examAssignment, exams, isEditable));
                this.iPdfTable.addCell(this.pdfBuildExamRoom(examAssignment, exams, isEditable));
            }
        }
    }

    private void pdfBuildSchedulingSubpartRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, SchedulingSubpart ss, String indentSpaces, SessionContext context) {
        boolean isEditable = context.hasPermission(ss, Right.SchedulingSubpartDetail);
        this.iBgColor = sBgColorSubpart;
        this.pdfBuildClassOrSubpartRow(classAssignment, examAssignment, co, ss, indentSpaces, isEditable, null, context);
    }

    private void pdfBuildSchedulingSubpartRows(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, SchedulingSubpart ss, String indentSpaces, SessionContext context) {
        if (subpartIds != null) {
            subpartIds.add(ss.getUniqueId());
        }
        this.pdfBuildSchedulingSubpartRow(classAssignment, examAssignment, co, ss, indentSpaces, context);
        Set<SchedulingSubpart> childSubparts = ss.getChildSubparts();
        if (childSubparts != null && !childSubparts.isEmpty()) {
            ArrayList<SchedulingSubpart> childSubpartList = new ArrayList<SchedulingSubpart>(childSubparts);
            Collections.sort(childSubpartList, new SchedulingSubpartComparator());
            Iterator<SchedulingSubpart> it = childSubpartList.iterator();
            SchedulingSubpart child = null;
            while (it.hasNext()) {
                child = it.next();
                this.pdfBuildSchedulingSubpartRows(subpartIds, classAssignment, examAssignment, co, child, indentSpaces + indent, context);
            }
        }
    }

    protected void pdfBuildClassRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, int ct, CourseOffering co, Class_ aClass, String indentSpaces, SessionContext context, String prevLabel) {
        boolean isEditable = context.hasPermission(aClass, Right.ClassDetail);
        this.iBgColor = sBgColorClass;
        this.pdfBuildClassOrSubpartRow(classAssignment, examAssignment, co, aClass, indentSpaces, isEditable && aClass.isCancelled() == false, prevLabel, context);
    }

    private void pdfBuildClassRows(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, int ct, CourseOffering co, Class_ aClass, String indentSpaces, SessionContext context, String prevLabel) {
        this.pdfBuildClassRow(classAssignment, examAssignment, ct, co, aClass, indentSpaces, context, prevLabel);
        Set<Class_> childClasses = aClass.getChildClasses();
        if (childClasses != null && !childClasses.isEmpty()) {
            ArrayList<Class_> childClassesList = new ArrayList<Class_>(childClasses);
            Collections.sort(childClassesList, this.getClassComparator());
            Iterator<Class_> it = childClassesList.iterator();
            Class_ child = null;
            String previousLabel = aClass.htmlLabel();
            while (it.hasNext()) {
                child = it.next();
                this.pdfBuildClassRows(classAssignment, examAssignment, ct, co, child, indentSpaces + indent, context, previousLabel);
            }
        }
    }

    protected void pdfBuildConfigRow(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, InstrOfferingConfig ioc, SessionContext context, boolean printConfigLine) {
        this.iBgColor = sBgColorConfig;
        boolean isEditable = context.hasPermission(ioc.getInstructionalOffering(), Right.InstructionalOfferingDetail);
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        String configName = ioc.getName();
        boolean unlimited = ioc.isUnlimitedEnrollment();
        boolean hasConfig = false;
        if (printConfigLine) {
            PdfPCell cell;
            if (this.isShowLabel()) {
                if (configName == null || configName.trim().length() == 0) {
                    configName = ioc.getUniqueId().toString();
                }
                cell = this.createCell();
                this.addText(cell, indent + (ioc.getInstructionalMethod() == null ? MSG.labelConfiguration(configName) : MSG.labelConfigurationWithInstructionalMethod(configName, ioc.getInstructionalMethod().getReference())), false, false, 0, color, true);
                this.iPdfTable.addCell(cell);
            }
            if (this.isShowDivSec()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowDemand()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowProjectedDemand()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowLimit()) {
                cell = this.createCell();
                this.addText(cell, unlimited ? "inf" : ioc.getLimit().toString(), false, false, 2, color, true);
                this.iPdfTable.addCell(cell);
            }
            if (this.isShowSnapshotLimit()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowRoomRatio()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowManager()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowDatePattern()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowMinPerWk()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowTimePattern()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowPreferences() || this.getDisplayInstructorPrefs()) {
                for (int j = 0; j < this.getPreferenceColumns(); ++j) {
                    this.iPdfTable.addCell(this.createCell());
                }
            }
            if (this.isShowInstructorAssignment()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowInstructor()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.getDisplayTimetable() && this.isShowTimetable()) {
                this.iPdfTable.addCell(this.createCell());
                this.iPdfTable.addCell(this.createCell());
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowTitle()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowCredit()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowSubpartCredit()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowConsent()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowSchedulePrintNote()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowNote()) {
                this.iPdfTable.addCell(this.createCell());
            }
            if (this.isShowExam()) {
                TreeSet exams = new TreeSet(Exam.findAll(2, ioc.getUniqueId()));
                if (this.isShowExamName()) {
                    this.iPdfTable.addCell(this.pdfBuildExamName(exams, isEditable));
                }
                Iterator i = exams.iterator();
                while (i.hasNext()) {
                    if (context.hasPermission(i.next(), Right.ExaminationView)) continue;
                    i.remove();
                }
                if (this.isShowExamTimetable()) {
                    this.iPdfTable.addCell(this.pdfBuildExamPeriod(examAssignment, exams, isEditable));
                    this.iPdfTable.addCell(this.pdfBuildExamRoom(examAssignment, exams, isEditable));
                }
            }
            hasConfig = true;
        }
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        Iterator<SchedulingSubpart> it = subpartList.iterator();
        SchedulingSubpart ss = null;
        while (it.hasNext()) {
            ss = it.next();
            if (ss.getParentSubpart() != null) continue;
            this.pdfBuildSchedulingSubpartRows(subpartIds, classAssignment, examAssignment, co, ss, hasConfig ? indent + indent : indent, context);
        }
        it = subpartList.iterator();
        int ct = 0;
        String prevLabel = null;
        while (it.hasNext()) {
            ss = it.next();
            if (ss.getParentSubpart() != null || ss.getClasses() == null) continue;
            Vector<Class_> classes = new Vector<Class_>(ss.getClasses());
            Collections.sort(classes, this.getClassComparator());
            Iterator<Class_> cIt = classes.iterator();
            Class_ c = null;
            while (cIt.hasNext()) {
                c = cIt.next();
                this.pdfBuildClassRows(classAssignment, examAssignment, ++ct, co, c, indent, context, prevLabel);
                prevLabel = c.htmlLabel();
            }
        }
    }

    private void pdfBuildConfigRows(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, Set instrOfferingConfigs, SessionContext context, boolean printConfigLine) {
        Iterator it = instrOfferingConfigs.iterator();
        InstrOfferingConfig ioc = null;
        while (it.hasNext()) {
            ioc = (InstrOfferingConfig)it.next();
            this.pdfBuildConfigRow(null, classAssignment, examAssignment, co, ioc, context, printConfigLine && instrOfferingConfigs.size() > 1);
        }
    }

    private void pdfAddInstrOffrRowsToTable(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, InstructionalOffering io, Long subjectAreaId, SessionContext context) {
        PdfPCell cell;
        Iterator<InstrOfferingConfig> x;
        PdfPCell cell2;
        Color color;
        this.iBgColor = sBgColorOffering;
        CourseOffering co = io.findSortCourseOfferingForSubjectArea(subjectAreaId);
        boolean isEditable = context.hasPermission(co.getInstructionalOffering(), Right.InstructionalOfferingDetail);
        boolean isManagedAs = co.isIsControl() == false;
        Color color2 = color = isEditable ? this.sEnableColor : this.sDisableColor;
        if (this.isShowLabel()) {
            this.iPdfTable.addCell(this.pdfSubjectAndCourseInfo(io, co));
        }
        if (this.isShowDivSec()) {
            this.iPdfTable.addCell(this.createCell());
        }
        if (this.isShowDemand()) {
            cell2 = this.createCell();
            if (StudentClassEnrollment.sessionHasEnrollments(io.getSessionId())) {
                this.addText(cell2, io.getEnrollment() != null ? io.getEnrollment().toString() : "0", false, false, 2, co.isIsControl() != false ? color : this.sDisableColor, true);
            } else {
                this.addText(cell2, io.getDemand() != null ? io.getDemand().toString() : "0", false, false, 2, co.isIsControl() != false ? color : this.sDisableColor, true);
            }
            this.iPdfTable.addCell(cell2);
        }
        if (this.isShowProjectedDemand()) {
            cell2 = this.createCell();
            this.addText(cell2, io.getProjectedDemand() != null ? io.getProjectedDemand().toString() : "0", false, false, 2, co.isIsControl() != false ? color : this.sDisableColor, true);
            this.iPdfTable.addCell(cell2);
        }
        if (this.isShowLimit()) {
            boolean unlimited = false;
            x = io.getInstrOfferingConfigs().iterator();
            while (!unlimited && x.hasNext()) {
                if (!x.next().isUnlimitedEnrollment().booleanValue()) continue;
                unlimited = true;
            }
            cell = this.createCell();
            this.addText(cell, unlimited ? "inf" : (io.getLimit() == null ? "0" : io.getLimit().toString()), false, false, 2, co.isIsControl() != false ? color : this.sDisableColor, true);
            this.iPdfTable.addCell(cell);
        }
        if (this.isShowSnapshotLimit()) {
            boolean unlimited = false;
            x = io.getInstrOfferingConfigs().iterator();
            while (!unlimited && x.hasNext()) {
                if (!x.next().isUnlimitedEnrollment().booleanValue()) continue;
                unlimited = true;
            }
            cell = this.createCell();
            String limitText = null;
            limitText = unlimited ? "inf" : (io.getSnapshotLimit() == null ? "" : io.getSnapshotLimit().toString());
            this.addText(cell, limitText, false, false, 2, co.isIsControl() != false ? color : this.sDisableColor, true);
            this.iPdfTable.addCell(cell);
        }
        int emptyCels = 0;
        if (this.isShowRoomRatio()) {
            ++emptyCels;
        }
        if (this.isShowManager()) {
            ++emptyCels;
        }
        if (this.isShowDatePattern()) {
            ++emptyCels;
        }
        if (this.isShowMinPerWk()) {
            ++emptyCels;
        }
        if (this.isShowTimePattern()) {
            ++emptyCels;
        }
        if (this.isShowPreferences() || this.getDisplayInstructorPrefs()) {
            emptyCels += this.getPreferenceColumns();
        }
        if (this.isShowInstructorAssignment()) {
            ++emptyCels;
        }
        if (this.isShowInstructor()) {
            ++emptyCels;
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            emptyCels += 3;
        }
        if (emptyCels > 0) {
            PdfPCell managedCell = this.createCell();
            if (isManagedAs) {
                if (!this.isShowTitle()) {
                    if (co.getTitle() != null && co.getTitle().length() > 0) {
                        this.addText(managedCell, "     " + co.getTitle() + " (" + MSG.crossListManagedAs(io.getControllingCourseOffering().getCourseName()) + ")", true, false, 0, this.sDisableColor, false);
                    } else {
                        this.addText(managedCell, "     " + MSG.crossListManagedAs(io.getControllingCourseOffering().getCourseName()), true, false, 0, this.sDisableColor, true);
                    }
                    for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                        this.addText(managedCell, x2.getTitle() == null ? "" : "     " + x2.getTitle(), false, false, 0, this.sDisableColor, true);
                    }
                } else {
                    this.addText(managedCell, "     " + MSG.crossListManagedAs(io.getControllingCourseOffering().getCourseName()), true, false, 0, this.sDisableColor, true);
                }
            } else if (!this.isShowTitle()) {
                this.addText(managedCell, co.getTitle() == null ? "" : "      " + co.getTitle(), true, false, 0, color, true);
                for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                    this.addText(managedCell, x2.getTitle() == null ? "" : "      " + x2.getTitle(), false, false, 0, this.sDisableColor, true);
                }
            }
            managedCell.setColspan(emptyCels);
            this.iPdfTable.addCell(managedCell);
        }
        if (this.isShowTitle()) {
            PdfPCell titleCell = this.createCell();
            this.addText(titleCell, co.getTitle() != null ? "      " + co.getTitle() : "", false, false, 0, color, true);
            for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                this.addText(titleCell, x2.getTitle() != null ? "      " + x2.getTitle() : "", false, false, 0, this.sDisableColor, true);
            }
            this.iPdfTable.addCell(titleCell);
        }
        if (this.isShowCredit()) {
            cell = this.createCell();
            this.addText(cell, co.getCredit() != null ? co.getCredit().creditAbbv() : "", true, false, 0, isManagedAs ? this.sDisableColor : color, true);
            for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                this.addText(cell, x2.getCredit() != null ? x2.getCredit().creditAbbv() : "", false, false, 0, this.sDisableColor, true);
            }
            this.iPdfTable.addCell(cell);
        }
        if (this.isShowSubpartCredit()) {
            this.iPdfTable.addCell(this.createCell());
        }
        if (this.isShowConsent()) {
            cell = this.createCell();
            this.addText(cell, co.getConsentType() != null ? co.getConsentType().getAbbv() : MSG.noConsentRequired(), true, false, 0, isManagedAs ? this.sDisableColor : color, true);
            for (CourseOffering x2 : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                this.addText(cell, x2.getConsentType() != null ? x2.getConsentType().getAbbv() : MSG.noConsentRequired(), false, false, 0, this.sDisableColor, true);
            }
            this.iPdfTable.addCell(cell);
        }
        if (this.isShowSchedulePrintNote()) {
            this.iPdfTable.addCell(this.pdfBuildSchedulePrintNote(io, isEditable, context.getUser()));
        }
        if (this.isShowNote()) {
            this.iPdfTable.addCell(this.pdfBuildNote(io, isEditable, context.getUser()));
        }
        if (this.isShowExam()) {
            TreeSet exams = new TreeSet(Exam.findAll(0, io.getUniqueId()));
            for (CourseOffering cox : io.getCourseOfferings()) {
                exams.addAll(Exam.findAll(1, cox.getUniqueId()));
            }
            if (io.getInstrOfferingConfigs().size() == 1) {
                for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                    exams.addAll(Exam.findAll(2, ioc.getUniqueId()));
                }
            }
            Iterator<Serializable> i = exams.iterator();
            while (i.hasNext()) {
                if (context.hasPermission(i.next(), Right.ExaminationView)) continue;
                i.remove();
            }
            if (this.isShowExamName()) {
                this.iPdfTable.addCell(this.pdfBuildExamName(exams, isEditable));
            }
            if (this.isShowExamTimetable()) {
                this.iPdfTable.addCell(this.pdfBuildExamPeriod(examAssignment, exams, isEditable));
                this.iPdfTable.addCell(this.pdfBuildExamRoom(examAssignment, exams, isEditable));
            }
        }
        if (io.getInstrOfferingConfigs() != null & !io.getInstrOfferingConfigs().isEmpty()) {
            TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
            configs.addAll(io.getInstrOfferingConfigs());
            this.pdfBuildConfigRows(classAssignment, examAssignment, io.getControllingCourseOffering(), configs, context, true);
        }
    }

    public void pdfTableForInstructionalOffering(OutputStream out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, Long instructionalOfferingId, SessionContext context, Comparator classComparator) throws Exception {
        if (instructionalOfferingId != null && context != null) {
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(instructionalOfferingId);
            Long subjectAreaId = io.getControllingCourseOffering().getSubjectArea().getUniqueId();
            TreeSet<InstructionalOffering> ts = new TreeSet<InstructionalOffering>();
            ts.add(io);
            WebInstructionalOfferingTableBuilder iotbl = new WebInstructionalOfferingTableBuilder();
            iotbl.setDisplayDistributionPrefs(false);
            this.setVisibleColumns(this.COLUMNS);
            this.iDocument = new Document(PageSize.A4, 30.0f, 30.0f, 30.0f, 30.0f);
            this.iWriter = PdfEventHandler.initFooter(this.iDocument, out);
            this.pdfTableForInstructionalOfferings(out, classAssignment, examAssignment, ts, subjectAreaId, context, false, false, classComparator);
            this.iDocument.close();
        }
    }

    public void pdfTableForInstructionalOfferings(OutputStream out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, InstructionalOfferingListForm form, String[] subjectAreaIds, SessionContext context, boolean displayHeader, boolean allCoursesAreGiven) throws Exception {
        this.setVisibleColumns(form);
        this.iDocument = new Document(PageSize.A4, 30.0f, 30.0f, 30.0f, 30.0f);
        this.iWriter = PdfEventHandler.initFooter(this.iDocument, out);
        for (String subjectAreaId : subjectAreaIds) {
            this.pdfTableForInstructionalOfferings(out, classAssignment, examAssignment, form.getInstructionalOfferings(Long.valueOf(subjectAreaId)), Long.valueOf(subjectAreaId), context, displayHeader, allCoursesAreGiven, new ClassCourseComparator(form.getSortBy(), classAssignment, false));
        }
        this.iDocument.close();
    }

    protected void pdfTableForInstructionalOfferings(OutputStream out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TreeSet insructionalOfferings, Long subjectAreaId, SessionContext context, boolean displayHeader, boolean allCoursesAreGiven, Comparator classComparator) throws Exception {
        if (insructionalOfferings == null) {
            return;
        }
        SubjectArea subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(subjectAreaId);
        if (classComparator != null) {
            this.setClassComparator(classComparator);
        }
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                if (classAssignment instanceof CachedClassAssignmentProxy) {
                    Vector<Class_> allClasses = new Vector<Class_>();
                    Iterator i = insructionalOfferings.iterator();
                    while (!hasTimetable && i.hasNext()) {
                        InstructionalOffering io = (InstructionalOffering)i.next();
                        Iterator<InstrOfferingConfig> j = io.getInstrOfferingConfigs().iterator();
                        while (!hasTimetable && j.hasNext()) {
                            InstrOfferingConfig ioc = j.next();
                            Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                            while (!hasTimetable && k.hasNext()) {
                                SchedulingSubpart ss = k.next();
                                for (Class_ clazz : ss.getClasses()) {
                                    allClasses.add(clazz);
                                }
                            }
                        }
                    }
                    ((CachedClassAssignmentProxy)classAssignment).setCache(allClasses);
                    hasTimetable = !classAssignment.getAssignmentTable(allClasses).isEmpty();
                } else {
                    Iterator i = insructionalOfferings.iterator();
                    while (!hasTimetable && i.hasNext()) {
                        InstructionalOffering io = (InstructionalOffering)i.next();
                        Iterator<InstrOfferingConfig> j = io.getInstrOfferingConfigs().iterator();
                        while (!hasTimetable && j.hasNext()) {
                            InstrOfferingConfig ioc = j.next();
                            Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                            block6: while (!hasTimetable && k.hasNext()) {
                                SchedulingSubpart ss = k.next();
                                for (Class_ clazz : ss.getClasses()) {
                                    if (classAssignment.getAssignment(clazz) == null) continue;
                                    hasTimetable = true;
                                    continue block6;
                                }
                            }
                        }
                    }
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        if (this.isShowExam()) {
            this.setShowExamTimetable(examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId()));
        }
        ArrayList<InstructionalOffering> notOfferedOfferings = new ArrayList<InstructionalOffering>();
        ArrayList<InstructionalOffering> offeredOfferings = new ArrayList<InstructionalOffering>();
        ArrayList<Long> offeringIds = new ArrayList<Long>();
        Iterator it = insructionalOfferings.iterator();
        InstructionalOffering io2 = null;
        boolean hasOfferedCourses = false;
        boolean hasNotOfferedCourses = false;
        this.setUserSettings(context.getUser());
        while (it.hasNext()) {
            io2 = (InstructionalOffering)it.next();
            if (io2.isNotOffered() == null || io2.isNotOffered().booleanValue()) {
                hasNotOfferedCourses = true;
                notOfferedOfferings.add(io2);
                continue;
            }
            hasOfferedCourses = true;
            offeredOfferings.add(io2);
        }
        float[] widths = this.getWidths();
        float totalWidth = 0.0f;
        for (int i = 0; i < widths.length; ++i) {
            totalWidth += widths[i];
        }
        this.iDocument.setPageSize(new Rectangle(60.0f + totalWidth, 60.0f + 0.77f * totalWidth));
        if (hasOfferedCourses || allCoursesAreGiven) {
            this.iPdfTable = new PdfPTable(this.getWidths());
            this.iPdfTable.setWidthPercentage(100.0f);
            this.iPdfTable.getDefaultCell().setPadding(3.0f);
            this.iPdfTable.getDefaultCell().setBorderWidth(0.0f);
            this.iPdfTable.setSplitRows(false);
            if (displayHeader) {
                if (!this.iDocument.isOpen()) {
                    this.iDocument.open();
                } else {
                    this.iDocument.newPage();
                }
                this.iDocument.add((Element)new Paragraph(MSG.labelOfferedCourses(subjectArea.getSubjectAreaAbbreviation()), PdfFont.getBigFont(true)));
            }
            this.pdfBuildTableHeader(context.getUser().getCurrentAcademicSessionId());
            if (hasOfferedCourses) {
                for (InstructionalOffering io2 : offeredOfferings) {
                    offeringIds.add(io2.getUniqueId());
                    this.pdfAddInstrOffrRowsToTable(classAssignment, examAssignment, io2, subjectAreaId, context);
                }
            } else if (displayHeader) {
                this.iDocument.add((Element)new Paragraph(MSG.errorNoCoursesOffered(subjectArea.getSubjectAreaAbbreviation()), PdfFont.getFont(true, false, Color.RED)));
            }
            this.iDocument.add((Element)this.iPdfTable);
        }
        if (hasNotOfferedCourses || allCoursesAreGiven) {
            this.iPdfTable = new PdfPTable(this.getWidths());
            this.iPdfTable.setWidthPercentage(100.0f);
            this.iPdfTable.getDefaultCell().setPadding(3.0f);
            this.iPdfTable.getDefaultCell().setBorderWidth(0.0f);
            this.iPdfTable.setSplitRows(false);
            if (displayHeader) {
                this.iDocument.newPage();
                this.iDocument.add((Element)new Paragraph(MSG.labelNotOfferedCourses(subjectArea.getSubjectAreaAbbreviation()), PdfFont.getBigFont(true)));
            }
            this.pdfBuildTableHeader(context.getUser().getCurrentAcademicSessionId());
            if (hasNotOfferedCourses) {
                for (InstructionalOffering io2 : notOfferedOfferings) {
                    offeringIds.add(io2.getUniqueId());
                    this.pdfAddInstrOffrRowsToTable(classAssignment, examAssignment, io2, subjectAreaId, context);
                }
            } else if (displayHeader) {
                this.iDocument.add((Element)new Paragraph(MSG.errorAllCoursesOffered(subjectArea.getSubjectAreaAbbreviation()), PdfFont.getFont()));
            }
            this.iDocument.add((Element)this.iPdfTable);
        }
    }
}

