/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.unitime.commons.Email;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ExamPdfReportForm;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.reports.exam.StudentExamReport;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.queue.QueueItem;

public class PdfExamReportQueueItem
extends QueueItem {
    private static final long serialVersionUID = 1L;
    public static String TYPE = "PDF Exam Report";
    private ExamPdfReportForm iForm;
    private String iUrl = null;
    private transient ExamSolverProxy iExamSolver;
    private String iName = null;
    private double iProgress = 0.0;
    private boolean iSubjectIndependent = false;

    public PdfExamReportQueueItem(Session session, UserContext owner, ExamPdfReportForm form, HttpServletRequest request, ExamSolverProxy examSolver) {
        super(session, owner);
        int i;
        this.iForm = form;
        this.iUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.iExamSolver = examSolver;
        this.iName = ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getLabel() + " ";
        for (i = 0; i < this.iForm.getReports().length; ++i) {
            if (i > 0) {
                this.iName = this.iName + ", ";
            }
            this.iName = this.iName + this.iForm.getReports()[i];
        }
        if (!this.iForm.getAll()) {
            this.iName = this.iName + " (";
            for (i = 0; i < this.iForm.getSubjects().length; ++i) {
                SubjectArea subject = (SubjectArea)new SubjectAreaDAO().get(Long.valueOf(this.iForm.getSubjects()[i]));
                if (i > 0) {
                    this.iName = this.iName + ", ";
                }
                this.iName = this.iName + subject.getSubjectAreaAbbreviation();
            }
            this.iName = this.iName + ")";
        }
        this.iSubjectIndependent = owner == null || owner.getCurrentAuthority() == null ? false : owner.getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        this.iForm.setSubjectAreas(SubjectArea.getUserSubjectAreas(owner, false));
    }

    @Override
    public void execute() {
        org.hibernate.Session hibSession = ExamDAO.getInstance().getSession();
        this.createReports(hibSession);
        if (hibSession.isOpen()) {
            hibSession.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createReports(org.hibernate.Session hibSession) {
        try {
            this.iProgress = 0.0;
            this.setStatus("Loading exams...");
            TreeSet<ExamAssignmentInfo> exams = null;
            if (this.iExamSolver != null && this.iExamSolver.getExamTypeId().equals(this.iForm.getExamType()) && ApplicationProperty.ExaminationPdfReportsCanUseSolution.isTrue()) {
                exams = new TreeSet<ExamAssignmentInfo>(this.iExamSolver.getAssignedExams());
                if (this.iForm.getIgnoreEmptyExams()) {
                    Iterator<ExamAssignmentInfo> i = exams.iterator();
                    while (i.hasNext()) {
                        if (!i.next().getStudentIds().isEmpty()) continue;
                        i.remove();
                    }
                }
                if (ApplicationProperty.ExaminationPdfReportsPreloadCrosslistedExams.isTrue()) {
                    Set<Long> studentsOfCourse;
                    Hashtable<Object, Object> course2students;
                    Long courseId;
                    Long studentId;
                    Long ownerId;
                    this.setStatus("  Fetching exams...");
                    hibSession.createQuery("select o from Exam x inner join x.owners o where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setCacheable(true).list();
                    this.setStatus("  Fetching related objects (class)...");
                    hibSession.createQuery("select c from Class_ c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:classType and c.uniqueId=o.ownerId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setInteger("classType", 3).setCacheable(true).list();
                    this.setStatus("  Fetching related objects (config)...");
                    hibSession.createQuery("select c from InstrOfferingConfig c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:configType and c.uniqueId=o.ownerId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setInteger("configType", 2).setCacheable(true).list();
                    this.setStatus("  Fetching related objects (course)...");
                    hibSession.createQuery("select c from CourseOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:courseType and c.uniqueId=o.ownerId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setInteger("courseType", 1).setCacheable(true).list();
                    this.setStatus("  Fetching related objects (offering)...");
                    hibSession.createQuery("select c from InstructionalOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:offeringType and c.uniqueId=o.ownerId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setInteger("offeringType", 0).setCacheable(true).list();
                    Hashtable<Long, Hashtable<Long, Set<Long>>> owner2course2students = new Hashtable<Long, Hashtable<Long, Set<Long>>>();
                    this.setStatus("  Loading students (class)...");
                    for (Object[] o : hibSession.createQuery("select o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=3 and o.ownerId=c.uniqueId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setCacheable(true).list()) {
                        ownerId = (Long)o[0];
                        studentId = (Long)o[1];
                        courseId = (Long)o[2];
                        course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
                        if (course2students == null) {
                            course2students = new Hashtable<Long, HashSet<Long>>();
                            owner2course2students.put(ownerId, course2students);
                        }
                        if ((studentsOfCourse = (HashSet<Long>)course2students.get(courseId)) == null) {
                            studentsOfCourse = new HashSet<Long>();
                            course2students.put(courseId, studentsOfCourse);
                        }
                        studentsOfCourse.add(studentId);
                    }
                    this.setStatus("  Loading students (config)...");
                    for (Object[] o : hibSession.createQuery("select o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c inner join c.schedulingSubpart.instrOfferingConfig ioc where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=2 and o.ownerId=ioc.uniqueId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setCacheable(true).list()) {
                        ownerId = (Long)o[0];
                        studentId = (Long)o[1];
                        courseId = (Long)o[2];
                        course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
                        if (course2students == null) {
                            course2students = new Hashtable<Long, HashSet<Long>>();
                            owner2course2students.put(ownerId, course2students);
                        }
                        if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                            studentsOfCourse = new HashSet();
                            course2students.put(courseId, studentsOfCourse);
                        }
                        studentsOfCourse.add(studentId);
                    }
                    this.setStatus("  Loading students (course)...");
                    for (Object[] o : hibSession.createQuery("select o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering co where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=1 and o.ownerId=co.uniqueId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setCacheable(true).list()) {
                        ownerId = (Long)o[0];
                        studentId = (Long)o[1];
                        courseId = (Long)o[2];
                        course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
                        if (course2students == null) {
                            course2students = new Hashtable<Long, HashSet<Long>>();
                            owner2course2students.put(ownerId, course2students);
                        }
                        if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                            studentsOfCourse = new HashSet();
                            course2students.put(courseId, studentsOfCourse);
                        }
                        studentsOfCourse.add(studentId);
                    }
                    this.setStatus("  Loading students (offering)...");
                    for (Object[] o : hibSession.createQuery("select o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering.instructionalOffering io where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=0 and o.ownerId=io.uniqueId").setLong("sessionId", this.iExamSolver.getSessionId().longValue()).setLong("examTypeId", this.iExamSolver.getExamTypeId().longValue()).setCacheable(true).list()) {
                        ownerId = (Long)o[0];
                        studentId = (Long)o[1];
                        courseId = (Long)o[2];
                        course2students = owner2course2students.get(ownerId);
                        if (course2students == null) {
                            course2students = new Hashtable();
                            owner2course2students.put(ownerId, course2students);
                        }
                        if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                            studentsOfCourse = new HashSet();
                            course2students.put(courseId, studentsOfCourse);
                        }
                        studentsOfCourse.add(studentId);
                    }
                    for (ExamAssignmentInfo exam : exams) {
                        exam.createSectionsIncludeCrosslistedDummies(owner2course2students);
                    }
                }
            } else {
                exams = PdfLegacyExamReport.loadExams(this.getSessionId(), this.iForm.getExamType(), true, this.iForm.getIgnoreEmptyExams(), true);
            }
            this.iProgress = 0.1;
            Hashtable<String, File> output = new Hashtable<String, File>();
            Hashtable<SubjectArea, Hashtable<String, File>> outputPerSubject = new Hashtable<SubjectArea, Hashtable<String, File>>();
            Hashtable<ExamInfo.ExamInstructorInfo, File> ireports = null;
            Hashtable<Student, File> sreports = null;
            Session session = this.getSession();
            for (int i = 0; i < this.iForm.getReports().length; ++i) {
                void var12_20;
                this.iProgress = 0.1 + 0.8 / (double)this.iForm.getReports().length * (double)i;
                this.setStatus("Generating " + this.iForm.getReports()[i] + "...");
                Class reportClass = ExamPdfReportForm.sRegisteredReports.get(this.iForm.getReports()[i]);
                String reportName = null;
                for (Map.Entry<String, Class> entry : PdfLegacyExamReport.sRegisteredReports.entrySet()) {
                    if (!entry.getValue().equals(reportClass)) continue;
                    reportName = entry.getKey();
                }
                if (reportName == null) {
                    reportName = "r" + (i + 1);
                }
                String name = session.getAcademicTerm() + session.getSessionStartYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + "_" + reportName;
                if (this.iForm.getAll()) {
                    File file = ApplicationProperties.getTempFile(name, this.iForm.getModeIdx() == 2 ? "txt" : "pdf");
                    this.log("&nbsp;&nbsp;Writing <a href='temp/" + file.getName() + "'>" + reportName + "." + (this.iForm.getModeIdx() == 2 ? "txt" : "pdf") + "</a>... " + (this.iSubjectIndependent ? " (" + exams.size() + " exams)" : ""));
                    PdfLegacyExamReport report = (PdfLegacyExamReport)reportClass.getConstructor(Integer.TYPE, File.class, Session.class, ExamType.class, Collection.class, Collection.class).newInstance(this.iForm.getModeIdx(), file, new SessionDAO().get(session.getUniqueId()), ExamTypeDAO.getInstance().get(this.iForm.getExamType()), this.iSubjectIndependent ? null : this.iForm.getSubjectAreas(), exams);
                    report.setDirect(this.iForm.getDirect());
                    report.setM2d(this.iForm.getM2d());
                    report.setBtb(this.iForm.getBtb());
                    report.setDispRooms(this.iForm.getDispRooms());
                    report.setNoRoom(this.iForm.getNoRoom());
                    report.setTotals(this.iForm.getTotals());
                    report.setLimit(this.iForm.getLimit() == null || this.iForm.getLimit().length() == 0 ? -1 : Integer.parseInt(this.iForm.getLimit()));
                    report.setRoomCode(this.iForm.getRoomCodes());
                    report.setDispLimits(this.iForm.getDispLimit());
                    report.setSince(this.iForm.getSince() == null || this.iForm.getSince().length() == 0 ? null : Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT).parse(this.iForm.getSince()));
                    report.setItype(this.iForm.getItype());
                    report.setClassSchedule(this.iForm.getClassSchedule());
                    report.setDispNote(this.iForm.getDispNote());
                    report.setCompact(this.iForm.getCompact());
                    report.setUseRoomDisplayNames(this.iForm.getRoomDispNames());
                    report.printReport();
                    report.close();
                    output.put(reportName + "." + (this.iForm.getModeIdx() == 2 ? "txt" : "pdf"), file);
                    if (report instanceof InstructorExamReport && this.iForm.getEmailInstructors()) {
                        ireports = ((InstructorExamReport)report).printInstructorReports(this.iForm.getModeIdx(), name, new FileGenerator(name));
                        continue;
                    }
                    if (!(report instanceof StudentExamReport) || !this.iForm.getEmailStudents()) continue;
                    sreports = ((StudentExamReport)report).printStudentReports(this.iForm.getModeIdx(), name, new FileGenerator(name));
                    continue;
                }
                boolean bl = false;
                while (var12_20 < this.iForm.getSubjects().length) {
                    SubjectArea subject = (SubjectArea)new SubjectAreaDAO().get(Long.valueOf(this.iForm.getSubjects()[var12_20]));
                    File file = ApplicationProperties.getTempFile((String)name + "_" + subject.getSubjectAreaAbbreviation(), this.iForm.getModeIdx() == 2 ? "txt" : "pdf");
                    int nrExams = 0;
                    for (ExamAssignmentInfo exam : exams) {
                        if (!exam.isOfSubjectArea(subject)) continue;
                        ++nrExams;
                    }
                    this.log("&nbsp;&nbsp;Writing <a href='temp/" + file.getName() + "'>" + subject.getSubjectAreaAbbreviation() + "_" + reportName + "." + (this.iForm.getModeIdx() == 2 ? "txt" : "pdf") + "</a>... (" + nrExams + " exams)");
                    ArrayList<SubjectArea> arrayList = new ArrayList<SubjectArea>();
                    arrayList.add(subject);
                    PdfLegacyExamReport report = (PdfLegacyExamReport)reportClass.getConstructor(Integer.TYPE, File.class, Session.class, ExamType.class, Collection.class, Collection.class).newInstance(this.iForm.getModeIdx(), file, new SessionDAO().get(session.getUniqueId()), ExamTypeDAO.getInstance().get(this.iForm.getExamType()), arrayList, exams);
                    report.setDirect(this.iForm.getDirect());
                    report.setM2d(this.iForm.getM2d());
                    report.setBtb(this.iForm.getBtb());
                    report.setDispRooms(this.iForm.getDispRooms());
                    report.setNoRoom(this.iForm.getNoRoom());
                    report.setTotals(this.iForm.getTotals());
                    report.setLimit(this.iForm.getLimit() == null || this.iForm.getLimit().length() == 0 ? -1 : Integer.parseInt(this.iForm.getLimit()));
                    report.setRoomCode(this.iForm.getRoomCodes());
                    report.setDispLimits(this.iForm.getDispLimit());
                    report.setItype(this.iForm.getItype());
                    report.setClassSchedule(this.iForm.getClassSchedule());
                    report.setDispNote(this.iForm.getDispNote());
                    report.setCompact(this.iForm.getCompact());
                    report.setUseRoomDisplayNames(this.iForm.getRoomDispNames());
                    report.printReport();
                    report.close();
                    output.put(subject.getSubjectAreaAbbreviation() + "_" + reportName + "." + (this.iForm.getModeIdx() == 2 ? "txt" : "pdf"), file);
                    Hashtable<String, File> files = (Hashtable<String, File>)outputPerSubject.get(subject);
                    if (files == null) {
                        files = new Hashtable<String, File>();
                        outputPerSubject.put(subject, files);
                    }
                    files.put(subject.getSubjectAreaAbbreviation() + "_" + reportName + "." + (this.iForm.getModeIdx() == 2 ? "txt" : "pdf"), file);
                    if (report instanceof InstructorExamReport && this.iForm.getEmailInstructors()) {
                        ireports = ((InstructorExamReport)report).printInstructorReports(this.iForm.getModeIdx(), name, new FileGenerator(name));
                    } else if (report instanceof StudentExamReport && this.iForm.getEmailStudents()) {
                        sreports = ((StudentExamReport)report).printStudentReports(this.iForm.getModeIdx(), name, new FileGenerator(name));
                    }
                    ++var12_20;
                }
            }
            this.iProgress = 0.9;
            byte[] buffer = new byte[32768];
            int len = 0;
            if (output.isEmpty()) {
                this.log("<font color='orange'>No report generated.</font>");
            } else if (this.iForm.getEmail()) {
                String email;
                Email mail;
                this.setStatus("Sending email(s)...");
                if (this.iForm.getEmailDeputies()) {
                    Hashtable files2send = new Hashtable();
                    for (Map.Entry entry : outputPerSubject.entrySet()) {
                        if (((SubjectArea)entry.getKey()).getDepartment().getTimetableManagers().isEmpty()) {
                            this.log("<font color='orange'>&nbsp;&nbsp;No manager associated with subject area " + ((SubjectArea)entry.getKey()).getSubjectAreaAbbreviation() + " (" + ((SubjectArea)entry.getKey()).getDepartment().getLabel() + ")</font>");
                        }
                        for (TimetableManager g : ((SubjectArea)entry.getKey()).getDepartment().getTimetableManagers()) {
                            void var16_44;
                            boolean receiveEmail = true;
                            for (ManagerRole mr : g.getManagerRoles()) {
                                if (mr.getRole().hasRight(Right.DepartmentIndependent)) continue;
                                receiveEmail = mr.isReceiveEmails() == null ? false : mr.isReceiveEmails();
                                break;
                            }
                            if (!receiveEmail) continue;
                            if (g.getEmailAddress() == null || g.getEmailAddress().length() == 0) {
                                this.log("<font color='orange'>&nbsp;&nbsp;Manager " + g.getName() + " has no email address.</font>");
                                continue;
                            }
                            Hashtable hashtable = (Hashtable)files2send.get(g);
                            if (hashtable == null) {
                                Hashtable hashtable2 = new Hashtable();
                                files2send.put(g, hashtable2);
                            }
                            var16_44.putAll((Map)entry.getValue());
                        }
                    }
                    if (files2send.isEmpty()) {
                        this.log("<font color='red'>Nothing to send.</font>");
                    } else {
                        Set managers = files2send.keySet();
                        while (!managers.isEmpty()) {
                            TimetableManager timetableManager = (TimetableManager)managers.iterator().next();
                            Hashtable files = (Hashtable)files2send.get(timetableManager);
                            managers.remove(timetableManager);
                            this.log("Sending email to " + timetableManager.getName() + " (" + timetableManager.getEmailAddress() + ")...");
                            try {
                                Object s;
                                mail = Email.createEmail();
                                mail.setSubject(this.iForm.getSubject() == null ? "Examination Report" : this.iForm.getSubject());
                                mail.setText((this.iForm.getMessage() == null ? "" : this.iForm.getMessage() + "\r\n\r\n") + "For an up-to-date examination report, please visit " + this.iUrl + "/\r\n\r\nThis email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                                mail.addRecipient(timetableManager.getEmailAddress(), timetableManager.getName());
                                Iterator i = managers.iterator();
                                while (i.hasNext()) {
                                    TimetableManager timetableManager2 = (TimetableManager)i.next();
                                    if (!files.equals(files2send.get(timetableManager2))) continue;
                                    this.log("&nbsp;&nbsp;Including " + timetableManager2.getName() + " (" + timetableManager2.getEmailAddress() + ")");
                                    mail.addRecipient(timetableManager2.getEmailAddress(), timetableManager2.getName());
                                    i.remove();
                                }
                                if (this.iForm.getAddress() != null) {
                                    s = new StringTokenizer(this.iForm.getAddress(), ";,\n\r ");
                                    while (((StringTokenizer)s).hasMoreTokens()) {
                                        mail.addRecipient(((StringTokenizer)s).nextToken(), null);
                                    }
                                }
                                if (this.iForm.getCc() != null) {
                                    s = new StringTokenizer(this.iForm.getCc(), ";,\n\r ");
                                    while (((StringTokenizer)s).hasMoreTokens()) {
                                        mail.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                                    }
                                }
                                if (this.iForm.getBcc() != null) {
                                    s = new StringTokenizer(this.iForm.getBcc(), ";,\n\r ");
                                    while (((StringTokenizer)s).hasMoreTokens()) {
                                        mail.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                                    }
                                }
                                for (Map.Entry entry : files.entrySet()) {
                                    mail.addAttachment((File)entry.getValue(), session.getAcademicTerm() + session.getSessionStartYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + "_" + (String)entry.getKey());
                                    this.log("&nbsp;&nbsp;Attaching <a href='temp/" + ((File)entry.getValue()).getName() + "'>" + (String)entry.getKey() + "</a>");
                                }
                                mail.send();
                                this.log("Email sent.");
                            }
                            catch (Exception e) {
                                this.log("<font color='red'>Unable to send email: " + e.getMessage() + "</font>");
                                this.setError(e);
                            }
                        }
                    }
                } else {
                    try {
                        Object s;
                        Email mail2 = Email.createEmail();
                        mail2.setSubject(this.iForm.getSubject() == null ? "Examination Report" : this.iForm.getSubject());
                        mail2.setText((this.iForm.getMessage() == null ? "" : this.iForm.getMessage() + "\r\n\r\n") + "For an up-to-date examination report, please visit " + this.iUrl + "/\r\n\r\nThis email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                        if (this.iForm.getAddress() != null) {
                            s = new StringTokenizer(this.iForm.getAddress(), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                mail2.addRecipient(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        if (this.iForm.getCc() != null) {
                            s = new StringTokenizer(this.iForm.getCc(), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                mail2.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        if (this.iForm.getBcc() != null) {
                            s = new StringTokenizer(this.iForm.getBcc(), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                mail2.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        for (Map.Entry entry : output.entrySet()) {
                            mail2.addAttachment((File)entry.getValue(), session.getAcademicTerm() + session.getSessionStartYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + "_" + (String)entry.getKey());
                        }
                        mail2.send();
                        this.log("Email sent.");
                    }
                    catch (Exception e) {
                        this.log("<font color='red'>Unable to send email: " + e.getMessage() + "</font>");
                        this.setError(e);
                    }
                }
                if (this.iForm.getEmailInstructors() && ireports != null && !ireports.isEmpty()) {
                    this.setStatus("Emailing instructors...");
                    for (ExamInfo.ExamInstructorInfo instructor : new TreeSet(ireports.keySet())) {
                        File file = (File)ireports.get(instructor);
                        email = instructor.getInstructor().getEmail();
                        if (email == null || email.length() == 0) {
                            this.log("&nbsp;&nbsp;<font color='orange'>Unable to email <a href='temp/" + file.getName() + "'>" + instructor.getName() + "</a> -- instructor has no email address.</font>");
                            continue;
                        }
                        try {
                            StringTokenizer s;
                            mail = Email.createEmail();
                            mail.setSubject(this.iForm.getSubject() == null ? "Examination Report" : this.iForm.getSubject());
                            mail.setText((this.iForm.getMessage() == null ? "" : this.iForm.getMessage() + "\r\n\r\n") + "For an up-to-date examination report, please visit " + this.iUrl + "/exams.do\r\n\r\nThis email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                            mail.addRecipient(email, null);
                            if (this.iForm.getCc() != null) {
                                s = new StringTokenizer(this.iForm.getCc(), ";,\n\r ");
                                while (s.hasMoreTokens()) {
                                    mail.addRecipientCC(s.nextToken(), null);
                                }
                            }
                            if (this.iForm.getBcc() != null) {
                                s = new StringTokenizer(this.iForm.getBcc(), ";,\n\r ");
                                while (s.hasMoreTokens()) {
                                    mail.addRecipientBCC(s.nextToken(), null);
                                }
                            }
                            mail.addAttachment(file, session.getAcademicTerm() + session.getSessionStartYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + (this.iForm.getModeIdx() == 2 ? ".txt" : ".pdf"));
                            mail.send();
                            this.log("&nbsp;&nbsp;An email was sent to <a href='temp/" + file.getName() + "'>" + instructor.getName() + "</a>.");
                        }
                        catch (Exception e) {
                            this.log("&nbsp;&nbsp;<font color='orange'>Unable to email <a href='temp/" + file.getName() + "'>" + instructor.getName() + "</a> -- " + e.getMessage() + ".</font>");
                            this.setError(e);
                        }
                    }
                    this.log("Emails sent.");
                }
                if (this.iForm.getEmailStudents() && sreports != null && !sreports.isEmpty()) {
                    this.setStatus("Emailing students...");
                    for (Student student : new TreeSet(sreports.keySet())) {
                        File file = (File)sreports.get(student);
                        email = student.getEmail();
                        if (email == null || email.length() == 0) {
                            this.log("&nbsp;&nbsp;<font color='orange'>Unable to email <a href='temp/" + file.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a> -- student has no email address.</font>");
                            continue;
                        }
                        try {
                            StringTokenizer s;
                            mail = Email.createEmail();
                            mail.setSubject(this.iForm.getSubject() == null ? "Examination Report" : this.iForm.getSubject());
                            mail.setText((this.iForm.getMessage() == null ? "" : this.iForm.getMessage() + "\r\n\r\n") + "For an up-to-date examination report, please visit " + this.iUrl + "/exams.do\r\n\r\nThis email was automatically generated by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                            mail.addRecipient(email, null);
                            if (this.iForm.getCc() != null) {
                                s = new StringTokenizer(this.iForm.getCc(), ";,\n\r ");
                                while (s.hasMoreTokens()) {
                                    mail.addRecipientCC(s.nextToken(), null);
                                }
                            }
                            if (this.iForm.getBcc() != null) {
                                s = new StringTokenizer(this.iForm.getBcc(), ";,\n\r ");
                                while (s.hasMoreTokens()) {
                                    mail.addRecipientBCC(s.nextToken(), null);
                                }
                            }
                            mail.addAttachment(file, session.getAcademicTerm() + session.getSessionStartYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + (this.iForm.getModeIdx() == 2 ? ".txt" : ".pdf"));
                            mail.send();
                            this.log("&nbsp;&nbsp;An email was sent to <a href='temp/" + file.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a>.");
                        }
                        catch (Exception e) {
                            this.log("&nbsp;&nbsp;<font color='orange'>Unable to email <a href='temp/" + file.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a> -- " + e.getMessage() + ".</font>");
                            this.setError(e);
                        }
                    }
                    this.log("Emails sent.");
                }
            }
            if (output.isEmpty()) {
                throw new Exception("Nothing generated.");
            }
            if (output.size() == 1) {
                this.setOutput((File)output.elements().nextElement());
            } else {
                FileInputStream fis = null;
                ZipOutputStream zip = null;
                try {
                    File file = ApplicationProperties.getTempFile(session.getAcademicTerm() + session.getSessionStartYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference(), "zip");
                    this.log("Writing <a href='temp/" + file.getName() + "'>" + session.getAcademicTerm() + session.getSessionStartYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + ".zip</a>...");
                    zip = new ZipOutputStream(new FileOutputStream(file));
                    for (Map.Entry entry : output.entrySet()) {
                        zip.putNextEntry(new ZipEntry((String)entry.getKey()));
                        fis = new FileInputStream((File)entry.getValue());
                        while ((len = fis.read(buffer)) > 0) {
                            zip.write(buffer, 0, len);
                        }
                        fis.close();
                        fis = null;
                        zip.closeEntry();
                    }
                    zip.flush();
                    zip.close();
                    this.setOutput(file);
                }
                catch (IOException iOException) {
                    if (fis != null) {
                        fis.close();
                    }
                    if (zip != null) {
                        zip.close();
                    }
                    this.setError(iOException);
                }
            }
            this.iProgress = 1.0;
            this.setStatus("All done.");
        }
        catch (Exception e) {
            this.fatal("Process failed.", e);
        }
    }

    @Override
    public String name() {
        return this.iName;
    }

    @Override
    public double progress() {
        return this.iProgress;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public static class FileGenerator
    implements InstructorExamReport.FileGenerator {
        String iName;

        public FileGenerator(String name) {
            this.iName = name;
        }

        @Override
        public File generate(String prefix, String ext) {
            return ApplicationProperties.getTempFile(this.iName + "_" + prefix, ext);
        }
    }
}

