/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.duration;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.duration.DurationModel;

public abstract class MeetingCountingDuration
implements DurationModel {
    public abstract boolean check(int var1, int var2);

    public abstract Integer getMaxMeetings(int var1, int var2);

    @Override
    public boolean isValidCombination(int minutes, DatePattern datePattern, TimePattern timePattern) {
        if (datePattern == null) {
            return false;
        }
        if (timePattern.getType() != null && timePattern.getType() == 5) {
            return true;
        }
        if (datePattern.getType() != null && datePattern.getType() == 4) {
            for (DatePattern child : datePattern.findChildren()) {
                if (!this.isValidCombination(minutes, child, timePattern)) continue;
                return true;
            }
            return false;
        }
        for (TimePatternDays days : timePattern.getDays()) {
            if (!this.check(minutes, this.nbrMeetings(datePattern, days.getDayCode()) * timePattern.getMinPerMtg())) continue;
            return true;
        }
        return false;
    }

    protected int nbrMeetings(DatePattern datePattern, int dayCode) {
        if (datePattern == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(datePattern.getStartDate());
        cal.setLenient(true);
        String pattern = datePattern.getPattern();
        int ret = 0;
        for (int idx = 0; idx < pattern.length(); ++idx) {
            if (pattern.charAt(idx) == '1') {
                boolean offered = false;
                switch (cal.get(7)) {
                    case 2: {
                        offered = (dayCode & Constants.DAY_CODES[0]) != 0;
                        break;
                    }
                    case 3: {
                        offered = (dayCode & Constants.DAY_CODES[1]) != 0;
                        break;
                    }
                    case 4: {
                        offered = (dayCode & Constants.DAY_CODES[2]) != 0;
                        break;
                    }
                    case 5: {
                        offered = (dayCode & Constants.DAY_CODES[3]) != 0;
                        break;
                    }
                    case 6: {
                        offered = (dayCode & Constants.DAY_CODES[4]) != 0;
                        break;
                    }
                    case 7: {
                        offered = (dayCode & Constants.DAY_CODES[5]) != 0;
                        break;
                    }
                    case 1: {
                        boolean bl = offered = (dayCode & Constants.DAY_CODES[6]) != 0;
                    }
                }
                if (offered) {
                    ++ret;
                }
            }
            cal.add(6, 1);
        }
        return ret;
    }

    @Override
    public boolean isValidSelection(int minutes, DatePattern datePattern, TimePattern timePattern, int dayCode) {
        if (!this.isValidCombination(minutes, datePattern, timePattern)) {
            return false;
        }
        if (datePattern.getType() != null && datePattern.getType() == 4) {
            for (DatePattern child : datePattern.findChildren()) {
                if (!this.check(minutes, this.nbrMeetings(child, dayCode) * timePattern.getMinPerMtg())) continue;
                return true;
            }
            return false;
        }
        return this.check(minutes, this.nbrMeetings(datePattern, dayCode) * timePattern.getMinPerMtg());
    }

    @Override
    public Set<Integer> getDayCodes(int minutes, DatePattern datePattern, TimePattern timePattern) {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (TimePatternDays days : timePattern.getDays()) {
            if (!this.isValidSelection(minutes, datePattern, timePattern, days.getDayCode())) continue;
            ret.add(days.getDayCode());
        }
        return ret;
    }

    @Override
    public List<Date> getDates(int minutes, DatePattern datePattern, int dayCode, int minutesPerMeeting) {
        ArrayList<Date> ret = new ArrayList<Date>();
        if (datePattern == null) {
            return ret;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(datePattern.getStartDate());
        cal.setLenient(true);
        EventDateMapping.Class2EventDateMap class2eventDates = EventDateMapping.getMapping(datePattern.getSession().getUniqueId());
        String pattern = datePattern.getPattern();
        Integer max = this.getMaxMeetings(minutes, minutesPerMeeting);
        for (int idx = 0; idx < pattern.length(); ++idx) {
            if (pattern.charAt(idx) == '1') {
                boolean offered = false;
                switch (cal.get(7)) {
                    case 2: {
                        offered = (dayCode & Constants.DAY_CODES[0]) != 0;
                        break;
                    }
                    case 3: {
                        offered = (dayCode & Constants.DAY_CODES[1]) != 0;
                        break;
                    }
                    case 4: {
                        offered = (dayCode & Constants.DAY_CODES[2]) != 0;
                        break;
                    }
                    case 5: {
                        offered = (dayCode & Constants.DAY_CODES[3]) != 0;
                        break;
                    }
                    case 6: {
                        offered = (dayCode & Constants.DAY_CODES[4]) != 0;
                        break;
                    }
                    case 7: {
                        offered = (dayCode & Constants.DAY_CODES[5]) != 0;
                        break;
                    }
                    case 1: {
                        boolean bl = offered = (dayCode & Constants.DAY_CODES[6]) != 0;
                    }
                }
                if (offered) {
                    ret.add(class2eventDates.getEventDate(cal.getTime()));
                }
            }
            cal.add(6, 1);
            if (max != null && ret.size() >= max) break;
        }
        return ret;
    }
}

