/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.RoomDAO;

public class RoomAvailabilityService
implements RoomAvailabilityInterface {
    private static Log sLog = LogFactory.getLog(RoomAvailabilityInterface.class);
    private static DecimalFormat sDf = new DecimalFormat("0.0");
    private boolean iStop = false;
    private RefreshThread iRefreshThread = null;
    private long iMaxAge = 1000 * Integer.parseInt(ApplicationProperties.getProperty("tmtbl.room.availability.maxage", "600"));
    private long iRefreshRate = 1000 * Integer.parseInt(ApplicationProperties.getProperty("tmtbl.room.availability.refresh", "60"));
    private long iTimeToLive = 1000 * Integer.parseInt(ApplicationProperties.getProperty("tmtbl.room.availability.timetolive", "3600"));
    private long iTimeout = 1000 * Integer.parseInt(ApplicationProperties.getProperty("tmtbl.room.availability.timeout", "60"));
    private File iRequestFile = new File(ApplicationProperties.getProperty("tmtbl.room.availability.request", ApplicationProperties.getDataFolder() + File.separator + "request.xml"));
    private File iResponseFile = new File(ApplicationProperties.getProperty("tmtbl.room.availability.response", ApplicationProperties.getDataFolder() + File.separator + "response.xml"));
    private boolean iDelete = "true".equals(ApplicationProperties.getProperty("tmtbl.room.availability.delete", "true"));
    private Vector<CacheElement> iCache = new Vector();

    @Override
    public Collection<RoomAvailabilityInterface.TimeBlock> getRoomAvailability(Long locationId, Date startTime, Date endTime, String excludeType) {
        org.unitime.timetable.model.Room room = (org.unitime.timetable.model.Room)RoomDAO.getInstance().get(locationId);
        if (room != null) {
            return this.getRoomAvailability(room.getExternalUniqueId(), room.getBuildingAbbv(), room.getRoomNumber(), startTime, endTime, excludeType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RoomAvailabilityInterface.TimeBlock> getRoomAvailability(String roomExternalId, String buildingAbbv, String roomNbr, Date startTime, Date endTime, String excludeType) {
        TimeFrame time = new TimeFrame(startTime, endTime);
        sLog.debug((Object)("Get: " + time + " (" + buildingAbbv + " " + roomNbr + ")"));
        CacheElement cache = this.get(time);
        if (cache == null) {
            sLog.error((Object)("Cache covering " + time + " not found."));
            return null;
        }
        CacheElement cacheElement = cache;
        synchronized (cacheElement) {
            if (!cache.isActive() && !cache.isDirty()) {
                sLog.warn((Object)("Cache " + cache + " not active."));
                return null;
            }
            if (this.iMaxAge > 0L && cache.getAge() > this.iMaxAge) {
                sLog.info((Object)("Cache " + cache + " too old, waiting for an update..."));
                cache.markDirty();
                try {
                    this.iRefreshThread.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
                try {
                    cache.wait(this.iTimeout);
                }
                catch (InterruptedException e) {
                    sLog.warn((Object)("Wait for an update of " + cache + " got timed out."));
                    cache.deactivate();
                }
                if (!cache.isActive()) {
                    sLog.warn((Object)("Cache " + cache + " is not active."));
                    return null;
                }
                sLog.debug((Object)("Return: " + cache.get(new Room(roomExternalId, buildingAbbv, roomNbr), excludeType)));
                return cache.get(new Room(roomExternalId, buildingAbbv, roomNbr), excludeType);
            }
            sLog.debug((Object)("Return: " + cache.get(new Room(roomExternalId, buildingAbbv, roomNbr), excludeType) + " from " + cache + "."));
            return cache.get(new Room(roomExternalId, buildingAbbv, roomNbr), excludeType);
        }
    }

    @Override
    public String getTimeStamp(Date startTime, Date endTime, String excludeType) {
        TimeFrame time = new TimeFrame(startTime, endTime);
        CacheElement cache = this.get(time);
        return cache == null ? null : cache.getTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheElement get(TimeFrame time) {
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            for (CacheElement cache : this.iCache) {
                if (!cache.cover(time)) continue;
                return cache;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(Session session, Date startTime, Date endTime, String excludeType, boolean waitForSync) {
        Object object;
        TimeFrame time = new TimeFrame(startTime, endTime);
        sLog.debug((Object)("Activate: " + time));
        CacheElement cache = this.get(time);
        if (cache == null) {
            cache = new CacheElement(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), time);
            this.iCache.add(cache);
        } else {
            object = cache;
            synchronized (object) {
                cache.markDirty();
            }
        }
        object = this.iRefreshThread;
        synchronized (object) {
            this.iRefreshThread.notify();
        }
        if (waitForSync) {
            object = cache;
            synchronized (object) {
                sLog.warn((Object)("Activate: waiting for update of " + time));
                try {
                    cache.wait(this.iTimeout);
                }
                catch (InterruptedException e) {
                    sLog.warn((Object)("Wait for an update of " + cache + " got timed out."));
                    cache.deactivate();
                }
                if (!cache.isActive()) {
                    sLog.warn((Object)("Cache " + cache + " is not active."));
                }
            }
        }
    }

    @Override
    public void startService() {
        sLog.info((Object)"Starting room availability service");
        this.iRefreshThread = new RefreshThread();
        this.iRefreshThread.start();
    }

    @Override
    public void stopService() {
        sLog.info((Object)"Stopping room availability service");
        this.iStop = true;
        this.iRefreshThread.interrupt();
    }

    protected Document createRequest(CacheElement cache) {
        Document request = DocumentHelper.createDocument();
        Element params = request.addElement("parameters");
        params.addAttribute("created", new Date().toString());
        params.addElement("year").addAttribute("value", cache.getYear());
        params.addElement("term").addAttribute("value", cache.getTerm());
        params.addElement("campus").addAttribute("value", cache.getCampus());
        params.addElement("beginDate").addAttribute("value", new SimpleDateFormat("MM/dd/yyyy").format(cache.getTimeFrame().getStartTime()));
        params.addElement("endDate").addAttribute("value", new SimpleDateFormat("MM/dd/yyyy").format(cache.getTimeFrame().getEndTime()));
        params.addElement("startTime").addAttribute("value", new SimpleDateFormat("HH:mm").format(cache.getTimeFrame().getStartTime()));
        params.addElement("endTime").addAttribute("value", new SimpleDateFormat("HH:mm").format(cache.getTimeFrame().getEndTime()));
        return request;
    }

    protected void sendRequest(Document request) throws IOException {
        try (FileOutputStream fos = null;){
            if (this.iDelete && this.iResponseFile.exists()) {
                this.iResponseFile.delete();
            }
            fos = new FileOutputStream(this.iRequestFile);
            new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(request);
            fos.flush();
            fos.close();
            fos = null;
        }
    }

    protected Hashtable<Room, HashSet<RoomAvailabilityInterface.TimeBlock>> readResponse(Document response) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(response.getRootElement().attributeValue("dateFormat", "MM/dd/yyyy"), Locale.US);
        SimpleDateFormat timeFormat = new SimpleDateFormat(response.getRootElement().attributeValue("timeFormat", "h:mm a"), Locale.US);
        Hashtable<Room, HashSet<RoomAvailabilityInterface.TimeBlock>> availability = new Hashtable<Room, HashSet<RoomAvailabilityInterface.TimeBlock>>();
        Iterator i = response.getRootElement().elementIterator("room");
        while (i.hasNext()) {
            Element roomElement = (Element)i.next();
            Room room = new Room(roomElement);
            HashSet<RoomAvailabilityInterface.TimeBlock> roomAvailability = availability.get(room);
            if (roomAvailability == null) {
                roomAvailability = new HashSet();
                availability.put(room, roomAvailability);
            }
            Iterator j = roomElement.elementIterator("event");
            while (j.hasNext()) {
                Element eventElement = (Element)j.next();
                EventTimeBlock event = new EventTimeBlock(eventElement, dateFormat, timeFormat);
                roomAvailability.add(event);
            }
        }
        return availability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document receiveResponse() throws IOException, DocumentException {
        try (FileInputStream fis = null;){
            if (!this.iResponseFile.exists() || !this.iResponseFile.canRead()) {
                Document document = null;
                return document;
            }
            fis = new FileInputStream(this.iResponseFile);
            Document document = new SAXReader().read((InputStream)fis);
            fis.close();
            fis = null;
            if (this.iDelete) {
                this.iResponseFile.delete();
            }
            Document document2 = document;
            return document2;
        }
    }

    @Override
    public Collection<RoomAvailabilityInterface.TimeBlock> getInstructorAvailability(Long instructorId, Date startTime, Date endTime, String excludeType) {
        return null;
    }

    public static class EventTimeBlock
    implements RoomAvailabilityInterface.TimeBlock {
        private static final long serialVersionUID = -2466335111767360325L;
        private String iEventName;
        private String iEventType;
        private Date iStartTime;
        private Date iEndTime;
        private Long iEventId;

        public EventTimeBlock(Element eventElement, SimpleDateFormat dateFormat, SimpleDateFormat timeFormat) throws ParseException {
            String id = eventElement.attributeValue("id");
            try {
                this.iEventId = id == null ? null : Long.valueOf(id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.iEventName = eventElement.attributeValue("name");
            this.iEventType = eventElement.attributeValue("type");
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(dateFormat.parse(eventElement.attributeValue("date")));
            int start = Integer.parseInt(new SimpleDateFormat("HHmm").format(timeFormat.parse(eventElement.attributeValue("startTime"))));
            int end = Integer.parseInt(new SimpleDateFormat("HHmm").format(timeFormat.parse(eventElement.attributeValue("endTime"))));
            c.set(10, start / 100);
            c.set(12, start % 100);
            this.iStartTime = c.getTime();
            c.setTime(dateFormat.parse(eventElement.attributeValue("date")));
            c.set(10, end / 100);
            c.set(12, end % 100);
            this.iEndTime = c.getTime();
            if (this.iEndTime.compareTo(this.iStartTime) < 0) {
                sLog.info((Object)("Event " + this.iEventName + " (" + this.iEventType + ") goes over midnight (" + eventElement.attributeValue("date") + " " + eventElement.attributeValue("startTime") + " - " + eventElement.attributeValue("endTime") + ")."));
                c.add(6, 1);
                this.iEndTime = c.getTime();
            }
        }

        @Override
        public Long getEventId() {
            return this.iEventId;
        }

        @Override
        public String getEventName() {
            return this.iEventName;
        }

        @Override
        public String getEventType() {
            return this.iEventType;
        }

        @Override
        public Date getStartTime() {
            return this.iStartTime;
        }

        @Override
        public Date getEndTime() {
            return this.iEndTime;
        }

        public String toString() {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy HH:mm");
            SimpleDateFormat df2 = new SimpleDateFormat("HH:mm");
            return this.getEventName() + " (" + this.getEventType() + ") " + df.format(this.getStartTime()) + " - " + df2.format(this.getEndTime());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RoomAvailabilityInterface.TimeBlock)) {
                return false;
            }
            RoomAvailabilityInterface.TimeBlock t = (RoomAvailabilityInterface.TimeBlock)o;
            return this.getEventName().equals(t.getEventName()) && this.getEventType().equals(t.getEventType()) && this.getStartTime().equals(t.getStartTime()) && this.getEndTime().equals(t.getEndTime());
        }

        public int hashCode() {
            return this.getEventName().hashCode() ^ this.getEventType().hashCode() ^ this.getStartTime().hashCode();
        }
    }

    public static class Room {
        private String iExternalId;
        private String iBuildingAbbv;
        private String iRoomNbr;

        public Room(String externalId, String buildingAbbv, String roomNbr) {
            this.iExternalId = externalId;
            this.iBuildingAbbv = buildingAbbv;
            this.iRoomNbr = roomNbr;
        }

        public Room(Element roomElement) {
            this.iExternalId = roomElement.attributeValue("externalId");
            this.iBuildingAbbv = roomElement.attributeValue("building");
            this.iRoomNbr = roomElement.attributeValue("roomNbr");
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public boolean hasExternalId() {
            return this.iExternalId != null;
        }

        public boolean hasName() {
            return this.iBuildingAbbv != null && this.iRoomNbr != null;
        }

        public String getBuildingAbbv() {
            return this.iBuildingAbbv;
        }

        public String getRoomNbr() {
            return this.iRoomNbr;
        }

        public int hashCode() {
            if (this.hasName()) {
                return this.getBuildingAbbv().hashCode() ^ this.getRoomNbr().hashCode();
            }
            return this.getExternalId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Room)) {
                return false;
            }
            Room r = (Room)o;
            if (this.hasExternalId() && r.hasExternalId()) {
                return this.getExternalId().equals(r.getExternalId());
            }
            return this.getBuildingAbbv().equals(r.getBuildingAbbv()) && this.getRoomNbr().equals(r.getRoomNbr());
        }

        public String toString() {
            return this.getBuildingAbbv() + " " + this.getRoomNbr();
        }
    }

    public static class CacheElement {
        private boolean iDirty = true;
        private boolean iActive = false;
        private TimeFrame iTime;
        private Hashtable<Room, HashSet<RoomAvailabilityInterface.TimeBlock>> iAvailability = new Hashtable();
        private long iLastAccess;
        private long iLastUpdate;
        private String iTerm;
        private String iYear;
        private String iCampus;
        private String iTimestamp = null;

        public CacheElement(String year, String term, String campus, TimeFrame time) {
            this.iYear = year;
            this.iTerm = term;
            this.iCampus = campus;
            this.iTime = time;
            this.iLastAccess = System.currentTimeMillis();
        }

        public void update(Hashtable<Room, HashSet<RoomAvailabilityInterface.TimeBlock>> availability, String timestamp) {
            this.iAvailability = availability;
            this.iLastUpdate = System.currentTimeMillis();
            this.iDirty = false;
            this.iActive = true;
            this.iTimestamp = timestamp;
        }

        public HashSet<RoomAvailabilityInterface.TimeBlock> get(Room room, String excludeType) {
            this.iLastAccess = System.currentTimeMillis();
            HashSet<RoomAvailabilityInterface.TimeBlock> roomAvailability = this.iAvailability.get(room);
            if (roomAvailability == null || excludeType == null) {
                return roomAvailability;
            }
            HashSet<RoomAvailabilityInterface.TimeBlock> ret = new HashSet<RoomAvailabilityInterface.TimeBlock>(roomAvailability.size());
            for (RoomAvailabilityInterface.TimeBlock block : roomAvailability) {
                if (excludeType.equals(block.getEventType())) continue;
                ret.add(block);
            }
            return ret;
        }

        public boolean isDirty() {
            return this.iDirty;
        }

        public boolean isActive() {
            return this.iActive;
        }

        public void markDirty() {
            this.iDirty = true;
            this.iLastAccess = System.currentTimeMillis();
        }

        public void markActive() {
            if (!this.iActive) {
                this.iActive = true;
                this.iDirty = true;
            }
        }

        public void deactivate() {
            this.iActive = false;
            this.iDirty = false;
            this.iAvailability.clear();
        }

        public long getAge() {
            return System.currentTimeMillis() - this.iLastUpdate;
        }

        public long getUse() {
            return System.currentTimeMillis() - this.iLastAccess;
        }

        public TimeFrame getTimeFrame() {
            return this.iTime;
        }

        public boolean cover(TimeFrame time) {
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat sdfTime = new SimpleDateFormat("HHmm");
            String startDay = sdfDate.format(this.iTime.getStartTime());
            String endDay = sdfDate.format(this.iTime.getEndTime());
            String startTime = sdfTime.format(this.iTime.getStartTime());
            String endTime = sdfTime.format(this.iTime.getEndTime());
            String givenStartDay = sdfDate.format(time.getStartTime());
            String givenEndDay = sdfDate.format(time.getEndTime());
            String givenStartTime = sdfTime.format(time.getStartTime());
            String givenEndTime = sdfTime.format(time.getEndTime());
            return startDay.compareTo(givenStartDay) <= 0 && givenEndDay.compareTo(endDay) <= 0 && startTime.compareTo(givenStartTime) <= 0 && givenEndTime.compareTo(endTime) <= 0;
        }

        public String getYear() {
            return this.iYear;
        }

        public String getTerm() {
            return this.iTerm;
        }

        public String getCampus() {
            return this.iCampus;
        }

        public String getTimestamp() {
            return this.iTimestamp;
        }

        public String toString() {
            return this.iTime + " (updated " + this.getAge() / 1000L + "s ago, used " + this.getUse() / 1000L + "s ago" + (this.iActive ? ", active" : "") + (this.iDirty ? ", dirty" : "") + ")";
        }
    }

    public static class TimeFrame {
        private Date iStart;
        private Date iEnd;

        public TimeFrame(Date start, Date end) {
            this.iStart = start;
            this.iEnd = end;
        }

        public Date getStartTime() {
            return this.iStart;
        }

        public Date getEndTime() {
            return this.iEnd;
        }

        public int hashCode() {
            return this.iStart.hashCode() ^ this.iEnd.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimeFrame)) {
                return false;
            }
            TimeFrame t = (TimeFrame)o;
            return this.getStartTime().equals(t.getStartTime()) && this.getEndTime().equals(t.getEndTime());
        }

        public String toString() {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy HH:mm");
            return df.format(this.getStartTime()) + " - " + df.format(this.getEndTime());
        }
    }

    public class RefreshThread
    extends Thread {
        public RefreshThread() {
            this.setName("Room Refresh");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(CacheElement cache) throws InterruptedException {
            try {
                sLog.debug((Object)("Updating " + cache));
                long t0 = System.currentTimeMillis();
                RoomAvailabilityService.this.sendRequest(RoomAvailabilityService.this.createRequest(cache));
                sLog.debug((Object)("Request " + RoomAvailabilityService.this.iRequestFile + " created."));
                Document response = null;
                long waited = 0L;
                while ((response = RoomAvailabilityService.this.receiveResponse()) == null) {
                    sLog.debug((Object)("Waiting for response (" + waited / 1000L + "s waited so far)..."));
                    RefreshThread.sleep(5000L);
                    if ((waited += 5000L) <= RoomAvailabilityService.this.iTimeout) continue;
                    sLog.error((Object)("No response received after " + RoomAvailabilityService.this.iTimeout / 1000L + "s."));
                    throw new Exception("Timeout");
                }
                sLog.debug((Object)"Reading response...");
                CacheElement cacheElement = cache;
                synchronized (cacheElement) {
                    Hashtable<Room, HashSet<RoomAvailabilityInterface.TimeBlock>> availability = RoomAvailabilityService.this.readResponse(response);
                    long dt = System.currentTimeMillis() - t0;
                    String ts = response.getRootElement().attributeValue("created");
                    if (ts == null) {
                        ts = new Date().toString();
                    }
                    if (dt > 100L && dt < 60000L) {
                        ts = ts + " (retrieved in " + sDf.format((double)dt / 1000.0) + " sec)";
                    } else if (dt >= 60000L) {
                        ts = ts + " (retrieved in " + sDf.format((double)dt / 60000.0) + " min)";
                    }
                    cache.update(availability, ts);
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to query room availability, reason:" + e.getMessage()), (Throwable)e);
                cache.deactivate();
            }
            CacheElement cacheElement = cache;
            synchronized (cacheElement) {
                cache.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (!RoomAvailabilityService.this.iStop) {
                        try {
                            RefreshThread refreshThread = this;
                            synchronized (refreshThread) {
                                this.wait(RoomAvailabilityService.this.iRefreshRate);
                            }
                            Vector<CacheElement> dirty = new Vector<CacheElement>();
                            for (CacheElement cache : RoomAvailabilityService.this.iCache) {
                                if (cache.isDirty()) {
                                    dirty.add(cache);
                                    continue;
                                }
                                if (!cache.isActive()) continue;
                                if (RoomAvailabilityService.this.iTimeToLive >= 0L && cache.getUse() > RoomAvailabilityService.this.iTimeToLive) {
                                    cache.deactivate();
                                    continue;
                                }
                                dirty.add(cache);
                            }
                            Iterator iterator = dirty.iterator();
                            while (true) {
                                CacheElement cache;
                                if (!iterator.hasNext()) continue block7;
                                cache = (CacheElement)iterator.next();
                                this.update(cache);
                            }
                        }
                        catch (InterruptedException e) {
                            if (!RoomAvailabilityService.this.iStop) continue;
                            break block7;
                        }
                    }
                }
                catch (Exception e) {
                    sLog.error((Object)("Room availability refresh is failing: " + e.getMessage()));
                    continue;
                }
                break;
            }
            sLog.info((Object)"Room availability refresh thread stopped.");
        }
    }
}

