/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.security;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.User;
import org.unitime.timetable.util.LoginManager;

@Service(value="unitimeAuthenticationFailureHandler")
public class UniTimeAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    public UniTimeAuthenticationFailureHandler() {
        this.setDefaultFailureUrl("/login.do");
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception != null && exception instanceof LockedException) {
            super.onAuthenticationFailure(request, response, exception);
            return;
        }
        LoginManager.addFailedLoginAttempt(request.getParameter("username"), new Date());
        if (ApplicationProperty.PasswordReset.isTrue() && User.findByUserName(request.getParameter("username")) != null) {
            request.getSession().setAttribute("SUGGEST_PASSWORD_RESET", (Object)true);
        }
        super.onAuthenticationFailure(request, response, exception);
    }
}

