/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.ifs.solver.Solver;
import org.dom4j.Element;
import org.unitime.timetable.onlinesectioning.reports.OnlineSectioningReport;
import org.unitime.timetable.solver.ui.TimetableInfo;

public class StudentGroupInfo
implements TimetableInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    public static int sVersion = 1;
    private long iId;
    private String iName;
    private double iWeight;
    private double iValue;
    private List<ClassInfo> iClasses;

    public StudentGroupInfo() {
    }

    public StudentGroupInfo(Solver<Lecture, Placement> solver, StudentGroup group) {
        this.iId = group.getId();
        this.iName = group.getName();
        this.iWeight = group.getWeight();
        this.iValue = StudentGroupInfo.value(group);
        HashMap<Lecture, ArrayList<Student>> class2students = new HashMap<Lecture, ArrayList<Student>>();
        for (Student student : group.getStudents()) {
            for (Lecture lecture : student.getLectures()) {
                ArrayList<Student> students = (ArrayList<Student>)class2students.get(lecture);
                if (students == null) {
                    students = new ArrayList<Student>();
                    class2students.put(lecture, students);
                }
                students.add(student);
            }
        }
        this.iClasses = new ArrayList<ClassInfo>();
        for (Map.Entry entry : class2students.entrySet()) {
            this.iClasses.add(new ClassInfo((Lecture)entry.getKey(), (Collection)entry.getValue()));
        }
    }

    public static double value(StudentGroup group) {
        HashMap<Long, Match> match = new HashMap<Long, Match>();
        for (Student student : group.getStudents()) {
            for (Lecture lecture : student.getLectures()) {
                Match m = (Match)match.get(lecture.getSchedulingSubpartId());
                if (m == null) {
                    m = new Match(group, lecture.getConfiguration().getOfferingId());
                    match.put(lecture.getSchedulingSubpartId(), m);
                }
                m.inc(lecture);
            }
        }
        double value = 0.0;
        for (Match m : match.values()) {
            value += m.value();
        }
        return value / (double)match.size();
    }

    public Long getGroupId() {
        return this.iId;
    }

    public String getGroupName() {
        return this.iName;
    }

    public double getGroupWeight() {
        return this.iWeight;
    }

    public double getGroupValue() {
        return this.iValue;
    }

    public List<ClassInfo> getGroupAssignments() {
        return this.iClasses;
    }

    public ClassInfo getGroupAssignment(Long classId) {
        for (ClassInfo clazz : this.iClasses) {
            if (!clazz.getClassId().equals(classId)) continue;
            return clazz;
        }
        return null;
    }

    public List<StudentInfo> getStudentAssignments(Long classId) {
        for (ClassInfo clazz : this.iClasses) {
            if (!clazz.getClassId().equals(classId)) continue;
            return clazz.getStudents();
        }
        return null;
    }

    public int countStudentsOfConfiguration(Long configId) {
        HashSet<Long> studentIds = new HashSet<Long>();
        for (ClassInfo clazz : this.iClasses) {
            if (!configId.equals(clazz.getConfigId())) continue;
            for (StudentInfo student : clazz.getStudents()) {
                studentIds.add(student.getStudentId());
            }
        }
        return studentIds.size();
    }

    public int countStudentsOfOffering(Long offeringId) {
        HashSet<Long> studentIds = new HashSet<Long>();
        for (ClassInfo clazz : this.iClasses) {
            if (!offeringId.equals(clazz.getOfferingId())) continue;
            for (StudentInfo student : clazz.getStudents()) {
                studentIds.add(student.getStudentId());
            }
        }
        return studentIds.size();
    }

    public int countStudents() {
        HashSet<Long> studentIds = new HashSet<Long>();
        for (ClassInfo clazz : this.iClasses) {
            for (StudentInfo student : clazz.getStudents()) {
                studentIds.add(student.getStudentId());
            }
        }
        return studentIds.size();
    }

    public double countStudentWeights() {
        HashMap<Long, OnlineSectioningReport.Counter> counters = new HashMap<Long, OnlineSectioningReport.Counter>();
        for (ClassInfo clazz : this.iClasses) {
            for (StudentInfo student : clazz.getStudents()) {
                OnlineSectioningReport.Counter c = (OnlineSectioningReport.Counter)counters.get(student.getStudentId());
                if (c == null) {
                    c = new OnlineSectioningReport.Counter();
                    counters.put(student.getStudentId(), c);
                }
                c.inc(student.getWeight());
            }
        }
        double total = 0.0;
        for (OnlineSectioningReport.Counter c : counters.values()) {
            total += c.avg();
        }
        return total;
    }

    @Override
    public void load(Element root) {
        this.iId = Long.valueOf(root.attributeValue("id"));
        this.iName = root.attributeValue("name");
        this.iWeight = Double.valueOf(root.attributeValue("weight"));
        this.iValue = Double.valueOf(root.attributeValue("value", "1.0"));
        this.iClasses = new ArrayList<ClassInfo>();
        Iterator i = root.elementIterator("class");
        while (i.hasNext()) {
            this.iClasses.add(new ClassInfo((Element)i.next()));
        }
    }

    @Override
    public void save(Element root) {
        root.addAttribute("version", String.valueOf(sVersion));
        root.addAttribute("id", String.valueOf(this.iId));
        if (this.iName != null) {
            root.addAttribute("name", this.iName);
        }
        root.addAttribute("weight", String.valueOf(this.iWeight));
        if (this.iValue != 1.0) {
            root.addAttribute("value", String.valueOf(this.iValue));
        }
        for (ClassInfo clazz : this.iClasses) {
            clazz.save(root.addElement("class"));
        }
    }

    @Override
    public boolean saveToFile() {
        return false;
    }

    private static class Match {
        private int iTotal = 0;
        private Map<Long, Integer> iMatch = new HashMap<Long, Integer>();

        Match(StudentGroup group, Long offeringId) {
            this.iTotal = group.countStudents(offeringId);
        }

        void inc(Lecture lecture) {
            Integer val = this.iMatch.get(lecture.getClassId());
            this.iMatch.put(lecture.getClassId(), 1 + (val == null ? 0 : val));
        }

        double value() {
            if (this.iTotal <= 1) {
                return 1.0;
            }
            double value = 0.0;
            for (Integer m : this.iMatch.values()) {
                if (m <= 1) continue;
                value += (double)m.intValue() * ((double)m.intValue() - 1.0) / ((double)this.iTotal * ((double)this.iTotal - 1.0));
            }
            return value;
        }

        public String toString() {
            return this.iTotal + "/" + this.iMatch;
        }
    }

    public static class StudentInfo {
        private Long iStudentId;
        private double iWeight;

        public StudentInfo(Lecture lecture, Student student) {
            this.iStudentId = student.getId();
            this.iWeight = student.getOfferingWeight(lecture.getConfiguration());
        }

        public StudentInfo(Element e) {
            this.iStudentId = Long.valueOf(e.attributeValue("id"));
            this.iWeight = Double.valueOf(e.attributeValue("weight", "1.0"));
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public double getWeight() {
            return this.iWeight;
        }

        public void save(Element element) {
            element.addAttribute("id", String.valueOf(this.iStudentId));
            if (this.iWeight != 1.0) {
                element.addAttribute("weight", String.valueOf(this.iWeight));
            }
        }
    }

    public static class ClassInfo {
        private Long iClassId;
        private Long iConfigId;
        private Long iOfferingId;
        private List<StudentInfo> iStudents = new ArrayList<StudentInfo>();

        public ClassInfo(Lecture clazz, Collection<Student> students) {
            this.iClassId = clazz.getClassId();
            this.iConfigId = clazz.getConfiguration().getConfigId();
            this.iOfferingId = clazz.getConfiguration().getOfferingId();
            for (Student student : students) {
                this.iStudents.add(new StudentInfo(clazz, student));
            }
        }

        public ClassInfo(Element e) {
            this.iClassId = Long.valueOf(e.attributeValue("id"));
            String configId = e.attributeValue("configId");
            this.iConfigId = configId == null ? null : Long.valueOf(configId);
            String offeringId = e.attributeValue("offeringId");
            this.iOfferingId = offeringId == null ? null : Long.valueOf(offeringId);
            Iterator i = e.elementIterator("student");
            while (i.hasNext()) {
                this.iStudents.add(new StudentInfo((Element)i.next()));
            }
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public Long getOfferingId() {
            return this.iOfferingId;
        }

        public Long getConfigId() {
            return this.iConfigId;
        }

        public List<StudentInfo> getStudents() {
            return this.iStudents;
        }

        public double countStudentsWeight() {
            double weight = 0.0;
            for (StudentInfo student : this.iStudents) {
                weight += student.getWeight();
            }
            return weight;
        }

        public void save(Element element) {
            element.addAttribute("id", String.valueOf(this.iClassId));
            if (this.iConfigId != null) {
                element.addAttribute("configId", String.valueOf(this.iConfigId));
            }
            if (this.iOfferingId != null) {
                element.addAttribute("offeringId", String.valueOf(this.iOfferingId));
            }
            for (StudentInfo student : this.iStudents) {
                student.save(element.addElement("student"));
            }
        }
    }
}

