/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.interactive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.solver.interactive.Suggestion;
import org.unitime.timetable.solver.interactive.SuggestionsModel;

public class Suggestions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Solver iSolver = null;
    private transient Assignment<Lecture, Placement> iAssignment = null;
    private transient TimetableModel iModel = null;
    private transient Lecture iLecture = null;
    private long iTimeOut = 5000L;
    private boolean iSameRoom = false;
    private boolean iSameTime = false;
    private boolean iAllTheSame = true;
    private boolean iAllowBreakHard = false;
    private int iDepth = 2;
    private TreeSet iSuggestions = new TreeSet();
    private transient Vector iHints = new Vector();
    private boolean iTimeoutReached = false;
    private long iNrCombinationsConsidered = 0L;
    private long iNrSolutions = 0L;
    private Suggestion iCurrentSuggestion = null;
    private Suggestion iEmptySuggestion = null;
    private TreeSet iAllAssignments = null;
    private Vector iConfTable = null;
    private long iNrTries;
    private Vector iOriginalHints = null;
    private int iLimit = 100;
    private String iFilterText = null;
    private boolean iTryAllAssignments = true;
    private boolean iComputeSuggestions = true;
    private boolean iComputeConfTable = true;
    private int iMinRoomSize = -1;
    private int iMaxRoomSize = -1;

    public Suggestions(Solver solver, SuggestionsModel model) {
        this.iSolver = solver;
        this.iModel = (TimetableModel)this.iSolver.currentSolution().getModel();
        this.iAssignment = this.iSolver.currentSolution().getAssignment();
        this.iDepth = model.getDepth();
        this.iTimeOut = model.getTimeout();
        this.iAllTheSame = model.isAllTheSame();
        this.iSameTime = model.getFilter() == 1;
        this.iSameRoom = model.getFilter() == 2;
        this.iAllowBreakHard = model.getAllowBreakHard();
        this.iHints = new Vector(model.getHints().size());
        this.iOriginalHints = model.getHints();
        this.iTryAllAssignments = model.getDisplayPlacements();
        this.iComputeSuggestions = model.getDisplaySuggestions();
        this.iComputeConfTable = model.getDisplayConfTable();
        this.iLimit = model.getLimit();
        if (this.iLimit <= 0) {
            this.iComputeSuggestions = false;
            this.iTryAllAssignments = false;
        }
        this.iMinRoomSize = model.getMinRoomSize();
        this.iMaxRoomSize = model.getMaxRoomSize();
        this.iFilterText = model.getFilterText() == null ? null : model.getFilterText().trim().toUpperCase();
        for (Lecture lecture : this.iModel.variables()) {
            if (!lecture.getClassId().equals(model.getClassId())) continue;
            this.iLecture = lecture;
            break;
        }
        Enumeration e = model.getHints().elements();
        while (e.hasMoreElements()) {
            Hint h = (Hint)e.nextElement();
            Placement p = h.getPlacement(this.iModel);
            if (p == null) continue;
            this.iHints.add(p);
        }
        if (this.iLecture != null) {
            this.compute();
        }
    }

    public boolean match(Placement p) {
        if (this.iMinRoomSize >= 0 && p.getRoomSize() < this.iMinRoomSize) {
            return false;
        }
        if (this.iMaxRoomSize >= 0 && p.getRoomSize() > this.iMaxRoomSize) {
            return false;
        }
        if (this.iFilterText == null || this.iFilterText.length() == 0) {
            return true;
        }
        StringTokenizer stk = new StringTokenizer(this.iFilterText);
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (p.getName().toUpperCase().indexOf(token) >= 0) continue;
            return false;
        }
        return true;
    }

    public Vector getHints() {
        return this.iOriginalHints;
    }

    public void compute() {
        if (this.iComputeSuggestions) {
            this.computeSuggestions();
        }
        if (this.iTryAllAssignments) {
            this.computeTryAllAssignments();
        }
        if (this.iComputeConfTable) {
            this.computeConfTable();
        }
        this.iCurrentSuggestion = this.tryAssignment((Placement)null);
        Hashtable<Lecture, Placement> initialAssignments = new Hashtable<Lecture, Placement>();
        for (Lecture lec : this.iAssignment.assignedVariables()) {
            initialAssignments.put(lec, (Placement)this.iAssignment.getValue((Variable)lec));
        }
        this.iEmptySuggestion = new Suggestion((Solver<Lecture, Placement>)this.iSolver, initialAssignments, new Vector(), new Vector());
        this.computeNrTries();
    }

    public TreeSet getSuggestions() {
        return this.iSuggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeSuggestions() {
        this.iSuggestions.clear();
        this.iTimeoutReached = false;
        this.iNrCombinationsConsidered = 0L;
        this.iNrSolutions = 0L;
        Solution solution = this.iSolver.currentSolution();
        synchronized (solution) {
            Lecture lect;
            Enumeration e;
            Vector unAssignedVariables = new Vector(this.iModel.nrUnassignedVariables(this.iAssignment));
            Hashtable<Lecture, Value> initialAssignments = new Hashtable<Lecture, Value>();
            for (Lecture lec : this.iAssignment.assignedVariables()) {
                initialAssignments.put(lec, this.iAssignment.getValue((Variable)lec));
            }
            Hashtable<Variable, Placement> conflictsToResolve = new Hashtable<Variable, Placement>();
            Vector<Long> resolvedLectures = new Vector<Long>();
            boolean canAssign = true;
            if (this.iHints != null) {
                e = this.iHints.elements();
                while (e.hasMoreElements()) {
                    Placement plac = (Placement)e.nextElement();
                    lect = (Lecture)plac.variable();
                    Set conflicts = this.iModel.conflictValues(this.iAssignment, (Value)plac);
                    for (Placement conflictPlacement : conflicts) {
                        conflictsToResolve.put(conflictPlacement.variable(), conflictPlacement);
                        this.iAssignment.unassign(0L, conflictPlacement.variable());
                    }
                    if (!conflicts.contains(plac)) {
                        resolvedLectures.add(lect.getClassId());
                        conflictsToResolve.remove(lect);
                        this.iAssignment.assign(0L, (Value)plac);
                        continue;
                    }
                    canAssign = false;
                }
            }
            if (canAssign) {
                Vector<Lecture> initialLectures = new Vector<Lecture>(1);
                if (!resolvedLectures.contains(this.iLecture.getClassId())) {
                    initialLectures.add(this.iLecture);
                }
                this.backtrack(System.currentTimeMillis(), initialLectures, resolvedLectures, conflictsToResolve, initialAssignments, this.iDepth);
            }
            e = unAssignedVariables.elements();
            while (e.hasMoreElements()) {
                Lecture lect2 = (Lecture)e.nextElement();
                if (this.iAssignment.getValue((Variable)lect2) == null) continue;
                this.iAssignment.unassign(0L, (Variable)lect2);
            }
            for (Placement plac : initialAssignments.values()) {
                if (plac.equals((Object)this.iAssignment.getValue((Variable)(lect = (Lecture)plac.variable())))) continue;
                this.iAssignment.assign(0L, (Value)plac);
            }
        }
    }

    public Suggestion tryAssignment(Hint hint) {
        return this.tryAssignment(hint.getPlacement(this.iModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Suggestion tryAssignment(Placement placement) {
        Suggestion ret = null;
        boolean canAssign = true;
        Solution solution = this.iSolver.currentSolution();
        synchronized (solution) {
            Lecture lect;
            Placement plac2;
            Enumeration e;
            Vector unAssignedVariables = new Vector(this.iModel.nrUnassignedVariables(this.iAssignment));
            Hashtable<Lecture, Placement> initialAssignments = new Hashtable<Lecture, Placement>();
            for (Lecture lec : this.iAssignment.assignedVariables()) {
                initialAssignments.put(lec, (Placement)this.iAssignment.getValue((Variable)lec));
            }
            Hashtable<Variable, Placement> conflictsToResolve = new Hashtable<Variable, Placement>();
            Vector<Long> resolvedLectures = new Vector<Long>();
            if (this.iHints != null) {
                e = this.iHints.elements();
                while (e.hasMoreElements()) {
                    plac2 = (Placement)e.nextElement();
                    lect = (Lecture)plac2.variable();
                    if (placement != null && ((Lecture)placement.variable()).equals((Object)lect)) continue;
                    Set conflicts = this.iModel.conflictValues(this.iAssignment, (Value)plac2);
                    for (Placement conflictPlacement : conflicts) {
                        conflictsToResolve.put(conflictPlacement.variable(), conflictPlacement);
                        this.iAssignment.unassign(0L, conflictPlacement.variable());
                    }
                    if (!conflicts.contains(plac2)) {
                        resolvedLectures.add(lect.getClassId());
                        conflictsToResolve.remove(lect);
                        this.iAssignment.assign(0L, (Value)plac2);
                        continue;
                    }
                    canAssign = false;
                }
            }
            if (placement != null) {
                Lecture lect2 = (Lecture)placement.variable();
                Set conflicts = this.iModel.conflictValues(this.iAssignment, (Value)placement);
                for (Placement conflictPlacement : conflicts) {
                    conflictsToResolve.put(conflictPlacement.variable(), conflictPlacement);
                    this.iAssignment.unassign(0L, conflictPlacement.variable());
                }
                if (!conflicts.contains(placement)) {
                    resolvedLectures.add(lect2.getClassId());
                    conflictsToResolve.remove(lect2);
                    this.iAssignment.assign(0L, (Value)placement);
                } else {
                    canAssign = false;
                }
            }
            ret = new Suggestion((Solver<Lecture, Placement>)this.iSolver, initialAssignments, resolvedLectures, conflictsToResolve.values());
            ret.setCanAssign(canAssign);
            if (placement != null) {
                ret.setHint(new Hint(this.iSolver, placement));
            }
            if (this.iHints != null) {
                e = this.iHints.elements();
                while (e.hasMoreElements()) {
                    plac2 = (Placement)e.nextElement();
                    lect = (Lecture)plac2.variable();
                    if (this.iAssignment.getValue((Variable)lect) == null) continue;
                    this.iAssignment.unassign(0L, (Variable)lect);
                }
            }
            e = unAssignedVariables.elements();
            while (e.hasMoreElements()) {
                Lecture lect3 = (Lecture)e.nextElement();
                if (this.iAssignment.getValue((Variable)lect3) == null) continue;
                this.iAssignment.unassign(0L, (Variable)lect3);
            }
            if (placement != null) {
                this.iAssignment.unassign(0L, placement.variable());
            }
            for (Placement plac2 : initialAssignments.values()) {
                if (plac2.equals((Object)this.iAssignment.getValue((Variable)(lect = (Lecture)plac2.variable())))) continue;
                this.iAssignment.assign(0L, (Value)plac2);
            }
        }
        return ret;
    }

    public Suggestion currentSuggestion() {
        return this.iCurrentSuggestion;
    }

    public Suggestion emptySuggestion() {
        return this.iEmptySuggestion;
    }

    private TreeSet<PlacementValue> values(Lecture lecture) {
        TreeSet<PlacementValue> vals = new TreeSet<PlacementValue>();
        if (lecture.equals((Object)this.iLecture)) {
            for (Placement p : lecture.allowBreakHard() || !this.iAllowBreakHard ? lecture.values(this.iAssignment) : lecture.computeValues(this.iAssignment, true)) {
                if (!this.match(p)) continue;
                vals.add(new PlacementValue(p));
            }
        } else if (lecture.allowBreakHard() || !this.iAllowBreakHard) {
            for (Placement x : lecture.values(this.iAssignment)) {
                vals.add(new PlacementValue(x));
            }
        } else {
            for (Placement x : lecture.computeValues(this.iAssignment, true)) {
                vals.add(new PlacementValue(x));
            }
        }
        return vals;
    }

    public boolean containsCommited(TimetableModel model, Collection values) {
        if (model.hasConstantVariables()) {
            for (Placement placement : values) {
                Lecture lecture = (Lecture)placement.variable();
                if (!lecture.isCommitted()) continue;
                return true;
            }
        }
        return false;
    }

    private void backtrack(long startTime, Vector initialLectures, Vector resolvedLectures, Hashtable conflictsToResolve, Hashtable initialAssignments, int depth) {
        Enumeration e1;
        ++this.iNrCombinationsConsidered;
        int nrUnassigned = conflictsToResolve.size();
        if ((initialLectures == null || initialLectures.isEmpty()) && nrUnassigned == 0) {
            if (this.iSuggestions.size() == this.iLimit && ((Suggestion)this.iSuggestions.last()).isBetter(this.iSolver)) {
                return;
            }
            this.iSuggestions.add(new Suggestion((Solver<Lecture, Placement>)this.iSolver, initialAssignments, resolvedLectures, conflictsToResolve.values()));
            ++this.iNrSolutions;
            if (this.iSuggestions.size() > this.iLimit) {
                this.iSuggestions.remove(this.iSuggestions.last());
            }
            return;
        }
        if (depth <= 0) {
            return;
        }
        if (this.iTimeOut > 0L && System.currentTimeMillis() - startTime > this.iTimeOut) {
            this.iTimeoutReached = true;
            return;
        }
        if (this.iSuggestions.size() == this.iLimit && ((Suggestion)this.iSuggestions.last()).getValue() < this.getBound(conflictsToResolve)) {
            return;
        }
        Enumeration<Object> enumeration = e1 = initialLectures != null && !initialLectures.isEmpty() ? initialLectures.elements() : conflictsToResolve.keys();
        while (e1.hasMoreElements()) {
            Lecture lecture = (Lecture)e1.nextElement();
            if (this.iTimeoutReached) break;
            if (resolvedLectures.contains(lecture.getClassId())) continue;
            resolvedLectures.add(lecture.getClassId());
            for (PlacementValue placementValue : this.values(lecture)) {
                Placement c;
                Iterator i;
                Set conflicts;
                Placement ini;
                Placement current;
                if (this.iTimeoutReached) break;
                Placement placement = placementValue.getPlacement();
                if (placement.equals((Object)(current = (Placement)this.iAssignment.getValue((Variable)lecture))) || !this.iAllowBreakHard && placement.isHard(this.iAssignment) || this.iSameTime && current != null && !placement.getTimeLocation().equals((Object)current.getTimeLocation()) || this.iSameRoom && current != null && !placement.sameRooms(current) || this.iAllTheSame && this.iSameTime && current == null && (ini = (Placement)initialAssignments.get(lecture)) != null && !placement.sameTime(ini) || this.iAllTheSame && this.iSameRoom && current == null && (ini = (Placement)initialAssignments.get(lecture)) != null && !placement.sameRooms(ini) || (conflicts = this.iModel.conflictValues(this.iAssignment, (Value)placement)) != null && nrUnassigned + conflicts.size() > depth || this.containsCommited(this.iModel, conflicts) || conflicts.contains(placement)) continue;
                boolean containException = false;
                if (conflicts != null) {
                    i = conflicts.iterator();
                    while (!containException && i.hasNext()) {
                        c = (Placement)i.next();
                        if (!resolvedLectures.contains(((Lecture)c.variable()).getClassId())) continue;
                        containException = true;
                    }
                }
                if (containException) continue;
                if (conflicts != null) {
                    i = conflicts.iterator();
                    while (!containException && i.hasNext()) {
                        c = (Placement)i.next();
                        this.iAssignment.unassign(0L, c.variable());
                    }
                }
                this.iAssignment.assign(0L, (Value)placement);
                i = conflicts.iterator();
                while (!containException && i.hasNext()) {
                    c = (Placement)i.next();
                    conflictsToResolve.put(c.variable(), c);
                }
                Placement resolvedConf = (Placement)conflictsToResolve.remove(lecture);
                this.backtrack(startTime, null, resolvedLectures, conflictsToResolve, initialAssignments, depth - 1);
                if (current == null) {
                    this.iAssignment.unassign(0L, (Variable)lecture);
                } else {
                    this.iAssignment.assign(0L, (Value)current);
                }
                if (conflicts != null) {
                    for (Placement p : conflicts) {
                        this.iAssignment.assign(0L, (Value)p);
                        conflictsToResolve.remove(p.variable());
                    }
                }
                if (resolvedConf == null) continue;
                conflictsToResolve.put(lecture, resolvedConf);
            }
            resolvedLectures.remove(lecture.getClassId());
        }
    }

    public boolean getTimeoutReached() {
        return this.iTimeoutReached;
    }

    public long getNrCombinationsConsidered() {
        return this.iNrCombinationsConsidered;
    }

    public long getNrSolutions() {
        return this.iNrSolutions;
    }

    public void computeConfTable() {
        this.iConfTable = new Vector();
        for (TimeLocation t : this.iLecture.timeLocations()) {
            if (!this.iAllowBreakHard && PreferenceLevel.sProhibited.equals(PreferenceLevel.int2prolog(t.getPreference())) || t.getPreference() > 500) continue;
            this.iConfTable.add(new Suggestion(this.iSolver, this.iLecture, t));
        }
    }

    public void computeTryAllAssignments() {
        this.iAllAssignments = new TreeSet();
        Placement current = (Placement)this.iAssignment.getValue((Variable)this.iLecture);
        for (Placement p : this.iLecture.values(this.iAssignment)) {
            if (p.equals((Object)current) || p.isHard(this.iAssignment) && !this.iAllowBreakHard || !this.match(p) || this.iSameTime && current != null && !p.getTimeLocation().equals((Object)current.getTimeLocation()) || this.iSameRoom && current != null && !p.sameRooms(current) || this.iAllAssignments.size() == this.iLimit && ((Suggestion)this.iAllAssignments.last()).isBetter(this.iSolver)) continue;
            Suggestion s = this.tryAssignment(p);
            if (s != null) {
                this.iAllAssignments.add(s);
            }
            if (this.iAllAssignments.size() <= this.iLimit) continue;
            this.iAllAssignments.remove(this.iAllAssignments.last());
        }
    }

    public TreeSet tryAllAssignments() {
        return this.iAllAssignments;
    }

    public long getNrTries() {
        return this.iNrTries;
    }

    public Vector getConfTable() {
        return this.iConfTable;
    }

    public void computeNrTries() {
        Placement placement = (Placement)this.iAssignment.getValue((Variable)this.iLecture);
        this.iNrTries = this.iSameTime && placement != null ? (long)(this.iLecture.nrValues(placement.getTimeLocation()) - 1) : (this.iSameRoom && placement != null ? (placement.isMultiRoom() ? (long)(this.iLecture.nrValues(placement.getRoomLocations()) - 1) : (long)(this.iLecture.nrValues(placement.getRoomLocation()) - 1)) : this.iLecture.nrValues() - (long)(placement == null ? 0 : 1));
    }

    public String toString() {
        return "Suggestions{\n  suggestions = " + this.getSuggestions() + "\n  timeoutReached = " + this.getTimeoutReached() + "\n  nrCombinationsConsidered = " + this.getNrCombinationsConsidered() + "\n  nrSolutions = " + this.getNrSolutions() + "\n  currentSuggestion = " + this.currentSuggestion() + "\n  tryAssignments = " + this.tryAllAssignments() + "\n  nrTries = " + this.getNrTries() + "\n  emptySuggestion = " + this.emptySuggestion() + "\n  hints = " + this.getHints() + "\n  confTable = " + this.getConfTable() + "\n}";
    }

    public double getBound(Hashtable conflictsToResolve) {
        double value = this.iSolver.currentSolution().getModel().getTotalValue(this.iAssignment);
        Enumeration e = conflictsToResolve.keys();
        while (e.hasMoreElements()) {
            Lecture lect = (Lecture)e.nextElement();
            TreeSet<PlacementValue> values = this.values(lect);
            if (values.isEmpty()) continue;
            PlacementValue val = values.first();
            value += val.getValue();
        }
        return value;
    }

    public class PlacementValue
    implements Comparable<PlacementValue> {
        private Placement iPlacement;
        private double iValue;

        public PlacementValue(Placement placement) {
            this.iPlacement = placement;
            this.iValue = placement.toDouble(Suggestions.this.iAssignment);
        }

        public Placement getPlacement() {
            return this.iPlacement;
        }

        public double getValue() {
            return this.iValue;
        }

        @Override
        public int compareTo(PlacementValue p) {
            int cmp = Double.compare(this.getValue(), p.getValue());
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(this.getPlacement().getId(), p.getPlacement().getId());
        }
    }
}

