/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.interactive;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.solver.Solver;
import org.dom4j.Element;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;

public class Hint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iClassId;
    private int iDays;
    private int iStartSlot;
    private List<Long> iRoomIds;
    private Long iPatternId;
    private Long iDatePatternId;
    private AssignmentPreferenceInfo iInfo = null;
    private ClassAssignmentDetails iDetails = null;

    public Hint(Long classId, int days, int startSlot, List<Long> roomIds, Long patternId, Long datePatternId) {
        this.iClassId = classId;
        this.iDays = days;
        this.iStartSlot = startSlot;
        this.iRoomIds = roomIds;
        this.iPatternId = patternId;
        this.iDatePatternId = datePatternId;
    }

    public Hint(Solver solver, Placement placement) {
        this(solver, placement, false);
    }

    public Hint(Solver solver, Placement placement, boolean populateInfo) {
        this.iClassId = ((Lecture)placement.variable()).getClassId();
        this.iDays = placement.getTimeLocation().getDayCode();
        this.iStartSlot = placement.getTimeLocation().getStartSlot();
        this.iRoomIds = placement.getRoomIds();
        this.iPatternId = placement.getTimeLocation().getTimePatternId();
        this.iDatePatternId = placement.getTimeLocation().getDatePatternId();
        if (populateInfo && solver != null) {
            this.iInfo = new AssignmentPreferenceInfo(solver, placement, false);
        }
        if (((Lecture)placement.variable()).isCommitted() && solver != null) {
            this.iDetails = new ClassAssignmentDetails(solver, (Lecture)placement.variable(), placement, false);
        }
    }

    public Placement getPlacement(TimetableModel model) {
        return this.getPlacement(model, true);
    }

    public Placement getPlacement(TimetableModel model, boolean checkValidity) {
        for (Lecture lecture : model.variables()) {
            if (!lecture.getClassId().equals(this.iClassId)) continue;
            Object timeLocation = null;
            for (Object t : lecture.timeLocations()) {
                if (t.getDayCode() != this.iDays || t.getStartSlot() != this.iStartSlot || !t.getTimePatternId().equals(this.iPatternId) || !t.getDatePatternId().equals(this.iDatePatternId)) continue;
                timeLocation = t;
                break;
            }
            Vector<RoomLocation> roomLocations = new Vector<RoomLocation>();
            if (lecture.getNrRooms() > 0) {
                Object t;
                t = this.iRoomIds.iterator();
                while (t.hasNext()) {
                    Long roomId = (Long)t.next();
                    for (RoomLocation r : lecture.roomLocations()) {
                        if (!r.getId().equals(roomId)) continue;
                        roomLocations.add(r);
                    }
                }
            }
            if (timeLocation == null || roomLocations.size() != lecture.getNrRooms()) continue;
            Placement placement = new Placement(lecture, timeLocation, roomLocations);
            if (checkValidity && !placement.isValid()) {
                return null;
            }
            return placement;
        }
        return null;
    }

    public AssignmentPreferenceInfo getInfo(Solver solver) {
        Placement p = this.getPlacement((TimetableModel)solver.currentSolution().getModel());
        if (p == null) {
            return null;
        }
        return new AssignmentPreferenceInfo(solver, p, false);
    }

    public String getNotValidReason(Solver solver) {
        Placement p = this.getPlacement((TimetableModel)solver.currentSolution().getModel(), false);
        if (p == null) {
            return "Selected placement is not valid (room or instructor not avaiable).";
        }
        if (p.isValid()) {
            return "Selected placement is valid.";
        }
        String reason = p.getNotValidReason(solver.currentSolution().getAssignment(), solver.getProperties().getPropertyBoolean("General.UseAmPm", true));
        return reason == null ? "Selected placement is not valid (room or instructor not avaiable)." : "Selected placement is not valid (" + reason + ")";
    }

    public Long getClassId() {
        return this.iClassId;
    }

    public int getDays() {
        return this.iDays;
    }

    public int getStartSlot() {
        return this.iStartSlot;
    }

    public List<Long> getRoomIds() {
        return this.iRoomIds;
    }

    public Long getPatternId() {
        return this.iPatternId;
    }

    public Long getDatePatternId() {
        return this.iDatePatternId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Hint)) {
            return false;
        }
        return this.iClassId.equals(((Hint)o).getClassId());
    }

    public int hashCode() {
        return this.iClassId.hashCode();
    }

    public ClassAssignmentDetails getDetails(SessionContext context, SolverProxy solver, boolean includeConstraints) {
        if (this.iDetails != null) {
            return this.iDetails;
        }
        if (this.iInfo == null && solver != null) {
            this.iInfo = solver.getInfo(this);
        }
        this.iDetails = ClassAssignmentDetails.createClassAssignmentDetails(context, solver, this.iClassId, includeConstraints);
        if (this.iDetails != null) {
            this.iDetails.setAssigned(this.iInfo, this.iRoomIds, this.iDays, this.iStartSlot, this.iPatternId, this.iDatePatternId);
        }
        return this.iDetails;
    }

    public ClassAssignmentDetails getDetailsUnassign(SessionContext context, SolverProxy solver, boolean includeConstraints) {
        if (this.iDetails != null) {
            return this.iDetails;
        }
        this.iDetails = ClassAssignmentDetails.createClassAssignmentDetails(context, solver, this.iClassId, includeConstraints);
        return this.iDetails;
    }

    public void setDetails(ClassAssignmentDetails details) {
        this.iDetails = details;
    }

    public void toXml(Element element) {
        element.addAttribute("id", String.valueOf(this.iClassId));
        element.addAttribute("days", String.valueOf(this.iDays));
        element.addAttribute("start", String.valueOf(this.iStartSlot));
        if (this.iRoomIds != null) {
            for (Long roomId : this.iRoomIds) {
                if (roomId == null) continue;
                element.addElement("room").addAttribute("id", roomId.toString());
            }
        }
        if (this.iPatternId != null) {
            element.addAttribute("pattern", this.iPatternId.toString());
        }
        if (this.iDatePatternId != null) {
            element.addAttribute("dates", this.iDatePatternId.toString());
        }
    }

    public static Hint fromXml(Element element) {
        Vector<Long> roomIds = new Vector<Long>();
        Iterator i = element.elementIterator("room");
        while (i.hasNext()) {
            roomIds.addElement(Long.valueOf(((Element)i.next()).attributeValue("id")));
        }
        return new Hint(Long.valueOf(element.attributeValue("id")), Integer.parseInt(element.attributeValue("days")), Integer.parseInt(element.attributeValue("start")), roomIds, element.attributeValue("pattern") == null ? null : Long.valueOf(element.attributeValue("pattern")), element.attributeValue("dates") == null ? null : Long.valueOf(element.attributeValue("dates")));
    }

    public String toString() {
        return "Hint{classId = " + this.iClassId + ", days = " + this.iDays + ", startSlot = " + this.iStartSlot + ", roomIds = " + this.iRoomIds + "}";
    }

    public static class HintComparator
    implements Comparator {
        private Vector iOrder;

        public HintComparator(Vector order) {
            this.iOrder = order;
        }

        public int compare(Object o1, Object o2) {
            Hint p1 = (Hint)o1;
            Hint p2 = (Hint)o2;
            int i1 = this.iOrder.indexOf(p1.getClassId());
            int i2 = this.iOrder.indexOf(p2.getClassId());
            return new Integer(i1).compareTo(new Integer(i2));
        }
    }
}

