/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.interactive;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.hibernate.Session;
import org.unitime.commons.Debug;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.base.BaseAssignment;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.AssignmentDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.BtbInstructorConstraintInfo;
import org.unitime.timetable.solver.ui.GroupConstraintInfo;
import org.unitime.timetable.solver.ui.JenrlInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.timegrid.SolutionGridModel;
import org.unitime.timetable.webutil.timegrid.SolverGridModel;

public class ClassAssignmentDetails
implements Serializable,
Comparable {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private static final long serialVersionUID = 1L;
    public static DecimalFormat sDF = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    public static DecimalFormat sJenrDF = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
    public static NaturalOrderComparator sCmp = new NaturalOrderComparator();
    private ClassInfo iClass = null;
    private TimeInfo iTime = null;
    private RoomInfo[] iRoom = null;
    private InstructorInfo[] iInstructor = null;
    private TimeInfo iInitialTime = null;
    private RoomInfo[] iInitialRoom = null;
    private TimeInfo iAssignedTime = null;
    private RoomInfo[] iAssignedRoom = null;
    private AssignmentPreferenceInfo iAssignmentInfo = null;
    private AssignmentPreferenceInfo iAssignedAssignmentInfo = null;
    private RoomInfos iRooms = new RoomInfos();
    private TimeInfos iTimes = new TimeInfos();
    private Vector iStudentConflicts = new Vector();
    private Vector iGroupConstraintInfos = new Vector();
    private Vector iBtbInstructorInfos = new Vector();

    public ClassInfo getClazz() {
        return this.iClass;
    }

    public TimeInfo getTime() {
        return this.iTime;
    }

    public RoomInfo[] getRoom() {
        return this.iRoom;
    }

    public InstructorInfo[] getInstructor() {
        return this.iInstructor;
    }

    public TimeInfo getInitialTime() {
        return this.iInitialTime;
    }

    public RoomInfo[] getInitialRoom() {
        return this.iInitialRoom;
    }

    public TimeInfo getAssignedTime() {
        return this.iAssignedTime != null ? this.iAssignedTime : this.iTime;
    }

    public RoomInfo[] getAssignedRoom() {
        return this.iAssignedRoom != null ? this.iAssignedRoom : this.iRoom;
    }

    public boolean isInitial() {
        return this.getAssignedTime() != null && this.getAssignedRoom() != null && this.getAssignedTime().equals(this.getInitialTime()) && this.getAssignedRoom().equals(this.getInitialRoom());
    }

    public void setAssigned(AssignmentPreferenceInfo info, List<Long> roomIds, int days, int slot, Long patternId, Long datePatternId) {
        this.iAssignedTime = null;
        if (days >= 0 && slot >= 0) {
            Enumeration e = this.iTimes.elements();
            while (e.hasMoreElements()) {
                TimeInfo time = (TimeInfo)e.nextElement();
                if (time.getDays() != days || time.getStartSlot() != slot || patternId != null && !patternId.equals(time.getPatternId()) || datePatternId != null && !datePatternId.equals(time.getDatePatternId())) continue;
                this.iAssignedTime = time;
                break;
            }
        }
        this.iAssignedRoom = null;
        if (roomIds != null) {
            int idx = 0;
            this.iAssignedRoom = new RoomInfo[roomIds.size()];
            block1: for (Long roomId : roomIds) {
                Enumeration f = this.iRooms.elements();
                while (f.hasMoreElements()) {
                    RoomInfo room = (RoomInfo)f.nextElement();
                    if (!room.getId().equals(roomId)) continue;
                    this.iAssignedRoom[idx++] = room;
                    continue block1;
                }
            }
        }
        this.iAssignedAssignmentInfo = info;
    }

    public AssignmentPreferenceInfo getAssignmentInfo() {
        return this.iAssignmentInfo;
    }

    public RoomInfos getRooms() {
        return this.iRooms;
    }

    public TimeInfos getTimes() {
        return this.iTimes;
    }

    public Vector getStudentConflicts() {
        return this.iStudentConflicts;
    }

    public Vector getGroupConstraints() {
        return this.iGroupConstraintInfos;
    }

    public Vector getBtbInstructors() {
        return this.iBtbInstructorInfos;
    }

    public boolean hasViolatedGroupConstraint() {
        Enumeration e = this.iGroupConstraintInfos.elements();
        while (e.hasMoreElements()) {
            DistributionInfo info = (DistributionInfo)e.nextElement();
            if (info.getInfo().isSatisfied()) continue;
            return true;
        }
        return false;
    }

    public ClassAssignmentDetails(Solver solver, Lecture lecture, boolean includeConstraints) {
        this(solver, lecture, (Placement)solver.currentSolution().getAssignment().getValue((Variable)lecture), includeConstraints);
    }

    public ClassAssignmentDetails(Solver solver, Lecture lecture, Placement placement, boolean includeConstraints) {
        Placement initialPlacement;
        org.cpsolver.ifs.assignment.Assignment assignment = solver.currentSolution().getAssignment();
        this.iClass = new ClassInfo(lecture.getName(), lecture.getClassId(), lecture.getNrRooms(), SolverGridModel.hardConflicts2pref((org.cpsolver.ifs.assignment.Assignment<Lecture, Placement>)solver.currentSolution().getAssignment(), lecture, placement), lecture.minRoomSize(), lecture.getOrd(), lecture.getNote());
        if (placement != null) {
            if (placement.isMultiRoom()) {
                this.iRoom = new RoomInfo[placement.getRoomLocations().size()];
                int idx = 0;
                for (RoomLocation room : placement.getRoomLocations()) {
                    this.iRoom[idx] = new RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference());
                    ++idx;
                }
            } else {
                RoomLocation room = placement.getRoomLocation();
                this.iRoom = new RoomInfo[]{new RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == 1 ? PreferenceLevel.sIntLevelRequired : room.getPreference())};
            }
            TimeLocation time = placement.getTimeLocation();
            int min = Constants.SLOT_LENGTH_MIN * time.getNrSlotsPerMeeting() - time.getBreakTime();
            this.iTime = new TimeInfo(time.getDayCode(), time.getStartSlot(), time.getPreference() == 0 && lecture.nrTimeLocations() == 1 ? PreferenceLevel.sIntLevelRequired : time.getPreference(), min, time.getDatePatternName(), time.getTimePatternId(), time.getDatePatternId(), time.getDatePatternPreference());
            if (!lecture.getInstructorConstraints().isEmpty()) {
                this.iInstructor = new InstructorInfo[lecture.getInstructorConstraints().size()];
                for (int i = 0; i < lecture.getInstructorConstraints().size(); ++i) {
                    InstructorConstraint ic = (InstructorConstraint)lecture.getInstructorConstraints().get(i);
                    this.iInstructor[i] = new InstructorInfo(ic.getName(), ic.getResourceId());
                }
            }
            this.iAssignmentInfo = new AssignmentPreferenceInfo(solver, placement);
        }
        if ((initialPlacement = (Placement)lecture.getInitialAssignment()) != null) {
            if (initialPlacement.isMultiRoom()) {
                this.iInitialRoom = new RoomInfo[initialPlacement.getRoomLocations().size()];
                int idx = 0;
                for (RoomLocation room : initialPlacement.getRoomLocations()) {
                    this.iInitialRoom[idx] = new RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference());
                    ++idx;
                }
            } else {
                RoomLocation room = initialPlacement.getRoomLocation();
                this.iInitialRoom = new RoomInfo[]{new RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == 1 ? PreferenceLevel.sIntLevelRequired : room.getPreference())};
            }
            TimeLocation time = initialPlacement.getTimeLocation();
            int min = Constants.SLOT_LENGTH_MIN * time.getNrSlotsPerMeeting() - time.getBreakTime();
            this.iInitialTime = new TimeInfo(time.getDayCode(), time.getStartSlot(), time.getPreference() == 0 && lecture.nrTimeLocations() == 1 ? PreferenceLevel.sIntLevelRequired : time.getPreference(), min, time.getDatePatternName(), time.getTimePatternId(), time.getDatePatternId(), time.getDatePatternPreference());
        }
        for (TimeLocation time : lecture.timeLocations()) {
            int min = Constants.SLOT_LENGTH_MIN * time.getNrSlotsPerMeeting() - time.getBreakTime();
            this.iTimes.add(new TimeInfo(time.getDayCode(), time.getStartSlot(), time.getPreference() == 0 && lecture.nrTimeLocations() == 1 ? PreferenceLevel.sIntLevelRequired : time.getPreference(), min, time.getDatePatternName(), time.getTimePatternId(), time.getDatePatternId(), time.getDatePatternPreference()));
        }
        for (RoomLocation room : lecture.roomLocations()) {
            this.iRooms.add(new RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference()));
        }
        if (includeConstraints) {
            for (JenrlConstraint jenrl : lecture.activeJenrls(assignment)) {
                Lecture another = (Lecture)jenrl.another((Variable)lecture);
                if (jenrl.isToBeIgnored()) continue;
                this.iStudentConflicts.add(new StudentConflictInfo(another.getClassId(), new JenrlInfo(solver, jenrl), "class"));
            }
            if (placement != null) {
                Hashtable<Long, JenrlInfo> infos = JenrlInfo.getCommitedJenrlInfos(solver, lecture);
                for (Map.Entry<Long, JenrlInfo> entry : infos.entrySet()) {
                    Long assignmentId = entry.getKey();
                    Iterator jInfo = entry.getValue();
                    this.iStudentConflicts.add(new StudentConflictInfo(assignmentId, (JenrlInfo)((Object)jInfo), "otherAssignment"));
                }
            }
            for (Constraint c : lecture.constraints()) {
                DistributionInfo dist;
                GroupConstraint gc;
                if (c instanceof GroupConstraint) {
                    gc = (GroupConstraint)c;
                    dist = new DistributionInfo(new GroupConstraintInfo((org.cpsolver.ifs.assignment.Assignment<Lecture, Placement>)assignment, gc));
                    for (Lecture another : gc.variables()) {
                        if (another.equals((Object)lecture)) continue;
                        dist.addClass(another.getClassId());
                    }
                    this.iGroupConstraintInfos.add(dist);
                }
                if (!(c instanceof FlexibleConstraint)) continue;
                gc = (FlexibleConstraint)c;
                dist = new DistributionInfo(new GroupConstraintInfo((org.cpsolver.ifs.assignment.Assignment<Lecture, Placement>)assignment, (FlexibleConstraint)gc));
                for (Lecture another : gc.variables()) {
                    if (another.equals((Object)lecture)) continue;
                    dist.addClass(another.getClassId());
                }
                this.iGroupConstraintInfos.add(dist);
            }
            if (!lecture.getInstructorConstraints().isEmpty() && placement != null) {
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    for (Lecture other : ic.variables()) {
                        int pref;
                        if (other.equals((Object)lecture) || assignment.getValue((Variable)other) == null || (pref = ic.getDistancePreference(placement, (Placement)assignment.getValue((Variable)other))) == PreferenceLevel.sIntLevelNeutral) continue;
                        this.iBtbInstructorInfos.add(new BtbInstructorInfo(other.getClassId(), pref));
                    }
                }
            }
        }
    }

    public ClassAssignmentDetails(Solution solution, Assignment assignment, boolean includeConstraints, Session hibSession, String instructorNameFormat) {
        if (assignment != null) {
            this.iAssignmentInfo = (AssignmentPreferenceInfo)assignment.getAssignmentInfo("AssignmentInfo");
            if (this.iAssignmentInfo == null) {
                this.iAssignmentInfo = new AssignmentPreferenceInfo();
            }
            if (!assignment.getRooms().isEmpty()) {
                this.iRoom = new RoomInfo[assignment.getRooms().size()];
                int idx = 0;
                for (Location room : assignment.getRooms()) {
                    this.iRoom[idx] = new RoomInfo(room.getLabel(), room.getUniqueId(), room.getCapacity().longValue(), this.iAssignmentInfo.getRoomPreference(room.getUniqueId()));
                    ++idx;
                }
            } else {
                this.iRoom = new RoomInfo[0];
            }
            int length = assignment.getTimePattern().getSlotsPerMtg();
            int breakTime = assignment.getTimePattern().getBreakTime();
            if (assignment.getTimePattern().getType() == 5) {
                DurationModel dm = assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(assignment.getClazz().getSchedulingSubpart().getMinutesPerWk(), assignment.getDatePattern(), assignment.getDays());
                length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
            }
            int min = Constants.SLOT_LENGTH_MIN * length - breakTime;
            DatePattern datePattern = assignment.getDatePattern();
            this.iTime = new TimeInfo(assignment.getDays(), assignment.getStartSlot(), this.iAssignmentInfo.getTimePreference(), min, datePattern == null ? "not set" : datePattern.getName(), assignment.getTimePattern().getUniqueId(), datePattern == null ? null : datePattern.getUniqueId(), this.iAssignmentInfo.getDatePatternPref());
            TreeSet<DepartmentalInstructor> instructors = new TreeSet<DepartmentalInstructor>();
            if (ApplicationProperty.TimetableGridUseClassInstructors.isTrue()) {
                if (!ApplicationProperty.TimetableGridUseClassInstructorsCheckClassDisplayInstructors.isTrue() || assignment.getClazz().isDisplayInstructor().booleanValue()) {
                    for (ClassInstructor classInstructor : assignment.getClazz().getClassInstructors()) {
                        if (!classInstructor.isLead().booleanValue() && ApplicationProperty.TimetableGridUseClassInstructorsCheckLead.isTrue()) continue;
                        instructors.add(classInstructor.getInstructor());
                    }
                }
            } else {
                instructors.addAll(assignment.getInstructors());
            }
            if (instructors != null && !instructors.isEmpty()) {
                this.iInstructor = new InstructorInfo[instructors.size()];
                int idx = 0;
                for (DepartmentalInstructor di : instructors) {
                    this.iInstructor[idx] = new InstructorInfo(di.getName(instructorNameFormat), di.getUniqueId());
                    ++idx;
                }
            }
            if (includeConstraints) {
                BaseAssignment another;
                Serializable info;
                ConstraintInfo constraint;
                for (Map.Entry entry : assignment.getConstraintInfoTable("JenrlInfo").entrySet()) {
                    constraint = (ConstraintInfo)entry.getKey();
                    info = (JenrlInfo)entry.getValue();
                    another = null;
                    for (Assignment x : constraint.getAssignments()) {
                        if (x.getUniqueId().equals(assignment.getUniqueId())) continue;
                        another = x;
                        break;
                    }
                    this.iStudentConflicts.add(new StudentConflictInfo(another.getUniqueId(), (JenrlInfo)info, "otherAssignment"));
                }
                for (Map.Entry entry : assignment.getConstraintInfoTable("DistributionInfo").entrySet()) {
                    constraint = (ConstraintInfo)entry.getKey();
                    info = (GroupConstraintInfo)entry.getValue();
                    DistributionInfo dist = new DistributionInfo((GroupConstraintInfo)info);
                    for (Assignment another2 : constraint.getAssignments()) {
                        if (another2.getUniqueId().equals(assignment.getUniqueId())) continue;
                        dist.addClass(another2.getClazz().getUniqueId());
                    }
                    this.iGroupConstraintInfos.add(dist);
                }
                for (Map.Entry entry : assignment.getConstraintInfoTable("BtbInstructorInfo").entrySet()) {
                    constraint = (ConstraintInfo)entry.getKey();
                    info = (BtbInstructorConstraintInfo)entry.getValue();
                    another = null;
                    for (Assignment x : constraint.getAssignments()) {
                        if (x.getUniqueId().equals(assignment.getUniqueId())) continue;
                        another = x;
                        break;
                    }
                    this.iBtbInstructorInfos.add(new BtbInstructorInfo(another.getClazz().getUniqueId(), ((BtbInstructorConstraintInfo)info).getPreference()));
                }
            }
        }
        this.iClass = new ClassInfo(assignment.getClassName(), assignment.getClassId(), assignment.getRooms().size(), SolutionGridModel.hardConflicts2pref(this.iAssignmentInfo), -1, assignment.getClazz());
    }

    public static ClassAssignmentDetails createClassAssignmentDetailsFromAssignment(SessionContext context, Long assignmentId, boolean includeConstraints) {
        AssignmentDAO dao = new AssignmentDAO();
        Session hibSession = dao.getSession();
        Assignment assignment = (Assignment)dao.get(assignmentId, hibSession);
        if (assignment == null) {
            return null;
        }
        String instructorNameFormat = context.getUser().getProperty(UserProperty.NameFormat);
        ClassAssignmentDetails ret = new ClassAssignmentDetails(assignment.getSolution(), assignment, includeConstraints, hibSession, instructorNameFormat);
        return ret;
    }

    public static ClassAssignmentDetails createClassAssignmentDetails(SessionContext context, SolverProxy solver, Long classId, boolean includeConstraints) {
        String instructorNameFormat = context.getUser().getProperty(UserProperty.NameFormat);
        if (solver != null) {
            ClassAssignmentDetails details = solver.getClassAssignmentDetails(classId, includeConstraints);
            if (details != null) {
                return details;
            }
            try {
                Class_DAO dao = new Class_DAO();
                Session hibSession = dao.getSession();
                Class_ clazz = (Class_)dao.get(classId, hibSession);
                if (clazz == null) {
                    return null;
                }
                Assignment assignment = solver.getAssignment(clazz);
                if (assignment == null || assignment.getSolution() == null) {
                    return null;
                }
                return new ClassAssignmentDetails(assignment.getSolution(), assignment, false, hibSession, instructorNameFormat);
            }
            catch (Exception e) {
                return null;
            }
        }
        Class_ clazz = (Class_)new Class_DAO().get(classId);
        if (clazz == null) {
            return null;
        }
        SolutionDAO dao = new SolutionDAO();
        Session hibSession = dao.getSession();
        String solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution);
        if (solutionIdsStr != null && solutionIdsStr.length() > 0) {
            StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
            while (s.hasMoreTokens()) {
                Long solutionId = Long.valueOf(s.nextToken());
                Solution solution = (Solution)dao.get(solutionId, hibSession);
                if (solution == null || !solution.getOwner().equals(clazz.getManagingDept().getSolverGroup())) continue;
                for (Assignment assignment : clazz.getAssignments()) {
                    if (!solution.equals(assignment.getSolution())) continue;
                    return new ClassAssignmentDetails(assignment.getSolution(), assignment, includeConstraints, hibSession, instructorNameFormat);
                }
                return null;
            }
        }
        if (clazz.getCommittedAssignment() != null) {
            return new ClassAssignmentDetails(clazz.getCommittedAssignment().getSolution(), clazz.getCommittedAssignment(), includeConstraints, hibSession, instructorNameFormat);
        }
        return null;
    }

    public static String dispPref(String oldPref, String newPref) {
        if (newPref == null) {
            return "<font color='" + PreferenceLevel.prolog2color(oldPref) + "'><u>" + PreferenceLevel.prolog2string(oldPref) + "</u></font>";
        }
        if (oldPref.equals(newPref)) {
            return "<font color='" + PreferenceLevel.prolog2color(newPref) + "'>" + PreferenceLevel.prolog2string(newPref) + "</font>";
        }
        return "<font color='" + PreferenceLevel.prolog2color(oldPref) + "'><s>" + PreferenceLevel.prolog2string(oldPref) + "</s></font><br><font color='" + PreferenceLevel.prolog2color(newPref) + "'><u>" + PreferenceLevel.prolog2string(newPref) + "</u></font>";
    }

    public static String dispNumber(int number) {
        return ClassAssignmentDetails.dispNumber("", number);
    }

    public static String dispNumber(String prefix, int number) {
        if (number > 0) {
            return "<font color='red'>" + prefix + "+" + number + "</font>";
        }
        if (number < 0) {
            return "<font color='green'>" + prefix + number + "</font>";
        }
        return prefix + "0";
    }

    public static String dispNumber(int n1, int n2) {
        return ClassAssignmentDetails.dispNumber(n1 - n2) + "</td><td nowrap>(" + n2 + (n1 == n2 ? "" : " &rarr; " + n1) + ")";
    }

    public static String dispNumber(double n1, double n2) {
        return ClassAssignmentDetails.dispNumber(n1 - n2) + "</td><td nowrap>(" + sDF.format(n2) + (n1 == n2 ? "" : " &rarr; " + sDF.format(n1)) + ")";
    }

    public static String dispNumberShort(boolean rem, int n1, int n2) {
        if (n1 == 0 && n2 == 0) {
            return "";
        }
        if (rem) {
            return ClassAssignmentDetails.dispNumber(-n1);
        }
        int dif = n2 - n1;
        if (dif == 0) {
            return n1 + "&rarr;" + n2;
        }
        if (dif < 0) {
            return "<font color='green'>" + n1 + "&rarr;" + n2 + "</font>";
        }
        return "<font color='red'>" + n1 + "&rarr;" + n2 + "</font>";
    }

    public static String dispNumberShort(boolean rem, double n1, double n2) {
        return ClassAssignmentDetails.dispNumberShort(rem, "", n1, n2);
    }

    public static String dispNumberShort(boolean rem, String prefix, double n1, double n2) {
        if (n1 == 0.0 && n2 == 0.0) {
            return "";
        }
        if (rem) {
            return ClassAssignmentDetails.dispNumber(prefix, -n1);
        }
        double dif = n2 - n1;
        if (dif == 0.0) {
            return prefix + sDF.format(n1) + "&rarr;" + sDF.format(n2);
        }
        if (dif < 0.0) {
            return "<font color='green'>" + prefix + sDF.format(n1) + "&rarr;" + sDF.format(n2) + "</font>";
        }
        return "<font color='red'>" + prefix + sDF.format(n1) + "&rarr;" + sDF.format(n2) + "</font>";
    }

    public static String dispTime(TimeInfo oldTime, TimeInfo newTime) {
        if (oldTime == null) {
            if (newTime == null) {
                return "";
            }
            return newTime.toHtml(false, false, false, false);
        }
        if (newTime == null) {
            return oldTime.toHtml(false, false, false, false) + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>";
        }
        if (oldTime.equals(newTime)) {
            return newTime.toHtml(false, false, false, false);
        }
        return oldTime.toHtml(false, false, false, false) + " &rarr; " + newTime.toHtml(false, false, false, false);
    }

    public static String dispTime2(TimeInfo oldTime, TimeInfo newTime) {
        if (oldTime == null) {
            if (newTime == null) {
                return "";
            }
            return "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font> &rarr; " + newTime.toHtml(false, false, false, false);
        }
        if (newTime == null) {
            return oldTime.toHtml(false, false, false, false) + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>";
        }
        if (oldTime.equals(newTime)) {
            return newTime.toHtml(false, false, false, false);
        }
        return oldTime.toHtml(false, false, false, false) + " &rarr; " + newTime.toHtml(false, false, false, false);
    }

    public static String dispTimeNoHtml(TimeInfo oldTime, TimeInfo newTime) {
        if (oldTime == null) {
            if (newTime == null) {
                return "";
            }
            return "not-assigned -> " + newTime.getDaysName() + " " + newTime.getStartTime();
        }
        if (newTime == null) {
            return oldTime.getDaysName() + " " + oldTime.getStartTime() + " -> not-assigned";
        }
        if (oldTime.equals(newTime)) {
            return newTime.getDaysName() + " " + newTime.getStartTime();
        }
        return oldTime.getDaysName() + " " + oldTime.getStartTime() + " -> " + newTime.getDaysName() + " " + newTime.getStartTime();
    }

    public static String dispRoom(RoomInfo oldRoom, RoomInfo newRoom) {
        if (oldRoom == null) {
            return newRoom.toHtml(false, false, false);
        }
        if (newRoom == null) {
            return oldRoom.toHtml(false, false, false) + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>";
        }
        if (oldRoom.equals(newRoom)) {
            return newRoom.toHtml(false, false, false);
        }
        return oldRoom.toHtml(false, false, false) + " &rarr; " + newRoom.toHtml(false, false, false);
    }

    public static String dispRoom2(RoomInfo oldRoom, RoomInfo newRoom) {
        if (oldRoom == null) {
            return "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font> &rarr; " + newRoom.toHtml(false, false, false);
        }
        if (newRoom == null) {
            return oldRoom.toHtml(false, false, false) + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>";
        }
        if (oldRoom.equals(newRoom)) {
            return newRoom.toHtml(false, false, false);
        }
        return oldRoom.toHtml(false, false, false) + " &rarr; " + newRoom.toHtml(false, false, false);
    }

    public static String dispRoomNoHtml(RoomInfo oldRoom, RoomInfo newRoom) {
        if (oldRoom == null) {
            return "not-assigned -> " + newRoom.getName();
        }
        if (newRoom == null) {
            return oldRoom.getName() + " -> not-assigned";
        }
        if (oldRoom.equals(newRoom)) {
            return newRoom.getName();
        }
        return oldRoom.getName() + " -> " + newRoom.getName();
    }

    public static String dispNumber(double number) {
        return ClassAssignmentDetails.dispNumber("", number);
    }

    public static String dispNumber(String prefix, double number) {
        if (number > 0.0) {
            return "<font color='red'>" + prefix + "+" + sDF.format(number) + "</font>";
        }
        if (number < 0.0) {
            return "<font color='green'>" + prefix + sDF.format(number) + "</font>";
        }
        return prefix + "0";
    }

    public static String dispNumberNoHtml(double number) {
        return ClassAssignmentDetails.dispNumberNoHtml("", number);
    }

    public static String dispNumberNoHtml(String prefix, double number) {
        if (number > 0.0) {
            return prefix + "+" + sDF.format(number);
        }
        if (number < 0.0) {
            return prefix + sDF.format(number);
        }
        return prefix + "0";
    }

    public String getDistributionPreference() {
        if (this.iGroupConstraintInfos.isEmpty()) {
            return "0";
        }
        PreferenceCombination constrPreference = PreferenceCombination.getDefault();
        Enumeration i2 = this.iGroupConstraintInfos.elements();
        while (i2.hasMoreElements()) {
            GroupConstraintInfo cInfo = ((DistributionInfo)i2.nextElement()).getInfo();
            if (cInfo.isSatisfied()) continue;
            constrPreference.addPreferenceProlog(cInfo.getPreference());
        }
        return constrPreference.getPreferenceProlog();
    }

    public String getClassName() {
        return this.getClazz().getName();
    }

    public String getClassHtml() {
        return this.getClazz().toHtml(true);
    }

    public String getTimeName() {
        return this.getTime() == null ? (this.getAssignedTime() == null ? "" : this.getAssignedTime().getDaysName() + " " + this.getAssignedTime().getStartTime()) : this.getTime().getDaysName() + " " + this.getTime().getStartTime();
    }

    public String getTimeHtml() {
        return ClassAssignmentDetails.dispTime(this.iTime, this.iAssignedTime);
    }

    public String getTimeNoHtml() {
        return ClassAssignmentDetails.dispTimeNoHtml(this.iTime, this.iAssignedTime);
    }

    public String getDaysName() {
        return this.getTime() == null ? (this.getAssignedTime() == null ? "" : this.getAssignedTime().getDatePatternName()) : this.getTime().getDatePatternName();
    }

    public String getDaysHtml() {
        return this.getTime() == null ? (this.getAssignedTime() == null ? "" : this.getAssignedTime().getDatePatternHtml()) : (this.getAssignedTime().getDatePatternName().equals(this.getTime().getDatePatternName()) ? this.getTime().getDatePatternHtml() : this.getTime().getDatePatternHtml() + " &rarr; " + this.getAssignedTime().getDatePatternHtml());
    }

    public String getRoomName() {
        RoomInfo[] r;
        RoomInfo[] roomInfoArray = r = this.getRoom() == null ? this.getAssignedRoom() : this.getRoom();
        if (r == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < r.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(r[i].getName());
        }
        return sb.toString();
    }

    public String getRoomHtml() {
        RoomInfo[] r;
        RoomInfo[] roomInfoArray = r = this.getRoom() == null ? this.getAssignedRoom() : this.getRoom();
        if (r == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < r.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ClassAssignmentDetails.dispRoom(this.iRoom == null ? null : this.iRoom[i], this.iAssignedRoom == null ? null : this.iAssignedRoom[i]));
        }
        return sb.toString();
    }

    public String getRoomNoHtml() {
        RoomInfo[] r;
        RoomInfo[] roomInfoArray = r = this.getRoom() == null ? this.getAssignedRoom() : this.getRoom();
        if (r == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < r.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ClassAssignmentDetails.dispRoomNoHtml(this.iRoom == null ? null : this.iRoom[i], this.iAssignedRoom == null ? null : this.iAssignedRoom[i]));
        }
        return sb.toString();
    }

    public String getPertPenalty() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0.0 : this.iAssignmentInfo.getPerturbationPenalty(), this.iAssignedAssignmentInfo == null ? 0.0 : this.iAssignedAssignmentInfo.getPerturbationPenalty());
    }

    public Comparable getPertPenaltyCmp() {
        return new Double((this.iAssignmentInfo == null ? 0.0 : this.iAssignmentInfo.getPerturbationPenalty()) - (this.iAssignedAssignmentInfo == null ? 0.0 : this.iAssignedAssignmentInfo.getPerturbationPenalty()));
    }

    public String getNrStudentConflicts() {
        String s = ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getNrStudentConflicts(), this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getNrStudentConflicts());
        String c = ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, "c", this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getNrCommitedStudentConflicts(), this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getNrCommitedStudentConflicts());
        String d = ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, "d", this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getNrDistanceStudentConflicts(), this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getNrDistanceStudentConflicts());
        String h = ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, "h", this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getNrHardStudentConflicts(), this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getNrHardStudentConflicts());
        if (c.length() == 0 && d.length() == 0 && h.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        if (c.length() > 0) {
            sb.append(c);
        }
        if (d.length() > 0) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(d);
        }
        if (h.length() > 0) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(h);
        }
        return s + " (" + sb + ")";
    }

    public Comparable getNrStudentConflictsCmp() {
        return new Integer((this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getNrStudentConflicts()) - (this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getNrStudentConflicts()));
    }

    public String getTimePreference() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0.0 : this.iAssignmentInfo.getNormalizedTimePreference(), this.iAssignedAssignmentInfo == null ? 0.0 : this.iAssignedAssignmentInfo.getNormalizedTimePreference());
    }

    public Comparable getTimePreferenceCmp() {
        return new Double((this.iAssignmentInfo == null ? 0.0 : this.iAssignmentInfo.getNormalizedTimePreference()) - (this.iAssignedAssignmentInfo == null ? 0.0 : this.iAssignedAssignmentInfo.getNormalizedTimePreference()));
    }

    public String getRoomPreference() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0.0 : (double)this.iAssignmentInfo.sumRoomPreference(), this.iAssignedAssignmentInfo == null ? 0.0 : (double)this.iAssignedAssignmentInfo.sumRoomPreference());
    }

    public Comparable getRoomPreferenceCmp() {
        return new Double((this.iAssignmentInfo == null ? 0.0 : (double)this.iAssignmentInfo.sumRoomPreference()) - (this.iAssignedAssignmentInfo == null ? 0.0 : (double)this.iAssignedAssignmentInfo.sumRoomPreference()));
    }

    public String getBtbInstructorPreference() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getBtbInstructorPreference(), this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getBtbInstructorPreference());
    }

    public Comparable getBtbInstructorPreferenceCmp() {
        return new Double((this.iAssignmentInfo == null ? 0.0 : (double)this.iAssignmentInfo.getBtbInstructorPreference()) - (this.iAssignedAssignmentInfo == null ? 0.0 : (double)this.iAssignedAssignmentInfo.getBtbInstructorPreference()));
    }

    public String getIsTooBig() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getTooBigRoomPreference(), this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getTooBigRoomPreference());
    }

    public Comparable getIsTooBigCmp() {
        return new Integer((this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getTooBigRoomPreference()) - (this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getTooBigRoomPreference()));
    }

    public String getUselessHalfHours() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getUselessHalfHours(), this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getUselessHalfHours());
    }

    public Comparable getUselessHalfHoursCmp() {
        return new Integer((this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getUselessHalfHours()) - (this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getUselessHalfHours()));
    }

    public String getDeptBalancPenalty() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0.0 : this.iAssignmentInfo.getDeptBalancPenalty(), this.iAssignedAssignmentInfo == null ? 0.0 : this.iAssignedAssignmentInfo.getDeptBalancPenalty());
    }

    public Comparable getDeptBalancPenaltyCmp() {
        return new Double((this.iAssignmentInfo == null ? 0.0 : this.iAssignmentInfo.getDeptBalancPenalty()) - (this.iAssignedAssignmentInfo == null ? 0.0 : this.iAssignedAssignmentInfo.getDeptBalancPenalty()));
    }

    public String getSpreadPenalty() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0.0 : this.iAssignmentInfo.getSpreadPenalty(), this.iAssignedAssignmentInfo == null ? 0.0 : this.iAssignedAssignmentInfo.getSpreadPenalty());
    }

    public Comparable getSpreadPenaltyCmp() {
        return new Double((this.iAssignmentInfo == null ? 0.0 : this.iAssignmentInfo.getSpreadPenalty()) - (this.iAssignedAssignmentInfo == null ? 0.0 : this.iAssignedAssignmentInfo.getSpreadPenalty()));
    }

    public String getGroupConstraintPref() {
        return ClassAssignmentDetails.dispNumberShort(this.iAssignedAssignmentInfo == null, this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getGroupConstraintPref(), this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getGroupConstraintPref());
    }

    public Comparable getGroupConstraintPrefCmp() {
        return new Integer((this.iAssignmentInfo == null ? 0 : this.iAssignmentInfo.getGroupConstraintPref()) - (this.iAssignedAssignmentInfo == null ? 0 : this.iAssignedAssignmentInfo.getGroupConstraintPref()));
    }

    public AssignmentPreferenceInfo getInfo() {
        return this.iAssignmentInfo;
    }

    public Hint getHint() {
        if (this.getAssignedTime() == null || this.getAssignedRoom() == null) {
            return null;
        }
        Vector<Long> roomIds = new Vector<Long>();
        for (int i = 0; i < this.getAssignedRoom().length; ++i) {
            roomIds.add(this.getAssignedRoom()[i].getId());
        }
        return new Hint(this.getClazz().getClassId(), this.getAssignedTime().getDays(), this.getAssignedTime().getStartSlot(), roomIds, this.getAssignedTime().getPatternId(), this.getAssignedTime().getDatePatternId());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassAssignmentDetails)) {
            return false;
        }
        return this.iClass.equals(((ClassAssignmentDetails)o).iClass);
    }

    public int hashCode() {
        return this.iClass.getClassId().hashCode();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof ClassAssignmentDetails)) {
            return -1;
        }
        return this.iClass.compareTo(((ClassAssignmentDetails)o).iClass);
    }

    public String getInstructorName() {
        if (this.iInstructor == null || this.iInstructor.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.iInstructor.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.iInstructor[i].getName());
        }
        return sb.toString();
    }

    public String getInstructorHtml() {
        if (this.iInstructor == null || this.iInstructor.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.iInstructor.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.iInstructor[i].toHtml());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getClassName() + " " + this.getTimeNoHtml() + " " + this.getRoomNoHtml() + " " + this.getDaysName() + " " + this.getInstructorName();
    }

    public static class DistributionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private GroupConstraintInfo iInfo;
        private Vector iClassIds = new Vector();

        public DistributionInfo(GroupConstraintInfo info) {
            this.iInfo = info;
        }

        public void addClass(Long classId) {
            this.iClassIds.add(classId);
        }

        public Vector getClassIds() {
            return this.iClassIds;
        }

        public GroupConstraintInfo getInfo() {
            return this.iInfo;
        }

        public String toHtml(SessionContext context, SolverProxy solver, boolean link) {
            StringBuffer sb = new StringBuffer();
            try {
                Enumeration e = this.iClassIds.elements();
                while (e.hasMoreElements()) {
                    Long classId = (Long)e.nextElement();
                    ClassAssignmentDetails other = ClassAssignmentDetails.createClassAssignmentDetails(context, solver, classId, false);
                    sb.append("<br>&nbsp;&nbsp;&nbsp;");
                    sb.append(other.getClazz().toHtml(link) + " ");
                    if (other.getTime() != null) {
                        sb.append(other.getTime().toHtml(false, false, true, false) + " ");
                    }
                    if (other.getRoom() == null) continue;
                    for (int i = 0; i < other.getRoom().length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(other.getRoom()[i].toHtml(false, false, false));
                    }
                }
            }
            catch (Exception e) {
                Debug.error(e);
                sb.append("<font color='red'>ERROR:" + e.getMessage() + "</font>");
            }
            return "<font color='" + PreferenceLevel.prolog2color(this.iInfo.getPreference()) + "'>" + PreferenceLevel.prolog2string(this.iInfo.getPreference()) + "</font> " + this.iInfo.getName() + sb.toString();
        }
    }

    public class TimeInfos
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public String toHtml(boolean link, boolean showSelected, Hint selection) {
            if (this.isEmpty()) {
                return "";
            }
            int idx = 0;
            StringBuffer sb = new StringBuffer();
            if (link) {
                sb.append("<input type='hidden' name='days' value='" + (selection == null ? (ClassAssignmentDetails.this.iTime == null ? "" : String.valueOf(ClassAssignmentDetails.this.iTime.getDays())) : String.valueOf(selection.getDays())) + "'/>");
                sb.append("<input type='hidden' name='slot' value='" + (selection == null ? (ClassAssignmentDetails.this.iTime == null ? "" : String.valueOf(ClassAssignmentDetails.this.iTime.getStartSlot())) : String.valueOf(selection.getStartSlot())) + "'/>");
                sb.append("<input type='hidden' name='pattern' value='" + (selection == null ? (ClassAssignmentDetails.this.iTime == null ? "" : ClassAssignmentDetails.this.iTime.getPatternId().toString()) : selection.getPatternId().toString()) + "'/>");
            }
            int count = 0;
            Collections.sort(this);
            HashSet<String> added = new HashSet<String>();
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                TimeInfo time = (TimeInfo)e.nextElement();
                if (time.isStriked() || !added.add(time.getDays() + ":" + time.getStartSlot() + ":" + time.getPatternId())) continue;
                if (!PreferenceLevel.sProhibited.equals(PreferenceLevel.int2prolog(time.getPref()))) {
                    ++count;
                }
                if (idx > 0) {
                    sb.append(", ");
                }
                if (idx == 4) {
                    sb.append("<span id='time_dots' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('time_dots').style.display='none';document.getElementById('time_rest').style.display='inline';\">...</a></span><span id='time_rest' style='display:none'>");
                }
                sb.append(time.toHtml(link, showSelected, false, true));
                ++idx;
            }
            int sidx = 0;
            Enumeration e2 = this.elements();
            while (e2.hasMoreElements()) {
                TimeInfo time = (TimeInfo)e2.nextElement();
                if (!time.isStriked() || !added.add(time.getDays() + ":" + time.getStartSlot() + ":" + time.getPatternId())) continue;
                if (idx + sidx > 0) {
                    sb.append(", ");
                }
                if (sidx == 0) {
                    sb.append("<span id='stime_dots' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('stime_dots').style.display='none';document.getElementById('stime_rest').style.display='inline';\">...</a></span><span id='stime_rest' style='display:none'>");
                }
                sb.append(time.toHtml(link, showSelected, false, true));
                ++sidx;
            }
            if (sidx > 0) {
                sb.append("</span>");
            }
            if (idx >= 4) {
                sb.append("</span>");
            }
            if (link) {
                sb.append("<script language='JavaScript'>initTime();</script>");
            }
            return count + " (" + sb.toString() + ")";
        }

        public int getNrDates() {
            HashSet<Long> dates = new HashSet<Long>();
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                TimeInfo time = (TimeInfo)e.nextElement();
                dates.add(time.getDatePatternId());
            }
            return dates.size();
        }

        public String toDatesHtml(boolean link, boolean showSelected, Hint selection) {
            if (this.isEmpty()) {
                return "";
            }
            int idx = 0;
            StringBuffer sb = new StringBuffer();
            if (link) {
                sb.append("<input type='hidden' name='dates' value='" + (selection == null ? (ClassAssignmentDetails.this.iTime == null ? String.valueOf(((TimeInfo)this.elementAt(0)).getDatePatternId()) : String.valueOf(ClassAssignmentDetails.this.iTime.getDatePatternId())) : String.valueOf(selection.getDatePatternId())) + "'/>");
            }
            int count = 0;
            Collections.sort(this);
            HashSet<Long> added = new HashSet<Long>();
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                TimeInfo time = (TimeInfo)e.nextElement();
                if (!added.add(time.getDatePatternId())) continue;
                if (idx > 0) {
                    sb.append(", ");
                }
                if (idx == 4) {
                    sb.append("<span id='dates_dots' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('dates_dots').style.display='none';document.getElementById('dates_rest').style.display='inline';\">...</a></span><span id='dates_rest' style='display:none'>");
                }
                sb.append(time.toDatesHtml(link, showSelected, false));
                ++idx;
                ++count;
            }
            if (idx >= 4) {
                sb.append("</span>");
            }
            if (link) {
                sb.append("<script language='JavaScript'>initDates();</script>");
            }
            return count + " (" + sb.toString() + ")";
        }
    }

    public class RoomInfos
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public String toHtml(boolean link, boolean showSelected, Hint selection) {
            if (this.isEmpty()) {
                return "";
            }
            int idx = 0;
            StringBuffer sb = new StringBuffer();
            int count = 0;
            Collections.sort(this);
            if (link) {
                sb.append("<input type='hidden' name='nrRooms' value='" + ClassAssignmentDetails.this.getClazz().nrRooms() + "'/>");
                sb.append("<input type='hidden' name='curRoom' value='0'/>");
                sb.append("<input type='hidden' name='roomState' value='0'/>");
                for (int i = 0; i < ClassAssignmentDetails.this.getClazz().nrRooms(); ++i) {
                    sb.append("<input type='hidden' name='room" + i + "' value='" + (selection == null ? (ClassAssignmentDetails.this.iRoom == null ? "" : ClassAssignmentDetails.this.iRoom[i].getId().toString()) : selection.getRoomIds().get(i).toString()) + "'/>");
                }
            }
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                RoomInfo room = (RoomInfo)e.nextElement();
                if (room.isStriked()) continue;
                if (!PreferenceLevel.sProhibited.equals(PreferenceLevel.int2prolog(room.getPref()))) {
                    ++count;
                }
                if (idx > 0) {
                    sb.append(", ");
                }
                if (idx == 4) {
                    sb.append("<span id='room_dots' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('room_dots').style.display='none';document.getElementById('room_rest').style.display='inline';\">...</a></span><span id='room_rest' style='display:none'>");
                }
                sb.append(room.toHtml(link, showSelected, true));
                ++idx;
            }
            int sidx = 0;
            Enumeration e2 = this.elements();
            while (e2.hasMoreElements()) {
                RoomInfo room = (RoomInfo)e2.nextElement();
                if (!room.isStriked()) continue;
                if (idx + sidx > 0) {
                    sb.append(", ");
                }
                if (sidx == 0) {
                    sb.append("<span id='sroom_dots' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('sroom_dots').style.display='none';document.getElementById('sroom_rest').style.display='inline';\">...</a></span><span id='sroom_rest' style='display:none'>");
                }
                sb.append(room.toHtml(link, showSelected, true));
                ++sidx;
            }
            if (sidx > 0) {
                sb.append("</span>");
            }
            if (idx >= 4) {
                sb.append("</span>");
            }
            if (link) {
                sb.append("<script language='JavaScript'>initRooms();</script>");
            }
            return count + " (" + sb.toString() + ")";
        }
    }

    public class BtbInstructorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long iOtherClassId;
        private int iPref;

        public BtbInstructorInfo(Long otherClassId, int pref) {
            this.iOtherClassId = otherClassId;
            this.iPref = pref;
        }

        public Long getOtherClassId() {
            return this.iOtherClassId;
        }

        public int getPreference() {
            return this.iPref;
        }

        public String toHtml(SessionContext context, SolverProxy solver) {
            try {
                ClassAssignmentDetails other = ClassAssignmentDetails.createClassAssignmentDetails(context, solver, this.iOtherClassId, false);
                StringBuffer sb = new StringBuffer();
                sb.append("<font color='" + PreferenceLevel.int2color(this.getPreference()) + "'>");
                sb.append(PreferenceLevel.int2string(this.getPreference()));
                sb.append("</font>&nbsp;&nbsp;&nbsp;");
                sb.append(other.getClazz().toHtml(true) + " ");
                sb.append(other.getTime().toHtml(false, false, true, false) + " ");
                sb.append(other.getTime().toDatesHtml(false, false, true) + " ");
                for (int i = 0; i < other.getRoom().length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(other.getRoom()[i].toHtml(false, false, false));
                }
                return sb.toString();
            }
            catch (Exception e) {
                Debug.error(e);
                return "<font color='red'>ERROR:" + e.getMessage() + "</font>";
            }
        }
    }

    public static class StudentConflictInfoComparator
    implements Comparator {
        SessionContext iContext = null;
        SolverProxy iSolver = null;

        public StudentConflictInfoComparator(SessionContext context, SolverProxy solver) {
            this.iContext = context;
            this.iSolver = solver;
        }

        public int compare(Object o1, Object o2) {
            try {
                StudentConflictInfo i1 = (StudentConflictInfo)o1;
                StudentConflictInfo i2 = (StudentConflictInfo)o2;
                int cmp = Double.compare(i1.getInfo().getJenrl(), i2.getInfo().getJenrl());
                if (cmp != 0) {
                    return -cmp;
                }
                if (i1.getInfo() == null) {
                    i1.createOther(this.iContext, this.iSolver);
                }
                if (i2.getInfo() == null) {
                    i2.createOther(this.iContext, this.iSolver);
                }
                return i1.getOther().compareTo(i2.getOther());
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    public static class StudentConflictInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String CLASS_CONFLICT_TYPE = "class";
        public static final String OTHER_ASSIGNMENT_CONFLICT_TYPE = "otherAssignment";
        private JenrlInfo iInfo;
        private Long iOtherClassId = null;
        private Long iOtherAssignmentId = null;
        private ClassAssignmentDetails iOther = null;

        public StudentConflictInfo(Long id, JenrlInfo jenrl, String type) {
            this.iInfo = jenrl;
            if (CLASS_CONFLICT_TYPE.equals(type)) {
                this.iOtherClassId = id;
            } else if (OTHER_ASSIGNMENT_CONFLICT_TYPE.equals(type)) {
                this.iOtherAssignmentId = id;
            }
        }

        public Long getOtherClassId() {
            return this.iOtherClassId;
        }

        public void createOther(SessionContext context, SolverProxy solver) {
            this.iOther = this.iOtherAssignmentId != null ? ClassAssignmentDetails.createClassAssignmentDetailsFromAssignment(context, this.iOtherAssignmentId, false) : ClassAssignmentDetails.createClassAssignmentDetails(context, solver, this.iOtherClassId, false);
        }

        public ClassAssignmentDetails getOther() {
            return this.iOther;
        }

        public JenrlInfo getInfo() {
            return this.iInfo;
        }

        public String toHtml(SessionContext context, SolverProxy solver, boolean link) {
            try {
                if (this.getOther() == null) {
                    this.createOther(context, solver);
                }
                Vector<String> props = new Vector<String>();
                if (this.iInfo.isCommited()) {
                    props.add("committed");
                }
                if (this.iInfo.isFixed()) {
                    props.add("fixed");
                } else if (this.iInfo.isHard()) {
                    props.add("hard");
                }
                if (this.iInfo.isDistance()) {
                    props.add("distance");
                }
                if (this.iInfo.isCommited()) {
                    this.iOther.getClazz().setPref(PreferenceLevel.sRequired);
                }
                if (this.iInfo.isImportant()) {
                    props.add("important");
                }
                if (this.iInfo.isInstructor()) {
                    props.add("instructor");
                }
                StringBuffer sb = new StringBuffer();
                sb.append(sJenrDF.format(this.iInfo.getJenrl()));
                sb.append("&times; ");
                sb.append(this.getOther().getClazz().toHtml(link && !this.iInfo.isCommited()) + " ");
                sb.append(this.getOther().getTime().toHtml(false, false, true, false) + " ");
                if (this.getOther().getRoom() != null) {
                    for (int i = 0; i < this.getOther().getRoom().length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.getOther().getRoom()[i].toHtml(false, false, false));
                    }
                }
                sb.append(props.isEmpty() ? "" : " <i>" + props + "</i>");
                sb.append(" <i>" + this.iInfo.getCurriculumText() + "</i>");
                return sb.toString();
            }
            catch (Exception e) {
                Debug.error(e);
                return "<font color='red'>ERROR:" + e.getMessage() + "</font>";
            }
        }
    }

    public class InstructorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private Long iInstructorId;

        public InstructorInfo(String name, Long instructorId) {
            this.iName = name;
            this.iInstructorId = instructorId;
        }

        public String getName() {
            return this.iName;
        }

        public Long getId() {
            return this.iInstructorId;
        }

        public String getColor() {
            return "black";
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof InstructorInfo)) {
                return false;
            }
            return this.getId().equals(((InstructorInfo)o).getId());
        }

        public String toHtml() {
            return "<a href='instructorDetail.do?instructorId=" + this.getId() + "' target='_blank' class='noFancyLinks' title='Open Instructor Detail for " + this.getName() + " in a new window.'>" + this.getName() + "</a>";
        }
    }

    public class RoomInfo
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private Long iRoomId;
        private int iPref;
        private long iSize;
        private boolean iStrike;

        public RoomInfo(String name, Long roomId, long size, int pref) {
            this.iName = name;
            this.iRoomId = roomId;
            this.iPref = pref;
            this.iSize = size;
            this.iStrike = this.iPref > 500;
        }

        public String getName() {
            return this.iName;
        }

        public Long getId() {
            return this.iRoomId;
        }

        public int getPref() {
            return this.iPref;
        }

        public boolean isStriked() {
            return this.iStrike;
        }

        public long getSize() {
            return this.iSize;
        }

        public String getColor() {
            return PreferenceLevel.int2color(this.iPref);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RoomInfo)) {
                return false;
            }
            return this.getId().equals(((RoomInfo)o).getId());
        }

        public String toHtml(boolean link, boolean showSelected, boolean showHint) {
            boolean uline = false;
            if (showSelected && ClassAssignmentDetails.this.iRoom != null) {
                for (int i = 0; i < ClassAssignmentDetails.this.iRoom.length; ++i) {
                    if (!ClassAssignmentDetails.this.iRoom[i].equals(this)) continue;
                    uline = true;
                }
            }
            if (showHint) {
                return (link ? "<a id='room_" + this.getId() + "' onclick=\"selectRoom(event, '" + this.getId() + "');\" onmouseover=\"this.style.cursor='pointer';\" class='noFancyLinks' title='" + this.iSize + " seats'>" : "<a class='noFancyLinks' title='" + this.iSize + " seats'>") + "<span style='color:" + PreferenceLevel.int2color(this.iPref) + ";' onmouseover=\"showGwtRoomHint(this, '" + this.getId() + "', '" + PreferenceLevel.int2string(this.iPref) + "');\" onmouseout=\"hideGwtRoomHint();\">" + (uline ? "<u>" : "") + (this.iStrike ? "<s>" : "") + this.iName + (this.iStrike ? "</s>" : "") + (uline ? "</u>" : "") + "</span></a>";
            }
            return (link ? "<a id='room_" + this.getId() + "' onclick=\"selectRoom(event, '" + this.getId() + "');\" onmouseover=\"this.style.cursor='pointer';\" class='noFancyLinks' title='" + this.iSize + " seats'>" : "<a class='noFancyLinks' title='" + this.iSize + " seats'>") + "<font color='" + PreferenceLevel.int2color(this.iPref) + "'>" + (uline ? "<u>" : "") + (this.iStrike ? "<s>" : "") + this.iName + (this.iStrike ? "</s>" : "") + (uline ? "</u>" : "") + "</font></a>";
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof RoomInfo)) {
                return -1;
            }
            return this.getName().compareTo(((RoomInfo)o).getName());
        }
    }

    public class TimeInfo
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 1L;
        private int iDays;
        private int iStartSlot;
        private int iMin;
        private String iDatePatternName;
        private int iDatePatternPref;
        private int iPref;
        private boolean iStrike = false;
        private Long iPatternId = null;
        private Long iDatePatternId;

        public TimeInfo(int days, int startSlot, int pref, int min, String datePatternName, Long patternId, Long datePatternId, int datePatternPref) {
            this.iDays = days;
            this.iStartSlot = startSlot;
            this.iPref = pref;
            this.iStrike = this.iPref > 500;
            this.iMin = min;
            this.iDatePatternName = datePatternName;
            this.iPatternId = patternId;
            this.iDatePatternId = datePatternId;
            this.iDatePatternPref = datePatternPref;
        }

        public int getDays() {
            return this.iDays;
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public int getPref() {
            return this.iPref;
        }

        public int getMin() {
            return this.iMin;
        }

        public String getDatePatternName() {
            return this.iDatePatternName;
        }

        public String getDatePatternHtml() {
            return "<span style='color:" + PreferenceLevel.int2color(this.iDatePatternPref) + ";'>" + this.iDatePatternName + "</span>";
        }

        public boolean isStriked() {
            return this.iStrike;
        }

        public Long getPatternId() {
            return this.iPatternId;
        }

        public Long getDatePatternId() {
            return this.iDatePatternId;
        }

        public int getDatePatternPreference() {
            return this.iDatePatternPref;
        }

        public String getDaysName() {
            StringBuffer ret = new StringBuffer();
            Integer firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
            for (int i = 0; i < CONSTANTS.shortDays().length; ++i) {
                int idx;
                int n = idx = firstDay == null ? i : (i + firstDay) % 7;
                if ((Constants.DAY_CODES[idx] & this.iDays) == 0) continue;
                ret.append(CONSTANTS.shortDays()[idx]);
            }
            return ret.toString();
        }

        public String getStartTime() {
            return Constants.toTime(this.iStartSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN);
        }

        public String getEndTime() {
            return Constants.toTime(this.iStartSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + this.iMin);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimeInfo)) {
                return false;
            }
            TimeInfo t = (TimeInfo)o;
            return t.getDays() == this.getDays() && t.getStartSlot() == this.getStartSlot() && t.getPatternId().equals(this.getPatternId()) && t.getDatePatternId().equals(this.getDatePatternId());
        }

        public String getName(boolean endTime) {
            return this.getDaysName() + " " + this.getStartTime() + (endTime ? " - " + this.getEndTime() : "");
        }

        public String toHtml(boolean link, boolean showSelected, boolean endTime, boolean showHint) {
            boolean uline = showSelected && this.equals(ClassAssignmentDetails.this.iTime);
            return (link ? "<a id='time_" + this.getDays() + "_" + this.getStartSlot() + "_" + this.getPatternId() + "' onclick=\"selectTime(event, '" + this.getDays() + "', '" + this.getStartSlot() + "', '" + this.getPatternId() + "');\" onmouseover=\"this.style.cursor='pointer';\" class='noFancyLinks' title='" + this.getDaysName() + " " + this.getStartTime() + " - " + this.getEndTime() + "'>" : "<a class='noFancyLinks' title='" + this.getDaysName() + " " + this.getStartTime() + " - " + this.getEndTime() + "'>") + "<span style='color:" + PreferenceLevel.int2color(this.iPref) + ";' " + (showHint ? "onmouseover=\"showGwtTimeHint(this, '" + ClassAssignmentDetails.this.getClazz().getClassId() + "," + this.iDays + "," + this.iStartSlot + "');\" onmouseout=\"hideGwtTimeHint();\"" : "") + ">" + (uline ? "<u>" : "") + (this.iStrike ? "<s>" : "") + this.getDaysName() + " " + this.getStartTime() + (endTime ? " - " + this.getEndTime() : "") + (this.iStrike ? "</s>" : "") + (uline ? "</u>" : "") + "</span></a>";
        }

        public String toDatesHtml(boolean link, boolean showSelected, boolean endTime) {
            boolean uline = showSelected && this.equals(ClassAssignmentDetails.this.iTime);
            return (link ? "<a id='dates_" + this.getDatePatternId() + "' onclick=\"selectDates(event, '" + this.getDatePatternId() + "');\" onmouseover=\"this.style.cursor='pointer';\" class='noFancyLinks' title='" + this.getDatePatternName() + "'>" : "<a class='noFancyLinks' title='" + this.getDatePatternName() + "'>") + (uline ? "<u>" : "") + (this.iStrike ? "<s>" : "") + this.getDatePatternHtml() + (this.iStrike ? "</s>" : "") + (uline ? "</u>" : "") + "</a>";
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof TimeInfo)) {
                return -1;
            }
            TimeInfo t = (TimeInfo)o;
            if (this.isStriked() && !t.isStriked()) {
                return 1;
            }
            if (!this.isStriked() && t.isStriked()) {
                return -1;
            }
            int cmp = sCmp.compare(this.getDatePatternName(), t.getDatePatternName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = -Double.compare(this.getDays(), t.getDays());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(this.getStartSlot(), t.getStartSlot());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(this.getMin(), t.getMin());
            return cmp;
        }
    }

    public class ClassInfo
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private Long iClassId;
        private String iPref;
        private int iRoomCap;
        private int iNrRooms;
        private int iOrd = -1;
        private String iNote;
        private transient Class_ iClazz;

        public ClassInfo(String name, Long classId, int nrRooms, String pref, int roomCapacity, int ord, String note) {
            this.iName = name;
            this.iClassId = classId;
            this.iPref = pref;
            this.iNrRooms = nrRooms;
            this.iRoomCap = roomCapacity;
            this.iOrd = ord;
            this.iNote = note;
        }

        public ClassInfo(String name, Long classId, int nrRooms, String pref, int roomCapacity, Class_ clazz) {
            this.iName = name;
            this.iClassId = classId;
            this.iPref = pref;
            this.iNrRooms = nrRooms;
            this.iRoomCap = roomCapacity;
            this.iClazz = clazz;
            this.iNote = this.iClazz == null ? null : this.iClazz.getNotes();
        }

        public String getName() {
            return this.iName;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public int getRoomCapacity() {
            return this.iRoomCap;
        }

        public String getPref() {
            return this.iPref;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setPref(String pref) {
            this.iPref = pref;
        }

        public int nrRooms() {
            return this.iNrRooms;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassInfo)) {
                return false;
            }
            return this.getClassId().equals(((ClassInfo)o).getClassId());
        }

        public String toHtml(boolean link) {
            return this.toHtml(link, false);
        }

        public String toHtml(boolean link, boolean newWindow) {
            if (link) {
                if (newWindow) {
                    return "<a class='noFancyLinks' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" onClick=\"showGwtDialog('Suggestions', 'suggestions.do?id=" + this.iClassId + "&op=Reset','900','90%');\"><font color='" + PreferenceLevel.prolog2color(this.iPref) + "'>" + this.iName + "</font></a>";
                }
                return "<a class='noFancyLinks' href='suggestions.do?id=" + this.iClassId + "&op=Select&noCacheTS=" + new Date().getTime() + "'><font color='" + PreferenceLevel.prolog2color(this.iPref) + "'>" + this.iName + "</font></a>";
            }
            return "<font color='" + PreferenceLevel.prolog2color(this.iPref) + "'>" + this.iName + "</font>";
        }

        public int compareTo(Object o) {
            int cmp;
            if (o == null || !(o instanceof ClassInfo)) {
                return -1;
            }
            ClassInfo ci = (ClassInfo)o;
            if (this.iOrd >= 0 && ci.iOrd >= 0) {
                int cmp2 = Double.compare(this.iOrd, ci.iOrd);
                if (cmp2 != 0) {
                    return cmp2;
                }
            } else if (this.iClazz != null && ci.iClazz != null && (cmp = new ClassComparator(5).compare(this.iClazz, ci.iClazz)) != 0) {
                return cmp;
            }
            return this.getName().compareTo(((ClassInfo)o).getName());
        }
    }
}

