/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AbstractClassWithContext;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.model.Model;
import org.unitime.timetable.solver.curricula.students.CurCourse;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

public class CurStudent
extends AbstractClassWithContext<CurVariable, CurValue, CurStudentContext> {
    private static DecimalFormat sDF = new DecimalFormat("0.###");
    private Long iStudentId;
    private double iWeight;

    public CurStudent(Long studentId, double weight) {
        this.iStudentId = studentId;
        this.iWeight = weight;
    }

    public double getWeight() {
        return this.iWeight;
    }

    public void setWeight(double weight) {
        this.iWeight = weight;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public Set<CurCourse> getCourses(Assignment<CurVariable, CurValue> assignment) {
        return ((CurStudentContext)this.getContext(assignment)).getCourses();
    }

    public String toString() {
        return this.getStudentId() + (this.getWeight() != 1.0 ? "@" + sDF.format(this.getWeight()) : "");
    }

    public CurStudentContext createAssignmentContext(Assignment<CurVariable, CurValue> assignment) {
        return new CurStudentContext(assignment);
    }

    public void setModel(CurModel model) {
        this.setAssignmentContextReference(model.createReference((HasAssignmentContext)this));
    }

    public Model<CurVariable, CurValue> getModel() {
        return null;
    }

    public class CurStudentContext
    implements AssignmentContext {
        private Set<CurCourse> iCourses = new HashSet<CurCourse>();

        public CurStudentContext(Assignment<CurVariable, CurValue> assignment) {
        }

        public Set<CurCourse> getCourses() {
            return this.iCourses;
        }
    }
}

