/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;

public class EnrolledStudentCourseDemands
implements StudentCourseDemands {
    private Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> iDemands = new Hashtable();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = new Hashtable();

    public EnrolledStudentCourseDemands(DataProperties properties) {
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return true;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        for (Object[] o : hibSession.createQuery("select distinct e.courseOffering, s from StudentClassEnrollment e inner join e.student s left join fetch s.areaClasfMajors where e.courseOffering.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            CourseOffering course = (CourseOffering)o[0];
            Student student = (Student)o[1];
            Set<StudentCourseDemands.WeightedStudentId> students = this.iDemands.get(course.getUniqueId());
            if (students == null) {
                students = new HashSet<StudentCourseDemands.WeightedStudentId>();
                this.iDemands.put(course.getUniqueId(), students);
            }
            StudentCourseDemands.WeightedStudentId studentId = new StudentCourseDemands.WeightedStudentId(student);
            students.add(studentId);
            Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(student.getUniqueId());
            if (courses == null) {
                courses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                this.iStudentRequests.put(student.getUniqueId(), courses);
            }
            courses.add(new StudentCourseDemands.WeightedCourseOffering(course));
        }
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        return this.iDemands.get(course.getUniqueId());
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        return null;
    }
}

