/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.MeetingDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.course.ui.ClassTimeInfo;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.RoomAvailability;

public class CommitedClassAssignmentProxy
implements ClassAssignmentProxy {
    private static AssignmentPreferenceInfo sCommitedAssignmentPreferenceInfo = new AssignmentPreferenceInfo();

    @Override
    public Assignment getAssignment(Long classId) {
        return this.getAssignment((Class_)new Class_DAO().get(classId));
    }

    @Override
    public Assignment getAssignment(Class_ clazz) {
        return clazz.getCommittedAssignment();
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Long classId) {
        return sCommitedAssignmentPreferenceInfo;
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) {
        return sCommitedAssignmentPreferenceInfo;
    }

    @Override
    public Hashtable getAssignmentTable(Collection classesOrClassIds) {
        Hashtable<Long, Assignment> assignments = new Hashtable<Long, Assignment>();
        for (Object classOrClassId : classesOrClassIds) {
            Assignment assignment;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((assignment = classOrClassId instanceof Class_ ? this.getAssignment((Class_)classOrClassId) : this.getAssignment((Long)classOrClassId)) == null) continue;
            assignments.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, assignment);
        }
        return assignments;
    }

    @Override
    public Hashtable getAssignmentInfoTable(Collection classesOrClassIds) {
        Hashtable<Long, AssignmentPreferenceInfo> infos = new Hashtable<Long, AssignmentPreferenceInfo>();
        for (Object classOrClassId : classesOrClassIds) {
            AssignmentPreferenceInfo info;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((info = classOrClassId instanceof Class_ ? this.getAssignmentInfo((Class_)classOrClassId) : this.getAssignmentInfo((Long)classOrClassId)) == null) continue;
            infos.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, info);
        }
        return infos;
    }

    @Override
    public boolean hasConflicts(Long offeringId) {
        InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId);
        if (offering == null || offering.isNotOffered().booleanValue()) {
            return false;
        }
        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    Assignment a;
                    Assignment assignment;
                    if (clazz.isCancelled().booleanValue() || (assignment = this.getAssignment(clazz)) == null) continue;
                    if (assignment.getRooms() != null) {
                        for (Location room : assignment.getRooms()) {
                            if (room.isIgnoreRoomCheck().booleanValue()) continue;
                            for (Assignment a2 : room.getCommitedAssignments()) {
                                if (assignment.equals(a2) || a2.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a2) || clazz.canShareRoom(a2.getClazz())) continue;
                                return true;
                            }
                        }
                    }
                    if (clazz.getClassInstructors() != null) {
                        for (ClassInstructor instructor : clazz.getClassInstructors()) {
                            if (!instructor.isLead().booleanValue()) continue;
                            for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor())) {
                                for (ClassInstructor ci : di.getClasses()) {
                                    Assignment a3;
                                    if (ci.equals(instructor) || ci.getClassInstructing().equals(clazz) || !ci.isLead().booleanValue() || (a3 = this.getAssignment(ci.getClassInstructing())) == null || a3.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a3) || clazz.canShareInstructor(a3.getClazz())) continue;
                                    return true;
                                }
                            }
                            if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                            for (Class_ c : Class_DAO.getInstance().getSession().createQuery("select e.clazz from StudentClassEnrollment e where e.student.externalUniqueId = :externalId and e.student.session.uniqueId = :sessionId").setLong("sessionId", instructor.getInstructor().getDepartment().getSessionId().longValue()).setString("externalId", instructor.getInstructor().getExternalUniqueId()).setCacheable(true).list()) {
                                a = this.getAssignment(c);
                                if (a == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a)) continue;
                                return true;
                            }
                        }
                    }
                    for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
                        Assignment a4 = this.getAssignment(parent);
                        if (a4 == null || a4.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a4)) continue;
                        return true;
                    }
                    for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
                        Class_ child;
                        if (ss.getClasses().size() != 1 || clazz.equals(child = ss.getClasses().iterator().next()) || (a = this.getAssignment(child)) == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a)) continue;
                        return true;
                    }
                }
            }
        }
        if (RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService) {
            boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            boolean ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            if (!changePast || ignorePast) {
                Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Date today = cal.getTime();
                return ((Number)MeetingDAO.getInstance().getSession().createQuery("select count(mx) from ClassEvent e inner join e.meetings m, Meeting mx where e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :offeringId and mx.event.class != ClassEvent and m.approvalStatus = 1 and mx.approvalStatus = 1 and m.locationPermanentId = mx.locationPermanentId and m.meetingDate = mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod and mx.meetingDate >= :today").setLong("offeringId", offeringId.longValue()).setDate("today", today).setCacheable(true).uniqueResult()).intValue() > 0;
            }
            return ((Number)MeetingDAO.getInstance().getSession().createQuery("select count(mx) from ClassEvent e inner join e.meetings m, Meeting mx where e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :offeringId and mx.event.class != ClassEvent and m.approvalStatus = 1 and mx.approvalStatus = 1 and m.locationPermanentId = mx.locationPermanentId and m.meetingDate = mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod").setLong("offeringId", offeringId.longValue()).setCacheable(true).uniqueResult()).intValue() > 0;
        }
        if (RoomAvailability.getInstance() != null) {
            Date[] bounds = DatePattern.getBounds(offering.getSessionId());
            boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            boolean ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date today = cal.getTime();
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    for (Class_ clazz : subpart.getClasses()) {
                        Assignment assignment = this.getAssignment(clazz);
                        if (assignment == null || assignment.getRooms() == null || assignment.getRooms().isEmpty()) continue;
                        ClassTimeInfo period = new ClassTimeInfo(assignment);
                        for (Location room : assignment.getRooms()) {
                            Collection<RoomAvailabilityInterface.TimeBlock> times;
                            if (room.isIgnoreRoomCheck().booleanValue() || (times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) == null || times.isEmpty()) continue;
                            Collection<RoomAvailabilityInterface.TimeBlock> timesToCheck = null;
                            if (!changePast || ignorePast) {
                                timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                                for (RoomAvailabilityInterface.TimeBlock time : times) {
                                    if (time.getEndTime().before(today)) continue;
                                    timesToCheck.add(time);
                                }
                            } else {
                                timesToCheck = times;
                            }
                            if (period.overlaps(timesToCheck) == null) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public Set<Assignment> getConflicts(Long classId) {
        if (classId == null) {
            return null;
        }
        Class_ clazz = (Class_)Class_DAO.getInstance().get(classId);
        if (clazz == null || clazz.isCancelled().booleanValue()) {
            return null;
        }
        Assignment assignment = this.getAssignment(clazz);
        if (assignment == null) {
            return null;
        }
        HashSet<Assignment> conflicts = new HashSet<Assignment>();
        if (assignment.getRooms() != null) {
            for (Location room : assignment.getRooms()) {
                if (room.isIgnoreRoomCheck().booleanValue()) continue;
                for (Assignment a : room.getCommitedAssignments()) {
                    if (assignment.equals(a) || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a) || clazz.canShareRoom(a.getClazz())) continue;
                    conflicts.add(a);
                }
            }
        }
        if (clazz.getClassInstructors() != null) {
            for (ClassInstructor instructor : clazz.getClassInstructors()) {
                if (!instructor.isLead().booleanValue()) continue;
                for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor())) {
                    for (ClassInstructor ci : di.getClasses()) {
                        Assignment a;
                        if (ci.equals(instructor) || ci.getClassInstructing().equals(clazz) || !ci.isLead().booleanValue() || (a = this.getAssignment(ci.getClassInstructing())) == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a) || clazz.canShareInstructor(a.getClazz())) continue;
                        conflicts.add(a);
                    }
                }
                if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                for (Class_ c : Class_DAO.getInstance().getSession().createQuery("select e.clazz from StudentClassEnrollment e where e.student.externalUniqueId = :externalId and e.student.session.uniqueId = :sessionId").setLong("sessionId", instructor.getInstructor().getDepartment().getSessionId().longValue()).setString("externalId", instructor.getInstructor().getExternalUniqueId()).setCacheable(true).list()) {
                    Assignment a = this.getAssignment(c);
                    if (a == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a)) continue;
                    conflicts.add(a);
                }
            }
        }
        for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
            Assignment a = this.getAssignment(parent);
            if (a == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a)) continue;
            conflicts.add(a);
        }
        LinkedList<Class_> children = new LinkedList<Class_>(clazz.getChildClasses());
        Class_ child = null;
        while ((child = (Class_)children.poll()) != null) {
            Assignment a;
            a = this.getAssignment(child);
            if (a != null && !a.getClazz().isCancelled().booleanValue() && assignment.overlaps(a)) {
                conflicts.add(a);
            }
            if (child.getChildClasses().isEmpty()) continue;
            children.addAll(child.getChildClasses());
        }
        for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
            Assignment a;
            if (ss.getClasses().size() != 1 || clazz.equals(child = ss.getClasses().iterator().next()) || (a = this.getAssignment(child)) == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a)) continue;
            conflicts.add(a);
        }
        return conflicts;
    }

    @Override
    public Set<RoomAvailabilityInterface.TimeBlock> getConflictingTimeBlocks(Long classId) {
        boolean ignorePast;
        boolean changePast;
        if (classId == null) {
            return null;
        }
        Class_ clazz = (Class_)Class_DAO.getInstance().get(classId);
        if (clazz == null || clazz.isCancelled().booleanValue()) {
            return null;
        }
        TreeSet<RoomAvailabilityInterface.TimeBlock> conflicts = new TreeSet<RoomAvailabilityInterface.TimeBlock>(new RoomAvailabilityInterface.TimeBlockComparator());
        Assignment assignment = this.getAssignment(clazz);
        HashSet<Long> ignorePermIds = new HashSet<Long>();
        if (assignment != null && assignment.getRooms() != null && !assignment.getRooms().isEmpty() && RoomAvailability.getInstance() != null) {
            Date[] bounds = DatePattern.getBounds(clazz.getSessionId());
            changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date today = cal.getTime();
            ClassTimeInfo period = new ClassTimeInfo(assignment);
            for (Location room : assignment.getRooms()) {
                List<RoomAvailabilityInterface.TimeBlock> overlaps;
                if (room.isIgnoreRoomCheck().booleanValue()) {
                    ignorePermIds.add(room.getPermanentId());
                    continue;
                }
                Collection<RoomAvailabilityInterface.TimeBlock> times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType);
                if (times == null || times.isEmpty()) continue;
                Collection<RoomAvailabilityInterface.TimeBlock> timesToCheck = null;
                if (!changePast || ignorePast) {
                    timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                    for (RoomAvailabilityInterface.TimeBlock time : times) {
                        if (time.getEndTime().before(today)) continue;
                        timesToCheck.add(time);
                    }
                } else {
                    timesToCheck = times;
                }
                if ((overlaps = period.allOverlaps(timesToCheck)) == null) continue;
                conflicts.addAll(overlaps);
            }
        }
        if (RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService) {
            EventDateMapping.Class2EventDateMap class2eventDateMap = EventDateMapping.getMapping(clazz.getManagingDept().getSessionId());
            changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            List meetings = null;
            if (!changePast || ignorePast) {
                Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Date today = cal.getTime();
                meetings = MeetingDAO.getInstance().getSession().createQuery("select distinct mx from ClassEvent e inner join e.meetings m, Meeting mx where e.clazz.uniqueId = :classId and mx.event.class != ClassEvent and m.approvalStatus = 1 and mx.approvalStatus = 1 and m.locationPermanentId = mx.locationPermanentId and m.meetingDate = mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod and mx.meetingDate >= :today").setLong("classId", classId.longValue()).setDate("today", today).setCacheable(true).list();
            } else {
                meetings = MeetingDAO.getInstance().getSession().createQuery("select distinct mx from ClassEvent e inner join e.meetings m, Meeting mx where e.clazz.uniqueId = :classId and mx.event.class != ClassEvent and m.approvalStatus = 1 and mx.approvalStatus = 1 and m.locationPermanentId = mx.locationPermanentId and m.meetingDate = mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod").setLong("classId", classId.longValue()).setCacheable(true).list();
            }
            for (Meeting m : meetings) {
                DefaultRoomAvailabilityService.MeetingTimeBlock block;
                if (m.getLocationPermanentId() != null && ignorePermIds.contains(m.getLocationPermanentId()) || (block = new DefaultRoomAvailabilityService.MeetingTimeBlock(m, class2eventDateMap)).getStartTime() == null) continue;
                conflicts.add(block);
            }
            return conflicts;
        }
        return conflicts;
    }
}

