/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.server.solver.TimetableGridHelper;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.NameFormat;

public class TimetableGridContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iFilter;
    private int iStartDayDayOfWeek;
    private int iResourceType;
    private int iFirstDay;
    private int iFirstSessionDay;
    private int iBgMode;
    private int iDispMode;
    private boolean iShowEvents;
    private int iFirstSlot;
    private int iLastSlot;
    private int iDayCode;
    private BitSet iPattern;
    private float iNrWeeks;
    private int iSlotsPerWeek;
    private Date iFirstDate;
    private boolean iShowInstructor;
    private boolean iShowTime;
    private boolean iShowPreference;
    private boolean iShowFreeTimes;
    private boolean iShowDate;
    private Date iSessionStartDate;
    private Date iSessionEndDate;
    private boolean iShowCrossLists;
    private boolean iShowClassSuffix;
    private boolean iShowConfigName;
    private boolean iShowClassNameTwoLines;
    private boolean iShowCourseTitle;
    private String iLocale;
    private String iInstructorNameFormat = NameFormat.SHORT.reference();
    private int iWeekOffset = 0;
    private Long iSessionId = null;
    private HashMap<Integer, String> iInstructionalTypeColors = null;
    public static String[] sBgColors = new String[]{"rgb(102,140,217)", "rgb(76,176,82)", "rgb(242,166,64)", "rgb(224,194,64)", "rgb(230,115,153)", "rgb(179,115,179)", "rgb(101,173,137)", "rgb(140,102,217)", "rgb(102,140,179)", "rgb(89,191,179)", "rgb(140,191,64)", "rgb(191,191,77)", "rgb(230,128,77)", "rgb(190,148,148)", "rgb(169,146,169)", "rgb(137,151,165)", "rgb(148,162,190)", "rgb(133,170,165)", "rgb(167,167,125)", "rgb(196,168,131)", "rgb(217,102,102)"};

    public TimetableGridContext() {
    }

    public TimetableGridContext(FilterInterface filter, Session session) {
        this.iWeekOffset = ApplicationProperty.TimeGridFirstDayOfWeek.intValue();
        this.iLocale = Localization.getLocale();
        DatePattern dp = session.getDefaultDatePatternNotNull();
        if (dp == null) {
            throw new RuntimeException("No default date pattern is defined for " + session.getLabel() + ". Use the <a href='sessionEdit.do?doit=editSession&sessionId=" + session.getUniqueId() + "'>Edit Academic Session</a> page to set a default date pattern.");
        }
        this.iFilter = filter.getParameterValue("filter", "");
        this.iStartDayDayOfWeek = Constants.getDayOfWeek(DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear()));
        int week = Integer.parseInt(filter.getParameterValue("weeks", "-100"));
        this.iFirstDay = week == -100 ? -1 : DateUtils.getFirstDayOfWeek(session.getSessionStartYear(), week) - session.getDayOfYear(1, session.getPatternStartMonth()) - 1 + this.iWeekOffset;
        this.iResourceType = Integer.valueOf(filter.getParameterValue("resource", "0"));
        this.iBgMode = Integer.valueOf(filter.getParameterValue("background", "0"));
        this.iShowEvents = "1".equals(filter.getParameterValue("showEvents"));
        String[] times = filter.getParameterValue("times", "0|288|6").split("\\|");
        this.iFirstSlot = Integer.parseInt(times[0]);
        int step = Integer.parseInt(times[2]);
        int nrTimes = (Integer.parseInt(times[1]) - this.iFirstSlot) / step;
        this.iLastSlot = this.iFirstSlot + step * nrTimes - 1;
        this.iDayCode = 0;
        int nrWeekDays = 0;
        String bitmap = filter.getParameterValue("days", "1111111");
        for (int i = 0; i < bitmap.length() && i < 7; ++i) {
            if (bitmap.charAt(i) != '1') continue;
            this.iDayCode += Constants.DAY_CODES[i];
            ++nrWeekDays;
        }
        this.iPattern = dp.getPatternBitSet();
        this.iNrWeeks = dp.getEffectiveNumberOfWeeks();
        if (this.iFirstDay < 0 && ApplicationProperty.TimetableGridUtilizationSkipHolidays.isTrue()) {
            int nrDays = 0;
            int idx = -1;
            int[] daysInWeek = new int[]{0, 0, 0, 0, 0, 0, 0};
            while ((idx = this.iPattern.nextSetBit(1 + idx)) >= 0) {
                int dow = (idx + this.iStartDayDayOfWeek) % 7;
                if ((this.iDayCode & Constants.DAY_CODES[dow]) == 0) continue;
                ++nrDays;
                int n = dow;
                daysInWeek[n] = daysInWeek[n] + 1;
            }
            float weekDays = 1.0f / (float)nrWeekDays;
            this.iNrWeeks = weekDays >= 0.2f ? weekDays * (float)nrDays : 0.2f * (float)(daysInWeek[0] + daysInWeek[1] + daysInWeek[2] + daysInWeek[3] + daysInWeek[4]);
        }
        this.iSlotsPerWeek = (this.iLastSlot - this.iFirstSlot + 1) * nrWeekDays;
        int startWeek = DateUtils.getWeek(session.getSessionBeginDateTime()) - ApplicationProperty.SessionNrExcessDays.intValue() / 7;
        this.iFirstDate = DateUtils.getStartDate(session.getSessionStartYear(), startWeek);
        this.iFirstSessionDay = DateUtils.getFirstDayOfWeek(session.getSessionStartYear(), startWeek) - session.getDayOfYear(1, session.getPatternStartMonth()) - 1;
        this.iShowInstructor = "1".equals(filter.getParameterValue("showInstructors"));
        this.iShowTime = "1".equals(filter.getParameterValue("showTimes"));
        this.iShowPreference = "1".equals(filter.getParameterValue("showPreferences"));
        this.iShowFreeTimes = "1".equals(filter.getParameterValue("showFreeTimes"));
        this.iShowDate = "-100".equals(filter.getParameterValue("weeks"));
        this.iDispMode = Integer.parseInt(filter.getParameterValue("dispMode", "0"));
        Calendar startDateCal = Calendar.getInstance(Locale.US);
        startDateCal.setTime(DateUtils.getDate(1, session.getStartMonth(), session.getSessionStartYear()));
        startDateCal.set(11, 0);
        startDateCal.set(12, 0);
        startDateCal.set(13, 0);
        this.iSessionStartDate = startDateCal.getTime();
        Calendar endDateCal = Calendar.getInstance(Locale.US);
        endDateCal.setTime(DateUtils.getDate(0, session.getEndMonth() + 1, session.getSessionStartYear()));
        endDateCal.set(11, 23);
        endDateCal.set(12, 59);
        endDateCal.set(13, 59);
        this.iSessionEndDate = endDateCal.getTime();
        this.iShowCrossLists = ApplicationProperty.TimeGridShowCrosslists.isTrue();
        this.iShowClassSuffix = ApplicationProperty.SolverShowClassSufix.isTrue();
        this.iShowConfigName = ApplicationProperty.SolverShowConfiguratioName.isTrue();
        this.iShowClassNameTwoLines = ApplicationProperty.TimeGridShowNameInTwoLines.isTrue();
        this.iShowCourseTitle = "1".equals(filter.getParameterValue("showTitles"));
        this.iSessionId = session.getUniqueId();
    }

    public String getFilter() {
        return this.iFilter;
    }

    public int getResourceType() {
        return this.iResourceType;
    }

    public int getFirstDay() {
        return this.iFirstDay;
    }

    public int getFirstSessionDay() {
        return this.iFirstSessionDay;
    }

    public int getBgMode() {
        return this.iBgMode;
    }

    public boolean isShowEvents() {
        return this.iShowEvents;
    }

    public int getStartDayDayOfWeek() {
        return this.iStartDayDayOfWeek;
    }

    public int getFirstSlot() {
        return this.iFirstSlot;
    }

    public int getLastSlot() {
        return this.iLastSlot;
    }

    public int getDayCode() {
        return this.iDayCode;
    }

    public BitSet getDefaultDatePattern() {
        return this.iPattern;
    }

    public float getNumberOfWeeks() {
        return this.iFirstDay >= 0 ? 1.0f : this.iNrWeeks;
    }

    public int getSlotsPerWeek() {
        return this.iSlotsPerWeek;
    }

    public Date getFirstDate() {
        return this.iFirstDate;
    }

    public boolean isShowInstructor() {
        return this.iShowInstructor;
    }

    public boolean isShowTime() {
        return this.iShowTime;
    }

    public boolean isShowPreference() {
        return this.iShowPreference;
    }

    public boolean isShowFreeTimes() {
        return this.iShowFreeTimes && this.iResourceType <= 1;
    }

    public boolean isShowRoom() {
        return this.iResourceType != TimetableGridHelper.ResourceType.ROOM.ordinal();
    }

    public boolean isShowDate() {
        return this.iShowDate;
    }

    public int getDisplayMode() {
        return this.iDispMode;
    }

    public boolean isVertical() {
        return this.iDispMode == TimetableGridHelper.DisplayMode.PerWeekVertical.ordinal();
    }

    public Date getSessionStartDate() {
        return this.iSessionStartDate;
    }

    public Date getSessionEndDate() {
        return this.iSessionEndDate;
    }

    public boolean isShowCrossLists() {
        return this.iShowCrossLists;
    }

    public boolean isShowClassSuffix() {
        return this.iShowClassSuffix;
    }

    public boolean isShowConfigName() {
        return this.iShowConfigName;
    }

    public boolean isShowClassNameTwoLines() {
        return this.iShowClassNameTwoLines;
    }

    public boolean isShowCourseTitle() {
        return this.iShowCourseTitle;
    }

    public void ensureLocalizationIsSet() {
        Localization.setLocale(this.iLocale);
    }

    public String getInstructorNameFormat() {
        return this.iInstructorNameFormat;
    }

    public void setInstructorNameFormat(String format) {
        this.iInstructorNameFormat = format;
    }

    public int getWeekOffset() {
        return this.iWeekOffset;
    }

    public String getInstructionalTypeColor(Integer id) {
        String color;
        if (id == null) {
            return null;
        }
        if (this.iInstructionalTypeColors == null) {
            this.iInstructionalTypeColors = new HashMap();
            List itypes = ItypeDescDAO.getInstance().getSession().createQuery("from ItypeDesc where itype in (select s.itype.itype from SchedulingSubpart s where s.instrOfferingConfig.instructionalOffering.session = :sessionId) order by itype").setLong("sessionId", this.iSessionId.longValue()).list();
            for (ItypeDesc it : itypes) {
                if (it.getParent() != null) continue;
                String color2 = sBgColors[this.iInstructionalTypeColors.size() % sBgColors.length];
                this.iInstructionalTypeColors.put(it.getItype(), color2);
            }
            for (ItypeDesc it : itypes) {
                if (it.getParent() == null) continue;
                this.iInstructionalTypeColors.put(it.getItype(), this.getInstructionalTypeColor(it.getParent().getItype()));
            }
        }
        if ((color = this.iInstructionalTypeColors.get(id)) == null) {
            color = sBgColors[this.iInstructionalTypeColors.size() % sBgColors.length];
            this.iInstructionalTypeColors.put(id, color);
        }
        return color;
    }
}

