/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.util.Collections;
import java.util.Map;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.util.HtmlUtils;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.RefTableEntryDAO;
import org.unitime.timetable.model.dao.ScriptDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=ScriptInterface.LoadAllScriptsRpcRequest.class)
public class LoadAllScriptsBackend
implements GwtRpcImplementation<ScriptInterface.LoadAllScriptsRpcRequest, GwtRpcResponseList<ScriptInterface>> {
    @Override
    @PreAuthorize(value="checkPermission('Scripts')")
    public GwtRpcResponseList<ScriptInterface> execute(ScriptInterface.LoadAllScriptsRpcRequest request, SessionContext context) {
        GwtRpcResponseList<ScriptInterface> list = new GwtRpcResponseList<ScriptInterface>();
        for (Script s : ScriptDAO.getInstance().findAll()) {
            ScriptInterface script = LoadAllScriptsBackend.load(s, context);
            if (script == null) continue;
            list.add(script);
        }
        Collections.sort(list);
        return list;
    }

    public static ScriptInterface load(Script s, SessionContext context) {
        ScriptInterface script = new ScriptInterface();
        script.setId(s.getUniqueId());
        script.setName(s.getName());
        script.setEngine(s.getEngine());
        script.setDescription(s.getDescription());
        script.setPermission(s.getPermission());
        script.setScript(s.getScript());
        script.setCanDelete(context.hasPermission(Right.ScriptEdit));
        script.setCanEdit(context.hasPermission(Right.ScriptEdit));
        Right right = null;
        if (s.getPermission() == null) {
            script.setCanExecute(true);
        } else {
            try {
                right = Right.valueOf(s.getPermission().replace(" ", ""));
                script.setCanExecute(context.hasPermission(right));
            }
            catch (IllegalArgumentException e) {
                script.setCanExecute(false);
            }
        }
        for (ScriptParameter p : s.getParameters()) {
            ScriptInterface.ScriptParameterInterface parameter = new ScriptInterface.ScriptParameterInterface();
            parameter.setLabel(p.getLabel() == null ? p.getName() : p.getLabel());
            parameter.setName(p.getName());
            parameter.setDefaultValue(p.getDefaultValue());
            parameter.setType(p.getType());
            if (p.getType().startsWith("enum(") && p.getType().endsWith(")")) {
                for (String string : p.getType().substring("enum(".length(), p.getType().length() - 1).split(",")) {
                    parameter.addOption(string, string);
                }
            } else if (p.getType().startsWith("reference(") && p.getType().endsWith(")")) {
                try {
                    String clazz = p.getType().substring("reference(".length(), p.getType().length() - 1);
                    if ("StudentSectioningStatus".equals(clazz)) {
                        for (StudentSectioningStatus entry : StudentSectioningStatus.findAll(context.getUser().getCurrentAcademicSessionId())) {
                            parameter.addOption(entry.getReference(), entry.getLabel());
                        }
                    }
                    if ("LearningManagementSystemInfo".equals(clazz)) {
                        for (LearningManagementSystemInfo entry : LearningManagementSystemInfo.findAll(context.getUser().getCurrentAcademicSessionId())) {
                            parameter.addOption(entry.getReference(), entry.getLabel());
                        }
                    }
                    for (RefTableEntry entry : RefTableEntryDAO.getInstance().getSession().createQuery("from " + clazz).setCacheable(true).list()) {
                        parameter.addOption(entry.getReference(), entry.getLabel());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (p.getType().equalsIgnoreCase("department") || p.getType().equalsIgnoreCase("departments")) {
                if (p.getType().equalsIgnoreCase("departments")) {
                    parameter.setMultiSelect(true);
                }
                for (Department department : Department.getUserDepartments(context.getUser())) {
                    if (right != null && Department.class.equals(right.type()) && !context.hasPermission(department, right)) continue;
                    parameter.addOption(department.getUniqueId().toString(), department.getDeptCode() + " - " + department.getName());
                }
            } else if (p.getType().equalsIgnoreCase("subject") || p.getType().equalsIgnoreCase("subjects")) {
                if (p.getType().equalsIgnoreCase("subjects")) {
                    parameter.setMultiSelect(true);
                }
                for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
                    if (right != null && SubjectArea.class.equals(right.type()) && !context.hasPermission(subject, right)) continue;
                    parameter.addOption(subject.getUniqueId().toString(), subject.getSubjectAreaAbbreviation() + " - " + HtmlUtils.htmlUnescape((String)subject.getTitle()));
                }
            } else if (p.getType().equalsIgnoreCase("building") || p.getType().equalsIgnoreCase("buildings")) {
                if (p.getType().equalsIgnoreCase("buildings")) {
                    parameter.setMultiSelect(true);
                }
                for (Building building : Building.findAll(context.getUser().getCurrentAcademicSessionId())) {
                    if (right != null && Building.class.equals(right.type()) && !context.hasPermission(building, right)) continue;
                    parameter.addOption(building.getUniqueId().toString(), building.getAbbreviation() + " - " + HtmlUtils.htmlUnescape((String)building.getName()));
                }
            } else if (p.getType().equalsIgnoreCase("room") || p.getType().equalsIgnoreCase("rooms")) {
                if (p.getType().equalsIgnoreCase("rooms")) {
                    parameter.setMultiSelect(true);
                }
                for (Room room : Room.findAllRooms(context.getUser().getCurrentAcademicSessionId())) {
                    if (right != null && Room.class.equals(right.type()) && !context.hasPermission(room, right)) continue;
                    parameter.addOption(room.getUniqueId().toString(), room.getLabel());
                }
            } else if (p.getType().equalsIgnoreCase("location") || p.getType().equalsIgnoreCase("locations")) {
                if (p.getType().equalsIgnoreCase("locations")) {
                    parameter.setMultiSelect(true);
                }
                for (Location location : Location.findAll(context.getUser().getCurrentAcademicSessionId())) {
                    if (right != null && Location.class.equals(right.type()) && !context.hasPermission(location, right)) continue;
                    parameter.addOption(location.getUniqueId().toString(), location.getLabel());
                }
            } else {
                for (SavedHQL.Option option : SavedHQL.Option.values()) {
                    Long id;
                    if (!p.getType().equalsIgnoreCase(option.name())) continue;
                    parameter.setMultiSelect(option.allowMultiSelection());
                    for (Map.Entry<Long, String> entry : option.values(context.getUser()).entrySet()) {
                        parameter.addOption(entry.getKey().toString(), entry.getValue());
                    }
                    if (p.getDefaultValue() == null || (id = option.lookupValue(context.getUser(), p.getDefaultValue())) == null) break;
                    parameter.setValue(id.toString());
                    break;
                }
            }
            script.addParameter(parameter);
        }
        if (script.hasParameters()) {
            Collections.sort(script.getParameters());
        }
        return script;
    }
}

