/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.security.SessionContext;

@GwtRpcImplements(value=RoomInterface.GeocodeRequest.class)
public class GeocodingBackend
implements GwtRpcImplementation<RoomInterface.GeocodeRequest, RoomInterface.GeocodeResponse>,
InitializingBean,
DisposableBean {
    private static Logger sLog = Logger.getLogger(GeocodingBackend.class);
    private Client iClient;

    public void afterPropertiesSet() throws Exception {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
    }

    public void destroy() throws Exception {
        this.iClient.stop();
    }

    @Override
    public RoomInterface.GeocodeResponse execute(RoomInterface.GeocodeRequest request, SessionContext context) {
        ClientResource resource = null;
        try {
            resource = request.isReverse() ? new ClientResource(ApplicationProperty.RoomGeocodeReverse.value()) : new ClientResource(ApplicationProperty.RoomGeocodeSearch.value());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("format", "json");
            resource.addQueryParameter("limit", "1");
            if (request.hasQuery()) {
                resource.addQueryParameter("q", request.getQuery());
            }
            if (request.hasViewBox()) {
                resource.addQueryParameter("viewbox", request.getViewBox());
            }
            if (request.hasCoordinates()) {
                resource.addQueryParameter("lat", request.getLat().toString());
                resource.addQueryParameter("lon", request.getLon().toString());
            }
            resource.get(MediaType.APPLICATION_JSON);
            GeocodeResponseMessage message = null;
            if (request.isReverse()) {
                message = new GsonRepresentation<GeocodeResponseMessage>(resource.getResponseEntity(), GeocodeResponseMessage.class).getObject();
            } else {
                List messages = (List)new GsonRepresentation(resource.getResponseEntity(), GeocodeResponseMessage.TYPE_LIST).getObject();
                if (messages != null && !messages.isEmpty()) {
                    message = (GeocodeResponseMessage)messages.get(0);
                }
            }
            if (message != null) {
                RoomInterface.GeocodeResponse response = new RoomInterface.GeocodeResponse();
                response.setQuery(message.display_name);
                response.setCoordinates(message.lat, message.lon);
                RoomInterface.GeocodeResponse geocodeResponse = response;
                return geocodeResponse;
            }
            try {
                throw new GwtRpcException("No match.");
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to geocode: " + e.getMessage()), (Throwable)e);
                throw new GwtRpcException("Failed to geocode: " + e.getMessage());
            }
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    static class GeocodeResponseMessage {
        public static final Type TYPE_LIST = new TypeToken<ArrayList<GeocodeResponseMessage>>(){}.getType();
        String display_name;
        Double lat;
        Double lon;

        GeocodeResponseMessage() {
        }
    }
}

