/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.reservation;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.springframework.web.util.HtmlUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseCurriculumReservation;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.dao.ReservationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.FilterBoxBackend;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

@GwtRpcImplements(value=ReservationInterface.ReservationFilterRpcRequest.class)
public class ReservationFilterBackend
extends FilterBoxBackend<ReservationInterface.ReservationFilterRpcRequest> {
    public static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    public static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public EventInterface.FilterRpcResponse execute(ReservationInterface.ReservationFilterRpcRequest request, SessionContext context) {
        context.checkPermission(Right.Reservations);
        return super.execute(request, context);
    }

    @Override
    public void load(ReservationInterface.ReservationFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        Integer curriculumOverrideCnt;
        Integer groupOverrideCnt;
        Integer individualOverrideCnt;
        ReservationQuery query = ReservationFilterBackend.getQuery(request, context);
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        org.hibernate.Session hibSession = ReservationDAO.getInstance().getSession();
        HashMap<Integer, Integer> type2count = new HashMap<Integer, Integer>();
        for (Object[] o : query.select("r.class, count(distinct r)").group("r.class").exclude("type").exclude("override").query(hibSession).list()) {
            Integer type = ((Number)o[0]).intValue();
            int count = ((Number)o[1]).intValue();
            type2count.put(type, count);
        }
        EventInterface.FilterRpcResponse.Entity individualType = new EventInterface.FilterRpcResponse.Entity(new Long(0L), "Individual", MESSAGES.reservationIndividualAbbv(), "translated-value", MESSAGES.reservationIndividualAbbv());
        Integer individualCnt = (Integer)type2count.get(0);
        if (individualCnt != null) {
            individualType.setCount(individualCnt);
        }
        if ((individualOverrideCnt = (Integer)type2count.get(5)) != null) {
            individualType.setCount(individualType.getCount() + individualOverrideCnt);
        }
        response.add("type", individualType);
        EventInterface.FilterRpcResponse.Entity groupType = new EventInterface.FilterRpcResponse.Entity(new Long(0L), "Group", MESSAGES.reservationStudentGroupAbbv(), "translated-value", MESSAGES.reservationStudentGroupAbbv());
        Integer groupCnt = (Integer)type2count.get(1);
        if (groupCnt != null) {
            groupType.setCount(groupCnt);
        }
        if ((groupOverrideCnt = (Integer)type2count.get(6)) != null) {
            groupType.setCount(groupType.getCount() + groupOverrideCnt);
        }
        response.add("type", groupType);
        EventInterface.FilterRpcResponse.Entity lcType = new EventInterface.FilterRpcResponse.Entity(new Long(0L), "LC", MESSAGES.reservationLearningCommunityAbbv(), "translated-value", MESSAGES.reservationLearningCommunityAbbv());
        Integer lcCnt = (Integer)type2count.get(7);
        if (lcCnt != null) {
            lcType.setCount(lcCnt);
        }
        response.add("type", lcType);
        EventInterface.FilterRpcResponse.Entity curriculumType = new EventInterface.FilterRpcResponse.Entity(new Long(0L), "Curriculum", MESSAGES.reservationCurriculumAbbv(), "translated-value", MESSAGES.reservationCurriculumAbbv());
        Integer curriculumCnt = (Integer)type2count.get(2);
        if (curriculumCnt != null) {
            curriculumType.setCount(curriculumCnt);
        }
        if ((curriculumOverrideCnt = (Integer)type2count.get(8)) != null) {
            curriculumType.setCount(curriculumType.getCount() + curriculumOverrideCnt);
        }
        response.add("type", curriculumType);
        EventInterface.FilterRpcResponse.Entity courseType = new EventInterface.FilterRpcResponse.Entity(new Long(0L), "Course", MESSAGES.reservationCourseAbbv(), "translated-value", MESSAGES.reservationCourseAbbv());
        Integer courseCnt = (Integer)type2count.get(3);
        if (courseCnt != null) {
            courseType.setCount(courseCnt);
        }
        EventInterface.FilterRpcResponse.Entity overrideType = new EventInterface.FilterRpcResponse.Entity(new Long(0L), "Override", MESSAGES.reservationOverrideAbbv(), "translated-value", MESSAGES.reservationOverrideAbbv());
        Integer overrideCnt = (Integer)type2count.get(4);
        if (overrideCnt != null) {
            overrideType.setCount(overrideCnt);
        }
        response.add("type", overrideType);
        HashMap<Long, Integer> dept2count = new HashMap<Long, Integer>();
        for (Object o : query.select("co.subjectArea.department.uniqueId, count(distinct r)").group("co.subjectArea.department.uniqueId").exclude("department").exclude("subject").query(hibSession).list()) {
            Long l = (Long)o[0];
            int count = ((Number)o[1]).intValue();
            dept2count.put(l, count);
        }
        TreeSet<EventInterface.FilterRpcResponse.Entity> depts = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
        for (Department department : Department.getUserDepartments(context.getUser())) {
            Integer count = (Integer)dept2count.get(department.getUniqueId());
            if (count == null) continue;
            EventInterface.FilterRpcResponse.Entity dept = new EventInterface.FilterRpcResponse.Entity(department.getUniqueId(), department.getDeptCode(), department.getDeptCode() + " - " + department.getName() + (department.isExternalManager() != false ? " (" + department.getExternalMgrLabel() + ")" : ""), new String[0]);
            dept.setCount(count);
            depts.add(dept);
        }
        response.add("department", depts);
        HashMap<Long, Integer> subject2count = new HashMap<Long, Integer>();
        for (Object[] o : query.select("co.subjectArea.uniqueId, count(distinct r)").group("co.subjectArea.uniqueId").exclude("department").exclude("subject").query(hibSession).list()) {
            Long type = (Long)o[0];
            int count = ((Number)o[1]).intValue();
            subject2count.put(type, count);
        }
        TreeSet<EventInterface.FilterRpcResponse.Entity> treeSet = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
        for (SubjectArea area : SubjectArea.getUserSubjectAreas(context.getUser())) {
            Integer count = (Integer)subject2count.get(area.getUniqueId());
            if (count == null) continue;
            EventInterface.FilterRpcResponse.Entity subject = new EventInterface.FilterRpcResponse.Entity(area.getUniqueId(), area.getSubjectAreaAbbreviation(), area.getSubjectAreaAbbreviation() + " - " + HtmlUtils.htmlUnescape((String)area.getTitle()), new String[0]);
            subject.setCount(count);
            treeSet.add(subject);
        }
        response.add("subject", treeSet);
        EventInterface.FilterRpcResponse.Entity all = new EventInterface.FilterRpcResponse.Entity(0L, "All", CONSTANTS.reservationModeLabel()[0], "translated-value", CONSTANTS.reservationModeAbbv()[0]);
        all.setCount(((Number)query.select("count(distinct r)").exclude("mode").query(hibSession).uniqueResult()).intValue());
        response.add("mode", all);
        EventInterface.FilterRpcResponse.Entity expired = new EventInterface.FilterRpcResponse.Entity(1L, "Expired", CONSTANTS.reservationModeLabel()[1], "translated-value", CONSTANTS.reservationModeAbbv()[1]);
        expired.setCount(((Number)query.select("count(distinct r)").exclude("mode").where("r.expirationDate < :today or :today < r.startDate").set("today", today).query(hibSession).uniqueResult()).intValue());
        response.add("mode", expired);
        EventInterface.FilterRpcResponse.Entity notExpired = new EventInterface.FilterRpcResponse.Entity(2L, "Not Expired", CONSTANTS.reservationModeLabel()[2], "translated-value", CONSTANTS.reservationModeAbbv()[2]);
        notExpired.setCount(all.getCount() - expired.getCount());
        response.add("mode", notExpired);
        if (request.hasOptions("type") && request.getOptions("type").contains("Curriculum")) {
            HashMap<Long, EventInterface.FilterRpcResponse.Entity> areas = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
            for (Reservation reservation : query.select("distinct r").where("r.class in (CurriculumReservation, CurriculumOverrideReservation)").exclude("area").query(hibSession).list()) {
                for (AcademicArea academicArea : ((CurriculumReservation)reservation).getAreas()) {
                    EventInterface.FilterRpcResponse.Entity area = (EventInterface.FilterRpcResponse.Entity)areas.get(academicArea.getUniqueId());
                    if (area == null) {
                        area = new EventInterface.FilterRpcResponse.Entity(academicArea.getUniqueId(), academicArea.getAcademicAreaAbbreviation(), Constants.curriculaToInitialCase(academicArea.getTitle()), new String[0]);
                        areas.put(area.getUniqueId(), area);
                    }
                    area.incCount();
                }
            }
            response.add("area", new TreeSet<EventInterface.FilterRpcResponse.Entity>(areas.values()));
        }
        if (request.hasOptions("type") && request.getOptions("type").contains("Override")) {
            ArrayList<EventInterface.FilterRpcResponse.Entity> types = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            for (Object[] typeAndCount : query.select("r.type, count(distinct r)").where("r.class = OverrideReservation").group("r.type").order("r.type").exclude("override").query(hibSession).list()) {
                ReservationInterface.OverrideType type = ReservationInterface.OverrideType.values()[((Number)typeAndCount[0]).intValue()];
                EventInterface.FilterRpcResponse.Entity e = new EventInterface.FilterRpcResponse.Entity(new Long(type.ordinal()), type.getReference(), CONSTANTS.reservationOverrideTypeAbbv()[type.ordinal()], new String[0]);
                e.setCount(((Number)typeAndCount[1]).intValue());
                types.add(e);
            }
            response.add("override", types);
        }
        if (request.hasOptions("type") && (request.getOptions("type").contains("Group") || request.getOptions("type").contains("LC"))) {
            boolean gr = request.getOptions("type").contains("Group");
            boolean lc = request.getOptions("type").contains("LC");
            HashMap<Long, EventInterface.FilterRpcResponse.Entity> groups = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
            for (Reservation reservation : query.select("distinct r").where(lc ? (gr ? "r.class in (StudentGroupReservation, LearningCommunityReservation)" : "r.class = LearningCommunityReservation") : "r.class = StudentGroupReservation").exclude("group").query(hibSession).list()) {
                StudentGroup studentGroup = ((StudentGroupReservation)reservation).getGroup();
                EventInterface.FilterRpcResponse.Entity group = (EventInterface.FilterRpcResponse.Entity)groups.get(studentGroup.getUniqueId());
                if (group == null) {
                    group = new EventInterface.FilterRpcResponse.Entity(studentGroup.getUniqueId(), studentGroup.getGroupAbbreviation(), Constants.curriculaToInitialCase(studentGroup.getGroupName()), new String[0]);
                    groups.put(group.getUniqueId(), group);
                }
                group.incCount();
            }
            response.add("group", new TreeSet<EventInterface.FilterRpcResponse.Entity>(groups.values()));
        }
    }

    @Override
    public void suggestions(ReservationInterface.ReservationFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        org.hibernate.Session hibSession = ReservationDAO.getInstance().getSession();
        ReservationQuery query = ReservationFilterBackend.getQuery(request, context);
        if (request.hasText()) {
            for (CourseOffering course : query.select("distinct co").where("lower(co.subjectAreaAbbv || ' ' || co.courseNbr) like :x").set("x", request.getText().toLowerCase() + "%").order("co.subjectAreaAbbv, co.courseNbr").limit(20).query(hibSession).list()) {
                response.addSuggestion(course.getCourseName(), course.getCourseName(), course.getTitle() == null ? MESSAGES.reservationCourseAbbv() : course.getTitle());
            }
        }
        if (!response.hasSuggestions()) {
            TreeSet<SubjectArea> subjects = SubjectArea.getUserSubjectAreas(context.getUser());
            Query q = new Query(request.getText());
            TreeSet<EventInterface.FilterRpcResponse.Entity> suggestions = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
            for (Reservation reservation : query.select("distinct r").query(hibSession).list()) {
                if (!q.match(new ReservationMatcher(reservation))) continue;
                for (CourseOffering course : reservation.getInstructionalOffering().getCourseOfferings()) {
                    if (!subjects.contains(course.getSubjectArea())) continue;
                    suggestions.add(new EventInterface.FilterRpcResponse.Entity(0L, course.getCourseName(), course.getCourseName(), "hint", course.getTitle() == null ? MESSAGES.reservationCourseAbbv() : course.getTitle()));
                }
            }
            for (EventInterface.FilterRpcResponse.Entity suggestion : suggestions) {
                response.addSuggestion(suggestion.getName(), suggestion.getName(), suggestion.getProperty("hint", MESSAGES.reservationCourseAbbv()));
                if (response.getSuggestions().size() != 20) continue;
                break;
            }
        }
        if (!request.getText().isEmpty() && (response.getSuggestions() == null || response.getSuggestions().size() < 20) && request.hasOptions("type") && (request.getOptions("type").contains("Individual") || request.getOptions("type").contains("Override"))) {
            ReservationQuery.ReservationQueryInstance instance = query.select("distinct s").from("inner join r.instructionalOffering.courseOfferings co inner join r.students s").exclude("student");
            int id = 0;
            StringTokenizer s = new StringTokenizer(request.getText().trim(), ", ");
            while (s.hasMoreTokens()) {
                String token = s.nextToken().toUpperCase();
                instance.where("upper(s.firstName) like :cn" + id + " || '%' or upper(s.middleName) like :cn" + id + " || '%' or upper(s.lastName) like :cn" + id + " || '%' or s.externalUniqueId = :cn" + id).set("cn" + id, token);
            }
            for (Student student : instance.limit(20).query(hibSession).list()) {
                response.addSuggestion(student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle), student.getExternalUniqueId(), "Student", "student");
            }
        }
    }

    @Override
    public void enumarate(ReservationInterface.ReservationFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        for (Reservation reservation : ReservationFilterBackend.reservations(request, context)) {
            CourseOffering course = reservation.getInstructionalOffering().getControllingCourseOffering();
            if (reservation instanceof CourseReservation) {
                course = ((CourseReservation)reservation).getCourse();
            }
            response.addResult(new EventInterface.FilterRpcResponse.Entity(reservation.getUniqueId(), course.getCourseName(), course.getCourseNameWithTitle(), new String[0]));
        }
    }

    public static List<Reservation> reservations(ReservationInterface.ReservationFilterRpcRequest request, SessionContext context) {
        ArrayList<Reservation> ret = new ArrayList<Reservation>();
        if (request.getSessionId() == null) {
            request.setSessionId(context.getUser().getCurrentAcademicSessionId());
        }
        org.hibernate.Session hibSession = ReservationDAO.getInstance().getSession();
        if (request.hasText()) {
            request.setOption("course", request.getText());
        }
        String fetch = "inner join fetch r.instructionalOffering io inner join io.courseOfferings co left join fetch r.classes xclz left join fetch r.configurations xcfg left join fetch r.areas xarea left join fetch r.majors xmjr left join fetch r.classifications xclf left join fetch r.course xcrs left join fetch r.students xstd left join fetch r.group xgrp";
        for (Reservation reservation : ReservationFilterBackend.getQuery(request, context).select("distinct r").from(fetch).query(hibSession).list()) {
            ret.add(reservation);
        }
        if (ret.isEmpty() && request.hasText()) {
            Query query = new Query(request.getText());
            for (Reservation reservation : ReservationFilterBackend.getQuery(request, context).select("distinct r").from(fetch).exclude("course").query(hibSession).list()) {
                if (!query.match(new ReservationMatcher(reservation))) continue;
                ret.add(reservation);
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static ReservationQuery getQuery(ReservationInterface.ReservationFilterRpcRequest request, SessionContext context) {
        ReservationQuery query = new ReservationQuery(request.getSessionId());
        if (request.hasOptions("type")) {
            String type = "";
            for (String string : request.getOptions("type")) {
                if (!type.isEmpty()) {
                    type = type + ",";
                }
                if ("individual".equalsIgnoreCase(string)) {
                    type = type + "IndividualReservation,IndividualOverrideReservation";
                }
                if ("group".equalsIgnoreCase(string)) {
                    type = type + "StudentGroupReservation,GroupOverrideReservation";
                }
                if ("course".equalsIgnoreCase(string)) {
                    type = type + "CourseReservation";
                }
                if ("curriculum".equalsIgnoreCase(string)) {
                    type = type + "CurriculumReservation,CurriculumOverrideReservation";
                }
                if ("override".equalsIgnoreCase(string)) {
                    type = type + "OverrideReservation";
                }
                if (!"lc".equalsIgnoreCase(string)) continue;
                type = type + "LearningCommunityReservation";
            }
            query.addWhere("type", "r.class " + (type.indexOf(44) < 0 ? "= " + type : "in (" + type + ")"));
        }
        if (request.hasOptions("override")) {
            String override = "";
            for (String string : request.getOptions("override")) {
                ReservationInterface.OverrideType type = null;
                for (ReservationInterface.OverrideType t : ReservationInterface.OverrideType.values()) {
                    if (!t.getReference().equals(string)) continue;
                    type = t;
                    break;
                }
                if (type == null) continue;
                if (!override.isEmpty()) {
                    override = override + ",";
                }
                override = override + type.ordinal();
            }
            query.addWhere("override", "r.type " + (override.indexOf(44) < 0 ? "= " + override : "in (" + override + ")"));
        }
        if (request.hasOption("department")) {
            query.addWhere("department", "co.subjectArea.department.deptCode = :deptCode");
            query.addParameter("department", "deptCode", request.getOption("department"));
        } else if (!context.hasPermission(Right.DepartmentIndependent)) {
            boolean external = false;
            TreeSet<Department> departments = Department.getUserDepartments(context.getUser());
            for (Department department : departments) {
                if (!department.isExternalManager().booleanValue()) continue;
                external = true;
                break;
            }
            if (!external) {
                void var5_15;
                String string = "";
                int id = 0;
                for (Department department : departments) {
                    String string2 = (String)var5_15 + (var5_15.isEmpty() ? "" : ",") + ":deptId" + id;
                    query.addParameter("department", "deptId" + id, department.getUniqueId());
                }
                if (var5_15.isEmpty()) {
                    query.addWhere("department", "1 = 0");
                } else {
                    query.addWhere("department", "co.subjectArea.department.uniqueId " + (id == 1 ? "= " + (String)var5_15 : "in (" + (String)var5_15 + ")"));
                }
            }
        }
        if (request.hasOptions("subject")) {
            String subjects = "";
            int id = 0;
            for (String t : request.getOptions("subject")) {
                subjects = subjects + (subjects.isEmpty() ? "" : ",") + ":subject" + id;
                query.addParameter("subject", "subject" + id, t);
                ++id;
            }
            query.addWhere("subject", "co.subjectArea.subjectAreaAbbreviation " + (id == 1 ? "= " + subjects : "in (" + subjects + ")"));
        }
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        if (request.hasOption("before")) {
            void var5_24;
            Object var5_20 = null;
            if ("today".equals(request.getOption("before"))) {
                Date date = today;
            } else {
                try {
                    int dayOfYear = Integer.parseInt(request.getOption("before"));
                    Date date = DateUtils.getDate(((Session)SessionDAO.getInstance().get(request.getSessionId())).getSessionStartYear(), dayOfYear);
                }
                catch (NumberFormatException f) {
                    try {
                        Date date = Formats.getDateFormat(Formats.Pattern.FILTER_DATE).parse(request.getOption("before"));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if (var5_24 != null) {
                query.addParameter("before", "before", var5_24);
                query.addWhere("before", "r.expirationDate < :before");
            }
        }
        if (request.hasOption("after")) {
            void var5_30;
            Object var5_26 = null;
            if ("today".equals(request.getOption("after"))) {
                Date date = today;
            } else {
                try {
                    int dayOfYear = Integer.parseInt(request.getOption("after"));
                    Date date = DateUtils.getDate(((Session)SessionDAO.getInstance().get(request.getSessionId())).getSessionStartYear(), dayOfYear);
                }
                catch (NumberFormatException f) {
                    try {
                        Date date = Formats.getDateFormat(Formats.Pattern.FILTER_DATE).parse(request.getOption("after"));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if (var5_30 != null) {
                query.addParameter("after", "after", var5_30);
                query.addWhere("after", "r.expirationDate is null or r.expirationDate >= :after");
            }
        }
        if (request.hasOption("mode")) {
            String string = request.getOption("mode");
            if ("Expired".equalsIgnoreCase(string)) {
                query.addWhere("mode", "r.expirationDate < :today or :today < r.startDate");
                query.addParameter("mode", "today", today);
            } else if ("Not Expired".equalsIgnoreCase(string)) {
                query.addWhere("mode", "(r.expirationDate is null or r.expirationDate >= :today) and (r.startDate is null or r.startDate <= :today)");
                query.addParameter("mode", "today", today);
            }
        }
        if (request.hasOptions("area")) {
            void var5_35;
            String string = "";
            int id = 0;
            for (String t : request.getOptions("area")) {
                String string3 = (String)var5_35 + (var5_35.isEmpty() ? "" : ",") + ":area" + id;
                query.addParameter("area", "area" + id, t);
                ++id;
            }
            query.addWhere("area", "xarea.academicAreaAbbreviation " + (id == 1 ? "= " + (String)var5_35 : "in (" + (String)var5_35 + ")"));
        }
        if (request.hasOptions("group")) {
            void var5_39;
            String string = "";
            int id = 0;
            for (String t : request.getOptions("group")) {
                String string4 = (String)var5_39 + (var5_39.isEmpty() ? "" : ",") + ":group" + id;
                query.addParameter("group", "group" + id, t);
                ++id;
            }
            query.addWhere("group", "r.group.groupAbbreviation " + (id == 1 ? "= " + (String)var5_39 : "in (" + (String)var5_39 + ")"));
        }
        if (request.hasOptions("student")) {
            void var5_43;
            query.addJoin("student", "r.students s");
            String string = "";
            int id = 0;
            StringTokenizer s = new StringTokenizer(request.getOption("student").trim(), ", ");
            while (s.hasMoreTokens()) {
                String token = s.nextToken().toUpperCase();
                String string5 = (String)var5_43 + (var5_43.isEmpty() ? "" : " and ") + "(upper(s.firstName) like :std" + id + " || '%' or upper(s.middleName) like :std" + id + " || '%' or upper(s.lastName) like :std" + id + " || '%' or s.externalUniqueId = :std" + id + ")";
                query.addParameter("student", "std" + id, token);
                ++id;
            }
            query.addWhere("student", (String)var5_43);
        }
        if (request.hasOptions("course")) {
            void var5_47;
            String string = "";
            int id = 0;
            for (String t : request.getOptions("course")) {
                String string6 = (String)var5_47 + (var5_47.isEmpty() ? "" : ",") + ":course" + id;
                query.addParameter("course", "course" + id, t.toLowerCase());
                ++id;
            }
            query.addWhere("course", "lower(co.subjectArea.subjectAreaAbbreviation || ' ' || co.courseNbr) " + (id == 1 ? "= " + (String)var5_47 : "in (" + (String)var5_47 + ")"));
        }
        return query;
    }

    private static class ReservationMatcher
    implements Query.TermMatcher {
        private Reservation iReservation;
        private Date iExpDate;
        private Formats.Format<Date> iDateFormat = null;

        private ReservationMatcher(Reservation r) {
            this.iReservation = r;
            Calendar c = Calendar.getInstance(Locale.US);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            this.iExpDate = c.getTime();
        }

        private String format(Date date) {
            if (this.iDateFormat == null) {
                this.iDateFormat = Formats.getDateFormat(Formats.Pattern.FILTER_DATE);
            }
            return this.iDateFormat.format(date);
        }

        private Date parse(String date) throws ParseException {
            if (this.iDateFormat == null) {
                this.iDateFormat = Formats.getDateFormat(Formats.Pattern.FILTER_DATE);
            }
            return this.iDateFormat.parse(date);
        }

        @Override
        public boolean match(String attr, String term) {
            StudentGroupReservation gr;
            Object d;
            if (term.isEmpty()) {
                return true;
            }
            if (attr == null || "course".equals(attr)) {
                for (CourseOffering courseOffering : this.iReservation.getInstructionalOffering().getCourseOfferings()) {
                    if (!this.eq(courseOffering.getCourseName(), term) && !this.has(courseOffering.getCourseName(), term)) continue;
                    return true;
                }
            }
            if (("dept".equals(attr) || "department".equals(attr)) && (this.eq(((BaseDepartment)(d = this.iReservation.getInstructionalOffering().getDepartment())).getDeptCode(), term) || this.eq(((BaseDepartment)d).getAbbreviation(), term) || this.has(((BaseDepartment)d).getName(), term))) {
                return true;
            }
            if ("subject".equals(attr) || "subj".equals(attr)) {
                for (CourseOffering courseOffering : this.iReservation.getInstructionalOffering().getCourseOfferings()) {
                    if (!this.eq(courseOffering.getSubjectAreaAbbv(), term) && !this.has(courseOffering.getSubjectArea().getTitle(), term)) continue;
                    return true;
                }
            }
            if ("type".equals(attr)) {
                if (this.iReservation instanceof OverrideReservation && "override".equalsIgnoreCase(term)) {
                    return true;
                }
                if (this.iReservation instanceof IndividualReservation && !(this.iReservation instanceof OverrideReservation) && "individual".equalsIgnoreCase(term)) {
                    return true;
                }
                if (this.iReservation instanceof StudentGroupReservation && !(this.iReservation instanceof LearningCommunityReservation) && "group".equalsIgnoreCase(term)) {
                    return true;
                }
                if (this.iReservation instanceof LearningCommunityReservation && "lc".equalsIgnoreCase(term)) {
                    return true;
                }
                if (this.iReservation instanceof CourseReservation && "course".equalsIgnoreCase(term)) {
                    return true;
                }
                if (this.iReservation instanceof CurriculumReservation && "curriculum".equalsIgnoreCase(term)) {
                    return true;
                }
            }
            if ("override".equals(attr) && this.iReservation instanceof OverrideReservation && ReservationInterface.OverrideType.values()[((OverrideReservation)this.iReservation).getType()].getReference().equalsIgnoreCase(term)) {
                return true;
            }
            if ("group".equals(attr) && this.iReservation instanceof StudentGroupReservation && (this.eq((gr = (StudentGroupReservation)this.iReservation).getGroup().getGroupAbbreviation(), term) || this.has(gr.getGroup().getGroupName(), term))) {
                return true;
            }
            if ("student".equals(attr) && this.iReservation instanceof IndividualReservation) {
                IndividualReservation ir = (IndividualReservation)this.iReservation;
                for (Student s : ir.getStudents()) {
                    if (!this.has(s.getName(DepartmentalInstructor.sNameFormatFirstMiddleLast), term) && !this.eq(s.getExternalUniqueId(), term)) continue;
                    return true;
                }
            }
            if ("area".equals(attr) && this.iReservation instanceof CurriculumReservation) {
                Iterator<InstrOfferingConfig> cr = (CurriculumReservation)this.iReservation;
                for (AcademicArea area : ((BaseCurriculumReservation)((Object)cr)).getAreas()) {
                    if (!this.eq(area.getAcademicAreaAbbreviation(), term) && !this.has(area.getTitle(), term)) continue;
                    return true;
                }
            }
            if ("class".equals(attr)) {
                for (Class_ class_ : this.iReservation.getClasses()) {
                    if (!this.eq(class_.getClassLabel(), term) && !this.has(class_.getClassLabel(), term) && !this.eq(class_.getClassSuffix(), term)) continue;
                    return true;
                }
            }
            if ("config".equals(attr)) {
                for (InstrOfferingConfig instrOfferingConfig : this.iReservation.getConfigurations()) {
                    if (!this.eq(instrOfferingConfig.getName(), term) && !this.has(instrOfferingConfig.getName(), term)) continue;
                    return true;
                }
            }
            if (attr == null && "expired".equalsIgnoreCase(term)) {
                if (this.iReservation.getExpirationDate() != null && this.iReservation.getExpirationDate().before(this.iExpDate)) {
                    return true;
                }
                if (this.iReservation.getStartDate() != null && this.iExpDate.before(this.iReservation.getStartDate())) {
                    return true;
                }
            }
            if ((attr == null || "expiration".equals(attr) || "exp".equals(attr)) && this.iReservation.getExpirationDate() != null && this.eq(this.format(this.iReservation.getExpirationDate()), term)) {
                return true;
            }
            if ((attr == null || "start".equals(attr)) && this.iReservation.getStartDate() != null && this.eq(this.format(this.iReservation.getStartDate()), term)) {
                return true;
            }
            if ("before".equals(attr)) {
                try {
                    Date x2;
                    Date date = x2 = "today".equalsIgnoreCase(term) ? this.iExpDate : this.parse(term);
                    if (this.iReservation.getExpirationDate() != null && this.iReservation.getExpirationDate().before(x2)) {
                        return true;
                    }
                }
                catch (Exception x2) {
                    // empty catch block
                }
            }
            if ("after".equals(attr)) {
                try {
                    Date x;
                    Date date = x = "today".equalsIgnoreCase(term) ? this.iExpDate : this.parse(term);
                    if (this.iReservation.getExpirationDate() == null || this.iReservation.getExpirationDate().after(x)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            for (String t : name.split(" ")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ReservationQuery {
        private Long iSessionId;
        private Map<String, String> iJoin = new HashMap<String, String>();
        private Map<String, String> iFrom = new HashMap<String, String>();
        private Map<String, String> iWhere = new HashMap<String, String>();
        private Map<String, Map<String, Object>> iParams = new HashMap<String, Map<String, Object>>();

        public ReservationQuery(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public void addFrom(String option, String from) {
            this.iFrom.put(option, from);
        }

        public void addWhere(String option, String where) {
            this.iWhere.put(option, where);
        }

        public void addJoin(String option, String from) {
            this.iJoin.put(option, from);
        }

        private void addParameter(String option, String name, Object value) {
            Map<String, Object> params = this.iParams.get(option);
            if (params == null) {
                params = new HashMap<String, Object>();
                this.iParams.put(option, params);
            }
            params.put(name, value);
        }

        public String getFrom(Collection<String> excludeOption) {
            String from = "";
            for (Map.Entry<String, String> entry : this.iFrom.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                from = from + ", " + entry.getValue();
            }
            return from;
        }

        public String getJoin(Collection<String> excludeOption) {
            String join = "";
            for (Map.Entry<String, String> entry : this.iJoin.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                join = join + " inner join " + entry.getValue();
            }
            return join;
        }

        public String getWhere(Collection<String> excludeOption) {
            String where = "";
            for (Map.Entry<String, String> entry : this.iWhere.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                where = where + " and (" + entry.getValue() + ")";
            }
            return where;
        }

        public org.hibernate.Query setParams(org.hibernate.Query query, Collection<String> excludeOption) {
            for (Map.Entry<String, Map<String, Object>> entry : this.iParams.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                for (Map.Entry<String, Object> param : entry.getValue().entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
            }
            return query;
        }

        public ReservationQueryInstance select(String select) {
            return new ReservationQueryInstance(select);
        }

        public class ReservationQueryInstance {
            private String iSelect = null;
            private String iFrom = "inner join r.instructionalOffering.courseOfferings co";
            private String iWhere = null;
            private String iOrderBy = null;
            private String iGroupBy = null;
            private String iType = "Reservation";
            private Integer iLimit = null;
            private Set<String> iExclude = new HashSet<String>();
            private Map<String, Object> iParams = new HashMap<String, Object>();

            private ReservationQueryInstance(String select) {
                this.iSelect = select;
            }

            public ReservationQueryInstance from(String from) {
                this.iFrom = from;
                return this;
            }

            public ReservationQueryInstance where(String where) {
                this.iWhere = this.iWhere == null ? "(" + where + ")" : this.iWhere + " and (" + where + ")";
                return this;
            }

            public ReservationQueryInstance type(String type) {
                this.iType = type;
                return this;
            }

            public ReservationQueryInstance order(String orderBy) {
                this.iOrderBy = orderBy;
                return this;
            }

            public ReservationQueryInstance group(String groupBy) {
                this.iGroupBy = groupBy;
                return this;
            }

            public ReservationQueryInstance exclude(String excludeOption) {
                this.iExclude.add(excludeOption);
                return this;
            }

            public ReservationQueryInstance set(String param, Object value) {
                this.iParams.put(param, value);
                return this;
            }

            public ReservationQueryInstance limit(Integer limit) {
                this.iLimit = limit == null || limit <= 0 ? null : limit;
                return this;
            }

            public String query() {
                return "select " + (this.iSelect == null ? "distinct r" : this.iSelect) + " from " + this.iType + " r " + ReservationQuery.this.getJoin(this.iExclude) + (this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + ReservationQuery.this.getFrom(this.iExclude) + " where r.instructionalOffering.session.uniqueId = :sessionId" + ReservationQuery.this.getWhere(this.iExclude) + (this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
            }

            public org.hibernate.Query query(org.hibernate.Session hibSession) {
                org.hibernate.Query query = ReservationQuery.this.setParams(hibSession.createQuery(this.query()), this.iExclude).setLong("sessionId", ReservationQuery.this.iSessionId.longValue()).setCacheable(true);
                for (Map.Entry<String, Object> param : this.iParams.entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
                if (this.iLimit != null) {
                    query.setMaxResults(this.iLimit.intValue());
                }
                return query;
            }
        }
    }
}

