/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=teachingResponsibility]")
public class TeachingResponsibilities
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageTeachingResponsibility(), MESSAGES.pageTeachingResponsibilities());
    }

    @Override
    @PreAuthorize(value="checkPermission('TeachingResponsibilities')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 200, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldInstructor(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldCoordinator(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldAuxiliaryNoReport(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldHideInEvents(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldNoExport(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldDefault(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]));
        data.setSortBy(1);
        for (TeachingResponsibility responsibility : TeachingResponsibilityDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(responsibility.getUniqueId());
            r.setField(0, responsibility.getReference());
            r.setField(1, responsibility.getLabel());
            r.setField(2, responsibility.getAbbreviation());
            r.setField(3, responsibility.isInstructor() != false ? "true" : "false");
            r.setField(4, responsibility.isCoordinator() != false ? "true" : "false");
            r.setField(5, responsibility.hasOption(TeachingResponsibility.Option.auxiliary) ? "true" : "false");
            r.setField(6, responsibility.hasOption(TeachingResponsibility.Option.noevents) ? "true" : "false");
            r.setField(7, responsibility.hasOption(TeachingResponsibility.Option.noexport) ? "true" : "false");
            r.setField(8, responsibility.hasOption(TeachingResponsibility.Option.isdefault) ? "true" : "false");
            r.setDeletable(!responsibility.isUsed());
        }
        data.setEditable(context.hasPermission(Right.TeachingResponsibilityEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('TeachingResponsibilityEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (TeachingResponsibility responsibility : TeachingResponsibilityDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(responsibility.getUniqueId());
            if (r == null) {
                this.delete(responsibility, context, hibSession);
                continue;
            }
            this.update(responsibility, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    protected static Integer options(SimpleEditInterface.Record record) {
        int ret = 0;
        if ("true".equals(record.getField(5))) {
            ret += TeachingResponsibility.Option.auxiliary.toggle();
        }
        if ("true".equals(record.getField(6))) {
            ret += TeachingResponsibility.Option.noevents.toggle();
        }
        if ("true".equals(record.getField(7))) {
            ret += TeachingResponsibility.Option.noexport.toggle();
        }
        if ("true".equals(record.getField(8))) {
            ret += TeachingResponsibility.Option.isdefault.toggle();
        }
        return ret;
    }

    @Override
    @PreAuthorize(value="checkPermission('TeachingResponsibilityEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        TeachingResponsibility responsibility = new TeachingResponsibility();
        responsibility.setReference(record.getField(0));
        responsibility.setLabel(record.getField(1));
        responsibility.setAbbreviation(record.getField(2));
        responsibility.setInstructor("true".equals(record.getField(3)));
        responsibility.setCoordinator("true".equals(record.getField(4)));
        responsibility.setOptions(TeachingResponsibilities.options(record));
        record.setUniqueId((Long)hibSession.save((Object)responsibility));
        ChangeLog.addChange(hibSession, context, responsibility, responsibility.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(TeachingResponsibility responsibility, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (responsibility == null) {
            return;
        }
        if (ToolBox.equals((Object)responsibility.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)responsibility.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)responsibility.getAbbreviation(), (Object)record.getField(2)) && ToolBox.equals((Object)responsibility.isInstructor(), (Object)"true".equals(record.getField(3))) && ToolBox.equals((Object)responsibility.isCoordinator(), (Object)"true".equals(record.getField(4))) && ToolBox.equals((Object)responsibility.getOptions(), (Object)TeachingResponsibilities.options(record))) {
            return;
        }
        responsibility.setReference(record.getField(0));
        responsibility.setLabel(record.getField(1));
        responsibility.setAbbreviation(record.getField(2));
        responsibility.setInstructor("true".equals(record.getField(3)));
        responsibility.setCoordinator("true".equals(record.getField(4)));
        responsibility.setOptions(TeachingResponsibilities.options(record));
        hibSession.saveOrUpdate((Object)responsibility);
        ChangeLog.addChange(hibSession, context, responsibility, responsibility.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('TeachingResponsibilityEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(TeachingResponsibility responsibility, SessionContext context, Session hibSession) {
        if (responsibility == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, responsibility, responsibility.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)responsibility);
    }

    @Override
    @PreAuthorize(value="checkPermission('TeachingResponsibilityEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

