/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.io.IOException;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.server.admin.AdminExportToCSV;

@Service(value="org.unitime.timetable.export.Exporter:admin-report.pdf")
public class AdminExportToPDF
extends AdminExportToCSV {
    @Override
    public String reference() {
        return "admin-report.pdf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void export(SimpleEditInterface data, ExportHelper helper, String hidden) throws IOException {
        try (PDFPrinter out = new PDFPrinter(helper.getOutputStream(), false);){
            boolean visible;
            helper.setup(out.getContentType(), helper.getParameter("type") + ".pdf", false);
            boolean hasDetails = this.hasDetails(data);
            for (int i = 0; i < data.getFields().length; ++i) {
                boolean bl = visible = data.getFields()[i].isVisible() && (hidden == null || !hidden.contains("|" + data.getFields()[i].getName() + "|"));
                if (hasDetails && i == 0) {
                    visible = false;
                }
                if (visible) continue;
                out.hideColumn(i);
            }
            String[] header = new String[data.getFields().length];
            for (int i = 0; i < data.getFields().length; ++i) {
                header[i] = this.header(data, data.getFields()[i]);
            }
            out.printHeader(header);
            visible = true;
            for (SimpleEditInterface.Record r : data.getRecords()) {
                int i;
                if (hasDetails) {
                    if ("-".equals(r.getField(0))) {
                        visible = true;
                    } else if ("+".equals(r.getField(0))) {
                        visible = false;
                    } else if (!visible) continue;
                }
                PDFPrinter.A[] line = new PDFPrinter.A[data.getFields().length];
                for (i = 0; i < data.getFields().length; ++i) {
                    line[i] = this.pdfCell(data.getFields()[i], r, i);
                }
                if (this.isParent(data, r)) {
                    for (PDFPrinter.A cell : line) {
                        cell.setBackground("#f3f3f3");
                        if (!cell.getText().isEmpty()) continue;
                        cell.setText(" ");
                    }
                } else if (hasDetails) {
                    for (i = 0; i < line.length; ++i) {
                        if (i <= 0 || !data.getFields()[i].getName().contains("|") || this.isParent(data, r)) continue;
                        line[i].setText("  " + line[i].getText());
                    }
                }
                out.printLine(line);
            }
        }
    }

    protected PDFPrinter.A pdfCell(SimpleEditInterface.Field field, SimpleEditInterface.Record record, int index) {
        PDFPrinter.A cell = new PDFPrinter.A(this.cell(field, record, index), new PDFPrinter.F[0]);
        if (field.getType() == SimpleEditInterface.FieldType.number) {
            cell.set(PDFPrinter.F.RIGHT);
        }
        return cell;
    }
}

