/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.command.server.GwtRpcServlet;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.gwt.shared.UserDataInterface;

@Service(value="org.unitime.timetable.export.Exporter:admin-report.csv")
public class AdminExportToCSV
implements Exporter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    ApplicationContext applicationContext;

    @Override
    public String reference() {
        return "admin-report.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        String type = helper.getParameter("type");
        if (type == null) {
            throw new IllegalArgumentException("Admin page type not provided, please set the type parameter.");
        }
        String[] filter = helper.getParameterValues("filter");
        SimpleEditInterface.LoadDataRpcRequest request = new SimpleEditInterface.LoadDataRpcRequest();
        request.setFilter(filter);
        request.setType(type);
        final SimpleEditInterface data = GwtRpcServlet.execute(request, this.applicationContext, helper.getSessionContext());
        if (data == null) {
            throw new IllegalArgumentException("No data returned.");
        }
        final SimpleEditInterface.RecordComparator cmp = data.getComparator();
        boolean hasDetails = this.hasDetails(data);
        String hidden = null;
        if (data.isSaveOrder()) {
            UserDataInterface.GetUserDataRpcRequest ordRequest = new UserDataInterface.GetUserDataRpcRequest();
            ordRequest.add("SimpleEdit.Order[" + type + "]");
            if (hasDetails) {
                ordRequest.add("SimpleEdit.Open[" + type + "]");
            }
            ordRequest.add("SimpleEdit.Hidden[" + type + "]");
            UserDataInterface result = GwtRpcServlet.execute(ordRequest, this.applicationContext, helper.getSessionContext());
            if (result != null) {
                if (helper.getParameter("order") != null) {
                    result.put("SimpleEdit.Order[" + type + "]", helper.getParameter("order"));
                }
                if (helper.getParameter("open") != null) {
                    result.put("SimpleEdit.Open[" + type + "]", helper.getParameter("open"));
                }
                if (helper.getParameter("hidden") != null) {
                    result.put("SimpleEdit.Hidden[" + type + "]", helper.getParameter("hidden"));
                }
                final String order = "|" + (String)result.get("SimpleEdit.Order[" + type + "]") + "|";
                if (hasDetails) {
                    String open = "|" + (String)result.get("SimpleEdit.Open[" + type + "]") + "|";
                    for (SimpleEditInterface.Record r : data.getRecords()) {
                        if (!this.isParent(data, r)) continue;
                        r.setField(0, open.indexOf("|" + r.getUniqueId() + "|") >= 0 ? "-" : "+");
                    }
                }
                Collections.sort(data.getRecords(), new Comparator<SimpleEditInterface.Record>(){

                    @Override
                    public int compare(SimpleEditInterface.Record r1, SimpleEditInterface.Record r2) {
                        int i1;
                        if (data.getFields()[0].getType() == SimpleEditInterface.FieldType.parent) {
                            SimpleEditInterface.Record p2;
                            SimpleEditInterface.Record p1 = "+".equals(r1.getField(0)) || "-".equals(r1.getField(0)) ? null : data.getRecord(Long.valueOf(r1.getField(0)));
                            if ((p1 == null ? r1 : p1).equals((p2 = "+".equals(r2.getField(0)) || "-".equals(r2.getField(0)) ? null : data.getRecord(Long.valueOf(r2.getField(0)))) == null ? r2 : p2)) {
                                if (p1 != null && p2 == null) {
                                    return 1;
                                }
                                if (p1 == null && p2 != null) {
                                    return -1;
                                }
                            } else if (p1 != null || p2 != null) {
                                return this.compare(p1 == null ? r1 : p1, p2 == null ? r2 : p2);
                            }
                        }
                        int n = i1 = r1.getUniqueId() == null ? -1 : order.indexOf("|" + r1.getUniqueId() + "|");
                        if (i1 >= 0) {
                            int i2;
                            int n2 = i2 = r2.getUniqueId() == null ? -1 : order.indexOf("|" + r2.getUniqueId() + "|");
                            if (i2 >= 0) {
                                return i1 < i2 ? -1 : (i1 > i2 ? 1 : cmp.compare(r1, r2));
                            }
                        }
                        return cmp.compare(r1, r2);
                    }
                });
                hidden = "|" + (String)result.get("SimpleEdit.Hidden[" + type + "]") + "|";
            } else {
                Collections.sort(data.getRecords(), cmp);
            }
        } else {
            Collections.sort(data.getRecords(), cmp);
        }
        this.export(data, helper, hidden);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void export(SimpleEditInterface data, ExportHelper helper, String hidden) throws IOException {
        try (CSVPrinter out = new CSVPrinter(helper, false);){
            boolean visible;
            helper.setup(out.getContentType(), helper.getParameter("type") + ".csv", false);
            boolean hasDetails = this.hasDetails(data);
            for (int i = 0; i < data.getFields().length; ++i) {
                boolean bl = visible = data.getFields()[i].isVisible() && (hidden == null || !hidden.contains("|" + data.getFields()[i].getName() + "|"));
                if (visible) continue;
                out.hideColumn(i);
            }
            String[] header = new String[data.getFields().length];
            for (int i = 0; i < data.getFields().length; ++i) {
                header[i] = this.header(data, data.getFields()[i]);
            }
            out.printHeader(header);
            visible = true;
            for (SimpleEditInterface.Record r : data.getRecords()) {
                if (hasDetails) {
                    if ("-".equals(r.getField(0))) {
                        visible = true;
                    } else if ("+".equals(r.getField(0))) {
                        visible = false;
                    } else if (!visible) continue;
                }
                String[] line = new String[data.getFields().length];
                for (int i = 0; i < data.getFields().length; ++i) {
                    line[i] = this.cell(data.getFields()[i], r, i);
                }
                out.printLine(line);
            }
        }
    }

    protected String header(SimpleEditInterface data, SimpleEditInterface.Field field) {
        String name = field.getName();
        if (this.hasDetails(data) && name.contains("|")) {
            name = name.replace("|", "\n  ");
        }
        if ("&otimes;".equals(name)) {
            name = "\u2297";
        }
        return name;
    }

    public static String slot2time(int slot) {
        if (CONSTANTS.useAmPm()) {
            if (slot == 0) {
                return CONSTANTS.timeMidnight();
            }
            if (slot == 144) {
                return CONSTANTS.timeNoon();
            }
            if (slot == 288) {
                return CONSTANTS.timeMidnightEnd();
            }
        }
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONSTANTS.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + " " + (h == 24 ? CONSTANTS.timeAm() : (h >= 12 ? CONSTANTS.timePm() : CONSTANTS.timeAm()));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    protected String getValue(SimpleEditInterface.Field field, SimpleEditInterface.Record record, int index) {
        String value = record.getField(index);
        if (value == null) {
            return "";
        }
        if (field.getType() == SimpleEditInterface.FieldType.list) {
            for (SimpleEditInterface.ListItem item : field.getValues()) {
                if (!item.getValue().equals(value)) continue;
                return item.getText();
            }
        } else {
            if (field.getType() == SimpleEditInterface.FieldType.multi) {
                String text = "";
                for (String val : record.getValues(index)) {
                    for (SimpleEditInterface.ListItem item : field.getValues()) {
                        if (!item.getValue().equals(val)) continue;
                        if (!text.isEmpty()) {
                            text = text + ", ";
                        }
                        text = text + item.getText();
                    }
                }
                return text;
            }
            if (field.getType() == SimpleEditInterface.FieldType.time) {
                if (value == null || value.isEmpty()) {
                    return "";
                }
                return AdminExportToCSV.slot2time(Integer.valueOf(value));
            }
        }
        return value;
    }

    protected boolean hasDetails(SimpleEditInterface data) {
        return data != null && data.getFields().length > 0 && data.getFields()[0].getType() == SimpleEditInterface.FieldType.parent;
    }

    protected boolean isParent(SimpleEditInterface data, SimpleEditInterface.Record r) {
        return this.hasDetails(data) && ("+".equals(r.getField(0)) || "-".equals(r.getField(0)));
    }

    protected String cell(SimpleEditInterface.Field field, SimpleEditInterface.Record record, int index) {
        String value = this.getValue(field, record, index);
        switch (field.getType()) {
            case parent: {
                if (!"+".equals(value) && !"-".equals(value)) {
                    return "";
                }
                return value;
            }
            case toggle: {
                if (!(value.isEmpty() || "true".equals(value) || "false".equals(value))) {
                    return record.getField(index);
                }
                if (value.isEmpty() && field.isCheckedByDefault() || !value.isEmpty() && "true".equalsIgnoreCase(record.getField(index))) {
                    return MESSAGES.exportTrue();
                }
                return MESSAGES.exportFalse();
            }
            case person: {
                String[] name = record.getValues(index);
                return name.length <= 2 ? "<i>" + MESSAGES.notSet() + "</i>" : (name.length >= 6 && !name[6].isEmpty() ? name[6] : name[0] + ", " + name[1] + (name[2].isEmpty() ? "" : " " + name[2]));
            }
        }
        return value;
    }
}

