/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.StudentEmail;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class NotifyStudentAction
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private Long iStudentId;
    private XOffering iOldOffering;
    private XCourseId iOldCourseId;
    private XEnrollment iOldEnrollment;
    private XStudent iOldStudent;

    public NotifyStudentAction forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public NotifyStudentAction oldEnrollment(XOffering oldOffering, XCourseId oldCourseId, XEnrollment oldEnrollment) {
        this.iOldOffering = oldOffering;
        this.iOldCourseId = oldCourseId;
        this.iOldEnrollment = oldEnrollment;
        return this;
    }

    public NotifyStudentAction oldStudent(XStudent oldStudent) {
        this.iOldStudent = oldStudent;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    @Override
    public Boolean execute(OnlineSectioningServer server, final OnlineSectioningHelper helper) {
        XStudent student = server.getStudent(this.getStudentId());
        if (student != null) {
            XCourse course;
            XCourseRequest cr;
            if (this.iOldOffering != null) {
                if (this.iOldEnrollment != null && !this.iOldOffering.getOfferingId().equals(this.iOldEnrollment.getOfferingId())) {
                    this.iOldOffering = server.getOffering(this.iOldEnrollment.getOfferingId());
                }
                String message = "Student " + student.getName() + " (" + student.getStudentId() + ") changed.";
                String courseName = this.iOldCourseId != null ? this.iOldCourseId.getCourseName() : (this.iOldEnrollment == null ? this.iOldOffering.getName() : this.iOldOffering.getCourse(this.iOldEnrollment.getCourseId()).getCourseName());
                XCourseRequest request = null;
                for (XRequest xRequest : student.getRequests()) {
                    XCourseRequest cr2;
                    XCourseId id;
                    if (!(xRequest instanceof XCourseRequest) || (id = (cr2 = (XCourseRequest)xRequest).getCourseIdByOfferingId(this.iOldOffering.getOfferingId())) == null || this.iOldCourseId != null && !id.equals(this.iOldCourseId) || this.iOldEnrollment != null && !id.getCourseId().equals(this.iOldEnrollment.getCourseId())) continue;
                    courseName = id.getCourseName();
                    request = cr2;
                    break;
                }
                message = message + "\n  Previous assignment:";
                if (this.iOldEnrollment != null) {
                    message = message + "\n    " + (request == null ? this.iOldOffering.toString() : request.toString());
                    if (this.iOldEnrollment.getApproval() != null) {
                        message = message + " (approved by " + this.iOldEnrollment.getApproval().getName() + ")";
                    }
                    for (XSection xSection : this.iOldOffering.getSections(this.iOldEnrollment)) {
                        message = message + "\n      " + courseName + " " + xSection.toString(this.iOldEnrollment.getCourseId());
                    }
                } else {
                    message = message + "\n    " + (request == null ? this.iOldOffering.toString() : request.toString()) + " NOT ASSIGNED";
                }
                message = message + "\n  New assignment:";
                XOffering offering2 = server.getOffering(this.iOldOffering.getOfferingId());
                if (offering2 == null || request == null || request.getEnrollment() == null) {
                    message = message + "\n    " + (request == null ? this.iOldOffering.toString() : request.toString()) + " NOT ASSIGNED";
                } else {
                    message = message + "\n    " + request;
                    if (request.getEnrollment().getApproval() != null) {
                        message = message + " (approved by " + request.getEnrollment().getApproval().getName() + ")";
                    }
                    for (XSection section : offering2.getSections(request.getEnrollment())) {
                        message = message + "\n      " + courseName + " " + section.toString(request.getEnrollment().getCourseId());
                    }
                }
                helper.debug(message);
                if (server.getAcademicSession().isSectioningEnabled() && ApplicationProperty.OnlineSchedulingEmailConfirmation.isTrue()) {
                    server.execute(server.createAction(StudentEmail.class).forStudent(this.getStudentId()).oldEnrollment(this.iOldOffering, this.iOldCourseId, this.iOldEnrollment), helper.getUser(), new OnlineSectioningServer.ServerCallback<Boolean>(){

                        @Override
                        public void onFailure(Throwable exception) {
                            helper.error("Failed to notify student: " + exception.getMessage(), exception);
                        }

                        @Override
                        public void onSuccess(Boolean result) {
                        }
                    });
                }
                return true;
            }
            String message = "Student " + student.getName() + " (" + student.getStudentId() + ") changed.";
            if (this.iOldStudent != null) {
                message = message + "\n  Previous schedule:";
                for (XRequest r : this.iOldStudent.getRequests()) {
                    XOffering xOffering;
                    message = message + "\n    " + r;
                    if (!(r instanceof XCourseRequest)) continue;
                    cr = (XCourseRequest)r;
                    if (cr.getEnrollment() == null) {
                        message = message + " NOT ASSIGNED";
                        continue;
                    }
                    if (cr.getEnrollment().getApproval() != null) {
                        message = message + " (approved by " + cr.getEnrollment().getApproval().getName() + ")";
                    }
                    if ((xOffering = server.getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                    course = xOffering.getCourse(cr.getEnrollment().getCourseId());
                    for (XSection section : xOffering.getSections(cr.getEnrollment())) {
                        message = message + "\n      " + (course == null ? xOffering.getName() : course.getCourseName()) + " " + section.toString(cr.getEnrollment().getCourseId());
                    }
                }
            }
            message = message + "\n  New schedule:";
            for (XRequest r : student.getRequests()) {
                XOffering xOffering;
                message = message + "\n    " + r;
                if (!(r instanceof XCourseRequest)) continue;
                cr = (XCourseRequest)r;
                if (cr.getEnrollment() == null) {
                    message = message + " NOT ASSIGNED";
                    continue;
                }
                if (cr.getEnrollment().getApproval() != null) {
                    message = message + " (approved by " + cr.getEnrollment().getApproval().getName() + ")";
                }
                if ((xOffering = server.getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                course = xOffering.getCourse(cr.getEnrollment().getCourseId());
                for (XSection section : xOffering.getSections(cr.getEnrollment())) {
                    message = message + "\n      " + (course == null ? xOffering.getName() : course.getCourseName()) + " " + section.toString(cr.getEnrollment().getCourseId());
                }
            }
            helper.debug(message);
            if (server.getAcademicSession().isSectioningEnabled() && ApplicationProperty.OnlineSchedulingEmailConfirmation.isTrue()) {
                server.execute(server.createAction(StudentEmail.class).forStudent(this.getStudentId()).oldStudent(this.iOldStudent), helper.getUser(), new OnlineSectioningServer.ServerCallback<Boolean>(){

                    @Override
                    public void onFailure(Throwable exception) {
                        helper.error("Failed to notify student: " + exception.getMessage(), exception);
                    }

                    @Override
                    public void onSuccess(Boolean result) {
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public String name() {
        return "notify";
    }
}

