/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;
import org.unitime.timetable.onlinesectioning.updates.StudentEmail;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class MassCancelAction
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private List<Long> iStudentIds;
    private String iStatus;
    private boolean iEmail = false;
    private String iSubject;
    private String iMessage;
    private String iCC;

    public MassCancelAction forStudents(List<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public MassCancelAction withStatus(String status) {
        this.iStatus = status;
        return this;
    }

    public MassCancelAction withEmail(String subject, String message, String cc) {
        this.iEmail = true;
        this.iSubject = subject;
        this.iMessage = message;
        this.iCC = cc;
        return this;
    }

    public List<Long> getStudentIds() {
        return this.iStudentIds;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public boolean hasStatus() {
        return this.iStatus != null && !this.iStatus.isEmpty();
    }

    public boolean changeStatus() {
        return !"-".equals(this.iStatus);
    }

    public String getSubject() {
        return this.iSubject;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public String getCC() {
        return this.iCC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, final OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        if (!CustomStudentEnrollmentHolder.isAllowWaitListing()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        Throwable caughtException = null;
        HashSet<Long> offeringsToCheck = new HashSet<Long>();
        OnlineSectioningServer.ServerCallback<Boolean> emailSent = new OnlineSectioningServer.ServerCallback<Boolean>(){

            @Override
            public void onFailure(Throwable exception) {
                helper.error("Student email failed: " + exception.getMessage(), exception);
            }

            @Override
            public void onSuccess(Boolean result) {
            }
        };
        StudentSectioningStatus status = this.changeStatus() && this.hasStatus() ? (StudentSectioningStatus)helper.getHibSession().createQuery("from StudentSectioningStatus where reference = :ref and (session is null or session = :sessionId)").setString("ref", this.getStatus()).setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).uniqueResult() : null;
        for (Long studentId : this.getStudentIds()) {
            OnlineSectioningServer.Lock lock = server.lockStudent(studentId, null, this.name());
            try {
                helper.beginTransaction();
                try {
                    Student student = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                    if (student != null) {
                        OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getUniqueId()).setExternalId(student.getExternalUniqueId()).setName(helper.getStudentNameFormat().format(student)));
                        if (status != null) {
                            action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(status.getUniqueId()).setName(status.getLabel()).setExternalId(status.getReference()).setType(OnlineSectioningLog.Entity.EntityType.OTHER));
                        }
                        Iterator<Serializable> i = student.getClassEnrollments().iterator();
                        while (i.hasNext()) {
                            StudentClassEnrollment enrl = i.next();
                            enrl.getClazz().getStudentEnrollments().remove(enrl);
                            helper.getHibSession().delete((Object)enrl);
                            i.remove();
                        }
                        i = student.getCourseDemands().iterator();
                        while (i.hasNext()) {
                            CourseDemand cd = (CourseDemand)i.next();
                            if (cd.getFreeTime() != null) {
                                helper.getHibSession().delete((Object)cd.getFreeTime());
                            }
                            Iterator<CourseRequest> j = cd.getCourseRequests().iterator();
                            while (j.hasNext()) {
                                CourseRequest cr = j.next();
                                Iterator<ClassWaitList> k = cr.getClassWaitLists().iterator();
                                while (k.hasNext()) {
                                    helper.getHibSession().delete((Object)k.next());
                                    k.remove();
                                }
                                helper.getHibSession().delete((Object)cr);
                                j.remove();
                            }
                            helper.getHibSession().delete((Object)cd);
                            i.remove();
                        }
                        if (this.changeStatus()) {
                            student.setSectioningStatus(status);
                        }
                        helper.getHibSession().saveOrUpdate((Object)student);
                        helper.getHibSession().flush();
                        XStudent oldStudent = server.getStudent(studentId);
                        XStudent newStudent = null;
                        try {
                            newStudent = ReloadAllData.loadStudent(student, null, server, helper);
                            server.update(newStudent, true);
                        }
                        catch (Exception e) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                        }
                        if (oldStudent != null) {
                            for (XRequest oldRequest : oldStudent.getRequests()) {
                                XEnrollment oldEnrollment;
                                XEnrollment xEnrollment = oldEnrollment = oldRequest instanceof XCourseRequest ? ((XCourseRequest)oldRequest).getEnrollment() : null;
                                if (oldEnrollment == null) continue;
                                offeringsToCheck.add(oldEnrollment.getOfferingId());
                                XOffering offering = server.getOffering(oldEnrollment.getOfferingId());
                                EnrollStudent.updateSpace(server, null, oldEnrollment == null ? null : SectioningRequest.convert(oldStudent, (XCourseRequest)oldRequest, server, offering, oldEnrollment), offering);
                            }
                            OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                            enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                            for (XRequest oldRequest : oldStudent.getRequests()) {
                                XEnrollment oldEnrollment = oldRequest instanceof XCourseRequest ? ((XCourseRequest)oldRequest).getEnrollment() : null;
                                if (oldEnrollment == null) continue;
                                for (XSection section : server.getOffering(oldEnrollment.getOfferingId()).getSections(oldEnrollment)) {
                                    enrollment.addSection(OnlineSectioningHelper.toProto(section, oldEnrollment));
                                }
                            }
                            action.addEnrollment(enrollment);
                        }
                        if (this.iEmail && ApplicationProperty.OnlineSchedulingEmailConfirmation.isTrue()) {
                            StudentEmail email = server.createAction(StudentEmail.class).forStudent(studentId).oldStudent(oldStudent);
                            email.setCC(this.getCC());
                            email.setEmailSubject(this.getSubject() == null || this.getSubject().isEmpty() ? MSG.defaulSubjectMassCancel() : this.getSubject());
                            email.setMessage(this.getMessage());
                            server.execute(email, helper.getUser(), emailSent);
                        }
                    }
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    caughtException = e;
                }
            }
            finally {
                lock.release();
            }
        }
        OnlineSectioningServer.ServerCallback<Boolean> offeringChecked = new OnlineSectioningServer.ServerCallback<Boolean>(){

            @Override
            public void onFailure(Throwable exception) {
                helper.error("Offering check failed: " + exception.getMessage(), exception);
            }

            @Override
            public void onSuccess(Boolean result) {
            }
        };
        for (Long offeringId : offeringsToCheck) {
            server.persistExpectedSpaces(offeringId);
            server.execute(server.createAction(CheckOfferingAction.class).forOfferings(offeringId), helper.getUser(), offeringChecked);
        }
        if (caughtException != null) {
            if (caughtException instanceof SectioningException) {
                throw (SectioningException)caughtException;
            }
            throw new SectioningException(MSG.exceptionUnknown(caughtException.getMessage()), caughtException);
        }
        return true;
    }

    @Override
    public String name() {
        return "mass-cancel";
    }
}

