/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

public class CheckAssignmentAction
implements OnlineSectioningAction<List<StudentEnrollmentProvider.EnrollmentRequest>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iStudentId;
    private Collection<ClassAssignmentInterface.ClassAssignment> iAssignment;

    public CheckAssignmentAction forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public CheckAssignmentAction withAssignment(Collection<ClassAssignmentInterface.ClassAssignment> assignment) {
        this.iAssignment = assignment;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public Collection<ClassAssignmentInterface.ClassAssignment> getAssignment() {
        return this.iAssignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StudentEnrollmentProvider.EnrollmentRequest> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock readLock = server.readLock();
        try {
            HashSet<Long> offeringIds = new HashSet<Long>();
            for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                XCourse course;
                if (ca == null || ca.isFreeTime() || (course = server.getCourse(ca.getCourseId())) == null) continue;
                offeringIds.add(course.getOfferingId());
            }
            OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), offeringIds, this.name());
            try {
                List<StudentEnrollmentProvider.EnrollmentRequest> list = this.check(server, helper, null);
                lock.release();
                return list;
            }
            catch (Throwable throwable) {
                lock.release();
                throw throwable;
            }
        }
        finally {
            readLock.release();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<StudentEnrollmentProvider.EnrollmentRequest> check(OnlineSectioningServer server, OnlineSectioningHelper helper, Set<ClassAssignmentInterface.ErrorMessage> errors) {
        XOffering offering;
        XCourse course;
        XOffering offering2;
        XCourse course2;
        XStudent student = server.getStudent(this.getStudentId());
        if (student == null) {
            throw new SectioningException(MSG.exceptionBadStudentId());
        }
        ArrayList<StudentEnrollmentProvider.EnrollmentRequest> requests = new ArrayList<StudentEnrollmentProvider.EnrollmentRequest>();
        Hashtable<Long, StudentEnrollmentProvider.EnrollmentRequest> courseId2request = new Hashtable<Long, StudentEnrollmentProvider.EnrollmentRequest>();
        Hashtable<Long, XOffering> courseId2offering = new Hashtable<Long, XOffering>();
        for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
            StudentEnrollmentProvider.EnrollmentRequest request;
            if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy() || ca.isTeachingAssignment()) continue;
            course2 = server.getCourse(ca.getCourseId());
            if (course2 == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(MSG.courseName(ca.getSubject(), ca.getClassNumber())));
            }
            offering2 = server.getOffering(course2.getOfferingId());
            if (offering2 == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(MSG.courseName(ca.getSubject(), ca.getClassNumber())));
            }
            XSection section = offering2.getSection(ca.getClassId());
            if (section == null) {
                throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection())));
            }
            if (section.isCancelled()) {
                if (server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
                    boolean contains = false;
                    for (XRequest xRequest : student.getRequests()) {
                        XCourseRequest cr;
                        if (!(xRequest instanceof XCourseRequest) || (cr = (XCourseRequest)xRequest).getEnrollment() == null || !cr.getEnrollment().getSectionIds().contains(section.getSectionId())) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) {
                        if (errors == null) throw new SectioningException(MSG.exceptionEnrollCancelled(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection())));
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course2.getCourseName(), section.getExternalId(ca.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_CANCEL, MSG.exceptionEnrollCancelled(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection()))));
                    }
                } else {
                    if (errors == null) throw new SectioningException(MSG.exceptionEnrollCancelled(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection())));
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course2.getCourseName(), section.getExternalId(ca.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_CANCEL, MSG.exceptionEnrollCancelled(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection()))));
                }
            }
            if ((request = (StudentEnrollmentProvider.EnrollmentRequest)courseId2request.get(ca.getCourseId())) == null) {
                request = new StudentEnrollmentProvider.EnrollmentRequest(course2, new ArrayList<XSection>());
                courseId2request.put(ca.getCourseId(), request);
                requests.add(request);
            }
            request.getSections().add(section);
            courseId2offering.put(course2.getCourseId(), offering2);
        }
        block2: for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            course2 = request.getCourse();
            List<XSection> sections = request.getSections();
            for (XRequest r : student.getRequests()) {
                XEnrollment enrollment;
                if (!(r instanceof XCourseRequest) || (enrollment = ((XCourseRequest)r).getEnrollment()) == null || !enrollment.getCourseId().equals(course2.getCourseId())) continue;
                for (XSection s : sections) {
                    if (enrollment.getSectionIds().contains(s.getSectionId()) || server.checkDeadline(course2.getCourseId(), s.getTime(), OnlineSectioningServer.Deadline.CHANGE)) continue;
                    if (errors == null) throw new SectioningException(MSG.exceptionEnrollDeadlineChange(MSG.clazz(course2.getSubjectArea(), course2.getCourseNumber(), s.getSubpartName(), s.getName(course2.getCourseId()))));
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course2.getCourseName(), s.getExternalId(course2.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineChange(MSG.clazz(course2.getSubjectArea(), course2.getCourseNumber(), s.getSubpartName(), s.getName(course2.getCourseId())))));
                }
                continue block2;
            }
            for (XSection section : sections) {
                if (server.checkDeadline(course2.getOfferingId(), section.getTime(), OnlineSectioningServer.Deadline.NEW)) continue;
                if (errors == null) throw new SectioningException(MSG.exceptionEnrollDeadlineNew(MSG.clazz(course2.getSubjectArea(), course2.getCourseNumber(), section.getSubpartName(), section.getName(course2.getCourseId()))));
                errors.add(new ClassAssignmentInterface.ErrorMessage(course2.getCourseName(), section.getExternalId(course2.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineNew(MSG.clazz(course2.getSubjectArea(), course2.getCourseNumber(), section.getSubpartName(), section.getName(course2.getCourseId())))));
            }
        }
        for (XRequest r : student.getRequests()) {
            XEnrollment enrollment;
            if (!(r instanceof XCourseRequest) || (enrollment = ((XCourseRequest)r).getEnrollment()) == null || courseId2offering.containsKey(enrollment.getCourseId()) || (offering2 = server.getOffering(enrollment.getOfferingId())) == null) continue;
            for (XSection section : offering2.getSections(enrollment)) {
                if (server.checkDeadline(offering2.getOfferingId(), section.getTime(), OnlineSectioningServer.Deadline.DROP)) continue;
                if (errors == null) throw new SectioningException(MSG.exceptionEnrollDeadlineDrop(enrollment.getCourseName()));
                errors.add(new ClassAssignmentInterface.ErrorMessage(enrollment.getCourseName(), section.getExternalId(enrollment.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineDrop(enrollment.getCourseName())));
            }
        }
        Hashtable<Long, XConfig> courseId2config = new Hashtable<Long, XConfig>();
        for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            course = request.getCourse();
            offering = (XOffering)courseId2offering.get(course.getCourseId());
            XEnrollments enrollments = server.getEnrollments(course.getOfferingId());
            List<XSection> sections = request.getSections();
            XSubpart xSubpart = offering.getSubpart(sections.get(0).getSubpartId());
            XConfig config = offering.getConfig(xSubpart.getConfigId());
            courseId2config.put(course.getCourseId(), config);
            XReservation reservation = null;
            block9: for (XReservation xReservation : offering.getReservations()) {
                if (!xReservation.isApplicable(student, course)) continue;
                if (xReservation.getLimit() >= 0 && xReservation.getLimit() <= enrollments.countEnrollmentsForReservation(xReservation.getReservationId())) {
                    boolean contain = false;
                    for (XEnrollment e : enrollments.getEnrollmentsForReservation(xReservation.getReservationId())) {
                        if (!e.getStudentId().equals(student.getStudentId())) continue;
                        contain = true;
                        break;
                    }
                    if (!contain) continue;
                }
                if (!xReservation.getConfigsIds().isEmpty() && !xReservation.getConfigsIds().contains(config.getConfigId())) continue;
                for (XSection section : sections) {
                    if (xReservation.getSectionIds(section.getSubpartId()) == null || xReservation.getSectionIds(section.getSubpartId()).contains(section.getSectionId())) continue;
                    continue block9;
                }
                if (reservation != null && xReservation.compareTo(reservation) >= 0) continue;
                reservation = xReservation;
            }
            if (reservation != null && reservation.canAssignOverLimit()) continue;
            for (XSection xSection : sections) {
                boolean contain;
                if (xSection.getLimit() >= 0 && xSection.getLimit() <= enrollments.countEnrollmentsForSection(xSection.getSectionId())) {
                    contain = false;
                    for (XEnrollment e : enrollments.getEnrollmentsForSection(xSection.getSectionId())) {
                        if (!e.getStudentId().equals(student.getStudentId())) continue;
                        contain = true;
                        break;
                    }
                    if (!contain) {
                        if (errors == null) throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), xSection.getSubpartName(), xSection.getName())));
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), xSection.getSubpartName(), xSection.getName()))));
                    }
                }
                if (reservation != null && offering.getSectionReservations(xSection.getSectionId()).contains(reservation) || offering.getUnreservedSectionSpace(xSection.getSectionId(), enrollments) > 0) continue;
                contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForSection(xSection.getSectionId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                if (errors == null) throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), xSection.getSubpartName(), xSection.getName())));
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), xSection.getSubpartName(), xSection.getName()))));
            }
            if (config.getLimit() >= 0 && config.getLimit() <= enrollments.countEnrollmentsForConfig(config.getConfigId())) {
                boolean contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForConfig(config.getConfigId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (!contain) {
                    if (errors == null) throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
                    for (XSection section : sections) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section.getSubpartName(), section.getName()))));
                    }
                }
            }
            if (!(reservation != null && offering.getConfigReservations(config.getConfigId()).contains(reservation) || offering.getUnreservedConfigSpace(config.getConfigId(), enrollments) > 0)) {
                boolean contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForConfig(config.getConfigId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (!contain) {
                    if (errors == null) throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
                    for (XSection section : sections) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section.getSubpartName(), section.getName()))));
                    }
                }
            }
            if (course.getLimit() < 0 || course.getLimit() > enrollments.countEnrollmentsForCourse(course.getCourseId())) continue;
            boolean contain = false;
            for (XEnrollment e : enrollments.getEnrollmentsForCourse(course.getCourseId())) {
                if (!e.getStudentId().equals(student.getStudentId())) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            if (errors == null) throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
            for (XSection section : sections) {
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section.getSubpartName(), section.getName()))));
            }
        }
        for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            course = request.getCourse();
            offering = (XOffering)courseId2offering.get(course.getCourseId());
            List<XSection> sections = request.getSections();
            XSubpart subpart = offering.getSubpart(sections.get(0).getSubpartId());
            XConfig xConfig = offering.getConfig(subpart.getConfigId());
            if (sections.size() < xConfig.getSubparts().size()) {
                if (errors == null) throw new SectioningException(MSG.exceptionEnrollmentIncomplete(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
                for (XSection section : sections) {
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentIncomplete(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            } else if (sections.size() > xConfig.getSubparts().size()) {
                if (errors == null) throw new SectioningException(MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
                for (XSection section : sections) {
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            }
            for (XSection s1 : sections) {
                for (XSection xSection : sections) {
                    if (s1.getSectionId() < xSection.getSectionId() && s1.isOverlapping(offering.getDistributions(), xSection)) {
                        if (errors == null) throw new SectioningException(MSG.exceptionEnrollmentOverlapping(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentOverlapping(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentOverlapping(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                    }
                    if (s1.getSectionId().equals(xSection.getSectionId()) || !s1.getSubpartId().equals(xSection.getSubpartId())) continue;
                    if (errors == null) throw new SectioningException(MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
                if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(xConfig.getConfigId())) continue;
                if (errors == null) throw new SectioningException(MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
            }
            if (offering.isAllowOverlap(student, xConfig.getConfigId(), course, sections)) continue;
            for (StudentEnrollmentProvider.EnrollmentRequest otherRequest : requests) {
                XOffering other = (XOffering)courseId2offering.get(otherRequest.getCourse().getCourseId());
                XConfig xConfig2 = (XConfig)courseId2config.get(otherRequest.getCourse().getCourseId());
                if (other.equals(offering) || other.isAllowOverlap(student, xConfig2.getConfigId(), otherRequest.getCourse(), otherRequest.getSections())) continue;
                List<XSection> assignment = otherRequest.getSections();
                for (XSection section : sections) {
                    if (!section.isOverlapping(offering.getDistributions(), assignment)) continue;
                    if (errors == null) throw new SectioningException(MSG.exceptionEnrollmentConflicting(MSG.courseName(course.getSubjectArea(), course.getCourseNumber())));
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentConflicting(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            }
        }
        return requests;
    }

    @Override
    public String name() {
        return "check-assignment";
    }
}

