/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.StudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.AbstractLockingServer;
import org.unitime.timetable.onlinesectioning.server.CourseComparator;
import org.unitime.timetable.onlinesectioning.server.SubSet;

public class InMemoryServer
extends AbstractLockingServer {
    private Hashtable<Long, XCourseId> iCourseForId = new Hashtable();
    private Hashtable<String, TreeSet<XCourseId>> iCourseForName = new Hashtable();
    private Hashtable<Long, XStudent> iStudentTable = new Hashtable();
    private Hashtable<Long, XOffering> iOfferingTable = new Hashtable();
    private Hashtable<Long, List<XCourseRequest>> iOfferingRequests = new Hashtable();
    private Hashtable<Long, XExpectations> iExpectations = new Hashtable();
    private Hashtable<String, Set<Long>> iInstructedOfferings = new Hashtable();

    public InMemoryServer(OnlineSectioningServerContext context) throws SectioningException {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            SubSet<XCourseId> ret = new SubSet<XCourseId>(limit, new CourseComparator(query));
            String queryInLowerCase = query.toLowerCase();
            for (XCourseId c : this.iCourseForId.values()) {
                if (!c.matchCourseName(queryInLowerCase) || matcher != null && !matcher.match(c)) continue;
                ret.add(c);
            }
            if (!ret.isLimitReached() && queryInLowerCase.length() > 2) {
                for (XCourseId c : this.iCourseForId.values()) {
                    if (!c.matchTitle(queryInLowerCase) || matcher != null && !matcher.match(c)) continue;
                    ret.add(c);
                }
            }
            Iterator<XCourseId> iterator = ret;
            return iterator;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XCourseId> findCourses(CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            TreeSet<XCourseId> ret = new TreeSet<XCourseId>();
            for (XCourseId c : this.iCourseForId.values()) {
                if (!matcher.match(c)) continue;
                ret.add(c);
            }
            TreeSet<XCourseId> treeSet = ret;
            return treeSet;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XStudent> findStudents(StudentMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            ArrayList<XStudent> ret = new ArrayList<XStudent>();
            for (XStudent s : this.iStudentTable.values()) {
                if (!matcher.match(s)) continue;
                ret.add(s);
            }
            ArrayList<XStudent> arrayList = ret;
            return arrayList;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourseId getCourse(String course) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XCourseId xCourseId;
            int idx = course.indexOf(45);
            while (idx >= 0) {
                String courseName = course.substring(0, idx).trim();
                String title = course.substring(idx + 1).trim();
                TreeSet<XCourseId> infos = this.iCourseForName.get(courseName.toLowerCase());
                if (infos != null && !infos.isEmpty()) {
                    for (XCourseId info : infos) {
                        if (!title.equalsIgnoreCase(info.getTitle())) continue;
                        XCourseId xCourseId2 = info;
                        return xCourseId2;
                    }
                }
                idx = course.indexOf(45, idx + 1);
            }
            TreeSet<XCourseId> infos = this.iCourseForName.get(course.toLowerCase());
            if (infos != null && !infos.isEmpty()) {
                xCourseId = infos.first();
                return xCourseId;
            }
            xCourseId = null;
            return xCourseId;
        }
        finally {
            lock.release();
        }
    }

    private XCourse toCourse(XCourseId course) {
        if (course == null) {
            return null;
        }
        if (course instanceof XCourse) {
            return (XCourse)course;
        }
        XOffering offering = this.getOffering(course.getOfferingId());
        return offering == null ? null : offering.getCourse(course);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourse getCourse(Long courseId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XCourse xCourse = this.toCourse(this.iCourseForId.get(courseId));
            return xCourse;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XStudent getStudent(Long studentId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XStudent xStudent = this.iStudentTable.get(studentId);
            return xStudent;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XOffering getOffering(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XOffering xOffering = this.iOfferingTable.get(offeringId);
            return xOffering;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<XCourseRequest> getRequests(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            Collection requests = this.iOfferingRequests.get(offeringId);
            ArrayList<XCourseRequest> arrayList = requests == null ? null : new ArrayList<XCourseRequest>(requests);
            return arrayList;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XExpectations getExpectations(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XExpectations expectations = this.iExpectations.get(offeringId);
            XExpectations xExpectations = expectations == null ? new XExpectations(offeringId) : expectations;
            return xExpectations;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void update(XExpectations expectations) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iExpectations.put(expectations.getOfferingId(), expectations);
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(XStudent student) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent oldStudent = this.iStudentTable.remove(student.getStudentId());
            if (oldStudent != null) {
                for (XRequest request : oldStudent.getRequests()) {
                    if (!(request instanceof XCourseRequest)) continue;
                    for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                        List<XCourseRequest> requests = this.iOfferingRequests.get(course.getOfferingId());
                        if (requests == null) continue;
                        requests.remove(request);
                    }
                }
            }
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(XStudent student, boolean updateRequests) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent oldStudent = this.iStudentTable.put(student.getStudentId(), student);
            if (updateRequests) {
                if (oldStudent != null) {
                    for (XRequest request : oldStudent.getRequests()) {
                        if (!(request instanceof XCourseRequest)) continue;
                        for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                            List<XCourseRequest> requests = this.iOfferingRequests.get(course.getOfferingId());
                            if (requests == null) continue;
                            requests.remove(request);
                        }
                    }
                }
                for (XRequest request : student.getRequests()) {
                    if (!(request instanceof XCourseRequest)) continue;
                    XCourseRequest cr = (XCourseRequest)request;
                    for (XCourseId course : cr.getCourseIds()) {
                        if (cr.isDuplicateOffering(course)) continue;
                        List<XCourseRequest> requests = this.iOfferingRequests.get(course.getOfferingId());
                        if (requests == null) {
                            requests = new ArrayList<XCourseRequest>();
                            this.iOfferingRequests.put(course.getOfferingId(), requests);
                        }
                        requests.add((XCourseRequest)request);
                    }
                }
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void remove(XOffering offering) {
        this.remove(offering, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(XOffering offering, boolean removeExpectations) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            for (XCourse course : offering.getCourses()) {
                this.iCourseForId.remove(course.getCourseId());
                TreeSet<XCourseId> courses = this.iCourseForName.get(course.getCourseNameInLowerCase());
                if (courses == null) continue;
                courses.remove(course);
                if (courses.size() == 1) {
                    for (XCourseId x : courses) {
                        x.setHasUniqueName(true);
                    }
                }
                if (!courses.isEmpty()) continue;
                this.iCourseForName.remove(course.getCourseNameInLowerCase());
            }
            this.iOfferingTable.remove(offering.getOfferingId());
            if (removeExpectations) {
                this.iExpectations.remove(offering.getOfferingId());
            }
            for (String externalId : offering.getInstructorExternalIds()) {
                Set<Long> offeringIds = this.iInstructedOfferings.get(externalId);
                if (offeringIds == null) continue;
                offeringIds.remove(offering.getOfferingId());
            }
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(XOffering offering) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XOffering oldOffering = this.iOfferingTable.get(offering.getOfferingId());
            if (oldOffering != null) {
                this.remove(oldOffering, false);
            }
            this.iOfferingTable.put(offering.getOfferingId(), offering);
            for (XCourse course : offering.getCourses()) {
                this.iCourseForId.put(course.getCourseId(), course);
                TreeSet<XCourseId> courses = this.iCourseForName.get(course.getCourseNameInLowerCase());
                if (courses == null) {
                    courses = new TreeSet();
                    this.iCourseForName.put(course.getCourseNameInLowerCase(), courses);
                }
                courses.add(course);
                if (courses.size() == 1) {
                    for (XCourseId x : courses) {
                        x.setHasUniqueName(true);
                    }
                    continue;
                }
                if (courses.size() <= 1) continue;
                for (XCourseId x : courses) {
                    x.setHasUniqueName(false);
                }
            }
            for (String externalId : offering.getInstructorExternalIds()) {
                Set<Long> offeringIds = this.iInstructedOfferings.get(externalId);
                if (offeringIds == null) {
                    offeringIds = new HashSet<Long>();
                    this.iInstructedOfferings.put(externalId, offeringIds);
                }
                offeringIds.add(offering.getOfferingId());
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void clearAll() {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            if (this.iStudentTable == null) {
                this.iStudentTable = new Hashtable();
            } else {
                this.iStudentTable.clear();
            }
            if (this.iOfferingTable == null) {
                this.iOfferingTable = new Hashtable();
            } else {
                this.iOfferingTable.clear();
            }
            if (this.iOfferingRequests == null) {
                this.iOfferingRequests = new Hashtable();
            } else {
                this.iOfferingRequests.clear();
            }
            if (this.iExpectations == null) {
                this.iExpectations = new Hashtable();
            } else {
                this.iExpectations.clear();
            }
            if (this.iCourseForId == null) {
                this.iCourseForId = new Hashtable();
            } else {
                this.iCourseForId.clear();
            }
            if (this.iCourseForName == null) {
                this.iCourseForName = new Hashtable();
            } else {
                this.iCourseForName.clear();
            }
            if (this.iInstructedOfferings == null) {
                this.iInstructedOfferings = new Hashtable();
            } else {
                this.iInstructedOfferings.clear();
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void clearAllStudents() {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iStudentTable.clear();
            this.iOfferingRequests.clear();
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourseRequest assign(XCourseRequest request, XEnrollment enrollment) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent student = this.iStudentTable.get(request.getStudentId());
            for (XRequest r : student.getRequests()) {
                List<XCourseRequest> requests;
                if (!r.equals(request)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                for (XCourseId course : cr.getCourseIds()) {
                    requests = this.iOfferingRequests.get(course.getOfferingId());
                    if (requests == null) continue;
                    requests.remove(cr);
                }
                cr.setEnrollment(enrollment);
                for (XCourseId course : cr.getCourseIds()) {
                    if (cr.isDuplicateOffering(course)) continue;
                    requests = this.iOfferingRequests.get(course.getOfferingId());
                    if (requests == null) {
                        requests = new ArrayList<XCourseRequest>();
                        this.iOfferingRequests.put(course.getOfferingId(), requests);
                    }
                    requests.add(cr);
                }
                XCourseRequest xCourseRequest = cr;
                return xCourseRequest;
            }
            Iterator<XRequest> iterator = null;
            return iterator;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourseRequest waitlist(XCourseRequest request, boolean waitlist) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent student = this.iStudentTable.get(request.getStudentId());
            for (XRequest r : student.getRequests()) {
                List<XCourseRequest> requests;
                if (!r.equals(request)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                for (XCourseId course : cr.getCourseIds()) {
                    requests = this.iOfferingRequests.get(course.getOfferingId());
                    if (requests == null) continue;
                    requests.remove(cr);
                }
                cr.setWaitlist(waitlist);
                for (XCourseId course : cr.getCourseIds()) {
                    if (cr.isDuplicateOffering(course)) continue;
                    requests = this.iOfferingRequests.get(course.getOfferingId());
                    if (requests == null) {
                        requests = new ArrayList<XCourseRequest>();
                        this.iOfferingRequests.put(course.getOfferingId(), requests);
                    }
                    requests.add(cr);
                }
                XCourseRequest xCourseRequest = cr;
                return xCourseRequest;
            }
            Iterator<XRequest> iterator = null;
            return iterator;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getInstructedOfferings(String instructorExternalId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            Collection collection = this.iInstructedOfferings.get(instructorExternalId);
            return collection;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getRequestedCourseIds(Long studentId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XStudent student = this.iStudentTable.get(studentId);
            Set<Long> set = student == null ? null : student.getRequestedCourseIds();
            return set;
        }
        finally {
            lock.release();
        }
    }
}

