/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.studentsct.reservation.CurriculumRestriction;
import org.cpsolver.studentsct.reservation.Restriction;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XRestriction;
import org.unitime.timetable.onlinesectioning.model.XRestrictionType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

@SerializeWith(value=XCurriculumRestrictionSerializer.class)
public class XCurriculumRestriction
extends XRestriction {
    private static final long serialVersionUID = 1L;
    private Set<String> iAcadAreas = new HashSet<String>();
    private Set<String> iClassifications = new HashSet<String>();
    private Set<String> iMajors = new HashSet<String>();
    private Set<String> iMinors = new HashSet<String>();
    private Map<String, Set<String>> iConcentrations = new HashMap<String, Set<String>>();

    public XCurriculumRestriction() {
    }

    public XCurriculumRestriction(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCurriculumRestriction(CurriculumRestriction reservation) {
        super(XRestrictionType.Curriculum, (Restriction)reservation);
        if (reservation.getAcademicAreas() != null) {
            this.iAcadAreas.addAll(reservation.getAcademicAreas());
        }
        if (reservation.getClassifications() != null) {
            this.iClassifications.addAll(reservation.getClassifications());
        }
        if (reservation.getMajors() != null) {
            this.iMajors.addAll(reservation.getMajors());
        }
        if (reservation.getMinors() != null) {
            this.iMinors.addAll(reservation.getMinors());
        }
        for (String major : reservation.getMajors()) {
            Set concentrations = reservation.getConcentrations(major);
            if (concentrations == null) continue;
            this.iConcentrations.put(major, new HashSet(concentrations));
        }
    }

    public Set<String> getAcademicAreas() {
        return this.iAcadAreas;
    }

    public Set<String> getMajors() {
        return this.iMajors;
    }

    public Set<String> getMinors() {
        return this.iMinors;
    }

    public Set<String> getClassifications() {
        return this.iClassifications;
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        if (!this.getMajors().isEmpty() || this.getMinors().isEmpty()) {
            for (XAreaClassificationMajor acm : student.getMajors()) {
                if (!this.getAcademicAreas().contains(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMajors().isEmpty() && !this.getMajors().contains(acm.getMajor())) continue;
                Set<String> conc = this.iConcentrations.get(acm.getMajor());
                if (conc != null && !conc.isEmpty()) {
                    return acm.getConcentration() != null && conc.contains(acm.getConcentration());
                }
                return true;
            }
        }
        if (!this.getMinors().isEmpty()) {
            for (XAreaClassificationMajor acm : student.getMinors()) {
                if (!this.getAcademicAreas().contains(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMinors().contains(acm.getMajor())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrAcadAreas = in.readInt();
        this.iAcadAreas.clear();
        for (int i = 0; i < nrAcadAreas; ++i) {
            this.iAcadAreas.add((String)in.readObject());
        }
        int nrClassifications = in.readInt();
        this.iClassifications.clear();
        for (int i = 0; i < nrClassifications; ++i) {
            this.iClassifications.add((String)in.readObject());
        }
        int nrMajors = in.readInt();
        this.iMajors.clear();
        for (int i = 0; i < nrMajors; ++i) {
            this.iMajors.add((String)in.readObject());
        }
        int nrMinors = in.readInt();
        this.iMinors.clear();
        for (int i = 0; i < nrMinors; ++i) {
            this.iMinors.add((String)in.readObject());
        }
        this.iConcentrations = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iAcadAreas.size());
        for (String area : this.iAcadAreas) {
            out.writeObject(area);
        }
        out.writeInt(this.iClassifications.size());
        for (String clasf : this.iClassifications) {
            out.writeObject(clasf);
        }
        out.writeInt(this.iMajors.size());
        for (String major : this.iMajors) {
            out.writeObject(major);
        }
        out.writeInt(this.iMinors.size());
        for (String minor : this.iMinors) {
            out.writeObject(minor);
        }
        out.writeObject(this.iConcentrations);
    }

    public static class XCurriculumRestrictionSerializer
    implements Externalizer<XCurriculumRestriction> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XCurriculumRestriction object) throws IOException {
            object.writeExternal(output);
        }

        public XCurriculumRestriction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XCurriculumRestriction(input);
        }
    }
}

