/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.interfaces.ExternalClassLookupInterface;
import org.unitime.timetable.interfaces.ExternalClassNameHelperInterface;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseClassInstructor;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.base.BaseStudentEnrollmentMessage;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.CourseDemandDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationDashboardUrlProvider;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationHelper;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.util.DefaultExternalClassLookup;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;

public class PurdueSpecialRegistrationProvider
implements SpecialRegistrationProvider,
SpecialRegistrationDashboardUrlProvider {
    private static Logger sLog = Logger.getLogger(PurdueSpecialRegistrationProvider.class);
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;
    private ExternalClassLookupInterface iExternalClassLookup;

    public PurdueSpecialRegistrationProvider() {
        String clazz;
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getSpecialRegistrationApiReadTimeout());
        this.iClient.setContext(cx);
        try {
            clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
        try {
            clazz = ApplicationProperty.CustomizationExternalClassLookup.value();
            this.iExternalClassLookup = clazz == null || clazz.isEmpty() ? new DefaultExternalClassLookup() : (ExternalClassLookupInterface)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external class lookup, using the default one instead.", (Throwable)e);
            this.iExternalClassLookup = new DefaultExternalClassLookup();
        }
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiReadTimeout() {
        return ApplicationProperties.getProperty("purdue.specreg.readTimeout", "60000");
    }

    protected String getSpecialRegistrationApiSiteSubmitRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.submitRegistration", this.getSpecialRegistrationApiSite() + "/submitRegistration");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationApiCheckRestrictions() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkRestrictions", this.getSpecialRegistrationApiSite() + "/checkRestrictions");
    }

    protected String getSpecialRegistrationApiSiteCancelSpecialRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.cancelSpecialRegistration", this.getSpecialRegistrationApiSite() + "/cancelRegistrationRequestFromUniTime");
    }

    protected String getSpecialRegistrationApiSiteCheckStudentGradeModes() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkStudentGradeModes", this.getSpecialRegistrationApiSite() + "/checkStudentModifyScheduleAttrs");
    }

    protected String getSpecialRegistrationApiSiteUpdateRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.updateRegistration", this.getSpecialRegistrationApiSite() + "/updateRequestorNotes");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected SpecialRegistrationInterface.ApiMode getSpecialRegistrationMode() {
        return SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode", "REG"));
    }

    protected boolean isUpdateUniTimeStatuses() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.updateUniTimeStatuses", "true"));
    }

    protected boolean isAllowClosedErrorForAvailableSections() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.allowClosedWhenAvailable", "false"));
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected String getSpecialRegistrationDashboardUrl() {
        return ApplicationProperties.getProperty("purdue.specreg.dashBoard");
    }

    protected String getResetGradeModesRegExp() {
        return ApplicationProperties.getProperty("banner.xe.resetGradeModes", "H|Q|R");
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerId(Student student) {
        String id = student.getExternalUniqueId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getRequestorId(OnlineSectioningLog.Entity user) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        String id = user.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected SpecialRegistrationInterface.RequestorRole getRequestorType(OnlineSectioningLog.Entity user, XStudent student) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        if (user.hasType()) {
            switch (user.getType()) {
                case MANAGER: {
                    return SpecialRegistrationInterface.RequestorRole.MANAGER;
                }
                case STUDENT: {
                    return SpecialRegistrationInterface.RequestorRole.STUDENT;
                }
            }
            return SpecialRegistrationInterface.RequestorRole.MANAGER;
        }
        return user.getExternalId().equals(student.getExternalId()) ? SpecialRegistrationInterface.RequestorRole.STUDENT : SpecialRegistrationInterface.RequestorRole.MANAGER;
    }

    protected SpecialRegistrationInterface.SpecialRegistrationStatus getStatus(SpecialRegistrationInterface.ChangeStatus status) {
        if (status == null) {
            return SpecialRegistrationInterface.SpecialRegistrationStatus.Pending;
        }
        switch (status) {
            case approved: {
                return SpecialRegistrationInterface.SpecialRegistrationStatus.Approved;
            }
            case cancelled: {
                return SpecialRegistrationInterface.SpecialRegistrationStatus.Cancelled;
            }
            case denied: {
                return SpecialRegistrationInterface.SpecialRegistrationStatus.Rejected;
            }
        }
        return SpecialRegistrationInterface.SpecialRegistrationStatus.Pending;
    }

    protected SpecialRegistrationInterface.SpecialRegistrationStatus getStatus(SpecialRegistrationInterface.CompletionStatus status) {
        if (status == null) {
            return SpecialRegistrationInterface.SpecialRegistrationStatus.Pending;
        }
        switch (status) {
            case cancelled: {
                return SpecialRegistrationInterface.SpecialRegistrationStatus.Cancelled;
            }
            case completed: {
                return SpecialRegistrationInterface.SpecialRegistrationStatus.Approved;
            }
        }
        return SpecialRegistrationInterface.SpecialRegistrationStatus.Pending;
    }

    protected SpecialRegistrationInterface.SpecialRegistrationStatus getStatus(SpecialRegistrationInterface.SpecialRegistration request) {
        SpecialRegistrationInterface.SpecialRegistrationStatus ret = null;
        if (request.changes != null) {
            for (SpecialRegistrationInterface.Change ch : request.changes) {
                if (ch.status == null) continue;
                ret = this.combine(ret, this.getStatus(ch.status));
            }
        }
        if (ret == SpecialRegistrationInterface.SpecialRegistrationStatus.Approved && request.completionStatus == SpecialRegistrationInterface.CompletionStatus.inProgress) {
            return SpecialRegistrationInterface.SpecialRegistrationStatus.Pending;
        }
        if (ret != null) {
            return ret;
        }
        return this.getStatus(request.completionStatus);
    }

    protected SpecialRegistrationInterface.SpecialRegistrationStatus getCreditStatus(SpecialRegistrationInterface.SpecialRegistration request) {
        SpecialRegistrationInterface.SpecialRegistrationStatus ret = null;
        if (request.changes != null) {
            for (SpecialRegistrationInterface.Change ch : request.changes) {
                if (ch.status == null || ch.subject != null || ch.courseNbr != null) continue;
                ret = this.combine(ret, this.getStatus(ch.status));
            }
        }
        if (ret != null) {
            return ret;
        }
        return this.getStatus(request.completionStatus);
    }

    protected int toStatus(SpecialRegistrationInterface.ChangeStatus status) {
        if (status == null) {
            return CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
        }
        switch (status) {
            case approved: {
                return CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal();
            }
            case cancelled: {
                return CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal();
            }
            case denied: {
                return CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal();
            }
        }
        return CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
    }

    protected int toStatus(SpecialRegistrationInterface.SpecialRegistrationStatus status) {
        if (status == null) {
            return CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
        }
        switch (status) {
            case Approved: {
                return CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal();
            }
            case Cancelled: {
                return CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal();
            }
            case Rejected: {
                return CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal();
            }
        }
        return CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
    }

    protected int toStatus(SpecialRegistrationInterface.SpecialRegistration request) {
        return this.toStatus(this.getStatus(request));
    }

    protected boolean isPending(SpecialRegistrationInterface.ChangeStatus status) {
        return status != null && status != SpecialRegistrationInterface.ChangeStatus.cancelled && status != SpecialRegistrationInterface.ChangeStatus.approved && status != SpecialRegistrationInterface.ChangeStatus.denied;
    }

    protected SpecialRegistrationInterface.SpecialRegistrationStatus combine(SpecialRegistrationInterface.SpecialRegistrationStatus s1, SpecialRegistrationInterface.SpecialRegistrationStatus s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1 == s2) {
            return s1;
        }
        if (s1 == SpecialRegistrationInterface.SpecialRegistrationStatus.Draft || s2 == SpecialRegistrationInterface.SpecialRegistrationStatus.Draft) {
            return SpecialRegistrationInterface.SpecialRegistrationStatus.Draft;
        }
        if (s1 == SpecialRegistrationInterface.SpecialRegistrationStatus.Pending || s2 == SpecialRegistrationInterface.SpecialRegistrationStatus.Pending) {
            return SpecialRegistrationInterface.SpecialRegistrationStatus.Pending;
        }
        if (s1 == SpecialRegistrationInterface.SpecialRegistrationStatus.Cancelled || s2 == SpecialRegistrationInterface.SpecialRegistrationStatus.Cancelled) {
            return SpecialRegistrationInterface.SpecialRegistrationStatus.Cancelled;
        }
        if (s1 == SpecialRegistrationInterface.SpecialRegistrationStatus.Rejected || s2 == SpecialRegistrationInterface.SpecialRegistrationStatus.Rejected) {
            return SpecialRegistrationInterface.SpecialRegistrationStatus.Rejected;
        }
        if (s1 == SpecialRegistrationInterface.SpecialRegistrationStatus.Approved || s2 == SpecialRegistrationInterface.SpecialRegistrationStatus.Approved) {
            return SpecialRegistrationInterface.SpecialRegistrationStatus.Approved;
        }
        return s1;
    }

    protected boolean canCancel(SpecialRegistrationInterface.SpecialRegistration request) {
        if (request.changes != null) {
            for (SpecialRegistrationInterface.Change ch : request.changes) {
                if (!this.isPending(ch.status)) continue;
                return true;
            }
        }
        return false;
    }

    protected void buildChangeList(SpecialRegistrationInterface.SpecialRegistration request, OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, Collection<ClassAssignmentInterface.ClassAssignment> assignment, Collection<ClassAssignmentInterface.ErrorMessage> errors, Float credit) {
        boolean bl;
        SpecialRegistrationInterface.Change ch;
        request.changes = new ArrayList<SpecialRegistrationInterface.Change>();
        float maxCredit = 0.0f;
        HashMap<XCourse, ArrayList<XSection>> enrollments = new HashMap<XCourse, ArrayList<XSection>>();
        HashMap<Long, XOffering> offerings = new HashMap<Long, XOffering>();
        for (ClassAssignmentInterface.ClassAssignment classAssignment : assignment) {
            ArrayList<XSection> sections;
            if (classAssignment == null || classAssignment.isFreeTime() || classAssignment.getClassId() == null || classAssignment.isDummy() || classAssignment.isTeachingAssignment()) continue;
            XCourse xCourse = server.getCourse(classAssignment.getCourseId());
            if (xCourse == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(MSG.courseName(classAssignment.getSubject(), classAssignment.getClassNumber())));
            }
            XOffering offering = server.getOffering(xCourse.getOfferingId());
            if (offering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(MSG.courseName(classAssignment.getSubject(), classAssignment.getClassNumber())));
            }
            XSection section = offering.getSection(classAssignment.getClassId());
            if (section == null) {
                throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(classAssignment.getSubject(), classAssignment.getCourseNbr(), classAssignment.getSubpart(), classAssignment.getSection())));
            }
            if (section.isCancelled()) {
                if (server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
                    boolean contains = false;
                    for (XRequest r : student.getRequests()) {
                        XCourseRequest cr;
                        if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getEnrollment() == null || !cr.getEnrollment().getSectionIds().contains(section.getSectionId())) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) {
                        throw new SectioningException(MSG.exceptionEnrollCancelled(MSG.clazz(classAssignment.getSubject(), classAssignment.getCourseNbr(), classAssignment.getSubpart(), classAssignment.getSection())));
                    }
                } else {
                    throw new SectioningException(MSG.exceptionEnrollCancelled(MSG.clazz(classAssignment.getSubject(), classAssignment.getCourseNbr(), classAssignment.getSubpart(), classAssignment.getSection())));
                }
            }
            if ((sections = (ArrayList<XSection>)enrollments.get(xCourse)) == null) {
                sections = new ArrayList<XSection>();
                enrollments.put(xCourse, sections);
            }
            sections.add(section);
            offerings.put(xCourse.getCourseId(), offering);
        }
        HashSet<String> crns = new HashSet<String>();
        block2: for (Map.Entry entry : enrollments.entrySet()) {
            XCourse course = (XCourse)entry.getKey();
            List sections = (List)entry.getValue();
            Object sectionCredit = null;
            for (XSection s : sections) {
                Float creditOverride = s.getCreditOverride(course.getCourseId());
                if (creditOverride == null) continue;
                sectionCredit = Float.valueOf((sectionCredit == null ? 0.0f : ((Float)sectionCredit).floatValue()) + creditOverride.floatValue());
            }
            if (sectionCredit != null) {
                maxCredit += ((Float)sectionCredit).floatValue();
            } else if (course.hasCredit()) {
                maxCredit += course.getMinCredit().floatValue();
            }
            for (XRequest r : student.getRequests()) {
                XEnrollment enrollment;
                if (!(r instanceof XCourseRequest) || (enrollment = ((XCourseRequest)r).getEnrollment()) == null || !enrollment.getCourseId().equals(course.getCourseId())) continue;
                for (XSection s : sections) {
                    if (enrollment.getSectionIds().contains(s.getSectionId())) continue;
                    SpecialRegistrationInterface.Change ch2 = new SpecialRegistrationInterface.Change();
                    ch2.subject = course.getSubjectArea();
                    ch2.courseNbr = course.getCourseNumber();
                    ch2.crn = s.getExternalId(course.getCourseId());
                    ch2.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    ch2.credit = course.getCreditAbbv();
                    if (!crns.add(ch2.crn)) continue;
                    request.changes.add(ch2);
                }
                for (Long id : enrollment.getSectionIds()) {
                    XSection s = ((XOffering)offerings.get(course.getCourseId())).getSection(id);
                    if (sections.contains(s)) continue;
                    SpecialRegistrationInterface.Change ch3 = new SpecialRegistrationInterface.Change();
                    ch3.subject = course.getSubjectArea();
                    ch3.courseNbr = course.getCourseNumber();
                    ch3.crn = s.getExternalId(course.getCourseId());
                    ch3.operation = SpecialRegistrationInterface.ChangeOperation.DROP;
                    ch3.credit = course.getCreditAbbv();
                    if (!crns.add(ch3.crn)) continue;
                    request.changes.add(ch3);
                }
                continue block2;
            }
            for (XSection section : sections) {
                ch = new SpecialRegistrationInterface.Change();
                ch.subject = course.getSubjectArea();
                ch.courseNbr = course.getCourseNumber();
                ch.crn = section.getExternalId(course.getCourseId());
                ch.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                ch.credit = course.getCreditAbbv();
                if (!crns.add(ch.crn)) continue;
                request.changes.add(ch);
            }
        }
        for (XRequest xRequest : student.getRequests()) {
            XOffering offering;
            XEnrollment enrollment;
            if (!(xRequest instanceof XCourseRequest) || (enrollment = ((XCourseRequest)xRequest).getEnrollment()) == null || offerings.containsKey(enrollment.getCourseId()) || (offering = server.getOffering(enrollment.getOfferingId())) == null) continue;
            for (XSection section : offering.getSections(enrollment)) {
                XCourse course = offering.getCourse(enrollment.getCourseId());
                ch = new SpecialRegistrationInterface.Change();
                ch.subject = course.getSubjectArea();
                ch.courseNbr = course.getCourseNumber();
                ch.crn = section.getExternalId(course.getCourseId());
                ch.operation = SpecialRegistrationInterface.ChangeOperation.DROP;
                ch.credit = course.getCreditAbbv();
                if (!crns.add(ch.crn)) continue;
                request.changes.add(ch);
            }
        }
        boolean bl2 = false;
        if (errors != null) {
            HashMap<String, SpecialRegistrationInterface.Change> hashMap = new HashMap<String, SpecialRegistrationInterface.Change>();
            for (SpecialRegistrationInterface.Change ch4 : request.changes) {
                hashMap.put(ch4.crn, ch4);
            }
            for (ClassAssignmentInterface.ErrorMessage m : errors) {
                SpecialRegistrationInterface.Change ch5;
                SpecialRegistrationInterface.Change change = m.getSection() != null ? (SpecialRegistrationInterface.Change)hashMap.get(m.getSection()) : (ch5 = m.getCourse() != null ? (SpecialRegistrationInterface.Change)hashMap.get(m.getCourse()) : null);
                if (ch5 == null && m.getCourse() != null) {
                    XOffering offering;
                    ch5 = new SpecialRegistrationInterface.Change();
                    ch5.subject = m.getCourse().substring(0, m.getCourse().lastIndexOf(32));
                    ch5.courseNbr = m.getCourse().substring(m.getCourse().lastIndexOf(32) + 1);
                    ch5.crn = m.getSection();
                    ch5.operation = SpecialRegistrationInterface.ChangeOperation.KEEP;
                    ch5.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    request.changes.add(ch5);
                    XCourseId course = server.getCourse(m.getCourse());
                    if (course != null && (offering = server.getOffering(course.getOfferingId())) != null) {
                        ch5.credit = offering.getCourse(course.getCourseId()).getCreditAbbv();
                    }
                    if (m.getSection() != null) {
                        hashMap.put(m.getSection(), ch5);
                    } else {
                        hashMap.put(m.getCourse(), ch5);
                    }
                }
                if (ch5 == null) continue;
                if (ch5.errors == null) {
                    ch5.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                }
                SpecialRegistrationInterface.ChangeError er = new SpecialRegistrationInterface.ChangeError();
                er.code = m.getCode();
                er.message = m.getMessage();
                ch5.errors.add(er);
                if (!"MAXI".equals(m.getCode())) continue;
                bl = true;
            }
        }
        if (credit != null && credit.floatValue() > maxCredit) {
            maxCredit = credit.floatValue();
        }
        if (bl || student.getMaxCredit() != null && student.getMaxCredit().floatValue() < maxCredit) {
            request.maxCredit = Float.valueOf(maxCredit);
        }
    }

    protected CourseRequest.CourseRequestOverrideIntent combine(SpecialRegistrationInterface.Change change, CourseRequest.CourseRequestOverrideIntent oldIntent) {
        boolean ex = false;
        if (change.errors != null) {
            for (SpecialRegistrationInterface.ChangeError e : change.errors) {
                if (e.code == null || !e.code.startsWith("EX-")) continue;
                ex = true;
            }
        }
        if (oldIntent != null) {
            switch (oldIntent) {
                case EX_ADD: 
                case EX_DROP: 
                case EX_CHANGE: {
                    ex = true;
                }
            }
        }
        if (change.operation == SpecialRegistrationInterface.ChangeOperation.ADD) {
            if (oldIntent != null) {
                switch (oldIntent) {
                    case EX_ADD: 
                    case ADD: {
                        return ex ? CourseRequest.CourseRequestOverrideIntent.EX_ADD : CourseRequest.CourseRequestOverrideIntent.ADD;
                    }
                }
                return ex ? CourseRequest.CourseRequestOverrideIntent.EX_CHANGE : CourseRequest.CourseRequestOverrideIntent.CHANGE;
            }
            return ex ? CourseRequest.CourseRequestOverrideIntent.EX_ADD : CourseRequest.CourseRequestOverrideIntent.ADD;
        }
        if (change.operation == SpecialRegistrationInterface.ChangeOperation.DROP) {
            if (oldIntent != null) {
                switch (oldIntent) {
                    case EX_DROP: 
                    case DROP: {
                        return ex ? CourseRequest.CourseRequestOverrideIntent.EX_DROP : CourseRequest.CourseRequestOverrideIntent.DROP;
                    }
                }
                return ex ? CourseRequest.CourseRequestOverrideIntent.EX_CHANGE : CourseRequest.CourseRequestOverrideIntent.CHANGE;
            }
            return ex ? CourseRequest.CourseRequestOverrideIntent.EX_DROP : CourseRequest.CourseRequestOverrideIntent.DROP;
        }
        return oldIntent;
    }

    @Override
    public SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.SpecialRegistrationEligibilityRequest input) throws SectioningException {
        if (student == null) {
            return new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, "No student.");
        }
        if (!this.isSpecialRegistrationEnabled(server, helper, student)) {
            return new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, "Special registration is disabled.");
        }
        SpecialRegistrationInterface.CheckRestrictionsRequest req = new SpecialRegistrationInterface.CheckRestrictionsRequest();
        req.term = this.getBannerTerm(server.getAcademicSession());
        req.campus = this.getBannerCampus(server.getAcademicSession());
        req.mode = this.getSpecialRegistrationMode();
        req.studentId = this.getBannerId(student);
        req.changes = SpecialRegistrationHelper.createValidationRequest(req, SpecialRegistrationInterface.ValidationMode.REG, true);
        HashSet<String> current = new HashSet<String>();
        HashSet<String> keep = new HashSet<String>();
        HashMap<String, String> crn2course = new HashMap<String, String>();
        ArrayList<String> newCourses = new ArrayList<String>();
        HashSet<String> adds = new HashSet<String>();
        HashMap<String, XCourse> courses = new HashMap<String, XCourse>();
        HashMap<String, ArrayList<XSection>> crn2sections = new HashMap<String, ArrayList<XSection>>();
        for (XRequest r : student.getRequests()) {
            XOffering offering;
            XCourse course;
            XCourseRequest cr;
            XEnrollment enr;
            if (!(r instanceof XCourseRequest) || (enr = (cr = (XCourseRequest)r).getEnrollment()) == null || (course = server.getCourse(enr.getCourseId())) == null || (offering = server.getOffering(enr.getOfferingId())) == null) continue;
            for (Long l : enr.getSectionIds()) {
                XSection section = offering.getSection(l);
                String crn = section.getExternalId(enr.getCourseId());
                current.add(crn);
                crn2course.put(crn, course.getCourseName());
                courses.put(course.getCourseName(), course);
                ArrayList<XSection> sections = (ArrayList<XSection>)crn2sections.get(crn);
                if (sections == null) {
                    sections = new ArrayList<XSection>();
                    crn2sections.put(crn, sections);
                }
                sections.add(section);
            }
        }
        if (input.getClassAssignments() != null) {
            for (ClassAssignmentInterface.ClassAssignment ca : input.getClassAssignments()) {
                Object section;
                XOffering offering;
                XCourse course;
                if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy() || ca.isTeachingAssignment() || (course = server.getCourse(ca.getCourseId())) == null || (offering = server.getOffering(course.getOfferingId())) == null || (section = offering.getSection(ca.getClassId())) == null) continue;
                String crn = ((XSection)section).getExternalId(course.getCourseId());
                if (current.contains(crn)) {
                    keep.add(crn);
                } else if (adds.add(crn)) {
                    SpecialRegistrationHelper.addCrn(req.changes, crn);
                    crn2course.put(crn, course.getCourseName());
                    if (!courses.containsKey(course.getCourseName())) {
                        courses.put(course.getCourseName(), course);
                        newCourses.add(crn);
                    }
                }
                Iterator<SpecialRegistrationInterface.Problem> sections = (ArrayList<XSection>)crn2sections.get(crn);
                if (sections == null) {
                    sections = new ArrayList<XSection>();
                    crn2sections.put(crn, (ArrayList<XSection>)((Object)sections));
                }
                sections.add((SpecialRegistrationInterface.Problem)section);
            }
        }
        for (String crn : current) {
            if (keep.contains(crn)) continue;
            SpecialRegistrationHelper.dropCrn(req.changes, crn);
        }
        SpecialRegistrationInterface.CheckRestrictionsResponse resp = null;
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiCheckRestrictions());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Request: " + gson.toJson((Object)req));
            }
            helper.getAction().addOptionBuilder().setKey("request").setValue(gson.toJson((Object)req));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(req));
            helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
            resp = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)resp));
            }
            helper.getAction().addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)resp));
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        String message = null;
        if (resp.eligible != null) {
            if (SpecialRegistrationInterface.ResponseStatus.success != resp.status) {
                return new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, resp.message == null || resp.message.isEmpty() ? "Failed to check student eligibility (" + (Object)((Object)resp.status) + ")." : resp.message);
            }
            boolean eligible = true;
            if (resp.eligible == null || resp.eligible.eligible == null || !resp.eligible.eligible.booleanValue()) {
                eligible = false;
            }
            if (resp.eligible != null && resp.eligible.eligibilityProblems != null) {
                for (SpecialRegistrationInterface.EligibilityProblem p : resp.eligible.eligibilityProblems) {
                    if (message == null) {
                        message = p.message;
                        continue;
                    }
                    message = message + "\n" + p.message;
                }
            }
            if (!eligible) {
                return new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, message != null ? message : "Student not eligible.");
            }
        }
        SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse ret = new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(true, message);
        HashSet<String> ext = new HashSet<String>();
        if (resp.outJson != null && resp.outJson.problems != null) {
            TreeSet<ClassAssignmentInterface.ErrorMessage> errors = new TreeSet<ClassAssignmentInterface.ErrorMessage>();
            for (SpecialRegistrationInterface.Problem problem : resp.outJson.problems) {
                if (!"CLOS".equals(problem.code) || adds.contains(problem.crn)) {
                    if ("MAXI".equals(problem.code) && !newCourses.isEmpty()) {
                        String crn = (String)newCourses.remove(newCourses.size() - 1);
                        errors.add(new ClassAssignmentInterface.ErrorMessage((String)crn2course.get(crn), crn, problem.code, problem.message));
                    } else {
                        errors.add(new ClassAssignmentInterface.ErrorMessage((String)crn2course.get(problem.crn), problem.crn, problem.code, problem.message));
                    }
                }
                if (problem.code == null || !problem.code.startsWith("EX-")) continue;
                ext.add(problem.crn);
            }
            ret.setErrors(errors);
            if (resp.outJson.maxHoursCalc != null) {
                ret.setCredit(resp.outJson.maxHoursCalc);
            }
        }
        TreeSet<ClassAssignmentInterface.ErrorMessage> denied = new TreeSet<ClassAssignmentInterface.ErrorMessage>();
        if (ret.hasErrors()) {
            for (ClassAssignmentInterface.ErrorMessage errorMessage : ret.getErrors()) {
                XCourse course;
                if (resp.overrides != null && !resp.overrides.contains(errorMessage.getCode())) {
                    ret.setMessage((ret.hasMessage() ? ret.getMessage() + "\n" : "") + "No approvals are allowed for " + errorMessage + ".");
                    ret.setCanSubmit(false);
                    denied.add(new ClassAssignmentInterface.ErrorMessage(errorMessage.getCourse(), "", errorMessage.getCode(), "Approvals are not allowed for: " + errorMessage.getMessage()));
                    continue;
                }
                if ("CLOS".equals(errorMessage.getCode()) && adds.contains(errorMessage.getSection()) && this.isAllowClosedErrorForAvailableSections()) {
                    course = (XCourse)courses.get(errorMessage.getCourse());
                    if (course == null) continue;
                    if (ext.contains(errorMessage.getSection())) {
                        XEnrollments enrollments = server.getEnrollments(course.getOfferingId());
                        boolean available = true;
                        for (XSection section : (List)crn2sections.get(errorMessage.getSection())) {
                            int enrl;
                            int n = enrl = enrollments != null ? enrollments.countEnrollmentsForSection(section.getSectionId()) : 0;
                            if (section.getLimit() < 0 || section.getLimit() > enrl) continue;
                            available = false;
                            break;
                        }
                        if (available) continue;
                        ret.setMessage((ret.hasMessage() ? ret.getMessage() + "\n" : "") + course.getCourseName() + " does not allow approvals for " + errorMessage + ".");
                        ret.setCanSubmit(false);
                        denied.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), "", errorMessage.getCode(), "Approvals are not allowed for: " + errorMessage.getMessage()));
                        continue;
                    }
                    if (course == null || course.isOverrideEnabled(errorMessage.getCode())) continue;
                    ret.setMessage((ret.hasMessage() ? ret.getMessage() + "\n" : "") + course.getCourseName() + " does not allow approvals for " + errorMessage + ".");
                    ret.setCanSubmit(false);
                    denied.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), "", errorMessage.getCode(), "Approvals are not allowed for: " + errorMessage.getMessage()));
                    continue;
                }
                course = (XCourse)courses.get(errorMessage.getCourse());
                if (course == null || course.isOverrideEnabled(errorMessage.getCode())) continue;
                ret.setMessage((ret.hasMessage() ? ret.getMessage() + "\n" : "") + course.getCourseName() + " does not allow approvals for " + errorMessage + ".");
                ret.setCanSubmit(false);
                denied.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), "", errorMessage.getCode(), "Approvals are not allowed for: " + errorMessage.getMessage()));
            }
        }
        HashSet<String> denials = new HashSet<String>();
        if (resp.deniedRequests != null && !resp.deniedRequests.isEmpty()) {
            for (SpecialRegistrationInterface.DeniedRequest r : resp.deniedRequests) {
                String course = null;
                if (r.subject != null) {
                    course = r.subject + " " + r.courseNbr;
                } else if (r.crn != null) {
                    for (String crn : r.crn.split(",")) {
                        CourseOffering courseOffering = this.findCourseByExternalId(server.getAcademicSession().getUniqueId(), crn);
                        if (courseOffering == null) continue;
                        course = courseOffering.getCourseName();
                        break;
                    }
                }
                if (course == null || !denials.add(course + ":" + r.code)) continue;
                ret.setMessage((ret.hasMessage() ? ret.getMessage() + "\n" : "") + course + ": " + r.errorMessage);
                ret.setCanSubmit(false);
                denied.add(new ClassAssignmentInterface.ErrorMessage(course, r.crn, r.code, r.errorMessage));
            }
        }
        if (resp.cancelRegistrationRequests != null) {
            TreeSet<ClassAssignmentInterface.ErrorMessage> treeSet = new TreeSet<ClassAssignmentInterface.ErrorMessage>();
            for (SpecialRegistrationInterface.SpecialRegistration r : resp.cancelRegistrationRequests) {
                ret.addCancelRequestId(r.regRequestId);
                if (r.changes == null) continue;
                String maxi = null;
                TreeSet<String> rAdds = new TreeSet<String>();
                TreeSet<String> rDrops = new TreeSet<String>();
                for (SpecialRegistrationInterface.Change change : r.changes) {
                    if (change.subject != null && change.courseNbr != null) {
                        if (this.isPending(change.status) && change.errors != null) {
                            for (SpecialRegistrationInterface.ChangeError e : change.errors) {
                                treeSet.add(new ClassAssignmentInterface.ErrorMessage(change.subject + " " + change.courseNbr, change.crn, e.code, e.message));
                            }
                        }
                        if (SpecialRegistrationInterface.ChangeOperation.ADD == change.operation) {
                            rAdds.add(change.subject + " " + change.courseNbr);
                            continue;
                        }
                        rDrops.add(change.subject + " " + change.courseNbr);
                        continue;
                    }
                    if (!r.regRequestId.equals(input.getRequestId()) || !this.isPending(change.status) || change.errors == null) continue;
                    for (SpecialRegistrationInterface.ChangeError e : change.errors) {
                        if (!"MAXI".equals(e.code)) continue;
                        maxi = e.message;
                    }
                }
                if (maxi == null) continue;
                for (String string : rAdds) {
                    if (rDrops.contains(string)) continue;
                    treeSet.add(new ClassAssignmentInterface.ErrorMessage(string, "", "MAXI", maxi));
                }
            }
            if (!treeSet.isEmpty()) {
                ret.setCancelErrors(treeSet);
            }
        }
        if (!denied.isEmpty()) {
            ret.setDeniedErrors(denied);
        }
        return ret;
    }

    @Override
    public SpecialRegistrationInterface.SubmitSpecialRegistrationResponse submitRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.SubmitSpecialRegistrationRequest input) throws SectioningException {
        ClientResource resource = null;
        try {
            SpecialRegistrationInterface.SpecialRegistrationRequest request = new SpecialRegistrationInterface.SpecialRegistrationRequest();
            AcademicSessionInfo session = server.getAcademicSession();
            request.term = this.getBannerTerm(session);
            request.campus = this.getBannerCampus(session);
            request.studentId = this.getBannerId(student);
            this.buildChangeList(request, server, helper, student, input.getClassAssignments(), input.getErrors(), input.getCredit());
            request.regRequestId = input.getRequestId();
            request.mode = this.getSpecialRegistrationMode();
            if (helper.getUser() != null) {
                request.requestorId = this.getRequestorId(helper.getUser());
                request.requestorRole = this.getRequestorType(helper.getUser(), student);
            }
            request.requestorNotes = input.getNote();
            if (request.changes == null || request.changes.isEmpty()) {
                throw new SectioningException("There are no changes.");
            }
            resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Request: " + gson.toJson((Object)request));
            }
            helper.getAction().addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)request));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(request));
            helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
            SpecialRegistrationInterface.SpecialRegistrationResponseList response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
            SpecialRegistrationInterface.SubmitSpecialRegistrationResponse ret = new SpecialRegistrationInterface.SubmitSpecialRegistrationResponse();
            ret.setMessage(response.message);
            ret.setSuccess(SpecialRegistrationInterface.ResponseStatus.success == response.status);
            if (response.data != null && !((List)response.data).isEmpty()) {
                ret.setStatus(this.getStatus((SpecialRegistrationInterface.SpecialRegistration)((List)response.data).get(0)));
                for (SpecialRegistrationInterface.SubmitRegistrationResponse r : (List)response.data) {
                    if (r.changes != null) {
                        for (SpecialRegistrationInterface.Change ch : r.changes) {
                            if (ch.errors == null || ch.errors.isEmpty() || ch.status != null) continue;
                            ch.status = SpecialRegistrationInterface.ChangeStatus.inProgress;
                        }
                    }
                    if (r.requestorNotes == null) {
                        r.requestorNotes = input.getNote();
                    }
                    if (r.maxCredit == null && request.maxCredit != null) {
                        r.maxCredit = request.maxCredit;
                    }
                    ret.addRequest(this.convert(server, helper, student, r, false));
                    if (r.cancelledRequests == null) continue;
                    for (SpecialRegistrationInterface.CancelledRequest c : r.cancelledRequests) {
                        ret.addCancelledRequest(c.regRequestId);
                    }
                }
            } else {
                ret.setSuccess(false);
            }
            if (this.isUpdateUniTimeStatuses() && response.data != null && !((List)response.data).isEmpty()) {
                boolean studentChanged = false;
                for (SpecialRegistrationInterface.SubmitRegistrationResponse r : (List)response.data) {
                    XCourseRequest cr;
                    Object dbStudent;
                    SpecialRegistrationInterface.ChangeStatus maxiStatus = null;
                    HashMap course2errors = new HashMap();
                    HashMap<Object, CourseRequest.CourseRequestOverrideIntent> course2intent = new HashMap<Object, CourseRequest.CourseRequestOverrideIntent>();
                    HashMap<Object, SpecialRegistrationInterface.SpecialRegistrationStatus> course2status = new HashMap<Object, SpecialRegistrationInterface.SpecialRegistrationStatus>();
                    if (r.changes != null) {
                        for (SpecialRegistrationInterface.Change ch : r.changes) {
                            if (ch.subject != null && ch.courseNbr != null && ch.errors != null && !ch.errors.isEmpty()) {
                                String course = ch.subject + " " + ch.courseNbr;
                                course2intent.put(course, this.combine(ch, (CourseRequest.CourseRequestOverrideIntent)((Object)course2intent.get(course))));
                                TreeSet<String> errors = (TreeSet<String>)course2errors.get(course);
                                if (errors == null) {
                                    errors = new TreeSet<String>();
                                    course2errors.put(course, errors);
                                }
                                for (SpecialRegistrationInterface.ChangeError e : ch.errors) {
                                    if (e.message == null) continue;
                                    errors.add(e.message);
                                }
                                if (ch.status == null) continue;
                                SpecialRegistrationInterface.SpecialRegistrationStatus s = (SpecialRegistrationInterface.SpecialRegistrationStatus)course2status.get(course);
                                course2status.put(course, s == null ? this.getStatus(ch.status) : this.combine(s, this.getStatus(ch.status)));
                                continue;
                            }
                            if (ch.crn != null || ch.errors == null) continue;
                            for (SpecialRegistrationInterface.ChangeError e : ch.errors) {
                                if (!"MAXI".equals(e.code)) continue;
                                maxiStatus = ch.status;
                            }
                        }
                    }
                    if (r.maxCredit != null) {
                        student.setMaxCreditOverride(new XOverride(r.regRequestId, r.dateCreated == null ? new Date() : r.dateCreated.toDate(), maxiStatus != null ? this.toStatus(maxiStatus) : this.toStatus(r)));
                        dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
                        if (dbStudent != null) {
                            ((BaseStudent)dbStudent).setOverrideStatus(maxiStatus != null ? this.toStatus(maxiStatus) : this.toStatus(r));
                            ((BaseStudent)dbStudent).setOverrideMaxCredit(r.maxCredit);
                            ((BaseStudent)dbStudent).setOverrideExternalId(r.regRequestId);
                            ((BaseStudent)dbStudent).setOverrideTimeStamp(r.dateCreated == null ? new Date() : r.dateCreated.toDate());
                            helper.getHibSession().update(dbStudent);
                        }
                        studentChanged = true;
                    }
                    for (Map.Entry e : course2errors.entrySet()) {
                        cr = student.getRequestForCourseName((String)e.getKey());
                        if (cr == null) continue;
                        String message = "";
                        for (Object m : (Set)e.getValue()) {
                            message = message + (((String)m).isEmpty() ? "" : "\n") + (String)m;
                        }
                        if (message.length() > 255) {
                            message = message.substring(0, 252) + "...";
                        }
                        cr.setEnrollmentMessage(message);
                        for (XCourseId course : cr.getCourseIds()) {
                            if (!course.getCourseName().equals(e.getKey())) continue;
                            cr.setOverride(course, new XOverride(r.regRequestId, r.dateCreated == null ? new Date() : r.dateCreated.toDate(), this.toStatus((SpecialRegistrationInterface.SpecialRegistrationStatus)course2status.get(e.getKey()))));
                        }
                        CourseDemand dbCourseDemand = (CourseDemand)CourseDemandDAO.getInstance().get(cr.getRequestId(), helper.getHibSession());
                        if (dbCourseDemand != null) {
                            Object m;
                            m = new StudentEnrollmentMessage();
                            ((BaseStudentEnrollmentMessage)m).setCourseDemand(dbCourseDemand);
                            ((BaseStudentEnrollmentMessage)m).setLevel(0);
                            ((BaseStudentEnrollmentMessage)m).setType(0);
                            ((BaseStudentEnrollmentMessage)m).setTimestamp(r.dateCreated == null ? new Date() : r.dateCreated.toDate());
                            ((BaseStudentEnrollmentMessage)m).setMessage(message);
                            ((BaseStudentEnrollmentMessage)m).setOrder(0);
                            dbCourseDemand.getEnrollmentMessages().add((StudentEnrollmentMessage)m);
                            helper.getHibSession().update((Object)dbCourseDemand);
                            for (CourseRequest dbCourseRequest : dbCourseDemand.getCourseRequests()) {
                                if (!dbCourseRequest.getCourseOffering().getCourseName().equals(e.getKey())) continue;
                                dbCourseRequest.setOverrideExternalId(r.regRequestId);
                                dbCourseRequest.setOverrideStatus(this.toStatus((SpecialRegistrationInterface.SpecialRegistrationStatus)course2status.get(e.getKey())));
                                dbCourseRequest.setOverrideTimeStamp(r.dateCreated == null ? new Date() : r.dateCreated.toDate());
                                dbCourseRequest.setCourseRequestOverrideIntent((CourseRequest.CourseRequestOverrideIntent)((Object)course2intent.get(e.getKey())));
                                helper.getHibSession().update((Object)dbCourseRequest);
                            }
                        }
                        studentChanged = true;
                    }
                    if (!ret.hasCancelledRequestIds()) continue;
                    if (student.getMaxCreditOverride() != null && ret.isCancelledRequest(student.getMaxCreditOverride().getExternalId())) {
                        student.getMaxCreditOverride().setStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal());
                        dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
                        if (dbStudent != null) {
                            ((BaseStudent)dbStudent).setOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal());
                            helper.getHibSession().update(dbStudent);
                        }
                        studentChanged = true;
                    }
                    for (XRequest xr : student.getRequests()) {
                        if (!(xr instanceof XCourseRequest) || !(cr = (XCourseRequest)xr).hasOverrides()) continue;
                        for (Map.Entry<XCourseId, XOverride> e : cr.getOverrides().entrySet()) {
                            if (!ret.isCancelledRequest(e.getValue().getExternalId())) continue;
                            e.getValue().setStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal());
                            CourseDemand dbCourseDemand = (CourseDemand)CourseDemandDAO.getInstance().get(cr.getRequestId(), helper.getHibSession());
                            if (dbCourseDemand != null) {
                                for (CourseRequest dbCourseRequest : dbCourseDemand.getCourseRequests()) {
                                    if (!dbCourseRequest.getCourseOffering().getUniqueId().equals(e.getKey().getCourseId())) continue;
                                    dbCourseRequest.setOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal());
                                    helper.getHibSession().update((Object)dbCourseRequest);
                                }
                            }
                            studentChanged = true;
                        }
                    }
                }
                if (studentChanged) {
                    server.update(student, false);
                    helper.getHibSession().flush();
                }
            }
            SpecialRegistrationInterface.SubmitSpecialRegistrationResponse submitSpecialRegistrationResponse = ret;
            return submitSpecialRegistrationResponse;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected CourseOffering findCourseByExternalId(Long sessionId, String externalId) {
        return this.iExternalClassLookup.findCourseByExternalId(sessionId, externalId);
    }

    protected List<Class_> findClassesByExternalId(Long sessionId, String externalId) {
        return this.iExternalClassLookup.findClassesByExternalId(sessionId, externalId);
    }

    protected boolean isDrop(XEnrollment enrollment, List<SpecialRegistrationInterface.Change> changes) {
        return false;
    }

    protected List<XRequest> getRequests(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, Map<CourseOffering, List<Class_>> adds, Map<CourseOffering, List<Class_>> drops) {
        Student dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
        ArrayList<XRequest> requests = new ArrayList<XRequest>();
        HashSet<CourseOffering> remaining = new HashSet<CourseOffering>(adds.keySet());
        for (XRequest request : student.getRequests()) {
            if (request instanceof XCourseRequest) {
                HashSet<Long> classIds;
                XCourseRequest cr = (XCourseRequest)request;
                List<Class_> add = null;
                Object drop = null;
                XCourseId courseId = null;
                Long configId = null;
                for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                    for (Map.Entry<CourseOffering, List<Class_>> e : adds.entrySet()) {
                        if (!course.getCourseId().equals(e.getKey().getUniqueId())) continue;
                        add = e.getValue();
                        courseId = course;
                        configId = e.getValue().iterator().next().getSchedulingSubpart().getInstrOfferingConfig().getUniqueId();
                        remaining.remove(e.getKey());
                    }
                    for (Map.Entry<CourseOffering, List<Class_>> e : drops.entrySet()) {
                        if (!course.getCourseId().equals(e.getKey().getUniqueId())) continue;
                        drop = e.getValue();
                    }
                }
                if (add == null && drop == null) {
                    requests.add(request);
                    continue;
                }
                XEnrollment enrollemnt = cr.getEnrollment();
                HashSet<Long> hashSet = classIds = enrollemnt == null ? new HashSet<Long>() : new HashSet<Long>(enrollemnt.getSectionIds());
                if (enrollemnt != null) {
                    if (courseId != null) {
                        if (!enrollemnt.getCourseId().equals(courseId.getCourseId()) && drop == null) {
                            requests.add(request);
                            remaining.add((CourseOffering)CourseOfferingDAO.getInstance().get(courseId.getCourseId(), helper.getHibSession()));
                            continue;
                        }
                        if (!enrollemnt.getConfigId().equals(configId)) {
                            classIds.clear();
                        }
                    } else {
                        courseId = enrollemnt;
                        configId = enrollemnt.getConfigId();
                    }
                }
                if (add != null) {
                    for (Class_ c : add) {
                        classIds.add(c.getUniqueId());
                    }
                }
                if (drop != null) {
                    Iterator<Map.Entry<CourseOffering, List<Class_>>> iterator = drop.iterator();
                    while (iterator.hasNext()) {
                        Class_ c;
                        c = (Class_)((Object)iterator.next());
                        classIds.remove(c.getUniqueId());
                    }
                }
                if (classIds.isEmpty()) {
                    requests.add(new XCourseRequest(cr, null));
                    continue;
                }
                requests.add(new XCourseRequest(cr, new XEnrollment(dbStudent, courseId, configId, classIds)));
                continue;
            }
            requests.add(request);
        }
        for (CourseOffering course : remaining) {
            Long configId = null;
            HashSet<Long> classIds = new HashSet<Long>();
            for (Class_ clazz : adds.get(course)) {
                if (configId == null) {
                    configId = clazz.getSchedulingSubpart().getInstrOfferingConfig().getUniqueId();
                }
                classIds.add(clazz.getUniqueId());
            }
            XCourseId courseId = new XCourseId(course);
            requests.add(new XCourseRequest(dbStudent, courseId, requests.size(), new XEnrollment(dbStudent, courseId, configId, classIds)));
        }
        return requests;
    }

    protected void checkRequests(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<XRequest> xrequests, Set<ClassAssignmentInterface.ErrorMessage> errors, boolean allowTimeConf, boolean allowSpaceConf) {
        XOffering offering;
        XCourse course;
        ArrayList<StudentEnrollmentProvider.EnrollmentRequest> requests = new ArrayList<StudentEnrollmentProvider.EnrollmentRequest>();
        Hashtable<Long, XOffering> courseId2offering = new Hashtable<Long, XOffering>();
        for (XRequest req : xrequests) {
            XCourseRequest courseReq;
            XEnrollment e;
            if (!(req instanceof XCourseRequest) || (e = (courseReq = (XCourseRequest)req).getEnrollment()) == null) continue;
            XCourse course2 = server.getCourse(e.getCourseId());
            if (course2 == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(e.getCourseName()));
            }
            StudentEnrollmentProvider.EnrollmentRequest request = new StudentEnrollmentProvider.EnrollmentRequest(course2, new ArrayList<XSection>());
            requests.add(request);
            XOffering offering2 = server.getOffering(course2.getOfferingId());
            if (offering2 == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(e.getCourseName()));
            }
            for (Long sectionId : e.getSectionIds()) {
                XSection section = offering2.getSection(sectionId);
                if (section == null) {
                    throw new SectioningException(MSG.exceptionEnrollNotAvailable(e.getCourseName() + " " + sectionId));
                }
                if (section.isCancelled()) {
                    if (server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
                        boolean contains = false;
                        for (XRequest r : student.getRequests()) {
                            Object cr;
                            if (!(r instanceof XCourseRequest) || ((XCourseRequest)(cr = (XCourseRequest)r)).getEnrollment() == null || !((XCourseRequest)cr).getEnrollment().getSectionIds().contains(section.getSectionId())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) {
                            errors.add(new ClassAssignmentInterface.ErrorMessage(course2.getCourseName(), section.getExternalId(course2.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_CANCEL, MSG.exceptionEnrollCancelled(MSG.clazz(course2.getSubjectArea(), course2.getCourseNumber(), section.getSubpartName(), section.getName(course2.getCourseId())))));
                        }
                    } else {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course2.getCourseName(), section.getExternalId(course2.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_CANCEL, MSG.exceptionEnrollCancelled(MSG.clazz(course2.getSubjectArea(), course2.getCourseNumber(), section.getSubpartName(), section.getName(course2.getCourseId())))));
                    }
                }
                request.getSections().add(section);
                courseId2offering.put(course2.getCourseId(), offering2);
            }
        }
        block3: for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            XCourse course3 = request.getCourse();
            List<XSection> sections = request.getSections();
            for (XRequest r : student.getRequests()) {
                XEnrollment enrollment;
                if (!(r instanceof XCourseRequest) || (enrollment = ((XCourseRequest)r).getEnrollment()) == null || !enrollment.getCourseId().equals(course3.getCourseId())) continue;
                for (XSection s : sections) {
                    if (enrollment.getSectionIds().contains(s.getSectionId()) || server.checkDeadline(course3.getCourseId(), s.getTime(), OnlineSectioningServer.Deadline.CHANGE)) continue;
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course3.getCourseName(), s.getExternalId(course3.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineChange(MSG.clazz(course3.getSubjectArea(), course3.getCourseNumber(), s.getSubpartName(), s.getName(course3.getCourseId())))));
                }
                continue block3;
            }
            for (XSection section : sections) {
                if (server.checkDeadline(course3.getOfferingId(), section.getTime(), OnlineSectioningServer.Deadline.NEW)) continue;
                errors.add(new ClassAssignmentInterface.ErrorMessage(course3.getCourseName(), section.getExternalId(course3.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineNew(MSG.clazz(course3.getSubjectArea(), course3.getCourseNumber(), section.getSubpartName(), section.getName(course3.getCourseId())))));
            }
        }
        for (XRequest r : student.getRequests()) {
            XOffering offering3;
            XEnrollment enrollment;
            if (!(r instanceof XCourseRequest) || (enrollment = ((XCourseRequest)r).getEnrollment()) == null || courseId2offering.containsKey(enrollment.getCourseId()) || (offering3 = server.getOffering(enrollment.getOfferingId())) == null) continue;
            for (XSection section : offering3.getSections(enrollment)) {
                if (server.checkDeadline(offering3.getOfferingId(), section.getTime(), OnlineSectioningServer.Deadline.DROP)) continue;
                errors.add(new ClassAssignmentInterface.ErrorMessage(enrollment.getCourseName(), section.getExternalId(enrollment.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineDrop(enrollment.getCourseName())));
            }
        }
        Hashtable<Long, XConfig> courseId2config = new Hashtable<Long, XConfig>();
        for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            course = request.getCourse();
            offering = (XOffering)courseId2offering.get(course.getCourseId());
            XEnrollments enrollments = server.getEnrollments(course.getOfferingId());
            List<XSection> sections = request.getSections();
            XSubpart subpart = offering.getSubpart(sections.get(0).getSubpartId());
            XConfig config = offering.getConfig(subpart.getConfigId());
            courseId2config.put(course.getCourseId(), config);
            XReservation reservation = null;
            block10: for (XReservation xReservation : offering.getReservations()) {
                if (!xReservation.isApplicable(student, course)) continue;
                if (xReservation.getLimit() >= 0 && xReservation.getLimit() <= enrollments.countEnrollmentsForReservation(xReservation.getReservationId())) {
                    boolean contain = false;
                    for (XEnrollment e : enrollments.getEnrollmentsForReservation(xReservation.getReservationId())) {
                        if (!e.getStudentId().equals(student.getStudentId())) continue;
                        contain = true;
                        break;
                    }
                    if (!contain) continue;
                }
                if (!xReservation.getConfigsIds().isEmpty() && !xReservation.getConfigsIds().contains(config.getConfigId())) continue;
                for (XSection section2 : sections) {
                    if (xReservation.getSectionIds(section2.getSubpartId()) == null || xReservation.getSectionIds(section2.getSubpartId()).contains(section2.getSectionId())) continue;
                    continue block10;
                }
                if (reservation != null && xReservation.compareTo(reservation) >= 0) continue;
                reservation = xReservation;
            }
            if (reservation != null && reservation.canAssignOverLimit() || allowSpaceConf) continue;
            for (XSection xSection : sections) {
                boolean contain;
                if (xSection.getLimit() >= 0 && xSection.getLimit() <= enrollments.countEnrollmentsForSection(xSection.getSectionId())) {
                    contain = false;
                    for (XEnrollment e : enrollments.getEnrollmentsForSection(xSection.getSectionId())) {
                        if (!e.getStudentId().equals(student.getStudentId())) continue;
                        contain = true;
                        break;
                    }
                    if (!contain) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), xSection.getSubpartName(), xSection.getName()))));
                    }
                }
                if (reservation != null && offering.getSectionReservations(xSection.getSectionId()).contains(reservation) || offering.getUnreservedSectionSpace(xSection.getSectionId(), enrollments) > 0) continue;
                contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForSection(xSection.getSectionId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), xSection.getSubpartName(), xSection.getName()))));
            }
            if (config.getLimit() >= 0 && config.getLimit() <= enrollments.countEnrollmentsForConfig(config.getConfigId())) {
                boolean contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForConfig(config.getConfigId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (!contain) {
                    for (XSection section4 : sections) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section4.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section4.getSubpartName(), section4.getName()))));
                    }
                }
            }
            if (!(reservation != null && offering.getConfigReservations(config.getConfigId()).contains(reservation) || offering.getUnreservedConfigSpace(config.getConfigId(), enrollments) > 0)) {
                boolean contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForConfig(config.getConfigId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (!contain) {
                    for (XSection section5 : sections) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section5.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section5.getSubpartName(), section5.getName()))));
                    }
                }
            }
            if (course.getLimit() < 0 || course.getLimit() > enrollments.countEnrollmentsForCourse(course.getCourseId())) continue;
            boolean contain = false;
            for (XEnrollment e : enrollments.getEnrollmentsForCourse(course.getCourseId())) {
                if (!e.getStudentId().equals(student.getStudentId())) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            for (XSection section6 : sections) {
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section6.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section6.getSubpartName(), section6.getName()))));
            }
        }
        for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            course = request.getCourse();
            offering = (XOffering)courseId2offering.get(course.getCourseId());
            List<XSection> sections = request.getSections();
            XSubpart subpart = offering.getSubpart(sections.get(0).getSubpartId());
            XConfig config = offering.getConfig(subpart.getConfigId());
            if (sections.size() < config.getSubparts().size()) {
                for (XSection section : sections) {
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentIncomplete(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            } else if (sections.size() > config.getSubparts().size()) {
                for (XSection section : sections) {
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            }
            for (XSection s1 : sections) {
                for (XSection xSection : sections) {
                    if (s1.getSectionId() < xSection.getSectionId() && s1.isOverlapping(offering.getDistributions(), xSection)) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentOverlapping(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentOverlapping(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                    }
                    if (s1.getSectionId().equals(xSection.getSectionId()) || !s1.getSubpartId().equals(xSection.getSubpartId())) continue;
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
                if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
            }
            if (offering.isAllowOverlap(student, config.getConfigId(), course, sections) || allowTimeConf) continue;
            for (StudentEnrollmentProvider.EnrollmentRequest otherRequest : requests) {
                XOffering other = (XOffering)courseId2offering.get(otherRequest.getCourse().getCourseId());
                XConfig xConfig = (XConfig)courseId2config.get(otherRequest.getCourse().getCourseId());
                if (other.equals(offering) || other.isAllowOverlap(student, xConfig.getConfigId(), otherRequest.getCourse(), otherRequest.getSections())) continue;
                List<XSection> assignment = otherRequest.getSections();
                for (XSection section : sections) {
                    if (!section.isOverlapping(offering.getDistributions(), assignment)) continue;
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentConflicting(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            }
        }
    }

    protected boolean isCancelled(SpecialRegistrationInterface.SpecialRegistration specialRequest) {
        if (specialRequest.changes != null) {
            for (SpecialRegistrationInterface.Change change : specialRequest.changes) {
                if (SpecialRegistrationInterface.ChangeStatus.cancelled != change.status) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    protected SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse convert(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.SpecialRegistration specialRequest, boolean excludeApprovedOrRejected) {
        SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse ret = new SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse();
        HashMap<CourseOffering, TreeSet<Class_>> adds = new HashMap<CourseOffering, TreeSet<Class_>>();
        HashMap drops = new HashMap();
        HashSet<CourseOffering> keeps = new HashSet<CourseOffering>();
        HashMap<Class_, ArrayList<SpecialRegistrationInterface.Change>> changes = new HashMap<Class_, ArrayList<SpecialRegistrationInterface.Change>>();
        TreeSet<CourseOffering> courses = new TreeSet<CourseOffering>();
        SpecialRegistrationInterface.SpecialRegistrationStatus status = null;
        String maxi = null;
        SpecialRegistrationInterface.ChangeStatus maxStatus = null;
        String maxiNote = null;
        String honorsGradeMode = this.getResetGradeModesRegExp();
        if (specialRequest.changes != null) {
            for (SpecialRegistrationInterface.Change change : specialRequest.changes) {
                if (change.crn == null || change.crn.isEmpty()) {
                    if (change.errors == null) continue;
                    for (SpecialRegistrationInterface.ChangeError err : change.errors) {
                        if (!"MAXI".equals(err.code)) continue;
                        maxi = err.message;
                        maxStatus = change.status;
                        maxiNote = SpecialRegistrationHelper.getLastNote(change);
                        ret.setMaxCredit(specialRequest.maxCredit);
                        if (specialRequest.maxCredit == null || student.getMaxCredit() == null) continue;
                        DecimalFormat df = new DecimalFormat("0.#");
                        maxi = "Maximum hours exceeded. Currently allowed " + df.format(student.getMaxCredit()) + " but needs " + df.format(specialRequest.maxCredit) + ".";
                        if (!(student.getMaxCredit().floatValue() >= specialRequest.maxCredit.floatValue()) || this.getStatus(change.status) != SpecialRegistrationInterface.SpecialRegistrationStatus.Pending) continue;
                        maxStatus = SpecialRegistrationInterface.ChangeStatus.approved;
                    }
                    continue;
                }
                for (String crn : change.crn.split(",")) {
                    CourseOffering course = this.findCourseByExternalId(server.getAcademicSession().getUniqueId(), crn);
                    Iterator classes = this.findClassesByExternalId(server.getAcademicSession().getUniqueId(), crn);
                    if (course != null && classes != null && !classes.isEmpty()) {
                        courses.add(course);
                        TreeSet<Class_> list = (TreeSet<Class_>)(SpecialRegistrationInterface.ChangeOperation.DROP != change.operation ? adds : drops).get(course);
                        if (SpecialRegistrationInterface.ChangeOperation.KEEP == change.operation || SpecialRegistrationInterface.ChangeOperation.CHGMODE == change.operation || SpecialRegistrationInterface.ChangeOperation.CHGVARCR == change.operation) {
                            keeps.add(course);
                        }
                        if (list == null) {
                            list = new TreeSet<Class_>(new ClassComparator(5));
                            (SpecialRegistrationInterface.ChangeOperation.DROP != change.operation ? adds : drops).put(course, list);
                        }
                        Iterator iterator = classes.iterator();
                        while (iterator.hasNext()) {
                            Class_ clazz = (Class_)iterator.next();
                            list.add(clazz);
                            ArrayList<SpecialRegistrationInterface.Change> ch = (ArrayList<SpecialRegistrationInterface.Change>)changes.get(clazz);
                            if (ch == null) {
                                ch = new ArrayList<SpecialRegistrationInterface.Change>();
                                changes.put(clazz, ch);
                            }
                            ch.add(change);
                        }
                    }
                    if (change.status == null) continue;
                    status = this.combine(status, this.getStatus(change.status));
                }
            }
        }
        String desc = "";
        NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
        for (CourseOffering course : courses) {
            String additionalMessage;
            String message;
            Float creditOverride;
            int limit;
            int maxLimit;
            int minLimit;
            Iterator placement;
            SpecialRegistrationInterface.SpecialRegistrationStatus s;
            List change;
            ClassAssignmentInterface.ClassAssignment ca;
            if (!desc.isEmpty()) {
                desc = desc + ", ";
            }
            desc = desc + course.getCourseName();
            if (adds.containsKey(course)) {
                desc = drops.containsKey(course) ? desc + " (change)" : desc + " (add)";
            } else if (drops.containsKey(course)) {
                desc = desc + " (drop)";
            }
            ExternalClassNameHelperInterface.HasGradableSubpart gs = null;
            if (ApplicationProperty.OnlineSchedulingGradableIType.isTrue() && Class_.getExternalClassNameHelper() != null && Class_.getExternalClassNameHelper() instanceof ExternalClassNameHelperInterface.HasGradableSubpart) {
                gs = (ExternalClassNameHelperInterface.HasGradableSubpart)((Object)Class_.getExternalClassNameHelper());
            }
            CourseCreditUnitConfig credit = course.getCredit();
            TreeSet<String> additionalMessages = new TreeSet<String>();
            if (adds.containsKey(course)) {
                block21: for (Class_ clazz : (Set)adds.get(course)) {
                    Object ci2;
                    ca = new ClassAssignmentInterface.ClassAssignment();
                    change = (List)changes.get(clazz);
                    ca.setSpecRegOperation(SpecialRegistrationInterface.ChangeOperation.ADD == ((SpecialRegistrationInterface.Change)change.get((int)0)).operation ? SpecialRegistrationInterface.SpecialRegistrationOperation.Add : SpecialRegistrationInterface.SpecialRegistrationOperation.Keep);
                    if (((SpecialRegistrationInterface.Change)change.get((int)0)).operation == SpecialRegistrationInterface.ChangeOperation.CHGMODE) {
                        ca.setGradeMode(new OnlineSectioningInterface.GradeMode(((SpecialRegistrationInterface.Change)change.get((int)0)).selectedGradeMode, ((SpecialRegistrationInterface.Change)change.get((int)0)).selectedGradeModeDescription, honorsGradeMode != null && !honorsGradeMode.isEmpty() && ((SpecialRegistrationInterface.Change)change.get((int)0)).selectedGradeMode.matches(honorsGradeMode)));
                        if (clazz.getParentClass() != null && clazz.getSchedulingSubpart().getItype().equals(clazz.getParentClass().getSchedulingSubpart().getItype())) continue;
                    }
                    if (((SpecialRegistrationInterface.Change)change.get((int)0)).operation == SpecialRegistrationInterface.ChangeOperation.CHGVARCR && clazz.getExternalId(course).equals(((SpecialRegistrationInterface.Change)change.get((int)0)).crn) && (clazz.getParentClass() == null || !clazz.getSchedulingSubpart().getItype().equals(clazz.getParentClass().getSchedulingSubpart().getItype())) && ((SpecialRegistrationInterface.Change)change.get((int)0)).selectedCreditHour != null) {
                        ca.setCreditHour(Float.valueOf(((SpecialRegistrationInterface.Change)change.get((int)0)).selectedCreditHour));
                    }
                    s = null;
                    for (SpecialRegistrationInterface.Change ch : change) {
                        if (ch.status == null) continue;
                        s = this.combine(s, this.getStatus(ch.status));
                    }
                    ca.setSpecRegStatus(s);
                    ca.setCourseId(course.getUniqueId());
                    ca.setSubject(course.getSubjectAreaAbbv());
                    ca.setCourseNbr(course.getCourseNbr());
                    ca.setCourseAssigned(true);
                    ca.setTitle(course.getTitle());
                    ca.setClassId(clazz.getUniqueId());
                    ca.setSection(clazz.getClassSuffix(course));
                    if (ca.getSection() == null) {
                        ca.setSection(clazz.getSectionNumberString(helper.getHibSession()));
                    }
                    ca.setClassNumber(clazz.getSectionNumberString(helper.getHibSession()));
                    ca.setSubpart(clazz.getSchedulingSubpart().getItypeDesc().trim());
                    ca.setExternalId(clazz.getExternalId(course));
                    if (clazz.getParentClass() != null) {
                        ca.setParentSection(clazz.getParentClass().getClassSuffix(course));
                        if (ca.getParentSection() == null) {
                            ca.setParentSection(clazz.getParentClass().getSectionNumberString(helper.getHibSession()));
                        }
                    }
                    if (clazz.getSchedulePrintNote() != null) {
                        ca.addNote(clazz.getSchedulePrintNote());
                    }
                    placement = clazz.getCommittedAssignment() == null ? null : clazz.getCommittedAssignment().getPlacement();
                    minLimit = clazz.getExpectedCapacity();
                    limit = maxLimit = clazz.getMaxExpectedCapacity().intValue();
                    if (minLimit < maxLimit && placement != null) {
                        int roomLimit = (int)Math.floor((float)placement.getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                        limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                    }
                    if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                        limit = -1;
                    }
                    ca.setCancelled(clazz.isCancelled());
                    ca.setLimit(new int[]{clazz.getEnrollment(), limit});
                    if (placement != null) {
                        if (placement.getTimeLocation() != null) {
                            for (DayCode d : DayCode.toDayCodes(placement.getTimeLocation().getDayCode())) {
                                ca.addDay(d.getIndex());
                            }
                            ca.setStart(placement.getTimeLocation().getStartSlot());
                            ca.setLength(placement.getTimeLocation().getLength());
                            ca.setBreakTime(placement.getTimeLocation().getBreakTime());
                            ca.setDatePattern(placement.getTimeLocation().getDatePatternName());
                        }
                        if (clazz.getCommittedAssignment() != null) {
                            for (Location loc : clazz.getCommittedAssignment().getRooms()) {
                                ca.addRoom(loc.getUniqueId(), loc.getLabelWithDisplayName());
                            }
                        }
                    }
                    if (clazz.getDisplayInstructor().booleanValue()) {
                        for (Object ci2 : clazz.getClassInstructors()) {
                            if (!((BaseClassInstructor)ci2).isLead().booleanValue()) continue;
                            ca.addInstructor(nameFormat.format(((BaseClassInstructor)ci2).getInstructor()));
                            ca.addInstructoEmail(((BaseClassInstructor)ci2).getInstructor().getEmail() == null ? "" : ((BaseClassInstructor)ci2).getInstructor().getEmail());
                        }
                    }
                    if (credit != null && gs != null && gs.isGradableSubpart(clazz.getSchedulingSubpart(), course, helper.getHibSession())) {
                        ca.setCredit(credit.creditAbbv() + "|" + credit.creditText());
                        ca.setCreditRange(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                        credit = null;
                    } else if (credit != null && gs == null) {
                        ca.setCredit(credit.creditAbbv() + "|" + credit.creditText());
                        ca.setCreditRange(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                        credit = null;
                    }
                    if (clazz.getSchedulingSubpart().getCredit() != null) {
                        ca.setCredit(clazz.getSchedulingSubpart().getCredit().creditAbbv() + "|" + clazz.getSchedulingSubpart().getCredit().creditText());
                        ca.setCreditRange(Float.valueOf(clazz.getSchedulingSubpart().getCredit().getMinCredit()), Float.valueOf(clazz.getSchedulingSubpart().getCredit().getMaxCredit()));
                        credit = null;
                    }
                    if ((creditOverride = clazz.getCredit(course)) != null) {
                        ca.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                    }
                    if (ca.getParentSection() == null) {
                        ca.setParentSection(course.getConsentType() == null ? null : course.getConsentType().getLabel());
                    }
                    ci2 = change.iterator();
                    while (ci2.hasNext()) {
                        Object ch = (SpecialRegistrationInterface.Change)ci2.next();
                        if (((SpecialRegistrationInterface.Change)ch).errors == null) continue;
                        block27: for (SpecialRegistrationInterface.ChangeError err : ((SpecialRegistrationInterface.Change)ch).errors) {
                            if ("TIME".equals(err.code)) {
                                ret.setHasTimeConflict(true);
                            }
                            if ("CLOS".equals(err.code)) {
                                ret.setHasSpaceConflict(true);
                            }
                            if ("CORQ".equals(err.code)) {
                                ret.setHasLinkedConflict(true);
                            }
                            if (err.code != null && err.code.startsWith("EX-")) {
                                ret.setExtended(true);
                            }
                            if ("MAXI".equals(err.code) && maxi != null) continue;
                            message = err.message;
                            switch (this.getStatus(((SpecialRegistrationInterface.Change)ch).status)) {
                                case Approved: {
                                    message = "Approved: " + message;
                                    if (!excludeApprovedOrRejected) break;
                                    continue block27;
                                }
                                case Rejected: {
                                    message = "Denied: " + message;
                                    if (!excludeApprovedOrRejected) break;
                                    continue block27;
                                }
                            }
                            if (SpecialRegistrationHelper.hasLastNote((SpecialRegistrationInterface.Change)ch)) {
                                message = message + "\n  <span class='note'>" + SpecialRegistrationHelper.getLastNote((SpecialRegistrationInterface.Change)ch) + "</span>";
                            }
                            if ((additionalMessage = ApplicationProperties.getProperty("purdue.specreg.note." + err.code + "." + (((SpecialRegistrationInterface.Change)ch).status == SpecialRegistrationInterface.ChangeStatus.approved && specialRequest.completionStatus == SpecialRegistrationInterface.CompletionStatus.completed ? "completed" : ((SpecialRegistrationInterface.Change)ch).status))) != null && !additionalMessage.isEmpty()) {
                                if (additionalMessage.contains("{course}")) {
                                    additionalMessage = additionalMessage.replace("{course}", ((SpecialRegistrationInterface.Change)ch).subject + " " + ((SpecialRegistrationInterface.Change)ch).courseNbr);
                                }
                                if (additionalMessage.contains("{crn}") && ((SpecialRegistrationInterface.Change)ch).crn != null) {
                                    additionalMessage = additionalMessage.replace("{crn}", ((SpecialRegistrationInterface.Change)ch).crn);
                                }
                                if (additionalMessage.contains("{currentGradeMode}") && ((SpecialRegistrationInterface.Change)ch).currentGradeMode != null) {
                                    additionalMessage = additionalMessage.replace("{currentGradeMode}", ((SpecialRegistrationInterface.Change)ch).currentGradeMode);
                                }
                                if (additionalMessage.contains("{selectedGradeMode}") && ((SpecialRegistrationInterface.Change)ch).selectedGradeMode != null) {
                                    additionalMessage = additionalMessage.replace("{selectedGradeMode}", ((SpecialRegistrationInterface.Change)ch).selectedGradeMode);
                                }
                                if (additionalMessage.contains("{selectedCreditHour}") && ((SpecialRegistrationInterface.Change)ch).selectedCreditHour != null) {
                                    additionalMessage = additionalMessage.replace("{selectedCreditHour}", ((SpecialRegistrationInterface.Change)ch).selectedCreditHour);
                                }
                                if (additionalMessage.contains("{currentCreditHour}") && ((SpecialRegistrationInterface.Change)ch).currentCreditHour != null) {
                                    additionalMessage = additionalMessage.replace("{currentCreditHour}", ((SpecialRegistrationInterface.Change)ch).currentCreditHour);
                                }
                                additionalMessages.add(additionalMessage);
                            }
                            if (((SpecialRegistrationInterface.Change)ch).status != null) {
                                message = "<span class='" + (Object)((Object)((SpecialRegistrationInterface.Change)ch).status) + "'>" + message + "</span>";
                            }
                            ca.addError(message);
                            if (this.isPending(((SpecialRegistrationInterface.Change)ch).status)) {
                                ret.addError(new ClassAssignmentInterface.ErrorMessage(((SpecialRegistrationInterface.Change)ch).subject + " " + ((SpecialRegistrationInterface.Change)ch).courseNbr, ((SpecialRegistrationInterface.Change)ch).crn, err.code, err.message));
                            }
                            ca.setPinned(true);
                        }
                    }
                    if (!drops.containsKey(course) && !keeps.contains(course) && maxStatus != null && maxi != null && clazz.getSchedulingSubpart().getParentSubpart() == null) {
                        boolean first = true;
                        for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
                            if (ss.getParentSubpart() != null || ss.getItype().getItype() >= clazz.getSchedulingSubpart().getItype().getItype()) continue;
                            first = false;
                            break;
                        }
                        if (first) {
                            String additionalMessage2;
                            String message2 = maxi;
                            switch (this.getStatus(maxStatus)) {
                                case Approved: {
                                    message2 = "Approved: " + message2;
                                    if (!excludeApprovedOrRejected) break;
                                    continue block21;
                                }
                                case Rejected: {
                                    message2 = "Denied: " + message2;
                                    if (!excludeApprovedOrRejected) break;
                                    continue block21;
                                }
                            }
                            if (maxiNote != null && !maxiNote.toString().isEmpty()) {
                                message2 = message2 + "\n  <span class='note'>" + maxiNote.trim() + "</span>";
                            }
                            if ((additionalMessage2 = ApplicationProperties.getProperty("purdue.specreg.note.MAXI." + (maxStatus == SpecialRegistrationInterface.ChangeStatus.approved && specialRequest.completionStatus == SpecialRegistrationInterface.CompletionStatus.completed ? "completed" : maxStatus))) != null && !additionalMessage2.isEmpty()) {
                                if (additionalMessage2.contains("{course}")) {
                                    additionalMessage2 = additionalMessage2.replace("{course}", ca.getCourseName());
                                }
                                additionalMessages.add(additionalMessage2);
                            }
                            if (maxStatus != null) {
                                message2 = "<span class='" + (Object)((Object)maxStatus) + "'>" + message2 + "</span>";
                            }
                            ca.addError(message2);
                            if (ca.getSpecRegStatus() == null) {
                                ca.setSpecRegStatus(this.getStatus(maxStatus));
                            }
                            if (this.isPending(maxStatus)) {
                                ret.addError(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), "", "MAXI", maxi));
                            }
                        }
                    }
                    ret.addChange(ca);
                }
            }
            if (drops.containsKey(course)) {
                for (Class_ clazz : (Set)drops.get(course)) {
                    ca = new ClassAssignmentInterface.ClassAssignment();
                    change = (List)changes.get(clazz);
                    ca.setSpecRegOperation(SpecialRegistrationInterface.SpecialRegistrationOperation.Drop);
                    s = null;
                    for (SpecialRegistrationInterface.Change ch : change) {
                        if (ch.status == null) continue;
                        s = this.combine(s, this.getStatus(ch.status));
                    }
                    ca.setSpecRegStatus(s);
                    ca.setCourseId(course.getUniqueId());
                    ca.setSubject(course.getSubjectAreaAbbv());
                    ca.setCourseNbr(course.getCourseNbr());
                    ca.setCourseAssigned(false);
                    ca.setTitle(course.getTitle());
                    ca.setClassId(clazz.getUniqueId());
                    ca.setSection(clazz.getClassSuffix(course));
                    if (ca.getSection() == null) {
                        ca.setSection(clazz.getSectionNumberString(helper.getHibSession()));
                    }
                    ca.setClassNumber(clazz.getSectionNumberString(helper.getHibSession()));
                    ca.setSubpart(clazz.getSchedulingSubpart().getItypeDesc().trim());
                    ca.setExternalId(clazz.getExternalId(course));
                    if (clazz.getParentClass() != null) {
                        ca.setParentSection(clazz.getParentClass().getClassSuffix(course));
                        if (ca.getParentSection() == null) {
                            ca.setParentSection(clazz.getParentClass().getSectionNumberString(helper.getHibSession()));
                        }
                    }
                    if (clazz.getSchedulePrintNote() != null) {
                        ca.addNote(clazz.getSchedulePrintNote());
                    }
                    placement = clazz.getCommittedAssignment() == null ? null : clazz.getCommittedAssignment().getPlacement();
                    minLimit = clazz.getExpectedCapacity();
                    limit = maxLimit = clazz.getMaxExpectedCapacity().intValue();
                    if (minLimit < maxLimit && placement != null) {
                        int roomLimit = (int)Math.floor((float)placement.getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                        limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                    }
                    if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                        limit = -1;
                    }
                    ca.setCancelled(clazz.isCancelled());
                    ca.setLimit(new int[]{clazz.getEnrollment(), limit});
                    if (placement != null) {
                        if (placement.getTimeLocation() != null) {
                            for (DayCode d : DayCode.toDayCodes(placement.getTimeLocation().getDayCode())) {
                                ca.addDay(d.getIndex());
                            }
                            ca.setStart(placement.getTimeLocation().getStartSlot());
                            ca.setLength(placement.getTimeLocation().getLength());
                            ca.setBreakTime(placement.getTimeLocation().getBreakTime());
                            ca.setDatePattern(placement.getTimeLocation().getDatePatternName());
                        }
                        if (clazz.getCommittedAssignment() != null) {
                            for (Location loc : clazz.getCommittedAssignment().getRooms()) {
                                ca.addRoom(loc.getUniqueId(), loc.getLabelWithDisplayName());
                            }
                        }
                    }
                    if (clazz.getDisplayInstructor().booleanValue()) {
                        for (ClassInstructor ci : clazz.getClassInstructors()) {
                            if (!ci.isLead().booleanValue()) continue;
                            ca.addInstructor(nameFormat.format(ci.getInstructor()));
                            ca.addInstructoEmail(ci.getInstructor().getEmail() == null ? "" : ci.getInstructor().getEmail());
                        }
                    }
                    if (credit != null && gs != null && gs.isGradableSubpart(clazz.getSchedulingSubpart(), course, helper.getHibSession())) {
                        ca.setCredit(credit.creditAbbv() + "|" + credit.creditText());
                        ca.setCreditRange(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                        credit = null;
                    } else if (credit != null && gs == null) {
                        ca.setCredit(credit.creditAbbv() + "|" + credit.creditText());
                        ca.setCreditRange(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                        credit = null;
                    }
                    if (clazz.getSchedulingSubpart().getCredit() != null) {
                        ca.setCredit(clazz.getSchedulingSubpart().getCredit().creditAbbv() + "|" + clazz.getSchedulingSubpart().getCredit().creditText());
                        ca.setCreditRange(Float.valueOf(clazz.getSchedulingSubpart().getCredit().getMinCredit()), Float.valueOf(clazz.getSchedulingSubpart().getCredit().getMaxCredit()));
                        credit = null;
                    }
                    if ((creditOverride = clazz.getCredit(course)) != null) {
                        ca.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                    }
                    if (ca.getParentSection() == null) {
                        ca.setParentSection(course.getConsentType() == null ? null : course.getConsentType().getLabel());
                    }
                    for (Object ch : change) {
                        if (((SpecialRegistrationInterface.Change)ch).errors == null) continue;
                        block35: for (SpecialRegistrationInterface.ChangeError err : ((SpecialRegistrationInterface.Change)ch).errors) {
                            if ("TIME".equals(err.code)) {
                                ret.setHasTimeConflict(true);
                            }
                            if ("CLOS".equals(err.code)) {
                                ret.setHasSpaceConflict(true);
                            }
                            if (err.code != null && err.code.startsWith("EX-")) {
                                ret.setExtended(true);
                            }
                            if ("MAXI".equals(err.code) && maxi != null) continue;
                            message = err.message;
                            switch (this.getStatus(((SpecialRegistrationInterface.Change)ch).status)) {
                                case Approved: {
                                    message = "Approved: " + message;
                                    if (!excludeApprovedOrRejected) break;
                                    continue block35;
                                }
                                case Rejected: {
                                    message = "Denied: " + message;
                                    if (!excludeApprovedOrRejected) break;
                                    continue block35;
                                }
                            }
                            if (SpecialRegistrationHelper.hasLastNote((SpecialRegistrationInterface.Change)ch)) {
                                message = message + "\n  <span class='note'>" + SpecialRegistrationHelper.getLastNote((SpecialRegistrationInterface.Change)ch) + "</span>";
                            }
                            if ((additionalMessage = ApplicationProperties.getProperty("purdue.specreg.note." + err.code + "." + (((SpecialRegistrationInterface.Change)ch).status == SpecialRegistrationInterface.ChangeStatus.approved && specialRequest.completionStatus == SpecialRegistrationInterface.CompletionStatus.completed ? "completed" : ((SpecialRegistrationInterface.Change)ch).status))) != null && !additionalMessage.isEmpty()) {
                                if (additionalMessage.contains("{course}")) {
                                    additionalMessage = additionalMessage.replace("{course}", ((SpecialRegistrationInterface.Change)ch).subject + " " + ((SpecialRegistrationInterface.Change)ch).courseNbr);
                                }
                                if (additionalMessage.contains("{crn}") && ((SpecialRegistrationInterface.Change)ch).crn != null) {
                                    additionalMessage = additionalMessage.replace("{crn}", ((SpecialRegistrationInterface.Change)ch).crn);
                                }
                                if (additionalMessage.contains("{currentGradeMode}") && ((SpecialRegistrationInterface.Change)ch).currentGradeMode != null) {
                                    additionalMessage = additionalMessage.replace("{currentGradeMode}", ((SpecialRegistrationInterface.Change)ch).currentGradeMode);
                                }
                                if (additionalMessage.contains("{selectedGradeMode}") && ((SpecialRegistrationInterface.Change)ch).selectedGradeMode != null) {
                                    additionalMessage = additionalMessage.replace("{selectedGradeMode}", ((SpecialRegistrationInterface.Change)ch).selectedGradeMode);
                                }
                                additionalMessages.add(additionalMessage);
                            }
                            if (((SpecialRegistrationInterface.Change)ch).status != null) {
                                message = "<span class='" + (Object)((Object)((SpecialRegistrationInterface.Change)ch).status) + "'>" + message + "</span>";
                            }
                            ca.addError(message);
                            ca.setPinned(true);
                            if (!this.isPending(((SpecialRegistrationInterface.Change)ch).status)) continue;
                            ret.addError(new ClassAssignmentInterface.ErrorMessage(((SpecialRegistrationInterface.Change)ch).subject + " " + ((SpecialRegistrationInterface.Change)ch).courseNbr, ((SpecialRegistrationInterface.Change)ch).crn, err.code, err.message));
                        }
                    }
                    ret.addChange(ca);
                }
            }
            if (additionalMessages.isEmpty() || !ret.hasChanges()) continue;
            ClassAssignmentInterface.ClassAssignment ca2 = ret.getChanges().get(ret.getChanges().size() - 1);
            for (String message3 : additionalMessages) {
                message3 = "<span class='note'>" + message3 + "</span>";
                ca2.addError(message3);
            }
        }
        ret.setDescription(desc);
        ret.setRequestId(specialRequest.regRequestId);
        ret.setSubmitDate(specialRequest.dateCreated == null ? new Date() : specialRequest.dateCreated.toDate());
        ret.setNote(specialRequest.requestorNotes);
        ret.setStatus(this.getStatus(specialRequest));
        ret.setCanCancel(this.canCancel(specialRequest));
        if (!ret.hasChanges() && maxi != null) {
            String message = maxi;
            switch (this.getStatus(maxStatus)) {
                case Approved: {
                    message = "Approved: " + message;
                    break;
                }
                case Rejected: {
                    message = "Denied: " + message;
                }
            }
            if (maxiNote != null && !maxiNote.toString().isEmpty()) {
                message = message + "\n  <span class='note'>" + maxiNote.trim() + "</span>";
            }
            if (maxStatus != null) {
                message = "<span class='" + (Object)((Object)maxStatus) + "'>" + message + "</span>";
            }
            ret.addError(new ClassAssignmentInterface.ErrorMessage("", "", "MAXI", message));
        }
        return ret;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    @Override
    public List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> retrieveAllRegistrations(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) throws SectioningException {
        if (student == null) {
            return null;
        }
        if (!this.isSpecialRegistrationEnabled(server, helper, student)) {
            return null;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t1 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t1);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
            if (this.isUpdateUniTimeStatuses() && response.data != null && ((SpecialRegistrationInterface.SpecialRegistrationStatus)response.data).requests != null && !((SpecialRegistrationInterface.SpecialRegistrationStatus)response.data).requests.isEmpty()) {
                boolean studentChanged = false;
                HashSet<String> requestIds = new HashSet<String>();
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)response.data).requests) {
                    requestIds.add(r.regRequestId);
                    if (r.maxCredit != null) {
                        SpecialRegistrationInterface.ChangeStatus maxiStatus = null;
                        if (r.changes != null) {
                            for (SpecialRegistrationInterface.Change change : r.changes) {
                                if (change.crn != null || change.errors == null) continue;
                                for (SpecialRegistrationInterface.ChangeError e : change.errors) {
                                    if (!"MAXI".equals(e.code)) continue;
                                    maxiStatus = change.status;
                                }
                            }
                        }
                        if (student.getMaxCreditOverride() != null && r.regRequestId.equals(student.getMaxCreditOverride().getExternalId()) && student.getMaxCreditOverride().getStatus() != (maxiStatus != null ? this.toStatus(maxiStatus) : this.toStatus(r))) {
                            student.getMaxCreditOverride().setStatus(maxiStatus != null ? this.toStatus(maxiStatus) : this.toStatus(r));
                            Student dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
                            if (dbStudent != null) {
                                dbStudent.setOverrideStatus(maxiStatus != null ? this.toStatus(maxiStatus) : this.toStatus(r));
                                helper.getHibSession().update((Object)dbStudent);
                            }
                            studentChanged = true;
                        }
                    }
                    if (r.changes == null) continue;
                    HashMap<String, SpecialRegistrationInterface.SpecialRegistrationStatus> course2status = new HashMap<String, SpecialRegistrationInterface.SpecialRegistrationStatus>();
                    for (SpecialRegistrationInterface.Change change : r.changes) {
                        if (change.subject == null || change.courseNbr == null || change.errors == null || change.errors.isEmpty()) continue;
                        String course = change.subject + " " + change.courseNbr;
                        if (change.status != null) {
                            SpecialRegistrationInterface.SpecialRegistrationStatus s = (SpecialRegistrationInterface.SpecialRegistrationStatus)course2status.get(course);
                            course2status.put(course, s == null ? this.getStatus(change.status) : this.combine(s, this.getStatus(change.status)));
                            continue;
                        }
                        for (SpecialRegistrationInterface.ChangeError e : change.errors) {
                            if (!"MAXI".equals(e.code)) continue;
                            SpecialRegistrationInterface.SpecialRegistrationStatus s = (SpecialRegistrationInterface.SpecialRegistrationStatus)course2status.get(course);
                            course2status.put(course, s == null ? this.getCreditStatus(r) : this.combine(s, this.getCreditStatus(r)));
                        }
                    }
                    for (Map.Entry entry : course2status.entrySet()) {
                        XCourseId id;
                        XOverride override;
                        XCourseRequest cr = student.getRequestForCourseName((String)entry.getKey());
                        if (cr == null || (override = cr.getOverride(id = cr.getCourseName((String)entry.getKey()))) == null || !r.regRequestId.equals(override.getExternalId()) || this.toStatus((SpecialRegistrationInterface.SpecialRegistrationStatus)entry.getValue()) == override.getStatus().intValue()) continue;
                        override.setStatus(this.toStatus((SpecialRegistrationInterface.SpecialRegistrationStatus)entry.getValue()));
                        CourseDemand dbCourseDemand = (CourseDemand)CourseDemandDAO.getInstance().get(cr.getRequestId(), helper.getHibSession());
                        if (dbCourseDemand != null) {
                            for (CourseRequest dbCourseRequest : dbCourseDemand.getCourseRequests()) {
                                if (!dbCourseRequest.getCourseOffering().getUniqueId().equals(id.getCourseId())) continue;
                                dbCourseRequest.setOverrideStatus(this.toStatus((SpecialRegistrationInterface.SpecialRegistrationStatus)entry.getValue()));
                                helper.getHibSession().update((Object)dbCourseRequest);
                            }
                        }
                        studentChanged = true;
                    }
                }
                if (student.getMaxCreditOverride() != null && !requestIds.contains(student.getMaxCreditOverride().getExternalId())) {
                    student.setMaxCreditOverride(null);
                    Student dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
                    if (dbStudent != null) {
                        dbStudent.setOverrideStatus(null);
                        dbStudent.setOverrideMaxCredit(null);
                        dbStudent.setOverrideExternalId(null);
                        dbStudent.setOverrideTimeStamp(null);
                        helper.getHibSession().update((Object)dbStudent);
                    }
                    studentChanged = true;
                }
                for (XRequest request : student.getRequests()) {
                    XCourseRequest cr;
                    if (!(request instanceof XCourseRequest) || !(cr = (XCourseRequest)request).hasOverrides()) continue;
                    Iterator<Map.Entry<XCourseId, XOverride>> i = cr.getOverrides().entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry<XCourseId, XOverride> entry = i.next();
                        if (requestIds.contains(entry.getValue().getExternalId())) continue;
                        i.remove();
                        CourseDemand dbCourseDemand = (CourseDemand)CourseDemandDAO.getInstance().get(cr.getRequestId(), helper.getHibSession());
                        if (dbCourseDemand != null) {
                            for (CourseRequest dbCourseRequest : dbCourseDemand.getCourseRequests()) {
                                if (!dbCourseRequest.getCourseOffering().getUniqueId().equals(entry.getKey().getCourseId())) continue;
                                dbCourseRequest.setOverrideStatus(null);
                                dbCourseRequest.setOverrideExternalId(null);
                                dbCourseRequest.setOverrideTimeStamp(null);
                                dbCourseRequest.setOverrideIntent(null);
                                helper.getHibSession().update((Object)dbCourseRequest);
                            }
                        }
                        studentChanged = true;
                    }
                }
                if (studentChanged) {
                    server.update(student, false);
                    helper.getHibSession().flush();
                }
            }
            if (response != null && SpecialRegistrationInterface.ResponseStatus.success == response.status && response.data != null && ((SpecialRegistrationInterface.SpecialRegistrationStatus)response.data).requests != null) {
                ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> ret = new ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>(((SpecialRegistrationInterface.SpecialRegistrationStatus)response.data).requests.size());
                for (SpecialRegistrationInterface.SpecialRegistration specialRequest : ((SpecialRegistrationInterface.SpecialRegistrationStatus)response.data).requests) {
                    if (specialRequest.regRequestId == null || this.isCancelled(specialRequest)) continue;
                    ret.add(this.convert(server, helper, student, specialRequest, false));
                }
                ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> arrayList = ret;
                return arrayList;
            }
            ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> arrayList = new ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>();
            return arrayList;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean isCanChangeNote() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.canChangeNote", "true"));
    }

    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, XStudent student) throws SectioningException {
        if (student == null || !this.isSpecialRegistrationEnabled(server, helper, student)) {
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG, false);
            return;
        }
        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_CHANGE_NOTE, this.isCanChangeNote());
        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) && !"true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.allowExtended", "false"))) {
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG, false);
            return;
        }
        ClientResource resource = null;
        try {
            Gson gson = this.getGson(helper);
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t1 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
            SpecialRegistrationInterface.CheckEligibilityResponse response = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
            check.setOverrideRequestDisclaimer(ApplicationProperties.getProperty("purdue.specreg.disclaimer"));
            if (response != null && SpecialRegistrationInterface.ResponseStatus.success == response.status) {
                boolean eligible = true;
                if (response.data == null || ((SpecialRegistrationInterface.SpecialRegistrationEligibility)response.data).eligible == null || !((SpecialRegistrationInterface.SpecialRegistrationEligibility)response.data).eligible.booleanValue()) {
                    eligible = false;
                }
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG, eligible);
                if (eligible) {
                    check.setOverrides(response.overrides);
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_TIME_CONF, check.hasOverride("TIME"));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_LIMIT_CONF, check.hasOverride("CLOS"));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_LINK_CONF, check.hasOverride("CORQ"));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_EXTENDED, check.hasOverride("EX-ADD") || check.hasOverride("EX-DROP"));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_CHANGE_GRADE_MODE, check.hasOverride("GMODE"));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_CHANGE_VAR_CREDIT, check.hasOverride("VARCR"));
                }
            } else {
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG, false);
            }
            if (response.hasNonCanceledRequest != null && response.hasNonCanceledRequest.booleanValue()) {
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.HAS_SPECREG, true);
            }
            String pin = null;
            if (response.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)response.data).PIN != null && !((SpecialRegistrationInterface.SpecialRegistrationEligibility)response.data).PIN.isEmpty() && !"NA".equals(((SpecialRegistrationInterface.SpecialRegistrationEligibility)response.data).PIN)) {
                pin = ((SpecialRegistrationInterface.SpecialRegistrationEligibility)response.data).PIN;
            }
            Float maxCredit = null;
            if (response.maxCredit != null && response.maxCredit.floatValue() > 0.0f) {
                maxCredit = response.maxCredit;
            }
            if (student.getStudentId() != null && (maxCredit != null && !maxCredit.equals(student.getMaxCredit()) || pin != null && !pin.equals(student.getPin()))) {
                Student dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
                if (dbStudent != null) {
                    if (maxCredit != null) {
                        dbStudent.setMaxCredit(maxCredit);
                    }
                    if (pin != null) {
                        dbStudent.setPin(pin);
                    }
                    helper.getHibSession().update((Object)dbStudent);
                    helper.getHibSession().flush();
                }
                if (maxCredit != null) {
                    student.setMaxCredit(maxCredit);
                }
                if (pin != null) {
                    student.setPin(pin);
                }
                server.update(student, false);
            }
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean isSpecialRegistrationEnabled(Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.specreg);
    }

    protected boolean isSpecialRegistrationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        if (student == null) {
            return false;
        }
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.specreg);
    }

    @Override
    public SpecialRegistrationInterface.CancelSpecialRegistrationResponse cancelRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.CancelSpecialRegistrationRequest request) throws SectioningException {
        ClientResource resource = null;
        try {
            Gson gson = this.getGson(helper);
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCancelSpecialRegistration());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("regRequestId", request.getRequestId());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            helper.getAction().addOptionBuilder().setKey("regRequestId").setValue(request.getRequestId());
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t1 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
            SpecialRegistrationInterface.SpecialRegistrationCancelResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationCancelResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationCancelResponse.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
            SpecialRegistrationInterface.CancelSpecialRegistrationResponse ret = new SpecialRegistrationInterface.CancelSpecialRegistrationResponse();
            if (response != null) {
                ret.setSuccess(SpecialRegistrationInterface.ResponseStatus.success == response.status);
                ret.setMessage(response.message);
            }
            if (this.isUpdateUniTimeStatuses() && ret.isSuccess()) {
                boolean studentChanged = false;
                if (student.getMaxCreditOverride() != null && request.getRequestId().equals(student.getMaxCreditOverride().getExternalId())) {
                    XOverride override = student.getMaxCreditOverride();
                    student.setMaxCreditOverride(new XOverride(override.getExternalId(), override.getTimeStamp(), CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()));
                    Student dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
                    if (dbStudent != null) {
                        dbStudent.setOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal());
                        helper.getHibSession().update((Object)dbStudent);
                    }
                    studentChanged = true;
                }
                for (XRequest xr : student.getRequests()) {
                    XCourseRequest cr;
                    if (!(xr instanceof XCourseRequest) || !(cr = (XCourseRequest)xr).hasOverrides()) continue;
                    for (Map.Entry<XCourseId, XOverride> e : cr.getOverrides().entrySet()) {
                        if (!request.getRequestId().equals(e.getValue().getExternalId())) continue;
                        e.getValue().setStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal());
                        CourseDemand dbCourseDemand = (CourseDemand)CourseDemandDAO.getInstance().get(cr.getRequestId(), helper.getHibSession());
                        if (dbCourseDemand != null) {
                            for (CourseRequest dbCourseRequest : dbCourseDemand.getCourseRequests()) {
                                if (!dbCourseRequest.getCourseOffering().getUniqueId().equals(e.getKey().getCourseId())) continue;
                                dbCourseRequest.setOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal());
                                helper.getHibSession().update((Object)dbCourseRequest);
                            }
                        }
                        studentChanged = true;
                    }
                }
                if (studentChanged) {
                    server.update(student, false);
                    helper.getHibSession().flush();
                }
            }
            SpecialRegistrationInterface.CancelSpecialRegistrationResponse cancelSpecialRegistrationResponse = ret;
            return cancelSpecialRegistrationResponse;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected String getBannerSite() {
        return ApplicationProperties.getProperty("banner.xe.site");
    }

    protected String getBannerUser(boolean admin) {
        String user;
        if (admin && (user = ApplicationProperties.getProperty("banner.xe.admin.user")) != null) {
            return user;
        }
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword(boolean admin) {
        String pwd;
        if (admin && (pwd = ApplicationProperties.getProperty("banner.xe.admin.password")) != null) {
            return pwd;
        }
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getAdminParameter() {
        return ApplicationProperties.getProperty("banner.xe.adminParameter", "persona");
    }

    @Override
    public SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse retrieveAvailableGradeModes(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) throws SectioningException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckStudentGradeModes());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t1 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t1);
            SpecialRegistrationInterface.SpecialRegistrationCheckGradeModesResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationCheckGradeModesResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationCheckGradeModesResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)response));
            if (SpecialRegistrationInterface.ResponseStatus.success != response.status || response.data == null) {
                throw new SectioningException(response.message == null || response.message.isEmpty() ? "Failed to check availabel grade modes." : response.message);
            }
            SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse ret = new SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse();
            ret.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationCheckGradeModes)response.data).maxCredit);
            ret.setCurrentCredit(((SpecialRegistrationInterface.SpecialRegistrationCheckGradeModes)response.data).currentCredit);
            String honorsGradeMode = this.getResetGradeModesRegExp();
            if (((SpecialRegistrationInterface.SpecialRegistrationCheckGradeModes)response.data).gradingModes != null) {
                for (SpecialRegistrationInterface.SpecialRegistrationCurrentGradeMode m : ((SpecialRegistrationInterface.SpecialRegistrationCheckGradeModes)response.data).gradingModes) {
                    SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges mode = new SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges();
                    mode.setCurrentGradeMode(new SpecialRegistrationInterface.SpecialRegistrationGradeMode(m.gradingMode, m.gradingModeDescription, honorsGradeMode != null && !honorsGradeMode.isEmpty() && m.gradingMode.matches(honorsGradeMode)));
                    if (m.availableGradingModes != null) {
                        for (SpecialRegistrationInterface.SpecialRegistrationAvailableGradeMode av : m.availableGradingModes) {
                            SpecialRegistrationInterface.SpecialRegistrationGradeMode availableMode = new SpecialRegistrationInterface.SpecialRegistrationGradeMode(av.gradingMode, av.gradingModeDescription, honorsGradeMode != null && !honorsGradeMode.isEmpty() && av.gradingMode.matches(honorsGradeMode));
                            availableMode.setOriginalGradeMode(m.gradingMode);
                            if (av.approvals != null) {
                                for (String ap : av.approvals) {
                                    availableMode.addApproval(ap);
                                }
                            }
                            availableMode.setDisclaimer(ApplicationProperties.getProperty("purdue.specreg.gradeModeDisclaimer." + av.gradingMode));
                            mode.addAvailableChange(availableMode);
                        }
                    }
                    ret.add(m.crn, mode);
                }
            }
            if (((SpecialRegistrationInterface.SpecialRegistrationCheckGradeModes)response.data).varCredits != null) {
                for (SpecialRegistrationInterface.SpecialRegistrationVariableCredit v : ((SpecialRegistrationInterface.SpecialRegistrationCheckGradeModes)response.data).varCredits) {
                    SpecialRegistrationInterface.SpecialRegistrationVariableCreditChange change = new SpecialRegistrationInterface.SpecialRegistrationVariableCreditChange();
                    if (v.approvals != null) {
                        for (String ap : v.approvals) {
                            change.addApproval(ap);
                        }
                    }
                    Float min = Float.valueOf(Float.parseFloat(v.creditHrLow));
                    Float max = Float.valueOf(Float.parseFloat(v.creditHrHigh));
                    if ("OR".equalsIgnoreCase(v.creditHrInd)) {
                        change.addAvailableCredit(min);
                        change.addAvailableCredit(max);
                    } else {
                        for (float c = min.floatValue(); c <= max.floatValue() + 0.001f; c += 1.0f) {
                            change.addAvailableCredit(Float.valueOf(c));
                        }
                    }
                    ret.add(v.crn, change);
                }
            }
            Iterator<SpecialRegistrationInterface.SpecialRegistrationVariableCredit> iterator = ret;
            return iterator;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public SpecialRegistrationInterface.ChangeGradeModesResponse changeGradeModes(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.ChangeGradeModesRequest request) throws SectioningException {
        float cred;
        SpecialRegistrationInterface.ChangeGradeModesResponse ret;
        block82: {
            ret = new SpecialRegistrationInterface.ChangeGradeModesResponse();
            float f = cred = request.getCurrentCredit() == null ? 0.0f : request.getCurrentCredit().floatValue();
            if (request.hasCreditChanges() && request.getMaxCredit() != null) {
                float app = 0.0f;
                for (SpecialRegistrationInterface.SpecialRegistrationCreditChange ch : request.getCreditChanges()) {
                    if (!ch.hasApprovals()) {
                        float f2 = ch.getCredit() == null ? 0.0f : ch.getCredit().floatValue();
                        float f3 = ch.getOriginalCredit() == null ? 0.0f : ch.getOriginalCredit().floatValue();
                        if (!((cred += f2 - f3) > request.getMaxCredit().floatValue())) continue;
                        ch.addApproval("MAXI");
                        continue;
                    }
                    app += (ch.getCredit() == null ? 0.0f : ch.getCredit().floatValue()) - (ch.getOriginalCredit() == null ? 0.0f : ch.getOriginalCredit().floatValue());
                }
                cred += app;
            }
            if (request.hasGradeModeChanges(false) || request.hasCreditChanges(false)) {
                ClientResource resource = null;
                try {
                    resource = new ClientResource(this.getBannerSite());
                    resource.setNext((Uniform)this.iClient);
                    resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(true), this.getBannerPassword(true));
                    Gson gson = this.getGson(helper);
                    XEInterface.RegisterResponse original = null;
                    Iterator<SpecialRegistrationInterface.SpecialRegistrationCreditChange> term = this.getBannerTerm(server.getAcademicSession());
                    resource.addQueryParameter("term", (String)((Object)term));
                    resource.addQueryParameter("bannerId", this.getBannerId(student));
                    helper.getAction().addOptionBuilder().setKey("term").setValue((String)((Object)term));
                    helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                    String string = this.getAdminParameter();
                    resource.addQueryParameter(string, "SB");
                    helper.getAction().addOptionBuilder().setKey(string).setValue("SB");
                    HashMap<String, String> code2desc = new HashMap<String, String>();
                    long t0 = System.currentTimeMillis();
                    try {
                        resource.get(MediaType.APPLICATION_JSON);
                    }
                    catch (ResourceException exception) {
                        helper.getAction().setApiException(exception.getMessage());
                        try {
                            XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                            helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                            XEInterface.Error error = response.getError();
                            if (error != null && error.message != null) {
                                throw new SectioningException(error.message);
                            }
                            if (error != null && error.description != null) {
                                throw new SectioningException(error.description);
                            }
                            if (error != null && error.errorMessage != null) {
                                throw new SectioningException(error.errorMessage);
                            }
                            throw exception;
                        }
                        catch (SectioningException e) {
                            helper.getAction().setApiException(e.getMessage());
                            throw e;
                        }
                        catch (Throwable t) {
                            throw exception;
                        }
                    }
                    finally {
                        helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                    }
                    List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                    helper.getAction().addOptionBuilder().setKey("xe_get_response").setValue(gson.toJson((Object)current));
                    if (current != null && !current.isEmpty()) {
                        original = (XEInterface.RegisterResponse)current.get(0);
                    }
                    if (original == null || !original.validStudent.booleanValue()) {
                        String reason = null;
                        if (original != null && original.failureReasons != null) {
                            for (String m : original.failureReasons) {
                                if (reason == null) {
                                    reason = m;
                                    continue;
                                }
                                reason = reason + "\n" + m;
                            }
                        }
                        if (reason == null || reason.isEmpty()) {
                            reason = "Failed to check student registration eligility.";
                        }
                        throw new SectioningException(reason);
                    }
                    XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(this.getBannerTerm(server.getAcademicSession()), this.getBannerId(student), null, true);
                    req.courseReferenceNumbers = new ArrayList<XEInterface.CourseReferenceNumber>();
                    req.actionsAndOptions = new ArrayList<XEInterface.RegisterAction>();
                    if (original.registrations != null) {
                        for (XEInterface.Registration reg : original.registrations) {
                            SpecialRegistrationInterface.SpecialRegistrationCreditChange credit;
                            if (!reg.isRegistered()) continue;
                            req.courseReferenceNumbers.add(new XEInterface.CourseReferenceNumber(reg.courseReferenceNumber));
                            SpecialRegistrationInterface.SpecialRegistrationGradeModeChange mode = request.getChange(reg.courseReferenceNumber);
                            XEInterface.RegisterAction action = new XEInterface.RegisterAction(reg.courseReferenceNumber);
                            if (mode != null && !mode.hasApprovals()) {
                                boolean allowed = false;
                                if (reg.registrationGradingModes != null) {
                                    for (XEInterface.RegistrationGradingMode m : reg.registrationGradingModes) {
                                        if (!mode.getSelectedGradeMode().equals(m.gradingMode)) continue;
                                        allowed = true;
                                        break;
                                    }
                                }
                                if (!allowed) {
                                    throw new SectioningException(mode.getSelectedGradeModeDescription() + " is not allowed for " + reg.courseReferenceNumber + ".");
                                }
                                action.selectedGradingMode = mode.getSelectedGradeMode();
                                code2desc.put(mode.getSelectedGradeMode(), mode.getSelectedGradeModeDescription());
                            }
                            if ((credit = request.getCreditChange(reg.courseReferenceNumber)) != null && !credit.hasApprovals()) {
                                action.selectedCreditHour = Formats.getNumberFormat("0.#").format(credit.getCredit());
                            }
                            if (action.selectedCreditHour == null && action.selectedGradingMode == null) continue;
                            req.actionsAndOptions.add(action);
                        }
                    }
                    if (req.actionsAndOptions.isEmpty()) break block82;
                    helper.getAction().addOptionBuilder().setKey("xe_request").setValue(gson.toJson((Object)req));
                    long t1 = System.currentTimeMillis();
                    try {
                        resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(req));
                    }
                    catch (ResourceException exception) {
                        helper.getAction().setApiException(exception.getMessage());
                        try {
                            XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                            helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                            XEInterface.Error error = response.getError();
                            if (error != null && error.message != null) {
                                throw new SectioningException(error.message);
                            }
                            if (error != null && error.description != null) {
                                throw new SectioningException(error.description);
                            }
                            if (error != null && error.errorMessage != null) {
                                throw new SectioningException(error.errorMessage);
                            }
                            throw exception;
                        }
                        catch (SectioningException e) {
                            helper.getAction().setApiException(e.getMessage());
                            throw e;
                        }
                        catch (Throwable t) {
                            throw exception;
                        }
                    }
                    finally {
                        helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                    }
                    XEInterface.RegisterResponse response = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
                    if (helper.isDebugEnabled()) {
                        helper.debug("Response: " + gson.toJson((Object)response));
                    }
                    helper.getAction().addOptionBuilder().setKey("xe_response").setValue(gson.toJson((Object)response));
                    if (response == null || !response.validStudent.booleanValue()) {
                        String reason = null;
                        if (response != null && response.failureReasons != null) {
                            for (String m : response.failureReasons) {
                                if (reason == null) {
                                    reason = m;
                                    continue;
                                }
                                reason = reason + "\n" + m;
                            }
                        }
                        throw new SectioningException(reason == null ? "Failed to change grade modes." : reason);
                    }
                    if (response.registrations != null) {
                        String honorsGradeMode = this.getResetGradeModesRegExp();
                        for (XEInterface.Registration reg : response.registrations) {
                            if (!"Registered".equals(reg.statusDescription)) continue;
                            if (reg.gradingMode != null) {
                                String desc = (String)code2desc.get(reg.gradingMode);
                                ret.addGradeMode(reg.courseReferenceNumber, reg.gradingMode, desc != null ? desc : reg.gradingModeDescription, honorsGradeMode != null && !honorsGradeMode.isEmpty() && reg.gradingMode.matches(honorsGradeMode));
                            }
                            if (reg.creditHour == null) continue;
                            ret.addCreditHour(reg.courseReferenceNumber, reg.creditHour);
                        }
                    }
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(e.getMessage());
                }
                finally {
                    if (resource != null) {
                        if (resource.getResponse() != null) {
                            resource.getResponse().release();
                        }
                        resource.release();
                    }
                }
            }
        }
        if (request.hasGradeModeChanges(true) || request.hasCreditChanges(true)) {
            ClientResource resource = null;
            try {
                SpecialRegistrationInterface.SpecialRegistrationRequest req = new SpecialRegistrationInterface.SpecialRegistrationRequest();
                AcademicSessionInfo session = server.getAcademicSession();
                req.term = this.getBannerTerm(session);
                req.campus = this.getBannerCampus(session);
                req.studentId = this.getBannerId(student);
                req.changes = new ArrayList();
                if (request.getMaxCredit() != null && cred > request.getMaxCredit().floatValue()) {
                    req.maxCredit = Float.valueOf(cred);
                }
                for (SpecialRegistrationInterface.SpecialRegistrationGradeModeChange specialRegistrationGradeModeChange : request.getChanges()) {
                    if (!specialRegistrationGradeModeChange.hasApprovals()) continue;
                    String crns = null;
                    for (String crn : specialRegistrationGradeModeChange.getCRNs()) {
                        if (crns == null) {
                            crns = crn;
                            continue;
                        }
                        crns = crns + "," + crn;
                    }
                    SpecialRegistrationInterface.Change ch = new SpecialRegistrationInterface.Change();
                    ch.courseNbr = specialRegistrationGradeModeChange.getCourse();
                    ch.subject = specialRegistrationGradeModeChange.getSubject();
                    ch.crn = crns;
                    ch.operation = SpecialRegistrationInterface.ChangeOperation.CHGMODE;
                    ch.credit = specialRegistrationGradeModeChange.getCredit();
                    if (ch.credit != null && ch.credit.indexOf(124) > 0) {
                        ch.credit = ch.credit.substring(0, ch.credit.indexOf(124));
                    }
                    ch.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    ch.selectedGradeMode = specialRegistrationGradeModeChange.getSelectedGradeMode();
                    ch.selectedGradeModeDescription = specialRegistrationGradeModeChange.getSelectedGradeModeDescription();
                    ch.currentGradeMode = specialRegistrationGradeModeChange.getOriginalGradeMode();
                    SpecialRegistrationInterface.ChangeError err = new SpecialRegistrationInterface.ChangeError();
                    err.code = "GMODE";
                    err.message = "Grade Mode Change: " + specialRegistrationGradeModeChange.getSelectedGradeModeDescription();
                    ch.errors.add(err);
                    req.changes.add(ch);
                }
                for (SpecialRegistrationInterface.SpecialRegistrationCreditChange specialRegistrationCreditChange : request.getCreditChanges()) {
                    if (!specialRegistrationCreditChange.hasApprovals()) continue;
                    SpecialRegistrationInterface.Change ch = new SpecialRegistrationInterface.Change();
                    ch.courseNbr = specialRegistrationCreditChange.getCourse();
                    ch.subject = specialRegistrationCreditChange.getSubject();
                    ch.crn = specialRegistrationCreditChange.getCrn();
                    ch.operation = SpecialRegistrationInterface.ChangeOperation.CHGVARCR;
                    ch.selectedCreditHour = specialRegistrationCreditChange.getCredit().toString();
                    ch.currentCreditHour = specialRegistrationCreditChange.getOriginalCredit() == null ? null : specialRegistrationCreditChange.getOriginalCredit().toString();
                    ch.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    SpecialRegistrationInterface.ChangeError err = new SpecialRegistrationInterface.ChangeError();
                    err.code = "VARCR";
                    err.message = "Variable Credit Change: " + Formats.getNumberFormat("0.#").format(specialRegistrationCreditChange.getCredit());
                    ch.errors.add(err);
                    req.changes.add(ch);
                }
                req.mode = this.getSpecialRegistrationMode();
                if (helper.getUser() != null) {
                    req.requestorId = this.getRequestorId(helper.getUser());
                    req.requestorRole = this.getRequestorType(helper.getUser(), student);
                }
                req.requestorNotes = request.getNote();
                if (req.changes != null && !req.changes.isEmpty()) {
                    resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
                    resource.setNext((Uniform)this.iClient);
                    resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                    Gson gson = this.getGson(helper);
                    if (helper.isDebugEnabled()) {
                        helper.debug("Request: " + gson.toJson((Object)request));
                    }
                    helper.getAction().addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)req));
                    long l = System.currentTimeMillis();
                    resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(req));
                    helper.getAction().setApiPostTime(System.currentTimeMillis() - l);
                    SpecialRegistrationInterface.SpecialRegistrationResponseList response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
                    if (helper.isDebugEnabled()) {
                        helper.debug("Response: " + gson.toJson((Object)response));
                    }
                    helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                    if (response.data != null && !((List)response.data).isEmpty()) {
                        for (SpecialRegistrationInterface.SubmitRegistrationResponse r : (List)response.data) {
                            if (r.requestorNotes == null) {
                                r.requestorNotes = request.getNote();
                            }
                            if (r.changes != null) {
                                for (SpecialRegistrationInterface.Change ch : r.changes) {
                                    if (ch.errors == null || ch.errors.isEmpty() || ch.status != null) continue;
                                    ch.status = SpecialRegistrationInterface.ChangeStatus.inProgress;
                                }
                            }
                            ret.addRequest(this.convert(server, helper, student, r, false));
                        }
                    }
                    if (response.cancelledRequests != null) {
                        for (SpecialRegistrationInterface.CancelledRequest c : response.cancelledRequests) {
                            ret.addCancelRequestId(c.regRequestId);
                        }
                    }
                }
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
        return ret;
    }

    @Override
    public SpecialRegistrationInterface.UpdateSpecialRegistrationResponse updateRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.UpdateSpecialRegistrationRequest input) throws SectioningException {
        ClientResource resource = null;
        try {
            SpecialRegistrationInterface.SpecialRegistrationRequest request = new SpecialRegistrationInterface.SpecialRegistrationRequest();
            AcademicSessionInfo session = server.getAcademicSession();
            request.term = this.getBannerTerm(session);
            request.campus = this.getBannerCampus(session);
            request.studentId = this.getBannerId(student);
            request.regRequestId = input.getRequestId();
            SpecialRegistrationInterface.ApiMode apiMode = request.mode = input.isPreReg() ? SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode.validation", "PREREG")) : this.getSpecialRegistrationMode();
            if (helper.getUser() != null) {
                request.requestorId = this.getRequestorId(helper.getUser());
                request.requestorRole = this.getRequestorType(helper.getUser(), student);
            }
            request.requestorNotes = input.getNote();
            resource = new ClientResource(this.getSpecialRegistrationApiSiteUpdateRegistration());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Request: " + gson.toJson((Object)request));
            }
            helper.getAction().addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)request));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(request));
            helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
            SpecialRegistrationInterface.SpecialRegistrationUpdateResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationUpdateResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationUpdateResponse.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
            SpecialRegistrationInterface.UpdateSpecialRegistrationResponse ret = new SpecialRegistrationInterface.UpdateSpecialRegistrationResponse();
            if (response != null) {
                ret.setSuccess(SpecialRegistrationInterface.ResponseStatus.success == response.status);
                ret.setMessage(response.message);
            }
            SpecialRegistrationInterface.UpdateSpecialRegistrationResponse updateSpecialRegistrationResponse = ret;
            return updateSpecialRegistrationResponse;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean isDashboardEnabled(Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.specreg) || status.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean isDashboardEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        if (student == null) {
            return false;
        }
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.specreg) || dbStatus.hasOption(StudentSectioningStatus.Option.reqval);
    }

    @Override
    public String getDashboardUrl(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) throws SectioningException {
        String dash = this.getSpecialRegistrationDashboardUrl();
        if (dash != null && student != null && this.isDashboardEnabled(server, helper, student)) {
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            return dash.replace("{term}", term).replace("{campus}", campus).replace("{studentId}", this.getBannerId(student));
        }
        return null;
    }

    @Override
    public String getDashboardUrl(Student student) throws SectioningException {
        String dash = this.getSpecialRegistrationDashboardUrl();
        if (dash != null && student != null && this.isDashboardEnabled(student)) {
            AcademicSessionInfo session = new AcademicSessionInfo(student.getSession());
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            return dash.replace("{term}", term).replace("{campus}", campus).replace("{studentId}", this.getBannerId(student));
        }
        return null;
    }
}

