/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;

public class ListCourseOfferings
implements OnlineSectioningAction<Collection<ClassAssignmentInterface.CourseAssignment>> {
    private static final long serialVersionUID = 1L;
    protected String iQuery = null;
    protected Integer iLimit = null;
    protected CourseMatcher iMatcher = null;

    public ListCourseOfferings forQuery(String query) {
        this.iQuery = query;
        return this;
    }

    public ListCourseOfferings withLimit(Integer limit) {
        this.iLimit = limit;
        return this;
    }

    public ListCourseOfferings withMatcher(CourseMatcher matcher) {
        this.iMatcher = matcher;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClassAssignmentInterface.CourseAssignment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            List<ClassAssignmentInterface.CourseAssignment> list = this.listCourses(server, helper);
            return list;
        }
        finally {
            lock.release();
        }
    }

    protected List<ClassAssignmentInterface.CourseAssignment> listCourses(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        List<ClassAssignmentInterface.CourseAssignment> ret = this.customCourseLookup(server, helper);
        if (ret != null && !ret.isEmpty()) {
            return ret;
        }
        ret = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
        for (XCourseId xCourseId : server.findCourses(this.iQuery, this.iLimit, this.iMatcher)) {
            XCourse course = server.getCourse(xCourseId.getCourseId());
            if (course == null) continue;
            ret.add(this.convert(course, server));
        }
        return ret;
    }

    protected List<ClassAssignmentInterface.CourseAssignment> customCourseLookup(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            List<XCourse> courses;
            if (this.iQuery != null && !this.iQuery.isEmpty() && CustomCourseLookupHolder.hasProvider() && (courses = CustomCourseLookupHolder.getProvider().getCourses(server, helper, this.iQuery, true)) != null && !courses.isEmpty()) {
                ArrayList<ClassAssignmentInterface.CourseAssignment> ret = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
                for (XCourse course : courses) {
                    if (course == null || this.iMatcher != null && !this.iMatcher.match(course)) continue;
                    ret.add(this.convert(course, server));
                }
                ListCourseOfferings.setSelection(ret);
                return ret;
            }
        }
        catch (Exception e) {
            helper.error("Failed to use the custom course lookup: " + e.getMessage(), e);
        }
        return null;
    }

    protected ClassAssignmentInterface.CourseAssignment convert(XCourse c, OnlineSectioningServer server) {
        ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
        course.setCourseId(c.getCourseId());
        course.setSubject(c.getSubjectArea());
        course.setCourseNbr(c.getCourseNumber());
        course.setTitle(c.getTitle());
        course.setNote(c.getNote());
        course.setCreditAbbv(c.getCreditAbbv());
        course.setCreditText(c.getCreditText());
        course.setTitle(c.getTitle());
        course.setHasUniqueName(c.hasUniqueName());
        course.setLimit(c.getLimit());
        course.setSnapShotLimit(c.getSnapshotLimit());
        XOffering offering = server.getOffering(c.getOfferingId());
        if (offering != null) {
            course.setAvailability(offering.getCourseAvailability(server.getRequests(c.getOfferingId()), c));
            for (XConfig config : offering.getConfigs()) {
                if (config.getInstructionalMethod() != null) {
                    course.addInstructionalMethod(config.getInstructionalMethod().getUniqueId(), config.getInstructionalMethod().getLabel());
                    continue;
                }
                course.setHasNoInstructionalMethod(true);
            }
            course.setHasCrossList(offering.hasCrossList());
        }
        return course;
    }

    public static void setSelection(List<ClassAssignmentInterface.CourseAssignment> courses) {
        if (courses == null || courses.isEmpty()) {
            return;
        }
        SelectionMode mode = SelectionMode.valueOf(ApplicationProperty.ListCourseOfferingsSelectionMode.value());
        int limit = ApplicationProperty.ListCourseOfferingsSelectionLimit.intValue();
        if (ApplicationProperty.ListCourseOfferingsSelectionRandomize.isTrue()) {
            RouletteWheelSelection roulette = new RouletteWheelSelection();
            for (ClassAssignmentInterface.CourseAssignment ca : courses) {
                int p = mode.getPoints(ca);
                if (p <= 0) continue;
                roulette.add((Object)ca, (double)p);
            }
            int idx = 0;
            while (roulette.hasMoreElements() && idx < limit) {
                ClassAssignmentInterface.CourseAssignment ca;
                ca = (ClassAssignmentInterface.CourseAssignment)roulette.nextElement();
                ca.setSelection(idx++);
            }
        } else {
            ClassAssignmentInterface.CourseAssignment ca;
            int p;
            ArrayList<ClassAssignmentInterface.CourseAssignment> sorted = new ArrayList<ClassAssignmentInterface.CourseAssignment>(courses);
            Collections.sort(sorted, mode);
            int idx = 0;
            Iterator iterator = sorted.iterator();
            while (iterator.hasNext() && (p = mode.getPoints(ca = (ClassAssignmentInterface.CourseAssignment)iterator.next())) > 0 && idx < limit) {
                ca.setSelection(idx++);
            }
        }
    }

    @Override
    public String name() {
        return "list-courses";
    }

    public static enum SelectionMode implements Comparator<ClassAssignmentInterface.CourseAssignment>
    {
        availability(new SelectionModeInterface(){

            @Override
            public int getPoints(ClassAssignmentInterface.CourseAssignment ca) {
                int p = 0;
                if (ca.getLimit() != null) {
                    p += 4 * (ca.getLimit() < 0 ? 9999 : ca.getLimit());
                }
                if (ca.getEnrollment() != null) {
                    p -= 3 * ca.getEnrollment();
                }
                if (ca.getRequested() != null) {
                    p -= ca.getRequested().intValue();
                }
                return p;
            }
        }),
        limit(new SelectionModeInterface(){

            @Override
            public int getPoints(ClassAssignmentInterface.CourseAssignment ca) {
                return ca.getLimit() < 0 ? 999 : ca.getLimit();
            }
        }),
        snapshot(new SelectionModeInterface(){

            @Override
            public int getPoints(ClassAssignmentInterface.CourseAssignment ca) {
                int snapshot = ca.getSnapShotLimit() == null ? 0 : (ca.getSnapShotLimit() < 0 ? 999 : ca.getSnapShotLimit());
                int limit = ca.getLimit() < 0 ? 999 : ca.getLimit();
                return Math.max(snapshot, limit);
            }
        });

        SelectionModeInterface iMode;

        private SelectionMode(SelectionModeInterface mode) {
            this.iMode = mode;
        }

        public int getPoints(ClassAssignmentInterface.CourseAssignment ca) {
            return this.iMode.getPoints(ca);
        }

        @Override
        public int compare(ClassAssignmentInterface.CourseAssignment ca1, ClassAssignmentInterface.CourseAssignment ca2) {
            int p2;
            int p1 = this.getPoints(ca1);
            if (p1 != (p2 = this.getPoints(ca2))) {
                return p1 > p2 ? -1 : 1;
            }
            return ca1.getCourseNameWithTitle().compareTo(ca2.getCourseNameWithTitle());
        }
    }

    static interface SelectionModeInterface {
        public int getPoints(ClassAssignmentInterface.CourseAssignment var1);
    }
}

