/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorGetCourseRequests;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class GetRequest
implements OnlineSectioningAction<CourseRequestInterface> {
    protected static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static final long serialVersionUID = 1L;
    private Long iStudentId;
    private boolean iSectioning;
    private boolean iCustomValidation = false;
    private boolean iCustomRequests = true;
    private boolean iAdvisorRequests = true;
    private CourseMatcher iMatcher = null;

    public GetRequest forStudent(Long studentId, boolean sectioning) {
        this.iStudentId = studentId;
        this.iSectioning = sectioning;
        return this;
    }

    public GetRequest forStudent(Long studentId) {
        return this.forStudent(studentId, true);
    }

    public GetRequest withCustomValidation(boolean validation) {
        this.iCustomValidation = validation;
        return this;
    }

    public GetRequest withCustomRequest(boolean request) {
        this.iCustomRequests = request;
        return this;
    }

    public GetRequest withAdvisorRequests(boolean adv) {
        this.iAdvisorRequests = adv;
        return this;
    }

    public GetRequest withCourseMatcher(CourseMatcher matcher) {
        this.iMatcher = matcher;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CourseRequestInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iStudentId == null) {
            if (CustomCourseRequestsHolder.hasProvider() && this.iCustomRequests) {
                CourseRequestInterface request;
                if (this.iMatcher != null) {
                    this.iMatcher.setServer(server);
                }
                if ((request = CustomCourseRequestsHolder.getProvider().getCourseRequests(server, helper, new XStudent(null, helper.getStudentExternalId(), helper.getUser().getName()), this.iMatcher)) != null) {
                    return request;
                }
            }
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            CourseRequestInterface request;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
            XStudent student = server.getStudent(this.iStudentId);
            if (student == null) {
                CourseRequestInterface courseRequestInterface = null;
                return courseRequestInterface;
            }
            action.getStudentBuilder().setExternalId(student.getExternalId());
            action.getStudentBuilder().setName(student.getName());
            if (student.getRequests().isEmpty() && CustomCourseRequestsHolder.hasProvider() && this.iCustomRequests) {
                if (this.iMatcher != null) {
                    this.iMatcher.setServer(server);
                }
                if ((request = CustomCourseRequestsHolder.getProvider().getCourseRequests(server, helper, student, this.iMatcher)) != null && !request.isEmpty()) {
                    CourseRequestInterface courseRequestInterface = request;
                    return courseRequestInterface;
                }
            }
            request = new CourseRequestInterface();
            request.setStudentId(this.iStudentId);
            request.setSaved(true);
            request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
            request.setMaxCredit(student.getMaxCredit());
            if (student.getMaxCreditOverride() != null) {
                request.setMaxCreditOverride(student.getMaxCreditOverride().getValue());
                request.setMaxCreditOverrideExternalId(student.getMaxCreditOverride().getExternalId());
                request.setMaxCreditOverrideTimeStamp(student.getMaxCreditOverride().getTimeStamp());
                Integer status = student.getMaxCreditOverride().getStatus();
                if (status == null) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
                } else {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                }
            }
            CourseRequestInterface.Request lastRequest = null;
            int lastRequestPriority = -1;
            boolean hasEnrollments = false;
            for (XRequest cd : student.getRequests()) {
                if (!(cd instanceof XCourseRequest) || ((XCourseRequest)cd).getEnrollment() == null) continue;
                hasEnrollments = true;
                break;
            }
            boolean setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnly.isTrue();
            boolean setReadOnlyWhenReserved = ApplicationProperty.OnlineSchedulingMakeReservedRequestReadOnly.isTrue();
            boolean setInactive = ApplicationProperty.OnlineSchedulingMakeUnassignedRequestsInactive.isTrue();
            if (helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER) {
                setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin.isTrue();
                setReadOnlyWhenReserved = ApplicationProperty.OnlineSchedulingMakeReservedRequestReadOnlyIfAdmin.isTrue();
                setInactive = ApplicationProperty.OnlineSchedulingMakeUnassignedRequestsInactiveIfAdmin.isTrue();
            }
            boolean reservedNoPriority = ApplicationProperty.OnlineSchedulingReservedRequestNoPriorityChanges.isTrue();
            boolean reservedNoAlternatives = ApplicationProperty.OnlineSchedulingReservedRequestNoAlternativeChanges.isTrue();
            boolean enrolledNoPriority = ApplicationProperty.OnlineSchedulingAssignedRequestNoPriorityChanges.isTrue();
            boolean enrolledNoAlternatives = ApplicationProperty.OnlineSchedulingAssignedRequestNoAlternativeChanges.isTrue();
            if (setInactive && !hasEnrollments) {
                setInactive = false;
            }
            if (setInactive && server instanceof StudentSolver) {
                setInactive = false;
            }
            for (XRequest cd : student.getRequests()) {
                CourseRequestInterface.Request r = null;
                if (cd instanceof XFreeTimeRequest) {
                    XFreeTimeRequest ftr = (XFreeTimeRequest)cd;
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setStart(ftr.getTime().getSlot());
                    ft.setLength(ftr.getTime().getLength());
                    for (DayCode day : DayCode.toDayCodes(ftr.getTime().getDays())) {
                        ft.addDay(day.getIndex());
                    }
                    if (lastRequest != null && lastRequestPriority == cd.getPriority() && lastRequest.hasRequestedCourse() && lastRequest.getRequestedCourse(0).isFreeTime()) {
                        lastRequest.getRequestedCourse(0).addFreeTime(ft);
                    } else {
                        r = new CourseRequestInterface.Request();
                        CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                        r.addRequestedCourse(rc);
                        rc.addFreeTime(ft);
                        if (cd.isAlternative()) {
                            request.getAlternatives().add(r);
                        } else {
                            request.getCourses().add(r);
                        }
                        lastRequest = r;
                        lastRequestPriority = cd.getPriority();
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    }
                } else if (cd instanceof XCourseRequest) {
                    r = new CourseRequestInterface.Request();
                    for (XCourseId courseId : ((XCourseRequest)cd).getCourseIds()) {
                        XOffering offering;
                        boolean isEnrolled;
                        XCourse c = server.getCourse(courseId.getCourseId());
                        if (c == null) continue;
                        CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                        rc.setCourseId(c.getCourseId());
                        rc.setCourseName(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                        rc.setCourseTitle(c.getTitle());
                        rc.setCredit(c.getMinCredit(), c.getMaxCredit());
                        boolean bl = isEnrolled = ((XCourseRequest)cd).getEnrollment() != null && c.getCourseId().equals(((XCourseRequest)cd).getEnrollment().getCourseId());
                        if (setReadOnly && isEnrolled) {
                            rc.setReadOnly(true);
                        }
                        if (this.iSectioning && setInactive && !isEnrolled) {
                            rc.setInactive(true);
                        }
                        if (!this.iSectioning && isEnrolled) {
                            rc.setReadOnly(true);
                            rc.setCanDelete(false);
                            if (enrolledNoAlternatives) {
                                rc.setCanChangeAlternatives(false);
                            }
                            if (enrolledNoPriority) {
                                rc.setCanChangePriority(false);
                            }
                        }
                        if (!this.iSectioning && setReadOnlyWhenReserved && (offering = server.getOffering(c.getOfferingId())) != null && (offering.hasIndividualReservation(student, c) || offering.hasGroupReservation(student, c))) {
                            rc.setReadOnly(true);
                            rc.setCanDelete(false);
                            if (reservedNoAlternatives) {
                                rc.setCanChangeAlternatives(false);
                            }
                            if (reservedNoPriority) {
                                rc.setCanChangePriority(false);
                            }
                        }
                        if (isEnrolled) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
                        } else {
                            Integer status = ((XCourseRequest)cd).getOverrideStatus(courseId);
                            if (status == null) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
                            } else {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                            }
                        }
                        rc.setOverrideExternalId(((XCourseRequest)cd).getOverrideExternalId(courseId));
                        rc.setOverrideTimeStamp(((XCourseRequest)cd).getOverrideTimeStamp(courseId));
                        ((XCourseRequest)cd).fillPreferencesIn(rc, courseId);
                        r.addRequestedCourse(rc);
                    }
                    r.setWaitList(((XCourseRequest)cd).isWaitlist());
                    r.setCritical(((XCourseRequest)cd).getCritical());
                    r.setTimeStamp(((XCourseRequest)cd).getTimeStamp());
                    if (r.hasRequestedCourse()) {
                        if (cd.isAlternative()) {
                            request.getAlternatives().add(r);
                        } else {
                            request.getCourses().add(r);
                        }
                    }
                    lastRequest = r;
                    lastRequestPriority = cd.getPriority();
                }
                action.addRequest(OnlineSectioningHelper.toProto(cd));
            }
            if (this.iCustomValidation && CustomCourseRequestsValidationHolder.hasProvider()) {
                CustomCourseRequestsValidationHolder.getProvider().check(server, helper, request);
            }
            if (!(student.getLastStudentChange() != null || server instanceof StudentSolver || !this.iAdvisorRequests || this.iSectioning && hasEnrollments || !request.applyAdvisorRequests(AdvisorGetCourseRequests.getRequest(student, server, helper)))) {
                request.setPopupMessage(ApplicationProperty.PopupMessageCourseRequestsPrepopulatedWithAdvisorRecommendations.value());
            }
            CourseRequestInterface courseRequestInterface = request;
            return courseRequestInterface;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "get-request";
    }
}

