/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.ExternalBuilding;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.Session;

public abstract class BaseExternalBuilding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iAbbreviation;
    private Double iCoordinateX;
    private Double iCoordinateY;
    private String iDisplayName;
    private Session iSession;
    private Set<ExternalRoom> iRooms;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_EXTERNAL_UID = "externalUniqueId";
    public static String PROP_ABBREVIATION = "abbreviation";
    public static String PROP_COORDINATE_X = "coordinateX";
    public static String PROP_COORDINATE_Y = "coordinateY";
    public static String PROP_DISPLAY_NAME = "displayName";

    public BaseExternalBuilding() {
        this.initialize();
    }

    public BaseExternalBuilding(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    public Double getCoordinateX() {
        return this.iCoordinateX;
    }

    public void setCoordinateX(Double coordinateX) {
        this.iCoordinateX = coordinateX;
    }

    public Double getCoordinateY() {
        return this.iCoordinateY;
    }

    public void setCoordinateY(Double coordinateY) {
        this.iCoordinateY = coordinateY;
    }

    public String getDisplayName() {
        return this.iDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.iDisplayName = displayName;
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public Set<ExternalRoom> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<ExternalRoom> rooms) {
        this.iRooms = rooms;
    }

    public void addTorooms(ExternalRoom externalRoom) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<ExternalRoom>();
        }
        this.iRooms.add(externalRoom);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExternalBuilding)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExternalBuilding)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExternalBuilding)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExternalBuilding[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ExternalBuilding[\n\tAbbreviation: " + this.getAbbreviation() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

