/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PosMajor;

public abstract class BaseCurriculum
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iAbbv;
    private String iName;
    private Boolean iMultipleMajors;
    private AcademicArea iAcademicArea;
    private Department iDepartment;
    private Set<PosMajor> iMajors;
    private Set<CurriculumClassification> iClassifications;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_ABBV = "abbv";
    public static String PROP_NAME = "name";
    public static String PROP_MULTIPLE_MAJORS = "multipleMajors";

    public BaseCurriculum() {
        this.initialize();
    }

    public BaseCurriculum(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public Boolean isMultipleMajors() {
        return this.iMultipleMajors;
    }

    public Boolean getMultipleMajors() {
        return this.iMultipleMajors;
    }

    public void setMultipleMajors(Boolean multipleMajors) {
        this.iMultipleMajors = multipleMajors;
    }

    public AcademicArea getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(AcademicArea academicArea) {
        this.iAcademicArea = academicArea;
    }

    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    public Set<PosMajor> getMajors() {
        return this.iMajors;
    }

    public void setMajors(Set<PosMajor> majors) {
        this.iMajors = majors;
    }

    public void addTomajors(PosMajor posMajor) {
        if (this.iMajors == null) {
            this.iMajors = new HashSet<PosMajor>();
        }
        this.iMajors.add(posMajor);
    }

    public Set<CurriculumClassification> getClassifications() {
        return this.iClassifications;
    }

    public void setClassifications(Set<CurriculumClassification> classifications) {
        this.iClassifications = classifications;
    }

    public void addToclassifications(CurriculumClassification curriculumClassification) {
        if (this.iClassifications == null) {
            this.iClassifications = new HashSet<CurriculumClassification>();
        }
        this.iClassifications.add(curriculumClassification);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Curriculum)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Curriculum)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Curriculum)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Curriculum[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "Curriculum[\n\tAbbv: " + this.getAbbv() + "\n\tAcademicArea: " + this.getAcademicArea() + "\n\tDepartment: " + this.getDepartment() + "\n\tMultipleMajors: " + this.getMultipleMajors() + "\n\tName: " + this.getName() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

