/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.base.BaseTimetableManager;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

public class TimetableManager
extends BaseTimetableManager
implements Comparable,
Qualifiable,
NameInterface {
    private static final long serialVersionUID = 1L;
    public static String MGR_LIST_ATTR_NAME = "managerList";

    public TimetableManager() {
    }

    public TimetableManager(Long uniqueId) {
        super(uniqueId);
    }

    public static TimetableManager findByExternalId(String externalId) {
        if (externalId == null || externalId.length() == 0) {
            return null;
        }
        TimetableManagerDAO tmDao = new TimetableManagerDAO();
        List mgrs = tmDao.getSession().createCriteria(TimetableManager.class).add((Criterion)Restrictions.eq((String)"externalUniqueId", (Object)externalId)).setCacheable(true).list();
        if (mgrs != null && mgrs.size() == 1) {
            return (TimetableManager)mgrs.get(0);
        }
        return null;
    }

    public static TimetableManager getWithUniqueId(Long uniqueId) {
        TimetableManagerDAO tmDao = new TimetableManagerDAO();
        return (TimetableManager)tmDao.get(uniqueId);
    }

    public boolean isExternalManager() {
        boolean isExternal = false;
        Department d2 = null;
        for (Department d2 : this.getDepartments()) {
            if (!d2.isExternalManager().booleanValue()) continue;
            isExternal = true;
        }
        return isExternal;
    }

    public Set departmentsForSession(Long sessionId) {
        HashSet<Department> l = new HashSet<Department>();
        if (this.getDepartments() != null) {
            Department d2 = null;
            for (Department d2 : this.getDepartments()) {
                if (!d2.getSessionId().equals(sessionId)) continue;
                l.add(d2);
            }
        }
        return l;
    }

    public Set sessionsCanManage() {
        TreeSet<Session> sessions = new TreeSet<Session>();
        Department dept2 = null;
        for (Department dept2 : this.getDepartments()) {
            sessions.add(dept2.getSession());
        }
        return sessions;
    }

    public boolean hasLastName() {
        return this.getLastName() != null && !this.getLastName().isEmpty();
    }

    public boolean hasFirstName() {
        return this.getFirstName() != null && !this.getFirstName().isEmpty();
    }

    public boolean hasMiddleName() {
        return this.getMiddleName() != null && !this.getMiddleName().isEmpty();
    }

    public String getName() {
        return (this.hasLastName() ? this.getLastName() : "") + (this.hasFirstName() || this.hasMiddleName() ? "," : "") + (this.hasFirstName() ? " " + this.getFirstName() : "") + (this.hasMiddleName() ? " " + this.getMiddleName() : "");
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }

    public Collection getClasses(Session session) {
        Vector classes = new Vector();
        for (Department d : this.departmentsForSession(session.getUniqueId())) {
            classes.addAll(d.getClasses());
        }
        return classes;
    }

    public Collection getNotAssignedClasses(Solution solution) {
        Vector classes = new Vector();
        for (Department d : this.departmentsForSession(solution.getSession().getUniqueId())) {
            classes.addAll(d.getNotAssignedClasses(solution));
        }
        return classes;
    }

    public Set getDistributionPreferences(Session session) {
        TreeSet prefs = new TreeSet();
        for (Department d : this.departmentsForSession(session.getUniqueId())) {
            prefs.addAll(d.getDistributionPreferences());
        }
        return prefs;
    }

    public Set getSolverGroups(Session session) {
        TreeSet<SolverGroup> groups = new TreeSet<SolverGroup>();
        for (SolverGroup g : this.getSolverGroups()) {
            if (!session.equals(g.getSession())) continue;
            groups.add(g);
        }
        return groups;
    }

    public String getShortName() {
        StringBuffer sb = new StringBuffer();
        if (this.getFirstName() != null && this.getFirstName().length() > 0) {
            sb.append(this.getFirstName().substring(0, 1).toUpperCase());
            sb.append(". ");
        }
        if (this.getLastName() != null && this.getLastName().length() > 0) {
            sb.append(this.getLastName().substring(0, 1).toUpperCase());
            sb.append(this.getLastName().substring(1, Math.min(10, this.getLastName().length())).toLowerCase().trim());
        }
        return sb.toString();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof TimetableManager)) {
            return -1;
        }
        TimetableManager m = (TimetableManager)o;
        int cmp = this.getName().compareTo(m.getName());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(m.getUniqueId() == null ? -1L : m.getUniqueId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static synchronized Vector getManagerList() {
        TimetableManagerDAO tdao = new TimetableManagerDAO();
        List l = tdao.findAll(Order.asc((String)"lastName"), Order.asc((String)"firstName"));
        if (l != null) {
            return new Vector(l);
        }
        return null;
    }

    public Roles getPrimaryRole() {
        for (ManagerRole role : this.getManagerRoles()) {
            if (!role.isPrimary().booleanValue()) continue;
            return role.getRole();
        }
        if (this.getManagerRoles().size() == 1) {
            return this.getManagerRoles().iterator().next().getRole();
        }
        return null;
    }

    @Override
    public Serializable getQualifierId() {
        return this.getUniqueId();
    }

    @Override
    public String getQualifierType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getQualifierReference() {
        return this.getExternalUniqueId();
    }

    @Override
    public String getQualifierLabel() {
        return this.getName();
    }
}

