/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import org.hibernate.HibernateException;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseInstructorAttribute;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;

public class InstructorAttribute
extends BaseInstructorAttribute
implements Comparable<InstructorAttribute> {
    private static final long serialVersionUID = 331064011983395675L;
    public static String ATTRIBUTES_LIST_ATTR_NAME = "attributesList";

    @Override
    public int compareTo(InstructorAttribute s) {
        int cmp = (this.getType() == null ? "" : this.getType().getLabel()).compareTo(s.getType() == null ? "" : s.getType().getLabel());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(s.getName());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(s.getUniqueId() == null ? -1L : s.getUniqueId());
    }

    public static List<InstructorAttribute> getAllGlobalAttributes(Long sessionId) throws HibernateException {
        return InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute ia where ia.session.uniqueId = :sessionId and ia.department is null order by name").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static List<InstructorAttribute> getAllDepartmentalAttributes(Long departmentId) throws HibernateException {
        return InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute ia where ia.department.uniqueId = :departmentId order by name").setLong("departmentId", departmentId.longValue()).setCacheable(true).list();
    }

    public InstructorAttribute findSameAttributeInSession(Session session) {
        if (session == null) {
            return null;
        }
        if (this.getDepartment() != null) {
            Department d = this.getDepartment().findSameDepartmentInSession(session);
            if (d == null) {
                return null;
            }
            return (InstructorAttribute)InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute ia where ia.department.uniqueId = :departmentId and ia.code = :code").setLong("departmentId", d.getUniqueId().longValue()).setString("code", this.getCode()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (InstructorAttribute)InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute ia where ia.session.uniqueId = :sessionId and ia.department is null and ia.code = :code").setLong("sessionId", session.getUniqueId().longValue()).setString("code", this.getCode()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public boolean isParentOf(InstructorAttribute attribute) {
        while (attribute != null) {
            if (this.equals(attribute.getParentAttribute())) {
                return true;
            }
            attribute = attribute.getParentAttribute();
        }
        return false;
    }

    public String getNameWithType() {
        return this.getName() + (this.getType() == null ? "" : " (" + this.getType().getLabel() + ")");
    }
}

