/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.unitime.timetable.model.base.BaseCurriculumClassification;

public class CurriculumClassification
extends BaseCurriculumClassification
implements Comparable<CurriculumClassification> {
    private static Log sLog = LogFactory.getLog(CurriculumClassification.class);
    private static final long serialVersionUID = 1L;

    public CurriculumClassification() {
    }

    public CurriculumClassification(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public int compareTo(CurriculumClassification cc) {
        int cmp;
        if (this.getAcademicClassification() != null && cc.getAcademicClassification() != null && (cmp = this.getAcademicClassification().getCode().compareTo(cc.getAcademicClassification().getCode())) != 0) {
            return cmp;
        }
        if (this.getOrd() != null && cc.getOrd() != null && !this.getOrd().equals(cc.getOrd())) {
            return this.getOrd().compareTo(cc.getOrd());
        }
        cmp = this.getName().compareToIgnoreCase(cc.getName());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(cc.getUniqueId() == null ? -1L : cc.getUniqueId());
    }

    public Document getStudentsDocument() {
        if (this.getStudents() == null) {
            return null;
        }
        try {
            return new SAXReader().read((Reader)new StringReader(this.getStudents()));
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to load cached students for " + this.getCurriculum().getAbbv() + " " + this.getName() + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public void setStudentsDocument(Document document) {
        try {
            if (document == null) {
                this.setStudents(null);
            } else {
                StringWriter string = new StringWriter();
                XMLWriter writer = new XMLWriter((Writer)string, OutputFormat.createCompactFormat());
                writer.write(document);
                writer.flush();
                writer.close();
                this.setStudents(string.toString());
            }
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to store cached students for " + this.getCurriculum().getAbbv() + " " + this.getName() + ": " + e.getMessage()), (Throwable)e);
        }
    }
}

