/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.listeners;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.struts.util.MessageResourcesFactory;
import org.unitime.commons.Debug;
import org.unitime.timetable.util.MessageResources;

public class SessionListener
implements HttpSessionListener {
    private static int activeSessions = 0;
    private static HashMap sessions = new HashMap();

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        sessions.put(session.getId(), session);
        ++activeSessions;
        Debug.info("TT Session started ... " + session.getId() + " " + new Date());
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        sessions.remove(session.getId());
        if (activeSessions > 0) {
            --activeSessions;
        }
        Debug.info("TT Session ended ... " + session.getId() + " " + new Date());
        Debug.info("    - TT Session time ... " + (new Date().getTime() - session.getCreationTime()) / 60000L + " minutes");
        session.invalidate();
    }

    public static int getActiveSessions() {
        return activeSessions;
    }

    public static HashMap getSessions() {
        return sessions;
    }

    public static void reloadMessageResources(String resourceFile) {
        if (sessions != null && sessions.size() > 0) {
            Iterator i = sessions.keySet().iterator();
            while (i.hasNext()) {
                HttpSession session = (HttpSession)sessions.get(i.next());
                if (session == null) continue;
                MessageResourcesFactory mrf = org.unitime.timetable.util.MessageResourcesFactory.createFactory();
                MessageResources mr = new MessageResources((org.unitime.timetable.util.MessageResourcesFactory)mrf, resourceFile);
                session.getServletContext().setAttribute("org.apache.struts.action.MESSAGE", (Object)mr);
                break;
            }
        }
    }
}

