/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Date;

public interface AcademicSessionProvider {
    public Long getAcademicSessionId();

    public String getAcademicSessionName();

    public AcademicSessionInfo getAcademicSessionInfo();

    public void addAcademicSessionChangeHandler(AcademicSessionChangeHandler var1);

    public void selectSession(Long var1, AsyncCallback<Boolean> var2);

    public static class AcademicSessionMatchSessionId
    implements AcademicSessionMatcher {
        Long iSessionId;

        public AcademicSessionMatchSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        @Override
        public boolean match(AcademicSessionInfo session) {
            return session.getSessionId().equals(this.iSessionId);
        }
    }

    public static interface AcademicSessionMatcher {
        public boolean match(AcademicSessionInfo var1);
    }

    public static class AcademicSessionInfo
    implements IsSerializable,
    Comparable<AcademicSessionInfo> {
        private Long iSessionId;
        private String iYear;
        private String iTerm;
        private String iCampus;
        private String iName;
        private String iExternalTerm;
        private String iExternalCampus;
        private Date iStartDate;

        public AcademicSessionInfo() {
        }

        public AcademicSessionInfo(Long sessionId, String year, String term, String campus, String name, Date sessionStartDate) {
            this.iSessionId = sessionId;
            this.iTerm = term;
            this.iYear = year;
            this.iCampus = campus;
            this.iName = name;
            this.iStartDate = sessionStartDate;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getYear() {
            return this.iYear;
        }

        public void setYear(String year) {
            this.iYear = year;
        }

        public String getCampus() {
            return this.iCampus;
        }

        public void setCampus(String campus) {
            this.iCampus = campus;
        }

        public String getTerm() {
            return this.iTerm;
        }

        public void setTerm(String term) {
            this.iTerm = term;
        }

        public String getName() {
            return this.iName == null || this.iName.isEmpty() ? this.iTerm + " " + this.iYear + " (" + this.iCampus + ")" : this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getExternalCampus() {
            return this.iExternalCampus;
        }

        public boolean hasExternalCampus() {
            return this.iExternalCampus != null && !this.iExternalCampus.isEmpty();
        }

        public AcademicSessionInfo setExternalCampus(String extCampus) {
            this.iExternalCampus = extCampus;
            return this;
        }

        public String getExternalTerm() {
            return this.iExternalTerm;
        }

        public boolean hasExternalTerm() {
            return this.iExternalTerm != null && !this.iExternalTerm.isEmpty();
        }

        public AcademicSessionInfo setExternalTerm(String extTerm) {
            this.iExternalTerm = extTerm;
            return this;
        }

        public boolean hasStartDate() {
            return this.iStartDate != null;
        }

        public Date getStartDate() {
            return this.iStartDate;
        }

        public void setStartDate(Date startDate) {
            this.iStartDate = startDate;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AcademicSessionInfo)) {
                return false;
            }
            return this.getSessionId().equals(((AcademicSessionInfo)o).getSessionId());
        }

        @Override
        public int compareTo(AcademicSessionInfo s) {
            int cmp = s.getStartDate().compareTo(this.getStartDate());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getName().compareTo(s.getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getSessionId().compareTo(s.getSessionId());
        }
    }

    public static interface AcademicSessionChangeHandler {
        public void onAcademicSessionChange(AcademicSessionChangeEvent var1);
    }

    public static interface AcademicSessionChangeEvent {
        public Long getNewAcademicSessionId();

        public Long getOldAcademicSessionId();

        public boolean isChanged();
    }
}

