/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.services.ReservationService;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.ReservationException;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.interfaces.ExternalCourseOfferingReservationEditAction;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumOverrideReservation;
import org.unitime.timetable.model.CurriculumProjectionRule;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.IndividualOverrideReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.AcademicAreaDAO;
import org.unitime.timetable.model.dao.AcademicClassificationDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.PosMajorConcentrationDAO;
import org.unitime.timetable.model.dao.PosMajorDAO;
import org.unitime.timetable.model.dao.PosMinorDAO;
import org.unitime.timetable.model.dao.ReservationDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.reservation.ReservationFilterBackend;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.util.Constants;

@Service(value="reservation.gwt")
public class ReservationServlet
implements ReservationService {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Logger sLog = Logger.getLogger(ReservationServlet.class);
    @Autowired
    private SessionContext sessionContext;
    @Autowired
    Permission<InstructionalOffering> permissionOfferingLockNeeded;
    @Autowired
    Permission<InstructionalOffering> permissionOfferingLockNeededOnlyWhenWaitListing;
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;

    private SessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public List<ReservationInterface.Area> getAreas() throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface.Area> results = new ArrayList<ReservationInterface.Area>();
            try (Session hibSession = ReservationDAO.getInstance().getSession();){
                ArrayList<ReservationInterface.IdName> classifications = new ArrayList<ReservationInterface.IdName>();
                for (AcademicClassification classification : hibSession.createQuery("select c from AcademicClassification c where c.session.uniqueId = :sessionId order by c.code, c.name").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
                    ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                    clasf.setId(classification.getUniqueId());
                    clasf.setName(Constants.curriculaToInitialCase(classification.getName()));
                    clasf.setAbbv(classification.getCode());
                    classifications.add(clasf);
                }
                for (AcademicArea area : hibSession.createQuery("select a from AcademicArea a where a.session.uniqueId = :sessionId order by a.academicAreaAbbreviation, a.title").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
                    ReservationInterface.IdName mj;
                    ReservationInterface.Area curriculum = new ReservationInterface.Area();
                    curriculum.setAbbv(area.getAcademicAreaAbbreviation());
                    curriculum.setId(area.getUniqueId());
                    curriculum.setName(Constants.curriculaToInitialCase(area.getTitle()));
                    for (PosMajor major : area.getPosMajors()) {
                        mj = new ReservationInterface.IdName();
                        mj.setId(major.getUniqueId());
                        mj.setAbbv(major.getCode());
                        mj.setName(Constants.curriculaToInitialCase(major.getName()));
                        mj.setParentId(area.getUniqueId());
                        curriculum.getMajors().add(mj);
                        for (PosMajorConcentration conc : major.getConcentrations()) {
                            ReservationInterface.IdName cc = new ReservationInterface.IdName();
                            cc.setId(conc.getUniqueId());
                            cc.setAbbv(conc.getCode());
                            cc.setName(Constants.curriculaToInitialCase(conc.getName()));
                            cc.setParentId(conc.getMajor().getUniqueId());
                            curriculum.getConcentrations().add(cc);
                        }
                    }
                    for (PosMinor minor : area.getPosMinors()) {
                        mj = new ReservationInterface.IdName();
                        mj.setId(minor.getUniqueId());
                        mj.setAbbv(minor.getCode());
                        mj.setName(Constants.curriculaToInitialCase(minor.getName()));
                        mj.setParentId(area.getUniqueId());
                        curriculum.getMinors().add(mj);
                    }
                    Collections.sort(curriculum.getMajors());
                    Collections.sort(curriculum.getMinors());
                    Collections.sort(curriculum.getConcentrations());
                    curriculum.getClassifications().addAll(classifications);
                    results.add(curriculum);
                }
            }
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    private ReservationInterface.Offering convert(InstructionalOffering io, Long courseId, Session hibSession) throws ReservationException, PageAccessException {
        return ReservationServlet.convert(io, courseId, hibSession, this.permissionOfferingLockNeededOnlyWhenWaitListing, this.sessionContext, this.classAssignmentService.getAssignment());
    }

    public static ReservationInterface.Offering convert(InstructionalOffering io, Long courseId, Session hibSession, Permission<InstructionalOffering> permissionOfferingLockNeededOnlyWhenWaitListing, SessionContext sessionContext, ClassAssignmentProxy assignments) {
        CourseOffering cc = io.getControllingCourseOffering();
        if (courseId != null) {
            for (CourseOffering courseOffering : io.getCourseOfferings()) {
                if (!courseId.equals(courseOffering.getUniqueId())) continue;
                cc = courseOffering;
                break;
            }
        }
        ReservationInterface.Offering offering = new ReservationInterface.Offering();
        offering.setAbbv(io.getCourseName());
        offering.setName(io.getControllingCourseOffering().getTitle());
        offering.setId(io.getUniqueId());
        offering.setOffered(io.isNotOffered() == false);
        offering.setUnlockNeeded(permissionOfferingLockNeededOnlyWhenWaitListing != null && permissionOfferingLockNeededOnlyWhenWaitListing.check(sessionContext.getUser(), io));
        for (CourseOffering co : io.getCourseOfferings()) {
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getUniqueId());
            course.setAbbv(co.getCourseName());
            course.setName(co.getTitle());
            course.setControl(co.isIsControl());
            course.setLimit(co.getReservation());
            offering.getCourses().add(course);
        }
        String string = UserProperty.NameFormat.get(sessionContext.getUser());
        ArrayList<InstrOfferingConfig> configs = new ArrayList<InstrOfferingConfig>(io.getInstrOfferingConfigs());
        Collections.sort(configs, new InstrOfferingConfigComparator(null));
        for (InstrOfferingConfig ioc : configs) {
            ReservationInterface.Config config = new ReservationInterface.Config();
            config.setId(ioc.getUniqueId());
            config.setName(ioc.getName());
            config.setAbbv(ioc.getName());
            config.setLimit(ioc.isUnlimitedEnrollment() != false ? null : ioc.getLimit());
            config.setInstructionalMethod(ioc.getInstructionalMethod() == null ? null : ioc.getInstructionalMethod().getLabel());
            offering.getConfigs().add(config);
            TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator());
            subparts.addAll(ioc.getSchedulingSubparts());
            for (SchedulingSubpart ss : subparts) {
                ReservationInterface.Subpart subpart = new ReservationInterface.Subpart();
                subpart.setId(ss.getUniqueId());
                String suffix = ss.getSchedulingSubpartSuffix(hibSession);
                subpart.setAbbv(ss.getItypeDesc() + (suffix == null || suffix.isEmpty() ? "" : " " + suffix));
                subpart.setName(ss.getSchedulingSubpartLabel());
                subpart.setConfig(config);
                config.getSubparts().add(subpart);
                if (ss.getParentSubpart() != null) {
                    subpart.setParentId(ss.getParentSubpart().getUniqueId());
                }
                ArrayList<Class_> classes = new ArrayList<Class_>(ss.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (Class_ c : classes) {
                    ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
                    clazz.setId(c.getUniqueId());
                    clazz.setAbbv(ss.getItypeDesc() + " " + c.getSectionNumberString(hibSession));
                    clazz.setName(c.getClassLabel(hibSession));
                    clazz.setExternalId(c.getClassSuffix(cc));
                    if (assignments != null) {
                        try {
                            Assignment a = assignments.getAssignment(c);
                            if (a != null) {
                                clazz.setDate(a.getDatePattern() != null ? a.getDatePattern().getName() : null);
                                if (a.getTimeLocation() != null) {
                                    String time = "";
                                    Integer firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
                                    for (int i = 0; i < CONSTANTS.shortDays().length; ++i) {
                                        int idx;
                                        int n = idx = firstDay == null ? i : (i + firstDay) % 7;
                                        if ((Constants.DAY_CODES[idx] & a.getTimeLocation().getDayCode()) == 0) continue;
                                        time = time + CONSTANTS.shortDays()[idx];
                                    }
                                    time = time + " " + a.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + a.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm());
                                    clazz.setTime(time);
                                }
                                if (a.getRooms() != null && !a.getRooms().isEmpty()) {
                                    String rooms = "";
                                    for (Location location : a.getRooms()) {
                                        if (!rooms.isEmpty()) {
                                            rooms = rooms + ", ";
                                        }
                                        rooms = rooms + location.getLabel();
                                    }
                                    clazz.setRoom(rooms);
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    clazz.setInstructor(c.instructorText(string, "; "));
                    if (c.isCancelled() != null) {
                        clazz.setCancelled(c.isCancelled());
                    }
                    subpart.getClasses().add(clazz);
                    clazz.setSubpart(subpart);
                    clazz.setLimit(c.getClassLimit());
                    if (c.getParentClass() != null) {
                        clazz.setParentId(c.getParentClass().getUniqueId());
                    }
                    clazz.setEnrollment(c.getEnrollment());
                }
            }
        }
        return offering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public ReservationInterface.Offering getOffering(Long offeringId, Long courseId) throws ReservationException, PageAccessException {
        ReservationInterface.Offering offering;
        Session hibSession = ReservationDAO.getInstance().getSession();
        try {
            InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId, hibSession);
            if (io == null) {
                throw new ReservationException(MESSAGES.errorOfferingDoesNotExist(offeringId == null ? "null" : offeringId.toString()));
            }
            offering = this.convert(io, courseId, hibSession);
        }
        catch (Throwable throwable) {
            try {
                hibSession.close();
                throw throwable;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (ReservationException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new ReservationException(e.getMessage());
            }
        }
        hibSession.close();
        return offering;
    }

    private CourseOffering getCourse(Session hibSession, String courseName) {
        Iterator iterator = hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course").setString("course", courseName.toLowerCase()).setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).setMaxResults(1).list().iterator();
        if (iterator.hasNext()) {
            CourseOffering co = (CourseOffering)iterator.next();
            return co;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public ReservationInterface.Offering getOfferingByCourseName(String courseName) throws ReservationException, PageAccessException {
        ReservationInterface.Offering offering;
        Session hibSession = ReservationDAO.getInstance().getSession();
        try {
            CourseOffering co = this.getCourse(hibSession, courseName);
            if (co == null) {
                throw new ReservationException(MESSAGES.errorCourseDoesNotExist(courseName));
            }
            offering = this.convert(co.getInstructionalOffering(), co.getUniqueId(), hibSession);
        }
        catch (Throwable throwable) {
            try {
                hibSession.close();
                throw throwable;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (ReservationException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new ReservationException(e.getMessage());
            }
        }
        hibSession.close();
        return offering;
    }

    private Hashtable<String, HashMap<String, Float>> getRules(Session hibSession, Long acadAreaId) {
        Hashtable<String, HashMap<String, Float>> clasf2major2proj = new Hashtable<String, HashMap<String, Float>>();
        for (CurriculumProjectionRule rule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.uniqueId=:acadAreaId").setLong("acadAreaId", acadAreaId.longValue()).setCacheable(true).list()) {
            String majorCode = rule.getMajor() == null ? "" : rule.getMajor().getCode();
            String clasfCode = rule.getAcademicClassification().getCode();
            Float projection = rule.getProjection();
            HashMap<String, Float> major2proj = clasf2major2proj.get(clasfCode);
            if (major2proj == null) {
                major2proj = new HashMap();
                clasf2major2proj.put(clasfCode, major2proj);
            }
            major2proj.put(majorCode, projection);
        }
        return clasf2major2proj;
    }

    private float getProjection(Hashtable<String, HashMap<String, Float>> clasf2major2proj, String majorCode, String clasfCode) {
        if (clasf2major2proj == null || clasf2major2proj.isEmpty()) {
            return 1.0f;
        }
        HashMap<String, Float> major2proj = clasf2major2proj.get(clasfCode);
        if (major2proj == null) {
            return 1.0f;
        }
        Float projection = major2proj.get(majorCode);
        if (projection == null) {
            projection = major2proj.get("");
        }
        return projection == null ? 1.0f : projection.floatValue();
    }

    /*
     * WARNING - void declaration
     */
    private ReservationInterface convert(Reservation reservation, String nameFormat, Session hibSession) {
        ReservationInterface.IdName group;
        StudentGroup sg;
        ReservationInterface r = null;
        CourseOffering co = reservation.getInstructionalOffering().getControllingCourseOffering();
        if (reservation instanceof CourseReservation) {
            co = ((CourseReservation)reservation).getCourse();
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getUniqueId());
            course.setAbbv(co.getCourseName());
            course.setControl(co.isIsControl());
            course.setName(co.getTitle());
            course.setLimit(co.getReservation());
            r = new ReservationInterface.CourseReservation();
            ((ReservationInterface.CourseReservation)r).setCourse(course);
            r.setLastLike(co.getDemand());
            r.setEnrollment(co.getEnrollment());
            r.setProjection(co.getProjectedDemand());
        } else if (reservation instanceof IndividualReservation) {
            Number enrollment;
            r = new ReservationInterface.IndividualReservation();
            if (reservation instanceof OverrideReservation) {
                r = new ReservationInterface.OverrideReservation(((OverrideReservation)reservation).getOverrideType());
            }
            String sId = "";
            for (Student student : ((IndividualReservation)reservation).getStudents()) {
                ReservationInterface.IdName idName = new ReservationInterface.IdName();
                idName.setId(student.getUniqueId());
                idName.setAbbv(student.getExternalUniqueId());
                idName.setName(student.getName(nameFormat));
                ((ReservationInterface.IndividualReservation)r).getStudents().add(idName);
                sId = sId + (sId.isEmpty() ? "" : ",") + student.getUniqueId();
            }
            Collections.sort(((ReservationInterface.IndividualReservation)r).getStudents(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getAbbv().compareTo(s2.getAbbv());
                }
            });
            if (!sId.isEmpty() && (enrollment = (Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId and e.student.uniqueId in (" + sId + ")").setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue() > 0) {
                r.setEnrollment(enrollment.intValue());
            }
        } else if (reservation instanceof CurriculumReservation) {
            Number enrollment;
            void var9_12;
            CurriculumReservation cr = (CurriculumReservation)reservation;
            r = new ReservationInterface.CurriculumReservation();
            ReservationInterface.Areas curriculum = new ReservationInterface.Areas();
            String aaCodes = "";
            String string = "";
            for (AcademicArea area : cr.getAreas()) {
                ReservationInterface.IdName aa = new ReservationInterface.IdName();
                aa.setId(area.getUniqueId());
                aa.setAbbv(area.getAcademicAreaAbbreviation());
                aa.setName(Constants.curriculaToInitialCase(area.getTitle()));
                curriculum.getAreas().add(aa);
                aaCodes = aaCodes + (aaCodes.isEmpty() ? "" : ",") + "'" + area.getAcademicAreaAbbreviation() + "'";
                String string2 = (String)var9_12 + (var9_12.isEmpty() ? "" : ",") + area.getUniqueId();
            }
            String cfCodes = "";
            String cfIds = "";
            for (AcademicClassification classification : cr.getClassifications()) {
                ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                clasf.setId(classification.getUniqueId());
                clasf.setName(Constants.curriculaToInitialCase(classification.getName()));
                clasf.setAbbv(classification.getCode());
                curriculum.getClassifications().add(clasf);
                cfCodes = cfCodes + (cfCodes.isEmpty() ? "" : ",") + "'" + classification.getCode() + "'";
                cfIds = cfIds + (cfIds.isEmpty() ? "" : ",") + classification.getUniqueId();
            }
            String mjCodes = "";
            String mjIds = "";
            for (PosMajor major : cr.getMajors()) {
                ReservationInterface.IdName mj = new ReservationInterface.IdName();
                mj.setId(major.getUniqueId());
                mj.setAbbv(major.getCode());
                mj.setName(Constants.curriculaToInitialCase(major.getName()));
                for (AcademicArea aa : major.getAcademicAreas()) {
                    if (!cr.getAreas().contains(aa)) continue;
                    mj.setParentId(aa.getUniqueId());
                    break;
                }
                curriculum.getMajors().add(mj);
                mjCodes = mjCodes + (mjCodes.isEmpty() ? "" : ",") + "'" + major.getCode() + "'";
                mjIds = mjIds + (mjIds.isEmpty() ? "" : ",") + major.getUniqueId();
            }
            String mnCodes = "";
            String mnIds = "";
            for (PosMinor minor : cr.getMinors()) {
                ReservationInterface.IdName mn = new ReservationInterface.IdName();
                mn.setId(minor.getUniqueId());
                mn.setAbbv(minor.getCode());
                mn.setName(Constants.curriculaToInitialCase(minor.getName()));
                for (AcademicArea aa : minor.getAcademicAreas()) {
                    if (!cr.getAreas().contains(aa)) continue;
                    mn.setParentId(aa.getUniqueId());
                    break;
                }
                curriculum.getMinors().add(mn);
                mnCodes = mnCodes + (mnCodes.isEmpty() ? "" : ",") + "'" + minor.getCode() + "'";
                mnIds = mnIds + (mnIds.isEmpty() ? "" : ",") + minor.getUniqueId();
            }
            String ccCodes = "";
            String ccIds = "";
            for (PosMajorConcentration conc : cr.getConcentrations()) {
                ReservationInterface.IdName cc = new ReservationInterface.IdName();
                cc.setId(conc.getUniqueId());
                cc.setAbbv(conc.getCode());
                cc.setName(Constants.curriculaToInitialCase(conc.getName()));
                cc.setParentId(conc.getMajor().getUniqueId());
                curriculum.getConcentrations().add(cc);
                ccCodes = ccCodes + (ccCodes.isEmpty() ? "" : ",") + "'" + conc.getCode() + "'";
                ccIds = ccIds + (ccIds.isEmpty() ? "" : ",") + conc.getUniqueId();
            }
            if (curriculum.getAreas().size() > 1) {
                Collections.sort(curriculum.getAreas(), new Comparator<ReservationInterface.IdName>(){

                    @Override
                    public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                        int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = s1.getName().compareTo(s2.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getId().compareTo(s2.getId());
                    }
                });
            }
            Collections.sort(curriculum.getMajors(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getClassifications(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getMinors(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getConcentrations(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            ((ReservationInterface.CurriculumReservation)r).setCurriculum(curriculum);
            if ((!mjIds.isEmpty() || mnIds.isEmpty()) && (enrollment = (Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.student.areaClasfMajors a inner join a.major m " + (ccIds.isEmpty() ? "" : "left outer join a.concentration c ") + "where e.courseOffering.instructionalOffering.uniqueId = :offeringId " + (mjIds.isEmpty() ? "" : " and m.uniqueId in (" + mjIds + ")") + (cfIds.isEmpty() ? "" : " and a.academicClassification.uniqueId in (" + cfIds + ")") + (var9_12.isEmpty() ? "" : " and a.academicArea.uniqueId in (" + (String)var9_12 + ")") + (ccIds.isEmpty() ? "" : " and (c is null or c.uniqueId in (" + ccIds + "))")).setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue() > 0) {
                r.setEnrollment(enrollment.intValue());
            }
            if (!mnIds.isEmpty() && (enrollment = (Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.student.areaClasfMinors a inner join a.minor m where e.courseOffering.instructionalOffering.uniqueId = :offeringId and m.uniqueId in (" + mnIds + ")" + (cfIds.isEmpty() ? "" : " and a.academicClassification.uniqueId in (" + cfIds + ")") + (var9_12.isEmpty() ? "" : " and a.academicArea.uniqueId in (" + (String)var9_12 + ")")).setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue() > 0) {
                r.setEnrollment(enrollment.intValue() + (r.getEnrollment() == null ? 0 : r.getEnrollment()));
            }
            float projection = 0.0f;
            int lastLike = 0;
            if (!mjIds.isEmpty() || mnIds.isEmpty()) {
                for (AcademicArea area : cr.getAreas()) {
                    Hashtable<String, HashMap<String, Float>> rules = this.getRules(hibSession, area.getUniqueId());
                    for (Object[] o : hibSession.createQuery("select count(distinct x.student), m.code, f.code from LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a inner join a.major m inner join a.academicClassification f inner join a.academicArea r" + (ccIds.isEmpty() ? "" : " left outer join a.concentration c") + ", CourseOffering co left outer join co.demandOffering do where x.subjectArea.session.uniqueId = :sessionId and co.instructionalOffering.uniqueId = :offeringId and ((co.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and co.permId=x.coursePermId) or (x.coursePermId is null and co.courseNbr=x.courseNbr))) or (do is not null and do.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and do.permId=x.coursePermId) or (x.coursePermId is null and do.courseNbr=x.courseNbr))))and r.academicAreaAbbreviation = :areaAbbv" + (mjCodes.isEmpty() ? "" : " and m.code in (" + mjCodes + ")") + (cfCodes.isEmpty() ? "" : " and f.code in (" + cfCodes + ")") + (ccIds.isEmpty() ? "" : " and (c is null or c.uniqueId in (" + ccIds + "))") + " group by m.code, f.code").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setString("areaAbbv", area.getAcademicAreaAbbreviation()).setCacheable(true).list()) {
                        int nrStudents = ((Number)o[0]).intValue();
                        lastLike += Math.round(nrStudents);
                        projection += this.getProjection(rules, (String)o[1], (String)o[2]) * (float)nrStudents;
                    }
                }
            }
            if (!mnIds.isEmpty()) {
                for (AcademicArea area : cr.getAreas()) {
                    for (Object[] o : hibSession.createQuery("select count(distinct x.student), m.code, f.code from LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMinors a inner join a.minor m inner join a.academicClassification f inner join a.academicArea r, CourseOffering co left outer join co.demandOffering do where x.subjectArea.session.uniqueId = :sessionId and co.instructionalOffering.uniqueId = :offeringId and ((co.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and co.permId=x.coursePermId) or (x.coursePermId is null and co.courseNbr=x.courseNbr))) or (do is not null and do.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and do.permId=x.coursePermId) or (x.coursePermId is null and do.courseNbr=x.courseNbr))))and r.academicAreaAbbreviation = :areaAbbv" + (mnCodes.isEmpty() ? "" : " and m.code in (" + mnCodes + ")") + (cfCodes.isEmpty() ? "" : " and f.code in (" + cfCodes + ")") + " group by m.code, f.code").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setString("areaAbbv", area.getAcademicAreaAbbreviation()).setCacheable(true).list()) {
                        int nrStudents = ((Number)o[0]).intValue();
                        lastLike += nrStudents;
                        projection += (float)nrStudents;
                    }
                }
            }
            if (lastLike > 0) {
                r.setLastLike(lastLike);
                r.setProjection(Math.round(projection));
            }
        } else if (reservation instanceof LearningCommunityReservation) {
            Number lastLike;
            r = new ReservationInterface.LCReservation();
            sg = ((LearningCommunityReservation)reservation).getGroup();
            group = new ReservationInterface.IdName();
            group.setId(sg.getUniqueId());
            group.setName(sg.getGroupName());
            group.setAbbv(sg.getGroupAbbreviation());
            group.setLimit(sg.getStudents().size());
            ((ReservationInterface.LCReservation)r).setGroup(group);
            co = ((LearningCommunityReservation)reservation).getCourse();
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getUniqueId());
            course.setAbbv(co.getCourseName());
            course.setControl(co.isIsControl());
            course.setName(co.getTitle());
            course.setLimit(co.getReservation());
            ((ReservationInterface.LCReservation)r).setCourse(course);
            Number number = (Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.student.groups g where e.courseOffering.uniqueId = :courseId and g.uniqueId = :groupId").setLong("courseId", course.getId().longValue()).setLong("groupId", sg.getUniqueId().longValue()).setCacheable(true).uniqueResult();
            if (number.intValue() > 0) {
                r.setEnrollment(number.intValue());
            }
            if ((lastLike = (Number)hibSession.createQuery("select count(distinct x.student) from LastLikeCourseDemand x inner join x.student s inner join s.groups g, CourseOffering co left outer join co.demandOffering do where x.subjectArea.session.uniqueId = :sessionId and co.uniqueId = :courseId and ((co.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and co.permId=x.coursePermId) or (x.coursePermId is null and co.courseNbr=x.courseNbr))) or (do is not null and do.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and do.permId=x.coursePermId) or (x.coursePermId is null and do.courseNbr=x.courseNbr))))and g.groupAbbreviation = :groupAbbv").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("courseId", course.getId().longValue()).setString("groupAbbv", sg.getGroupAbbreviation()).setCacheable(true).uniqueResult()).intValue() > 0) {
                r.setLastLike(lastLike.intValue());
            }
        } else if (reservation instanceof StudentGroupReservation) {
            Number number;
            r = new ReservationInterface.GroupReservation();
            sg = ((StudentGroupReservation)reservation).getGroup();
            group = new ReservationInterface.IdName();
            group.setId(sg.getUniqueId());
            group.setName(sg.getGroupName());
            group.setAbbv(sg.getGroupAbbreviation());
            group.setLimit(sg.getStudents().size());
            ((ReservationInterface.GroupReservation)r).setGroup(group);
            Number enrollment = (Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.student.groups g where e.courseOffering.instructionalOffering.uniqueId = :offeringId and g.uniqueId = :groupId").setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setLong("groupId", sg.getUniqueId().longValue()).setCacheable(true).uniqueResult();
            if (enrollment.intValue() > 0) {
                r.setEnrollment(enrollment.intValue());
            }
            if ((number = (Number)hibSession.createQuery("select count(distinct x.student) from LastLikeCourseDemand x inner join x.student s inner join s.groups g, CourseOffering co left outer join co.demandOffering do where x.subjectArea.session.uniqueId = :sessionId and co.instructionalOffering.uniqueId = :offeringId and ((co.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and co.permId=x.coursePermId) or (x.coursePermId is null and co.courseNbr=x.courseNbr))) or (do is not null and do.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and do.permId=x.coursePermId) or (x.coursePermId is null and do.courseNbr=x.courseNbr))))and g.groupAbbreviation = :groupAbbv").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setString("groupAbbv", sg.getGroupAbbreviation()).setCacheable(true).uniqueResult()).intValue() > 0) {
                r.setLastLike(number.intValue());
            }
        } else {
            throw new ReservationException(MESSAGES.errorUnknownReservationType(reservation.getClass().getName()));
        }
        ReservationInterface.Offering offering = new ReservationInterface.Offering();
        offering.setAbbv(co.getCourseName());
        offering.setName(co.getTitle());
        offering.setId(reservation.getInstructionalOffering().getUniqueId());
        offering.setOffered(reservation.getInstructionalOffering().isNotOffered() == false);
        offering.setUnlockNeeded(this.permissionOfferingLockNeededOnlyWhenWaitListing != null && this.permissionOfferingLockNeededOnlyWhenWaitListing.check(this.sessionContext.getUser(), reservation.getInstructionalOffering()));
        r.setOffering(offering);
        boolean showClassSuffixes = ApplicationProperty.ReservationsShowClassSufix.isTrue();
        for (CourseOffering courseOffering : reservation.getInstructionalOffering().getCourseOfferings()) {
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(courseOffering.getUniqueId());
            course.setAbbv(courseOffering.getCourseName());
            course.setName(courseOffering.getTitle());
            course.setControl(courseOffering.isIsControl());
            course.setLimit(courseOffering.getReservation());
            offering.getCourses().add(course);
        }
        ArrayList<InstrOfferingConfig> configs = new ArrayList<InstrOfferingConfig>(reservation.getConfigurations());
        Collections.sort(configs, new InstrOfferingConfigComparator(null));
        for (InstrOfferingConfig ioc : configs) {
            ReservationInterface.Config config = new ReservationInterface.Config();
            config.setId(ioc.getUniqueId());
            config.setName(ioc.getName());
            config.setAbbv(ioc.getName());
            config.setLimit(ioc.isUnlimitedEnrollment() != false ? null : ioc.getLimit());
            r.getConfigs().add(config);
        }
        ArrayList<Class_> arrayList = new ArrayList<Class_>(reservation.getClasses());
        Collections.sort(arrayList, new ClassComparator(5));
        for (Class_ c : arrayList) {
            ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
            clazz.setId(c.getUniqueId());
            clazz.setAbbv(c.getSchedulingSubpart().getItypeDesc() + " " + c.getSectionNumberString(hibSession));
            clazz.setName(c.getClassLabel(co, showClassSuffixes));
            clazz.setLimit(c.getClassLimit());
            r.getClasses().add(clazz);
        }
        r.setStartDate(reservation.getStartDate());
        r.setExpirationDate(reservation.getExpirationDate());
        r.setExpired(reservation.isExpired());
        r.setLimit(reservation.getLimit());
        r.setInclusive(reservation.getInclusive());
        r.setId(reservation.getUniqueId());
        r.setOverride(reservation instanceof IndividualOverrideReservation || reservation instanceof GroupOverrideReservation || reservation instanceof CurriculumOverrideReservation);
        r.setAllowOverlaps(reservation.isAllowOverlap());
        r.setMustBeUsed(reservation.isMustBeUsed());
        r.setAlwaysExpired(reservation.isAlwaysExpired());
        r.setOverLimit(reservation.isCanAssignOverLimit());
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public List<ReservationInterface> getReservations(Long offeringId) throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface> results = new ArrayList<ReservationInterface>();
            String nameFormat = UserProperty.NameFormat.get(this.getSessionContext().getUser());
            try (Session hibSession = ReservationDAO.getInstance().getSession();){
                for (Reservation reservation : hibSession.createQuery("select r from Reservation r where r.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", offeringId.longValue()).setCacheable(true).list()) {
                    ReservationInterface.OverrideReservation o;
                    ReservationInterface r = this.convert(reservation, nameFormat, hibSession);
                    r.setEditable(this.getSessionContext().hasPermission(reservation, Right.ReservationEdit));
                    if (r instanceof ReservationInterface.OverrideReservation && (o = (ReservationInterface.OverrideReservation)r).getType() != null && !o.getType().isEditable()) {
                        r.setEditable(false);
                    }
                    results.add(r);
                }
            }
            Collections.sort(results);
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public List<ReservationInterface.IdName> getStudentGroups() throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface.IdName> results = new ArrayList<ReservationInterface.IdName>();
            try (Session hibSession = ReservationDAO.getInstance().getSession();){
                for (StudentGroup sg : hibSession.createQuery("select g from StudentGroup g where g.session.uniqueId = :sessionId order by g.groupName").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
                    ReservationInterface.IdName group = new ReservationInterface.IdName();
                    group.setId(sg.getUniqueId());
                    group.setName(sg.getGroupAbbreviation());
                    group.setAbbv(sg.getGroupName());
                    group.setLimit(sg.getStudents().size());
                    results.add(group);
                }
            }
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission(#reservationId, 'Reservation', 'ReservationEdit')")
    public ReservationInterface getReservation(Long reservationId) throws ReservationException, PageAccessException {
        try {
            ReservationInterface r;
            try (Session hibSession = ReservationDAO.getInstance().getSession();){
                ReservationInterface.OverrideReservation o;
                Reservation reservation = (Reservation)ReservationDAO.getInstance().get(reservationId, hibSession);
                if (reservation == null) {
                    throw new ReservationException("Reservation not found.");
                }
                r = this.convert(reservation, UserProperty.NameFormat.get(this.getSessionContext().getUser()), hibSession);
                r.setEditable(this.getSessionContext().hasPermission(reservation, Right.ReservationEdit));
                if (r instanceof ReservationInterface.OverrideReservation && (o = (ReservationInterface.OverrideReservation)r).getType() != null && !o.getType().isEditable()) {
                    r.setEditable(false);
                }
            }
            return r;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="(#reservation.id != null and checkPermission(#reservation.id, 'Reservation', 'ReservationEdit')) or (#reservation.id == null and checkPermission(#reservation.offering.id, 'InstructionalOffering', 'ReservationOffering') and checkPermission('ReservationAdd'))")
    public Long save(ReservationInterface reservation) throws ReservationException, PageAccessException {
        Long l;
        Session hibSession = ReservationDAO.getInstance().getSession();
        UserContext user = this.getSessionContext().getUser();
        try {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(reservation.getOffering().getId(), hibSession);
            if (offering == null) {
                throw new ReservationException(MESSAGES.errorOfferingDoesNotExist(reservation.getOffering().getName()));
            }
            Reservation r = null;
            if (reservation.getId() != null) {
                r = (Reservation)ReservationDAO.getInstance().get(reservation.getId(), hibSession);
            }
            if (r == null) {
                if (reservation instanceof ReservationInterface.OverrideReservation) {
                    r = new OverrideReservation();
                    ((OverrideReservation)r).setOverrideType(((ReservationInterface.OverrideReservation)reservation).getType());
                } else if (reservation instanceof ReservationInterface.IndividualReservation) {
                    r = new IndividualReservation();
                    if (reservation.isOverride()) {
                        r = new IndividualOverrideReservation();
                    }
                } else if (reservation instanceof ReservationInterface.GroupReservation) {
                    r = new StudentGroupReservation();
                    if (reservation.isOverride()) {
                        r = new GroupOverrideReservation();
                    }
                } else if (reservation instanceof ReservationInterface.CurriculumReservation) {
                    r = new CurriculumReservation();
                    if (reservation.isOverride()) {
                        r = new CurriculumOverrideReservation();
                    }
                } else if (reservation instanceof ReservationInterface.CourseReservation) {
                    r = new CourseReservation();
                } else if (reservation instanceof ReservationInterface.LCReservation) {
                    r = new LearningCommunityReservation();
                } else {
                    throw new ReservationException(MESSAGES.errorUnknownReservationType(reservation.getClass().getName()));
                }
            }
            r.setLimit(r instanceof IndividualReservation ? null : reservation.getLimit());
            r.setStartDate(reservation.getStartDate());
            r.setExpirationDate(reservation.getExpirationDate());
            r.setInstructionalOffering(offering);
            r.setInclusive(reservation.isInclusive());
            if (r instanceof IndividualOverrideReservation) {
                ((IndividualOverrideReservation)r).setAllowOverlap(reservation.isAllowOverlaps());
                ((IndividualOverrideReservation)r).setAlwaysExpired(reservation.isAlwaysExpired());
                ((IndividualOverrideReservation)r).setCanAssignOverLimit(reservation.isOverLimit());
                ((IndividualOverrideReservation)r).setMustBeUsed(reservation.isMustBeUsed());
            } else if (r instanceof GroupOverrideReservation) {
                ((GroupOverrideReservation)r).setAllowOverlap(reservation.isAllowOverlaps());
                ((GroupOverrideReservation)r).setAlwaysExpired(reservation.isAlwaysExpired());
                ((GroupOverrideReservation)r).setCanAssignOverLimit(reservation.isOverLimit());
                ((GroupOverrideReservation)r).setMustBeUsed(reservation.isMustBeUsed());
            } else if (r instanceof CurriculumOverrideReservation) {
                ((CurriculumOverrideReservation)r).setAllowOverlap(reservation.isAllowOverlaps());
                ((CurriculumOverrideReservation)r).setAlwaysExpired(reservation.isAlwaysExpired());
                ((CurriculumOverrideReservation)r).setCanAssignOverLimit(reservation.isOverLimit());
                ((CurriculumOverrideReservation)r).setMustBeUsed(reservation.isMustBeUsed());
            }
            offering.getReservations().add(r);
            if (r.getClasses() == null) {
                r.setClasses(new HashSet<Class_>());
            } else {
                r.getClasses().clear();
            }
            for (ReservationInterface.Clazz l2 : reservation.getClasses()) {
                r.getClasses().add((Class_)Class_DAO.getInstance().get(l2.getId(), hibSession));
            }
            if (r.getConfigurations() == null) {
                r.setConfigurations(new HashSet<InstrOfferingConfig>());
            } else {
                r.getConfigurations().clear();
            }
            for (ReservationInterface.Config config : reservation.getConfigs()) {
                r.getConfigurations().add((InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(config.getId(), hibSession));
            }
            if (r instanceof IndividualReservation) {
                IndividualReservation ir = (IndividualReservation)r;
                if (ir.getStudents() == null) {
                    ir.setStudents(new HashSet<Student>());
                } else {
                    ir.getStudents().clear();
                }
                for (ReservationInterface.IdName student : ((ReservationInterface.IndividualReservation)reservation).getStudents()) {
                    Student s = Student.findByExternalId(offering.getSessionId(), student.getAbbv());
                    if (s == null) continue;
                    ir.getStudents().add(s);
                }
            } else if (r instanceof CourseReservation) {
                ((CourseReservation)r).setCourse((CourseOffering)CourseOfferingDAO.getInstance().get(((ReservationInterface.CourseReservation)reservation).getCourse().getId(), hibSession));
            } else if (r instanceof LearningCommunityReservation) {
                LearningCommunityReservation lcr = (LearningCommunityReservation)r;
                lcr.setGroup((StudentGroup)StudentGroupDAO.getInstance().get(((ReservationInterface.LCReservation)reservation).getGroup().getId(), hibSession));
                lcr.setCourse((CourseOffering)CourseOfferingDAO.getInstance().get(((ReservationInterface.LCReservation)reservation).getCourse().getId(), hibSession));
            } else if (r instanceof StudentGroupReservation) {
                ((StudentGroupReservation)r).setGroup((StudentGroup)StudentGroupDAO.getInstance().get(((ReservationInterface.GroupReservation)reservation).getGroup().getId(), hibSession));
            } else if (r instanceof CurriculumReservation) {
                ReservationInterface.Areas curriculum = ((ReservationInterface.CurriculumReservation)reservation).getCurriculum();
                CurriculumReservation curriculumReservation = (CurriculumReservation)r;
                if (curriculumReservation.getAreas() == null) {
                    curriculumReservation.setAreas(new HashSet<AcademicArea>());
                } else {
                    curriculumReservation.getAreas().clear();
                }
                for (ReservationInterface.IdName aa : curriculum.getAreas()) {
                    curriculumReservation.getAreas().add((AcademicArea)AcademicAreaDAO.getInstance().get(aa.getId(), hibSession));
                }
                if (curriculumReservation.getMajors() == null) {
                    curriculumReservation.setMajors(new HashSet<PosMajor>());
                } else {
                    curriculumReservation.getMajors().clear();
                }
                for (ReservationInterface.IdName mj : curriculum.getMajors()) {
                    curriculumReservation.getMajors().add((PosMajor)PosMajorDAO.getInstance().get(mj.getId(), hibSession));
                }
                if (curriculumReservation.getClassifications() == null) {
                    curriculumReservation.setClassifications(new HashSet<AcademicClassification>());
                } else {
                    curriculumReservation.getClassifications().clear();
                }
                for (ReservationInterface.IdName clasf : curriculum.getClassifications()) {
                    curriculumReservation.getClassifications().add((AcademicClassification)AcademicClassificationDAO.getInstance().get(clasf.getId(), hibSession));
                }
                if (curriculumReservation.getMinors() == null) {
                    curriculumReservation.setMinors(new HashSet<PosMinor>());
                } else {
                    curriculumReservation.getMinors().clear();
                }
                for (ReservationInterface.IdName mn : curriculum.getMinors()) {
                    curriculumReservation.getMinors().add((PosMinor)PosMinorDAO.getInstance().get(mn.getId(), hibSession));
                }
                if (curriculumReservation.getConcentrations() == null) {
                    curriculumReservation.setConcentrations(new HashSet<PosMajorConcentration>());
                } else {
                    curriculumReservation.getConcentrations().clear();
                }
                for (ReservationInterface.IdName cc : curriculum.getConcentrations()) {
                    curriculumReservation.getConcentrations().add((PosMajorConcentration)PosMajorConcentrationDAO.getInstance().get(cc.getId(), hibSession));
                }
            }
            hibSession.saveOrUpdate((Object)r);
            hibSession.saveOrUpdate((Object)r.getInstructionalOffering());
            if (this.permissionOfferingLockNeeded.check(user, offering)) {
                StudentSectioningQueue.offeringChanged(hibSession, user, offering.getSession().getUniqueId(), offering.getUniqueId());
            }
            hibSession.flush();
            String className = ApplicationProperty.ExternalActionCourseOfferingReservationEdit.value();
            if (className != null && !className.trim().isEmpty()) {
                ExternalCourseOfferingReservationEditAction externalCourseOfferingReservationEditAction = (ExternalCourseOfferingReservationEditAction)Class.forName(className).newInstance();
                externalCourseOfferingReservationEditAction.performExternalCourseOfferingReservationEditAction(r.getInstructionalOffering(), hibSession);
            }
            ChangeLog.addChange(hibSession, this.sessionContext, r.getInstructionalOffering(), ChangeLog.Source.RESERVATION, reservation.getId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, r.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), r.getInstructionalOffering().getDepartment());
            hibSession.flush();
            l = r.getUniqueId();
        }
        catch (Throwable throwable) {
            try {
                hibSession.close();
                throw throwable;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (ReservationException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new ReservationException(e.getMessage());
            }
        }
        hibSession.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="checkPermission(#reservationId, 'Reservation', 'ReservationDelete')")
    public Boolean delete(Long reservationId) throws ReservationException, PageAccessException {
        try {
            UserContext user = this.getSessionContext().getUser();
            try (Session hibSession = ReservationDAO.getInstance().getSession();){
                Reservation reservation = (Reservation)ReservationDAO.getInstance().get(reservationId, hibSession);
                if (reservation == null) {
                    Boolean bl = false;
                    return bl;
                }
                InstructionalOffering offering = reservation.getInstructionalOffering();
                offering.getReservations().remove(reservation);
                hibSession.delete((Object)reservation);
                hibSession.saveOrUpdate((Object)offering);
                if (this.permissionOfferingLockNeeded.check(user, offering)) {
                    StudentSectioningQueue.offeringChanged(hibSession, user, offering.getSession().getUniqueId(), offering.getUniqueId());
                }
                hibSession.flush();
                String className = ApplicationProperty.ExternalActionCourseOfferingReservationEdit.value();
                if (className != null && !className.trim().isEmpty()) {
                    ExternalCourseOfferingReservationEditAction editAction = (ExternalCourseOfferingReservationEditAction)Class.forName(className).newInstance();
                    editAction.performExternalCourseOfferingReservationEditAction(offering, hibSession);
                }
                ChangeLog.addChange(hibSession, this.sessionContext, offering, ChangeLog.Source.RESERVATION, ChangeLog.Operation.DELETE, offering.getControllingCourseOffering().getSubjectArea(), offering.getDepartment());
                hibSession.flush();
                return true;
            }
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    private Long getAcademicSessionId() throws PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MESSAGES.authenticationExpired() : MESSAGES.authenticationRequired());
        }
        if (user.getCurrentAuthority() == null) {
            throw new PageAccessException(MESSAGES.authenticationInsufficient());
        }
        Long sessionId = user.getCurrentAcademicSessionId();
        if (sessionId == null) {
            throw new PageAccessException(MESSAGES.authenticationNoSession());
        }
        return sessionId;
    }

    @Override
    @PreAuthorize(value="checkPermission('ReservationAdd')")
    public Boolean canAddReservation() throws ReservationException, PageAccessException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public List<ReservationInterface> findReservations(ReservationInterface.ReservationFilterRpcRequest filter) throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface> results = new ArrayList<ReservationInterface>();
            this.getSessionContext().setAttribute("Reservations.LastFilter", (Object)filter.toQueryString());
            String nameFormat = UserProperty.NameFormat.get(this.getSessionContext().getUser());
            try (Session hibSession = CurriculumDAO.getInstance().getSession();){
                for (Reservation reservation : ReservationFilterBackend.reservations(filter, this.getSessionContext())) {
                    ReservationInterface.OverrideReservation o;
                    ReservationInterface r = this.convert(reservation, nameFormat, hibSession);
                    r.setEditable(this.getSessionContext().hasPermission(reservation, Right.ReservationEdit));
                    if (r instanceof ReservationInterface.OverrideReservation && (o = (ReservationInterface.OverrideReservation)r).getType() != null && !o.getType().isEditable()) {
                        r.setEditable(false);
                    }
                    results.add(r);
                }
            }
            Collections.sort(results);
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public String lastReservationFilter() throws ReservationException, PageAccessException {
        String filter = (String)this.getSessionContext().getAttribute("Reservations.LastFilter");
        return filter == null ? "mode:\"Not Expired\"" : filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReservationInterface.Curriculum> getCurricula(Long offeringId) throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface.Curriculum> results = new ArrayList<ReservationInterface.Curriculum>();
            try (Session hibSession = ReservationDAO.getInstance().getSession();){
                for (Curriculum c : hibSession.createQuery("select distinct c.classification.curriculum from CurriculumCourse c where c.course.instructionalOffering = :offeringId ").setLong("offeringId", offeringId.longValue()).setCacheable(true).list()) {
                    ReservationInterface.Curriculum curriculum = new ReservationInterface.Curriculum();
                    curriculum.setAbbv(c.getAbbv());
                    curriculum.setId(c.getUniqueId());
                    curriculum.setName(c.getName());
                    ReservationInterface.IdName area = new ReservationInterface.IdName();
                    area.setAbbv(c.getAcademicArea().getAcademicAreaAbbreviation());
                    area.setId(c.getAcademicArea().getUniqueId());
                    area.setName(Constants.curriculaToInitialCase(c.getAcademicArea().getTitle()));
                    curriculum.setArea(area);
                    int limit = 0;
                    for (CurriculumClassification cc : c.getClassifications()) {
                        AcademicClassification classification = cc.getAcademicClassification();
                        ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                        clasf.setId(classification.getUniqueId());
                        clasf.setName(Constants.curriculaToInitialCase(classification.getName()));
                        clasf.setAbbv(classification.getCode());
                        clasf.setLimit(0);
                        curriculum.getClassifications().add(clasf);
                        for (CurriculumCourse cr : cc.getCourses()) {
                            if (!cr.getCourse().getInstructionalOffering().getUniqueId().equals(offeringId)) continue;
                            limit += Math.round(cr.getPercShare().floatValue() * (float)cc.getNrStudents().intValue());
                            clasf.setLimit(clasf.getLimit() + Math.round(cr.getPercShare().floatValue() * (float)cc.getNrStudents().intValue()));
                        }
                    }
                    curriculum.setLimit(limit);
                    Collections.sort(curriculum.getMajors());
                    for (PosMajor major : c.getMajors()) {
                        ReservationInterface.IdName mj = new ReservationInterface.IdName();
                        mj.setId(major.getUniqueId());
                        mj.setAbbv(major.getCode());
                        mj.setName(Constants.curriculaToInitialCase(major.getName()));
                        curriculum.getMajors().add(mj);
                    }
                    Collections.sort(curriculum.getMajors());
                    results.add(curriculum);
                }
            }
            Collections.sort(results);
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    public ReservationServlet withSessionContext(SessionContext cx) {
        this.sessionContext = cx;
        return this;
    }
}

