/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class UniTimeConfirmationDialog
extends UniTimeDialogBox {
    protected static GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private String iAnswer = null;
    private UniTimeTextBox iTextBox = null;
    private AriaButton iYes;
    private AriaButton iNo;
    private Command iCommand;
    private P iError = null;
    private String iMessage;
    private boolean iDefaultIsYes = true;

    protected UniTimeConfirmationDialog(Type type, String message, String question, String answer, Command command) {
        this(type, message, false, question, answer, command);
    }

    protected UniTimeConfirmationDialog(Type type, String title, ImageResource icon, String message, String question, String answer, Command command) {
        this(type, title, icon, message, false, question, answer, command);
    }

    protected UniTimeConfirmationDialog(Type type, String message, boolean html, String question, String answer, Command command) {
        this(type, type.getTitle(), type.getIcon(), message, html, question, answer, command);
    }

    protected UniTimeConfirmationDialog(Type type, String title, ImageResource icon, String message, boolean html, String question, String answer, Command command) {
        super(true, true);
        this.setText(title);
        this.iAnswer = answer;
        this.iCommand = command;
        this.iMessage = message;
        P panel = new P("unitime-ConfirmationPanel");
        this.setEscapeToHide(true);
        this.setEnterToSubmit(new Command(){

            public void execute() {
                if (!UniTimeConfirmationDialog.this.iDefaultIsYes) {
                    UniTimeConfirmationDialog.this.hide();
                }
                if (UniTimeConfirmationDialog.this.iNo != null && UniTimeConfirmationDialog.this.iNo.isFocused()) {
                    return;
                }
                UniTimeConfirmationDialog.this.submit();
            }
        });
        P bd = new P("body-panel");
        panel.add((Widget)bd);
        P ic = new P("icon-panel");
        bd.add((Widget)ic);
        ic.add((Widget)new Image(icon));
        P cp = new P("content-panel");
        bd.add((Widget)cp);
        if (message != null && !message.isEmpty()) {
            P mp = new P("message-panel");
            cp.add((Widget)mp);
            P m = new P("message");
            if (html) {
                m.setHTML(message);
            } else {
                m.setText(message);
            }
            mp.add((Widget)m);
        }
        if (question != null) {
            P qp = new P("question-panel");
            cp.add((Widget)qp);
            P q = new P("question");
            q.setText(question);
            qp.add((Widget)q);
            this.iError = new P("error");
            this.iTextBox = new UniTimeTextBox();
            this.iTextBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    UniTimeConfirmationDialog.this.iError.setText("");
                }
            });
            this.iTextBox.addStyleName("answer");
            qp.add((Widget)this.iTextBox);
        }
        if (this.iError != null) {
            P ep = new P("error-panel");
            cp.add((Widget)ep);
            ep.add((Widget)this.iError);
        }
        P bp = new P("buttons-panel");
        panel.add((Widget)bp);
        this.iYes = new AriaButton(type == Type.CONFIRM ? MESSAGES.buttonConfirmYes() : MESSAGES.buttonConfirmOK());
        this.iYes.addStyleName("yes");
        bp.add((Widget)this.iYes);
        this.iYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeConfirmationDialog.this.submit();
            }
        });
        if (type == Type.CONFIRM) {
            this.iNo = new AriaButton(MESSAGES.buttonConfirmNo());
            this.iNo.addStyleName("no");
            bp.add((Widget)this.iNo);
            this.iNo.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    UniTimeConfirmationDialog.this.hide();
                }
            });
        }
        this.setWidget((Widget)panel);
    }

    @Override
    public void center() {
        this.center(true);
    }

    public void center(boolean defaultIsYes) {
        super.center();
        this.iDefaultIsYes = defaultIsYes;
        if (this.iMessage != null && !this.iMessage.isEmpty()) {
            AriaStatus.getInstance().setText(ARIA.dialogOpened(this.getText()) + " " + this.iMessage + (this.iNo == null ? "" : " " + ARIA.confirmationEnterToAcceptEscapeToReject()));
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                if (UniTimeConfirmationDialog.this.iTextBox != null) {
                    UniTimeConfirmationDialog.this.iTextBox.setFocus(true);
                    UniTimeConfirmationDialog.this.iTextBox.selectAll();
                } else {
                    (UniTimeConfirmationDialog.this.iDefaultIsYes ? UniTimeConfirmationDialog.this.iYes : UniTimeConfirmationDialog.this.iNo).setFocus(true);
                }
            }
        });
    }

    protected void submit() {
        if (this.iTextBox != null) {
            if (this.iTextBox.getText().equalsIgnoreCase(this.iAnswer)) {
                this.hide();
                if (this.iCommand != null) {
                    this.iCommand.execute();
                }
            } else {
                this.iError.setText(MESSAGES.confirmationWrongAnswer(this.iAnswer));
            }
        } else {
            this.hide();
            if (this.iCommand != null) {
                this.iCommand.execute();
            }
        }
    }

    public static void alert(String message) {
        new UniTimeConfirmationDialog(Type.ALERT, message, null, null, null).center();
    }

    public static void info(String message) {
        new UniTimeConfirmationDialog(Type.INFO, message, null, null, null).center();
    }

    public static void info(String message, boolean html) {
        new UniTimeConfirmationDialog(Type.INFO, message, html, null, null, null).center();
    }

    public static void alert(boolean useDefault, String message) {
        if (useDefault) {
            Window.alert((String)message);
        } else {
            UniTimeConfirmationDialog.alert(message);
        }
    }

    public static void confirm(String message, Command callback) {
        new UniTimeConfirmationDialog(Type.CONFIRM, message, null, null, callback).center();
    }

    public static void confirmFocusNo(String message, Command callback) {
        new UniTimeConfirmationDialog(Type.CONFIRM, message, null, null, callback).center(false);
    }

    public static void confirm(String message, ImageResource icon, Command callback) {
        new UniTimeConfirmationDialog(Type.CONFIRM, Type.CONFIRM.getTitle(), icon, message, null, null, callback).center();
    }

    public static void confirm(boolean useDefault, String message, Command callback) {
        if (useDefault) {
            if (Window.confirm((String)message)) {
                callback.execute();
            }
        } else {
            UniTimeConfirmationDialog.confirm(message, callback);
        }
    }

    public static void confirm(String message, String question, String answer, Command callback) {
        new UniTimeConfirmationDialog(Type.CONFIRM, message, question, answer, callback).center();
    }

    public static native void fireCallback(JavaScriptObject var0);

    public static void _confirm(String message, final JavaScriptObject callback, String question, String answer) {
        new UniTimeConfirmationDialog(callback == null ? Type.ALERT : Type.CONFIRM, message, question, answer, callback == null ? null : new Command(){

            public void execute() {
                UniTimeConfirmationDialog.fireCallback(callback);
            }
        }).center();
    }

    public static native void createTriggers();

    public static enum Type {
        ALERT(MESSAGES.dialogAlert(), RESOURCES.alert()),
        CONFIRM(MESSAGES.dialogConfirmation(), RESOURCES.confirm()),
        INFO(MESSAGES.dialogInfo(), RESOURCES.info());

        private String iTitle;
        private ImageResource iIcon;

        private Type(String title, ImageResource icon) {
            this.iTitle = title;
            this.iIcon = icon;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public ImageResource getIcon() {
            return this.iIcon;
        }
    }
}

