/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.solver.suggestions.ConflictTable;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsPageContext;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

public class ConflictsWidget
extends SimpleForm
implements TakesValue<Long> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private SuggestionsPageContext iContext;
    private UniTimeHeaderPanel iHeader;
    private ConflictTable iTable;
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private Long iClassId = null;
    private boolean iConflictsComputed = false;

    public ConflictsWidget(SuggestionsPageContext context) {
        this.iContext = context;
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.headerConflicts());
        this.iHeader.setCollapsible(SolverCookie.getInstance().isShowConflicts());
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SolverCookie.getInstance().setShowConflicts((Boolean)event.getValue());
                if (((Boolean)event.getValue()).booleanValue()) {
                    ConflictsWidget.this.showConflicts();
                } else {
                    ConflictsWidget.this.hideConflicts();
                }
            }
        });
        this.removeStyleName("unitime-NotPrintableBottomLine");
    }

    public void onSelection(SuggestionsInterface.ClassAssignmentDetails conflict) {
    }

    public void setValue(Long classId) {
        this.iHeader.clearMessage();
        this.clear();
        this.iConflictsComputed = false;
        if (this.iTable == null) {
            this.iTable = new ConflictTable(this.iContext);
            this.iTable.setVisible(false);
            this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<SuggestionsInterface.ClassAssignmentDetails>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<SuggestionsInterface.ClassAssignmentDetails> event) {
                    if (event.getData() != null) {
                        ConflictsWidget.this.onSelection(event.getData());
                    }
                }
            });
        } else {
            this.iTable.setVisible(false);
        }
        this.addHeaderRow((Widget)this.iHeader);
        this.addRow((Widget)this.iTable);
        this.iClassId = classId;
        if (SolverCookie.getInstance().isShowConflicts()) {
            this.showConflicts();
        } else {
            this.hideConflicts();
        }
    }

    public Long getValue() {
        return this.iClassId;
    }

    protected void hideConflicts() {
        this.iTable.setVisible(false);
    }

    protected void showConflicts() {
        if (!this.iConflictsComputed) {
            this.computeConflicts();
        } else {
            this.iTable.setVisible(true);
        }
    }

    protected void computeConflicts() {
        this.iConflictsComputed = true;
        this.iTable.setVisible(false);
        this.iHeader.showLoading();
        RPC.execute(new SuggestionsInterface.ComputeConflictTableRequest(this.iClassId), new AsyncCallback<GwtRpcResponseList<SuggestionsInterface.ClassAssignmentDetails>>(){

            public void onFailure(Throwable caught) {
                ConflictsWidget.this.iHeader.setErrorMessage(MESSAGES.failedToComputeConflicts(caught.getMessage()));
            }

            public void onSuccess(GwtRpcResponseList<SuggestionsInterface.ClassAssignmentDetails> result) {
                ConflictsWidget.this.iHeader.clearMessage();
                ConflictsWidget.this.iTable.setValue(result);
                ConflictsWidget.this.iTable.setVisible(true);
            }
        });
    }
}

