/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.Lookup;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaDialogBox;
import org.unitime.timetable.gwt.client.aria.AriaPasswordTextBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.page.InfoPanel;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.gwt.shared.UserAuthenticationProvider;

public class UserAuthentication
implements UserAuthenticationProvider {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private InfoPanel iPanel;
    private AriaButton iLogIn;
    private AriaButton iSkip;
    private AriaButton iLookup;
    private AriaTextBox iUserName;
    private AriaPasswordTextBox iUserPassword;
    private AriaTextBox iPin = null;
    private DialogBox iDialog;
    private Label iError;
    private ArrayList<UserAuthenticatedHandler> iUserAuthenticatedHandlers = new ArrayList();
    private static final SectioningServiceAsync sSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private static AsyncCallback<String> sAuthenticateCallback = null;
    private boolean iLoggedIn = false;
    private boolean iGuest = false;
    private String iLastUser = null;
    private String iLastPin = null;
    private boolean iAllowGuest = false;
    private Command iOnLoginCommand = null;
    private Lookup iLookupDialog = null;

    public UserAuthentication(InfoPanel panel, boolean allowGuest) {
        this.iAllowGuest = allowGuest;
        this.iPanel = panel;
        this.iPanel.setPreventDefault(true);
        this.iPanel.setVisible(true);
        this.iPanel.setText(MESSAGES.userNotAuthenticated());
        this.iPanel.setHint(MESSAGES.userHint());
        this.iPanel.setAriaLabel(ARIA.userNotAuthenticated());
        this.iPanel.setInfo(null);
        this.iDialog = new AriaDialogBox();
        this.iDialog.setText(MESSAGES.dialogAuthenticate());
        this.iDialog.setAnimationEnabled(true);
        this.iDialog.setAutoHideEnabled(false);
        this.iDialog.setGlassEnabled(true);
        this.iDialog.setModal(true);
        this.iDialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                UserAuthentication.this.iUserName.setText("");
                UserAuthentication.this.iUserPassword.setText("");
                if (UserAuthentication.this.iPin != null) {
                    UserAuthentication.this.iPin.setText("");
                }
            }
        });
        FlexTable grid = new FlexTable();
        grid.setCellPadding(5);
        grid.setCellSpacing(0);
        int row = 0;
        grid.setText(row, 0, MESSAGES.username());
        this.iUserName = new AriaTextBox();
        this.iUserName.setStyleName("gwt-SuggestBox");
        this.iUserName.setAriaLabel(ARIA.propUserName());
        grid.setWidget(row, 1, (Widget)this.iUserName);
        grid.setText(++row, 0, MESSAGES.password());
        this.iUserPassword = new AriaPasswordTextBox();
        this.iUserPassword.setStyleName("gwt-SuggestBox");
        this.iUserPassword.setAriaLabel(ARIA.propPassword());
        grid.setWidget(row, 1, (Widget)this.iUserPassword);
        ++row;
        if (CONSTANTS.hasAuthenticationPin()) {
            grid.setText(row, 0, MESSAGES.pin());
            this.iPin = new AriaTextBox();
            this.iPin.setStyleName("gwt-SuggestBox");
            this.iPin.setAriaLabel(ARIA.propPinNumber());
            grid.setWidget(row, 1, (Widget)this.iPin);
            ++row;
        }
        this.iError = new Label();
        this.iError.setStyleName("unitime-ErrorMessage");
        this.iError.setVisible(false);
        grid.getFlexCellFormatter().setColSpan(row, 0, 2);
        grid.setWidget(row, 0, (Widget)this.iError);
        ++row;
        HorizontalPanel buttonPanelWithPad = new HorizontalPanel();
        buttonPanelWithPad.setWidth("100%");
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setSpacing(5);
        buttonPanelWithPad.add((Widget)buttonPanel);
        buttonPanelWithPad.setCellHorizontalAlignment((Widget)buttonPanel, HasHorizontalAlignment.ALIGN_RIGHT);
        grid.getFlexCellFormatter().setColSpan(row, 0, 2);
        grid.setWidget(row, 0, (Widget)buttonPanelWithPad);
        ++row;
        this.iLogIn = new AriaButton(MESSAGES.buttonUserLogin());
        buttonPanel.add((Widget)this.iLogIn);
        this.iSkip = new AriaButton(MESSAGES.buttonUserSkip());
        buttonPanel.add((Widget)this.iSkip);
        this.iSkip.setVisible(this.iAllowGuest);
        this.iSkip.setAriaLabel(ARIA.buttonLogInAsGuest());
        this.iLookupDialog = new Lookup();
        this.iLookupDialog.setOptions("mustHaveExternalId,source=students");
        this.iLookupDialog.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

            public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                if (event.getValue() != null) {
                    sSectioningService.logIn("LOOKUP", ((PersonInterface)event.getValue()).getId(), null, (AsyncCallback<String>)sAuthenticateCallback);
                }
            }
        });
        this.iLookup = new AriaButton(MESSAGES.buttonUserLookup());
        buttonPanel.add((Widget)this.iLookup);
        this.iLookup.setVisible(false);
        this.iSkip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserAuthentication.this.logIn(true);
            }
        });
        this.iLogIn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserAuthentication.this.logIn(false);
            }
        });
        this.iLookup.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserAuthentication.this.doLookup();
            }
        });
        this.iUserName.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            UserAuthentication.this.iUserPassword.selectAll();
                            UserAuthentication.this.iUserPassword.setFocus(true);
                        }
                    });
                }
                if (event.getNativeKeyCode() == 27 && UserAuthentication.this.iAllowGuest) {
                    UserAuthentication.this.logIn(true);
                }
            }
        });
        this.iUserPassword.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    UserAuthentication.this.logIn(false);
                }
                if (event.getNativeKeyCode() == 27 && UserAuthentication.this.iAllowGuest) {
                    UserAuthentication.this.logIn(true);
                }
            }
        });
        this.iDialog.add((Widget)grid);
        ClickHandler ch = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (UserAuthentication.this.iLoggedIn) {
                    UserAuthentication.this.logOut();
                } else {
                    UserAuthentication.this.authenticate();
                }
            }
        };
        this.iPanel.setClickHandler(ch);
        sAuthenticateCallback = new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                AriaStatus.getInstance().setText(caught.getMessage());
                UserAuthentication.this.iError.setText(caught.getMessage());
                UserAuthentication.this.iError.setVisible(true);
                UserAuthentication.this.iUserName.setEnabled(true);
                UserAuthentication.this.iUserPassword.setEnabled(true);
                if (UserAuthentication.this.iPin != null) {
                    UserAuthentication.this.iPin.setEnabled(true);
                }
                UserAuthentication.this.iLogIn.setEnabled(true);
                UserAuthentication.this.iSkip.setEnabled(true);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        UserAuthentication.this.iUserName.selectAll();
                        UserAuthentication.this.iUserName.setFocus(true);
                    }
                });
            }

            public void onSuccess(String result) {
                UserAuthentication.this.iLastPin = UserAuthentication.this.iPin == null ? null : UserAuthentication.this.iPin.getText();
                UserAuthentication.this.iUserName.setEnabled(true);
                UserAuthentication.this.iUserPassword.setEnabled(true);
                if (UserAuthentication.this.iPin != null) {
                    UserAuthentication.this.iPin.setEnabled(true);
                }
                UserAuthentication.this.iLogIn.setEnabled(true);
                UserAuthentication.this.iSkip.setEnabled(true);
                UserAuthentication.this.iError.setVisible(false);
                UserAuthentication.this.iDialog.hide();
                UserAuthentication.this.authenticated(result);
                UserAuthenticatedEvent e = new UserAuthenticatedEvent(UserAuthentication.this.iGuest);
                for (UserAuthenticatedHandler h : UserAuthentication.this.iUserAuthenticatedHandlers) {
                    h.onLogIn(e);
                }
                if (UserAuthentication.this.iOnLoginCommand != null) {
                    UserAuthentication.this.iOnLoginCommand.execute();
                }
                Client.reloadMenu();
            }
        };
    }

    public void setLookupOptions(String options) {
        this.iLookupDialog.setOptions(options);
    }

    public void setAllowLookup(boolean allow) {
        this.iLookup.setVisible(allow);
        if (this.isAllowLookup() && !CONSTANTS.allowUserLogin()) {
            this.iPanel.setHint(MESSAGES.userHintLookup());
            this.iPanel.setAriaLabel(ARIA.userAuthenticatedLookup(this.getUser()));
        } else {
            this.iPanel.setHint(this.iGuest || this.getUser() == null ? MESSAGES.userHintLogin() : MESSAGES.userHintLogout());
            this.iPanel.setAriaLabel(this.iGuest || this.getUser() == null ? ARIA.userGuest() : ARIA.userAuthenticated(this.getUser()));
        }
    }

    public boolean isAllowLookup() {
        return this.iLookup.isVisible();
    }

    public void doLookup() {
        if (this.iDialog.isShowing()) {
            this.iDialog.hide();
        }
        this.iLookupDialog.center();
    }

    public boolean isShowing() {
        return this.iDialog.isShowing();
    }

    public boolean isGuest() {
        return this.iGuest;
    }

    public void authenticate() {
        if (!CONSTANTS.allowUserLogin()) {
            if (this.isAllowLookup()) {
                this.doLookup();
            } else {
                ToolBox.open(GWT.getHostPageBaseURL() + "login.do?target=" + URL.encodeQueryString((String)Window.Location.getHref()));
            }
            return;
        }
        AriaStatus.getInstance().setText(ARIA.authenticationDialogOpened());
        this.iError.setVisible(false);
        this.iDialog.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                UserAuthentication.this.iUserName.selectAll();
                UserAuthentication.this.iUserName.setFocus(true);
            }
        });
    }

    public void authenticated(String user) {
        if (this.iDialog.isShowing()) {
            this.iDialog.hide();
        }
        if (user == null) {
            if (this.iAllowGuest) {
                this.iGuest = true;
                this.iPanel.setText(MESSAGES.userLabel(MESSAGES.userGuest()));
                this.iPanel.setAriaLabel(ARIA.userGuest());
            } else {
                this.iGuest = false;
                this.iPanel.setText(MESSAGES.userNotAuthenticated());
                this.iPanel.setAriaLabel(ARIA.userNotAuthenticated());
            }
            this.iLoggedIn = false;
            this.iPanel.setHint(MESSAGES.userHintLogin());
        } else {
            this.iLoggedIn = true;
            this.iGuest = false;
            this.iPanel.setText(MESSAGES.userLabel(user));
            if (this.isAllowLookup() && !CONSTANTS.allowUserLogin()) {
                this.iPanel.setHint(MESSAGES.userHintLookup());
                this.iPanel.setAriaLabel(ARIA.userAuthenticatedLookup(this.getUser()));
            } else {
                this.iPanel.setHint(MESSAGES.userHintLogout());
                this.iPanel.setAriaLabel(ARIA.userAuthenticated(user));
            }
        }
        this.iLastUser = user;
    }

    private void logIn(boolean guest) {
        this.iError.setVisible(false);
        if (guest) {
            sSectioningService.logOut(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(Boolean result) {
                    UserAuthentication.this.iDialog.hide();
                    UserAuthentication.this.authenticated(null);
                    UserAuthenticatedEvent e = new UserAuthenticatedEvent(UserAuthentication.this.iGuest);
                    for (UserAuthenticatedHandler h : UserAuthentication.this.iUserAuthenticatedHandlers) {
                        h.onLogIn(e);
                    }
                    if (UserAuthentication.this.iOnLoginCommand != null) {
                        UserAuthentication.this.iOnLoginCommand.execute();
                    }
                    Client.reloadMenu();
                }
            });
            return;
        }
        this.iUserName.setEnabled(false);
        this.iUserPassword.setEnabled(false);
        if (this.iPin != null) {
            this.iPin.setEnabled(false);
        }
        this.iLogIn.setEnabled(false);
        this.iSkip.setEnabled(false);
        sSectioningService.logIn(this.iUserName.getText(), this.iUserPassword.getText(), this.iPin == null ? null : this.iPin.getText(), sAuthenticateCallback);
    }

    public void logOut() {
        sSectioningService.logOut(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                if (result.booleanValue()) {
                    UserAuthentication.this.authenticated(null);
                    UserAuthenticatedEvent e = new UserAuthenticatedEvent(UserAuthentication.this.iGuest);
                    for (UserAuthenticatedHandler h : UserAuthentication.this.iUserAuthenticatedHandlers) {
                        h.onLogOut(e);
                    }
                    Client.reloadMenu();
                } else {
                    sSectioningService.whoAmI(new AsyncCallback<String>(){

                        public void onFailure(Throwable caught) {
                            UserAuthentication.this.authenticated(null);
                            UserAuthenticatedEvent e = new UserAuthenticatedEvent(UserAuthentication.this.iGuest);
                            for (UserAuthenticatedHandler h : UserAuthentication.this.iUserAuthenticatedHandlers) {
                                h.onLogOut(e);
                            }
                            Client.reloadMenu();
                        }

                        public void onSuccess(String result) {
                            UserAuthentication.this.authenticated(result);
                            UserAuthenticatedEvent e = new UserAuthenticatedEvent(UserAuthentication.this.iGuest);
                            for (UserAuthenticatedHandler h : UserAuthentication.this.iUserAuthenticatedHandlers) {
                                h.onLogOut(e);
                            }
                            Client.reloadMenu();
                        }
                    });
                }
            }
        });
    }

    @Override
    public String getUser() {
        return this.iLastUser;
    }

    public String getPin() {
        return this.iLastPin;
    }

    @Override
    public void setUser(final String user, final AsyncCallback<Boolean> callback) {
        this.iOnLoginCommand = null;
        if (user == null) {
            if (this.iLastUser == null) {
                callback.onSuccess((Object)true);
            } else if (this.iAllowGuest) {
                this.logIn(true);
                callback.onSuccess((Object)true);
            } else {
                callback.onSuccess((Object)false);
                this.authenticate();
            }
        } else if (user.equals(this.iLastUser)) {
            callback.onSuccess((Object)true);
        } else {
            this.iOnLoginCommand = new Command(){

                public void execute() {
                    callback.onSuccess((Object)user.equals(UserAuthentication.this.getUser()));
                }
            };
            this.iPanel.setText(user);
            this.iPanel.setAriaLabel(ARIA.userAuthenticated(user));
            this.authenticate();
        }
    }

    public void addUserAuthenticatedHandler(UserAuthenticatedHandler h) {
        this.iUserAuthenticatedHandlers.add(h);
    }

    public static void personFound(String externalUniqueId) {
        sSectioningService.logIn("LOOKUP", externalUniqueId, null, sAuthenticateCallback);
    }

    public boolean isLoggedIn() {
        return this.iLoggedIn;
    }

    private native JavaScriptObject createLookupCallback();

    public static interface UserAuthenticatedHandler {
        public void onLogIn(UserAuthenticatedEvent var1);

        public void onLogOut(UserAuthenticatedEvent var1);
    }

    public static class UserAuthenticatedEvent {
        private boolean iGuest = false;

        private UserAuthenticatedEvent(boolean guest) {
            this.iGuest = guest;
        }

        public boolean isGuest() {
            return this.iGuest;
        }
    }
}

