/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.PageAccessException;

public class ScheduleStatus
extends P {
    static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private Level iLevel;
    private Image iImage;
    private P iMessage;
    private Command iOnClickCommand;

    public ScheduleStatus() {
        super("unitime-ScheduleStatus");
        this.setVisible(false);
        this.iImage = new Image();
        this.iImage.setStyleName("image");
        this.iMessage = new P("message");
        this.add((Widget)this.iImage);
        this.add((Widget)this.iMessage);
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ScheduleStatus.this.iOnClickCommand != null) {
                    ScheduleStatus.this.iOnClickCommand.execute();
                }
            }
        });
    }

    public void setMessage(Level level, String message, Command command) {
        this.iOnClickCommand = command;
        if (this.iLevel != null) {
            this.removeStyleName(this.iLevel.getStyleName());
        }
        if (message == null || message.isEmpty()) {
            this.iLevel = null;
            this.iMessage.setHTML("");
            this.setVisible(false);
        } else {
            this.iLevel = level;
            this.addStyleName(this.iLevel.getStyleName());
            this.iMessage.setHTML(message);
            this.iImage.setResource(this.iLevel.getIcon());
            this.iImage.setAltText(message);
            this.setVisible(true);
        }
        if (this.iOnClickCommand != null) {
            this.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        } else {
            this.getElement().getStyle().clearCursor();
        }
    }

    public void setMessage(Level level, String message) {
        this.setMessage(level, message, null);
    }

    public Level getLevel() {
        return this.iLevel;
    }

    public String getMessage() {
        return this.iMessage.getHTML();
    }

    public void info(String message, boolean popup) {
        this.setMessage(Level.INFO, message);
        if (popup) {
            UniTimeNotifications.info(message);
        }
    }

    public void info(String message) {
        this.info(message, true);
    }

    public void warning(String message, boolean popup) {
        this.setMessage(Level.WARNING, message);
        if (popup) {
            UniTimeNotifications.warn(message);
        }
    }

    public void warning(String message) {
        this.warning(message, true);
    }

    public void error(String message, boolean popup) {
        this.setMessage(Level.ERROR, message);
        if (popup) {
            UniTimeNotifications.error(message);
        }
    }

    public void error(String message, boolean popup, Throwable t) {
        if (t != null && t instanceof PageAccessException && message != null && !message.contains(MESSAGES.sessionExpiredClickToLogin())) {
            this.setMessage(Level.ERROR, message + "\n" + MESSAGES.sessionExpiredClickToLogin(), new Command(){

                public void execute() {
                    Window.open((String)("selectPrimaryRole.do?m=" + URL.encodeQueryString((String)MESSAGES.sessionExpiredClickToLogin()) + "&target=" + URL.encodeQueryString((String)Window.Location.getHref())), (String)"_self", (String)"");
                }
            });
        } else {
            this.setMessage(Level.ERROR, message);
        }
        if (popup) {
            UniTimeNotifications.error(message);
        }
    }

    public void error(String message) {
        this.error(message, true);
    }

    public void error(String message, Throwable t) {
        if (t != null && t instanceof PageAccessException && message != null && !message.contains(MESSAGES.sessionExpiredClickToLogin())) {
            this.setMessage(Level.ERROR, message + "\n" + MESSAGES.sessionExpiredClickToLogin(), new Command(){

                public void execute() {
                    Window.open((String)("selectPrimaryRole.do?m=" + URL.encodeQueryString((String)MESSAGES.sessionExpiredClickToLogin()) + "&target=" + URL.encodeQueryString((String)Window.Location.getHref())), (String)"_self", (String)"");
                }
            });
        } else {
            this.setMessage(Level.ERROR, message);
        }
        UniTimeNotifications.error(message, t);
    }

    public void error(String message, Throwable t, Command callback) {
        this.setMessage(Level.ERROR, message, callback);
        UniTimeNotifications.error(message, t, callback);
    }

    public void error(Throwable t) {
        this.error(t.getMessage(), t);
    }

    public void done(String message, boolean popup) {
        this.setMessage(Level.DONE, message);
        if (popup) {
            UniTimeNotifications.info(message);
        }
    }

    public void done(String message) {
        this.done(message, true);
    }

    public void clear() {
        this.setMessage(null, null);
    }

    public void setOnClickCommand(Command command) {
        this.iOnClickCommand = command;
    }

    public static enum Level {
        INFO("unitime-ScheduleMessage", RESOURCES.statusInfo()),
        WARNING("unitime-ScheduleWarningMessage", RESOURCES.statusWarning()),
        ERROR("unitime-ScheduleErrorMessage", RESOURCES.statusError()),
        DONE("unitime-ScheduleMessage", RESOURCES.statusDone());

        private String iStyleName;
        private ImageResource iIcon;

        private Level(String styleName, ImageResource icon) {
            this.iStyleName = styleName;
            this.iIcon = icon;
        }

        public String getStyleName() {
            return this.iStyleName;
        }

        public ImageResource getIcon() {
            return this.iIcon;
        }
    }
}

