/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.sectioning.CourseRequestLine;
import org.unitime.timetable.gwt.client.sectioning.CourseRequestsConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.CourseSelection;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.Validator;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class CourseRequestsTable
extends P
implements HasValue<CourseRequestInterface> {
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private OnlineSectioningInterface.StudentSectioningContext iContext;
    private ArrayList<CourseRequestLine> iCourses;
    private ArrayList<CourseRequestLine> iAlternatives;
    private Label iTip;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecReg;
    private CourseRequestInterface.CheckCoursesResponse iLastCheck;
    Validator<CourseSelection> iCheckForDuplicities;
    private boolean iCanWaitList = true;
    private P iHeader;
    private P iHeaderTitle;
    private P iHeaderWaitlist;
    private P iAltHeader;
    private P iAltHeaderTitle;
    private P iAltHeaderNote;
    private boolean iArrowsVisible = true;
    private Image iCreditStatusIcon = null;

    public CourseRequestsTable(OnlineSectioningInterface.StudentSectioningContext context, SpecialRegistrationInterface.SpecialRegistrationContext specreg) {
        super("unitime-CourseRequests");
        CourseRequestLine prev;
        CourseRequestLine line;
        int i;
        this.iContext = context;
        this.iSpecReg = specreg;
        this.iHeader = new P("header");
        this.iHeaderTitle = new P("title");
        this.iHeaderTitle.setText(MESSAGES.courseRequestsCourses());
        this.iHeaderWaitlist = new P("waitlist");
        this.iHeaderWaitlist.setHTML(MESSAGES.courseRequestsWaitList());
        this.iHeader.add((Widget)this.iHeaderTitle);
        this.iHeader.add((Widget)this.iHeaderWaitlist);
        this.add((Widget)this.iHeader);
        this.iCourses = new ArrayList();
        this.iAlternatives = new ArrayList();
        this.iCheckForDuplicities = new Validator<CourseSelection>(){

            @Override
            public String validate(CourseSelection source) {
                CourseRequestInterface.RequestedCourse course = (CourseRequestInterface.RequestedCourse)source.getValue();
                if (course == null || course.isFreeTime()) {
                    return null;
                }
                for (CourseRequestLine line : CourseRequestsTable.this.iCourses) {
                    for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                        if (courseSelectionBox == source || !course.equals(courseSelectionBox.getValue()) || courseSelectionBox.isInactive() || course.isInactive()) continue;
                        return MESSAGES.validationMultiple(course.getCourseName());
                    }
                }
                for (CourseRequestLine line : CourseRequestsTable.this.iAlternatives) {
                    for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                        if (courseSelectionBox == source || !course.equals(courseSelectionBox.getValue()) || courseSelectionBox.isInactive() || course.isInactive()) continue;
                        return MESSAGES.validationMultiple(course.getCourseName());
                    }
                }
                return null;
            }
        };
        for (i = 0; i < CONSTANTS.numberOfCourses(); ++i) {
            line = new CourseRequestLine(this.iContext, i, false, this.iCheckForDuplicities, this.iSpecReg);
            this.iCourses.add(line);
            if (i > 0) {
                prev = this.iCourses.get(i - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            }
            line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

                public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                    if (CourseRequestsTable.this.iLastCheck != null) {
                        for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                            CourseRequestsTable.this.setErrors(courseSelectionBox, CourseRequestsTable.this.iLastCheck);
                        }
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getValue());
                    if (event.getValue() != null && CourseRequestsTable.this.iCourses.indexOf((Object)line) + 1 == CourseRequestsTable.this.iCourses.size()) {
                        CourseRequestsTable.this.addCourseLine();
                    }
                }
            });
            this.add((Widget)line);
        }
        this.iCourses.get(1).getCourses().get(0).setHint(MESSAGES.courseRequestsHint1());
        this.iCourses.get(3).getCourses().get(0).setHint(MESSAGES.courseRequestsHint3());
        this.iCourses.get(4).getCourses().get(0).setHint(MESSAGES.courseRequestsHint4());
        this.iCourses.get(CONSTANTS.numberOfCourses() - 1).getCourses().get(0).setHint(MESSAGES.courseRequestsHint8());
        this.iTip = new Label(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
        ToolBox.disableTextSelectInternal((Element)this.iTip.getElement());
        this.iTip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String oldText = CourseRequestsTable.this.iTip.getText();
                do {
                    CourseRequestsTable.this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
                } while (oldText.equals(CourseRequestsTable.this.iTip.getText()));
            }
        });
        this.iTip.addStyleName("tip");
        this.iTip.addStyleName("unitime-NoPrint");
        this.add((Widget)this.iTip);
        if (CONSTANTS.numberOfAlternatives() > 0) {
            this.iAltHeader = new P("alt-header");
            this.iAltHeaderTitle = new P("title");
            this.iAltHeaderTitle.setText(MESSAGES.courseRequestsAlternatives());
            this.iAltHeaderNote = new P("note");
            this.iAltHeaderNote.setText(MESSAGES.courseRequestsAlternativesNote());
            this.iAltHeader.add((Widget)this.iAltHeaderTitle);
            this.iAltHeader.add((Widget)this.iAltHeaderNote);
            this.add((Widget)this.iAltHeader);
        }
        for (i = 0; i < CONSTANTS.numberOfAlternatives(); ++i) {
            line = new CourseRequestLine(this.iContext, i, true, this.iCheckForDuplicities, this.iSpecReg);
            this.iAlternatives.add(line);
            if (i == 0) {
                prev = this.iCourses.get(this.iCourses.size() - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            } else {
                prev = this.iAlternatives.get(i - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            }
            line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

                public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                    if (CourseRequestsTable.this.iLastCheck != null) {
                        for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                            CourseRequestsTable.this.setErrors(courseSelectionBox, CourseRequestsTable.this.iLastCheck);
                        }
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getValue());
                    if (event.getValue() != null && CourseRequestsTable.this.iAlternatives.indexOf((Object)line) + 1 == CourseRequestsTable.this.iAlternatives.size()) {
                        CourseRequestsTable.this.addAlternativeLine();
                    }
                }
            });
            this.add((Widget)line);
        }
        if (CONSTANTS.numberOfAlternatives() > 0) {
            this.iAlternatives.get(0).getCourses().get(0).setHint(MESSAGES.courseRequestsHintA0());
        }
    }

    private void addCourseLine() {
        int i = this.iCourses.size();
        final CourseRequestLine line = new CourseRequestLine(this.iContext, i, false, this.iCheckForDuplicities, this.iSpecReg);
        this.iCourses.add(line);
        CourseRequestLine prev = this.iCourses.get(i - 1);
        prev.getCourses().get(0).setHint("");
        line.getCourses().get(0).setHint(MESSAGES.courseRequestsHint8());
        CourseRequestLine next = this.iAlternatives.isEmpty() ? null : this.iAlternatives.get(0);
        line.setPrevious(prev);
        prev.setNext(line);
        if (next != null) {
            line.setNext(next);
            next.setPrevious(line);
        }
        line.setArrowsVisible(this.iArrowsVisible);
        line.setWaitListVisible(this.iCanWaitList);
        this.insert((Widget)line, 1 + i);
        line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                if (CourseRequestsTable.this.iLastCheck != null) {
                    for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                        CourseRequestsTable.this.setErrors(courseSelectionBox, CourseRequestsTable.this.iLastCheck);
                    }
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getValue());
                if (event.getValue() != null && CourseRequestsTable.this.iCourses.indexOf((Object)line) + 1 == CourseRequestsTable.this.iCourses.size()) {
                    CourseRequestsTable.this.addCourseLine();
                }
            }
        });
    }

    private void addAlternativeLine() {
        CourseRequestLine prev;
        if (this.iAlternatives.isEmpty()) {
            this.iAltHeader = new P("alt-header");
            this.iAltHeaderTitle = new P("title");
            this.iAltHeaderTitle.setText(MESSAGES.courseRequestsAlternatives());
            this.iAltHeaderNote = new P("note");
            this.iAltHeaderNote.setText(MESSAGES.courseRequestsAlternativesNote());
            this.iAltHeader.add((Widget)this.iAltHeaderTitle);
            this.iAltHeader.add((Widget)this.iAltHeaderNote);
            this.add((Widget)this.iAltHeader);
        }
        int i = this.iAlternatives.size();
        final CourseRequestLine line = new CourseRequestLine(this.iContext, i, true, this.iCheckForDuplicities, this.iSpecReg);
        this.iAlternatives.add(line);
        CourseRequestLine courseRequestLine = prev = i == 0 ? this.iCourses.get(this.iCourses.size() - 1) : this.iAlternatives.get(i - 1);
        if (prev != null) {
            line.setPrevious(prev);
            prev.setNext(line);
        }
        line.setArrowsVisible(this.iArrowsVisible);
        this.insert((Widget)line, 3 + this.iCourses.size() + i);
        line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                if (CourseRequestsTable.this.iLastCheck != null) {
                    for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                        CourseRequestsTable.this.setErrors(courseSelectionBox, CourseRequestsTable.this.iLastCheck);
                    }
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getValue());
                if (event.getValue() != null && CourseRequestsTable.this.iAlternatives.indexOf((Object)line) + 1 == CourseRequestsTable.this.iAlternatives.size()) {
                    CourseRequestsTable.this.addAlternativeLine();
                }
            }
        });
    }

    public void setCanWaitList(boolean canWaitList) {
        this.iCanWaitList = canWaitList;
        this.iHeaderWaitlist.setVisible(canWaitList);
        for (CourseRequestLine line : this.iCourses) {
            line.setWaitListVisible(canWaitList);
        }
    }

    public void setArrowsVisible(boolean arrowsVisible, boolean noSubs) {
        this.iArrowsVisible = arrowsVisible;
        if (noSubs) {
            this.iHeaderWaitlist.setHTML(arrowsVisible ? MESSAGES.courseRequestsNoSubstitutions() : MESSAGES.courseRequestsNoSubstitutionsNoArrows());
        } else {
            this.iHeaderWaitlist.setHTML(arrowsVisible ? MESSAGES.courseRequestsWaitList() : MESSAGES.courseRequestsWaitListNoArrows());
        }
        this.iHeader.setStyleName("noarrows", !arrowsVisible);
        for (CourseRequestLine line : this.iCourses) {
            line.setArrowsVisible(arrowsVisible);
        }
        for (CourseRequestLine line : this.iAlternatives) {
            line.setArrowsVisible(arrowsVisible);
        }
    }

    public void validate(AsyncCallback<Boolean> callback) {
        this.validate(null, callback);
    }

    public void validate(Boolean updateLastRequest, final AsyncCallback<Boolean> callback) {
        try {
            String message;
            this.iLastCheck = null;
            String failed = null;
            LoadingWidget.getInstance().show(MESSAGES.courseRequestsValidating());
            for (CourseRequestLine line : this.iCourses) {
                message = line.validate();
                if (message == null) continue;
                failed = message;
            }
            for (CourseRequestLine line : this.iAlternatives) {
                message = line.validate();
                if (message == null) continue;
                failed = message;
            }
            CourseRequestInterface cr = new CourseRequestInterface(this.iContext);
            if (cr.getAcademicSessionId() == null) {
                throw new SectioningException(MESSAGES.sessionSelectorNoSession());
            }
            this.fillInCourses(cr);
            this.fillInAlternatives(cr);
            if (updateLastRequest != null) {
                cr.setUpdateLastRequest(updateLastRequest);
            }
            final boolean success = failed == null;
            this.iSectioningService.checkCourses(cr, new AsyncCallback<CourseRequestInterface.CheckCoursesResponse>(){

                public void onSuccess(final CourseRequestInterface.CheckCoursesResponse result) {
                    CourseRequestInterface.RequestedCourse rc;
                    String message;
                    CourseRequestsTable.this.iLastCheck = result;
                    if (CourseRequestsTable.this.iCreditStatusIcon != null) {
                        if (result != null && result.hasCreditWarning()) {
                            Object warning = result.getCreditWarning();
                            if (result.getMaxCreditOverrideStatus() != null) {
                                switch (result.getMaxCreditOverrideStatus()) {
                                    case CREDIT_HIGH: {
                                        CourseRequestsTable.this.iCreditStatusIcon.setResource(RESOURCES.requestNeeded());
                                        warning = warning + "\n" + MESSAGES.creditStatusTooHigh();
                                        break;
                                    }
                                    case OVERRIDE_REJECTED: {
                                        CourseRequestsTable.this.iCreditStatusIcon.setResource(RESOURCES.requestError());
                                        warning = warning + "\n" + MESSAGES.creditStatusDenied();
                                        break;
                                    }
                                    default: {
                                        CourseRequestsTable.this.iCreditStatusIcon.setResource(RESOURCES.requestNeeded());
                                        break;
                                    }
                                }
                            } else {
                                CourseRequestsTable.this.iCreditStatusIcon.setResource(RESOURCES.requestNeeded());
                            }
                            CourseRequestsTable.this.iCreditStatusIcon.setAltText(warning);
                            CourseRequestsTable.this.iCreditStatusIcon.setTitle(warning);
                            CourseRequestsTable.this.iCreditStatusIcon.setVisible(true);
                        } else {
                            CourseRequestsTable.this.iCreditStatusIcon.setVisible(false);
                        }
                    }
                    for (CourseRequestLine line : CourseRequestsTable.this.iCourses) {
                        for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                            message = courseSelectionBox.validate();
                            if (message == null) continue;
                            rc = courseSelectionBox.getValue();
                            CourseRequestsTable.this.iLastCheck.addError(rc.getCourseId(), rc.getCourseName(), "ERROR", message);
                        }
                    }
                    for (CourseRequestLine line : CourseRequestsTable.this.iAlternatives) {
                        for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                            message = courseSelectionBox.validate();
                            if (message == null) continue;
                            rc = courseSelectionBox.getValue();
                            CourseRequestsTable.this.iLastCheck.addError(rc.getCourseId(), rc.getCourseName(), "ERROR", message);
                        }
                    }
                    CourseRequestsTable.this.setErrors(result);
                    LoadingWidget.getInstance().hide();
                    if (result.isError()) {
                        callback.onFailure(null);
                        return;
                    }
                    if (success && result.isConfirm()) {
                        final Iterator<Integer> it = result.getConfirms().iterator();
                        new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                            }

                            public void onSuccess(Boolean accept) {
                                if (accept.booleanValue() && it.hasNext()) {
                                    CourseRequestsConfirmationDialog.confirm(result, (Integer)it.next(), this);
                                } else {
                                    callback.onSuccess((Object)accept);
                                }
                            }
                        }.onSuccess(Boolean.valueOf(true));
                    } else if (success) {
                        callback.onSuccess((Object)true);
                    } else {
                        callback.onFailure(null);
                    }
                }

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    callback.onFailure(caught);
                }
            });
        }
        catch (Exception e) {
            callback.onFailure((Throwable)e);
        }
    }

    public void setError(String course, String error) {
        GWT.log((String)error);
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!course.equals(courseSelectionBox.getText())) continue;
                courseSelectionBox.setError(error);
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!course.equals(courseSelectionBox.getText())) continue;
                courseSelectionBox.setError(error);
            }
        }
    }

    public void setErrors(CourseRequestInterface.CheckCoursesResponse response) {
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                this.setErrors(courseSelectionBox, response);
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                this.setErrors(courseSelectionBox, response);
            }
        }
    }

    protected void setErrors(CourseRequestLine.CourseSelectionBox box, CourseRequestInterface.CheckCoursesResponse messages) {
        String note;
        String message = null;
        String itemized = null;
        for (CourseRequestInterface.CourseMessage m : messages.getMessages(box.getText())) {
            if (message == null) {
                message = m.getMessage();
                itemized = MESSAGES.courseMessage(m.getMessage());
                continue;
            }
            message = message + "\n" + m.getMessage();
            itemized = itemized + "\n" + MESSAGES.courseMessage(m.getMessage());
        }
        CourseRequestInterface.RequestedCourseStatus status = messages.getStatus(box.getText());
        if (status == null) {
            status = box.getValue().getStatus();
        }
        if (status == null && !box.isCanDelete()) {
            status = CourseRequestInterface.RequestedCourseStatus.ENROLLED;
        }
        if (message != null) {
            note = "";
            if (box.getValue().hasRequestorNote()) {
                note = note + "\n<span class='status-note'>" + box.getValue().getRequestorNote() + "</span>";
            } else if (this.iSpecReg != null && this.iSpecReg.isAllowChangeRequestNote() && box.getValue().hasRequestId() && status == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING) {
                note = note + "\n<span class='status-note'>" + MESSAGES.noRequestNoteClickToChange() + "</span>";
            }
            if (box.getValue().hasStatusNote()) {
                note = note + "\n<span class='status-note'>" + box.getValue().getStatusNote() + "</span>";
            }
            if (messages.isError(box.getText()) || messages.isConfirm(box.getText())) {
                box.setError(message + note);
            } else {
                box.setWarning(message + note);
            }
        }
        note = "";
        if (box.getValue().hasRequestorNote()) {
            note = note + "\n\n" + MESSAGES.requestNote(box.getValue().getRequestorNote());
        }
        if (box.getValue().hasStatusNote()) {
            note = "\n\n" + MESSAGES.overrideNote(box.getValue().getStatusNote());
        }
        if (messages.isError(box.getText()) && (status == null || status != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
            box.setStatus(RESOURCES.requestError(), itemized);
        } else if (status != null) {
            switch (status) {
                case ENROLLED: {
                    box.setStatus(RESOURCES.requestEnrolled(), MESSAGES.enrolled(box.getText()) + note);
                    break;
                }
                case OVERRIDE_NEEDED: {
                    box.setStatus(RESOURCES.requestNeeded(), (itemized == null ? "" : MESSAGES.overrideNeeded(itemized)) + note);
                    break;
                }
                case SAVED: {
                    box.setStatus(RESOURCES.requestSaved(), (itemized == null ? "" : MESSAGES.requestWarnings(itemized) + "\n\n") + MESSAGES.requested(box.getText()) + note);
                    break;
                }
                case OVERRIDE_REJECTED: {
                    box.setStatus(RESOURCES.requestRejected(), (itemized == null ? "" : MESSAGES.requestWarnings(itemized) + "\n\n") + MESSAGES.overrideRejected(box.getText()) + note);
                    break;
                }
                case OVERRIDE_PENDING: {
                    box.setStatus(RESOURCES.requestPending(), (itemized == null ? "" : MESSAGES.requestWarnings(itemized) + "\n\n") + MESSAGES.overridePending(box.getText()) + note);
                    break;
                }
                case OVERRIDE_CANCELLED: {
                    box.setStatus(RESOURCES.requestCancelled(), (itemized == null ? "" : MESSAGES.requestWarnings(itemized) + "\n\n") + MESSAGES.overrideCancelled(box.getText()) + note);
                    break;
                }
                case OVERRIDE_APPROVED: {
                    box.setStatus(RESOURCES.requestSaved(), (itemized == null ? "" : MESSAGES.requestWarnings(itemized) + "\n\n") + MESSAGES.overrideApproved(box.getText()) + note);
                    break;
                }
                default: {
                    if (messages.isError(box.getText())) {
                        box.setStatus(RESOURCES.requestError(), (itemized == null ? "" : itemized) + note);
                        break;
                    }
                    box.clearStatus();
                }
            }
        }
    }

    public void changeTip() {
        this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
    }

    public void fillInCourses(CourseRequestInterface cr) {
        for (CourseRequestLine line : this.iCourses) {
            CourseRequestInterface.Request req = line.getValue();
            if (req == null) continue;
            cr.getCourses().add(req);
        }
    }

    public void fillInAlternatives(CourseRequestInterface cr) {
        for (CourseRequestLine line : this.iAlternatives) {
            CourseRequestInterface.Request req = line.getValue();
            if (req == null) continue;
            cr.getAlternatives().add(req);
        }
    }

    public CourseRequestInterface getRequest() {
        CourseRequestInterface cr = new CourseRequestInterface(this.iContext);
        this.fillInCourses(cr);
        this.fillInAlternatives(cr);
        cr.setTimeConflictsAllowed(this.iSpecReg.isEnabled() && this.iSpecReg.isDisclaimerAccepted() && this.iSpecReg.areTimeConflictsAllowed());
        cr.setSpaceConflictsAllowed(this.iSpecReg.isEnabled() && this.iSpecReg.isDisclaimerAccepted() && this.iSpecReg.areSpaceConflictsAllowed());
        cr.setLinkedConflictsAllowed(this.iSpecReg.isEnabled() && this.iSpecReg.isDisclaimerAccepted() && this.iSpecReg.areLinkedConflictsAllowed());
        cr.setDeadlineConflictsAllowed(this.iSpecReg.isEnabled() && this.iSpecReg.isDisclaimerAccepted() && this.iSpecReg.areDeadlineConflictsAllowed());
        if (this.iLastCheck != null) {
            cr.setConfirmations(this.iLastCheck.getMessages());
        }
        cr.removeInactiveDuplicates();
        return cr;
    }

    public void activate(Long courseId) {
        if (courseId == null) {
            return;
        }
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!courseSelectionBox.isActive(courseId)) continue;
                return;
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!courseSelectionBox.isActive(courseId)) continue;
                return;
            }
        }
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                courseSelectionBox.activate(courseId);
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                courseSelectionBox.activate(courseId);
            }
        }
    }

    public boolean isActive(Long courseId) {
        if (courseId == null) {
            return true;
        }
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!courseSelectionBox.isActive(courseId)) continue;
                return true;
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!courseSelectionBox.isActive(courseId)) continue;
                return true;
            }
        }
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!courseSelectionBox.isInactive(courseId)) continue;
                return false;
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (!courseSelectionBox.isInactive(courseId)) continue;
                return false;
            }
        }
        return true;
    }

    public void setRequest(CourseRequestInterface request) {
        int idx;
        this.clear();
        while (this.iCourses.size() < request.getCourses().size()) {
            this.addCourseLine();
        }
        for (idx = 0; idx < request.getCourses().size(); ++idx) {
            this.iCourses.get(idx).setValue(request.getCourses().get(idx), true);
        }
        while (this.iAlternatives.size() < request.getAlternatives().size()) {
            this.addAlternativeLine();
        }
        for (idx = 0; idx < request.getAlternatives().size(); ++idx) {
            this.iAlternatives.get(idx).setValue(request.getAlternatives().get(idx), true);
        }
        if (request.hasConfirmations()) {
            this.iLastCheck = new CourseRequestInterface.CheckCoursesResponse(request.getConfirmations());
            this.setErrors(this.iLastCheck);
        } else {
            this.iLastCheck = null;
        }
    }

    public void disableArrowsWhereNeeded() {
        CourseRequestLine prev = null;
        for (CourseRequestLine line : this.iCourses) {
            if (prev != null) {
                prev.setDownArrowEnabled(prev.getValue().isCanChangePriority() && line.getValue().isCanChangePriority());
                line.setUpArrowEnabled(prev.getValue().isCanChangePriority() && line.getValue().isCanChangePriority());
            }
            prev = line;
        }
        for (CourseRequestLine line : this.iAlternatives) {
            if (prev != null) {
                prev.setDownArrowEnabled(prev.getValue().isCanChangePriority() && line.getValue().isCanChangePriority());
                line.setUpArrowEnabled(prev.getValue().isCanChangePriority() && line.getValue().isCanChangePriority());
            }
            prev = line;
        }
    }

    public void notifySaveSucceeded() {
        if (this.iLastCheck != null && this.iLastCheck.hasMessages()) {
            for (CourseRequestInterface.CourseMessage m : this.iLastCheck.getMessages()) {
                if (!m.isConfirm()) continue;
                m.setConfirm(null);
            }
            this.setErrors(this.iLastCheck);
        }
    }

    public Boolean getWaitList(Long course) {
        if (this.iCanWaitList && course != null) {
            for (CourseRequestLine line : this.iCourses) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    CourseRequestInterface.RequestedCourse rc = courseSelectionBox.getValue();
                    if (rc == null || !course.equals(rc.getCourseId())) continue;
                    return line.getWaitList();
                }
            }
        }
        return null;
    }

    public void setWaitList(Long course, boolean waitList) {
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                CourseRequestInterface.RequestedCourse rc = courseSelectionBox.getValue();
                if (rc == null || !course.equals(rc.getCourseId())) continue;
                line.setWaitList(waitList);
            }
        }
    }

    public void clear() {
        this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
        for (CourseRequestLine line : this.iCourses) {
            line.setValue(null);
        }
        for (CourseRequestLine line : this.iAlternatives) {
            line.setValue(null);
        }
    }

    public String getFirstError() {
        if (this.iLastCheck != null && this.iLastCheck.hasErrorMessage()) {
            return this.iLastCheck.getErrorMessage();
        }
        if (this.iLastCheck != null && this.iLastCheck.hasMessages()) {
            for (CourseRequestLine line : this.iCourses) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    for (CourseRequestInterface.CourseMessage m : this.iLastCheck.getMessages(courseSelectionBox.getText())) {
                        if (!m.isError()) continue;
                        return m.getMessage();
                    }
                }
            }
            for (CourseRequestLine line : this.iAlternatives) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    for (CourseRequestInterface.CourseMessage m : this.iLastCheck.getMessages(courseSelectionBox.getText())) {
                        if (!m.isError()) continue;
                        return m.getMessage();
                    }
                }
            }
            for (CourseRequestInterface.CourseMessage m : this.iLastCheck.getMessages()) {
                if (!m.isError()) continue;
                return m.getMessage();
            }
        }
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (courseSelectionBox.getError() == null) continue;
                return courseSelectionBox.getError();
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                if (courseSelectionBox.getError() == null) continue;
                return courseSelectionBox.getError();
            }
        }
        return null;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public CourseRequestInterface getValue() {
        return this.getRequest();
    }

    public void setValue(CourseRequestInterface value) {
        this.setValue(value, false);
    }

    public void setValue(CourseRequestInterface value, boolean fireEvents) {
        this.setRequest(value);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    protected void clearErrors() {
        for (CourseRequestLine line : this.iCourses) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                courseSelectionBox.setError(null);
            }
        }
        for (CourseRequestLine line : this.iAlternatives) {
            for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                courseSelectionBox.setError(null);
            }
        }
    }

    public Command addCourse(CourseRequestInterface.RequestedCourse rc) {
        CourseRequestInterface.Request request = new CourseRequestInterface.Request();
        request.addRequestedCourse(rc);
        for (final CourseRequestLine line : this.iCourses) {
            if (line.getValue() != null) continue;
            line.setValue(request, true);
            return new Command(){

                public void execute() {
                    line.setValue(null, true);
                    CourseRequestsTable.this.clearErrors();
                }
            };
        }
        this.addCourseLine();
        final CourseRequestLine line = this.iCourses.get(this.iCourses.size() - 1);
        line.setValue(request, true);
        return new Command(){

            public void execute() {
                line.setValue(null, true);
                CourseRequestsTable.this.clearErrors();
            }
        };
    }

    public boolean hasCourse(CourseRequestInterface.RequestedCourse rc) {
        CourseRequestInterface.Request request;
        for (CourseRequestLine line : this.iCourses) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourse(rc)) continue;
            return true;
        }
        for (CourseRequestLine line : this.iAlternatives) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourse(rc)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCourseActive(CourseRequestInterface.RequestedCourse rc) {
        CourseRequestInterface.Request request;
        for (CourseRequestLine line : this.iCourses) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourseActive(rc)) continue;
            return true;
        }
        for (CourseRequestLine line : this.iAlternatives) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourseActive(rc)) continue;
            return true;
        }
        return false;
    }

    public void dropCourse(CourseRequestInterface.RequestedCourse rc) {
        CourseRequestInterface.Request request;
        for (CourseRequestLine line : this.iCourses) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourseActive(rc)) continue;
            line.delete();
            return;
        }
        for (CourseRequestLine line : this.iAlternatives) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourseActive(rc)) continue;
            line.delete();
            return;
        }
        for (CourseRequestLine line : this.iCourses) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourse(rc)) continue;
            line.delete();
            return;
        }
        for (CourseRequestLine line : this.iAlternatives) {
            request = line.getValue();
            if (request == null || !request.hasRequestedCourse(rc)) continue;
            line.delete();
            return;
        }
    }

    public void dropCourse(ClassAssignmentInterface.ClassAssignment assignment) {
        block12: {
            block11: {
                if (!assignment.isFreeTime() || !assignment.isAssigned()) break block11;
                CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime(assignment.getDays(), assignment.getStart(), assignment.getLength());
                for (CourseRequestLine line : this.iCourses) {
                    CourseRequestInterface.Request request = line.getValue();
                    if (request == null || !request.hasRequestedCourse() || !request.getRequestedCourse(0).isFreeTime() || !request.getRequestedCourse(0).getFreeTime().contains(ft)) continue;
                    request.getRequestedCourse(0).getFreeTime().remove(ft);
                    if (request.getRequestedCourse(0).isEmpty()) {
                        line.delete();
                    } else {
                        line.setValue(request, true);
                    }
                    return;
                }
                break block12;
            }
            if (assignment.isFreeTime()) break block12;
            for (CourseRequestLine line : this.iCourses) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    if (!assignment.equalsIgnoreCase(courseSelectionBox.getValue()) || courseSelectionBox.isInactive()) continue;
                    line.delete();
                    return;
                }
            }
            for (CourseRequestLine line : this.iAlternatives) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    if (!assignment.equalsIgnoreCase(courseSelectionBox.getValue()) || courseSelectionBox.isInactive()) continue;
                    line.delete();
                    return;
                }
            }
            for (CourseRequestLine line : this.iCourses) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    if (!assignment.equalsIgnoreCase(courseSelectionBox.getValue())) continue;
                    line.delete();
                    return;
                }
            }
            for (CourseRequestLine line : this.iAlternatives) {
                for (CourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                    if (!assignment.equalsIgnoreCase(courseSelectionBox.getValue())) continue;
                    line.delete();
                    return;
                }
            }
        }
    }

    public void setCreditStatusIcon(Image image) {
        this.iCreditStatusIcon = image;
    }

    public CourseRequestInterface.CheckCoursesResponse getLastCheck() {
        return this.iLastCheck;
    }
}

