/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class CourseRequestsConfirmationDialog
extends UniTimeDialogBox {
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static StudentSectioningMessages SCT_MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private AriaButton iYes;
    private AriaButton iNo;
    private AsyncCallback<Boolean> iCommand;
    private String iMessage;
    private boolean iValue = false;
    private TextArea iNote = null;
    private Image iImage;
    private CheckBox iCheckBox = null;

    public CourseRequestsConfirmationDialog(CourseRequestInterface.CheckCoursesResponse response, int confirm, AsyncCallback<Boolean> callback) {
        super(true, true);
        this.addStyleName("unitime-CourseRequestsConfirmationDialog");
        this.setText(response.getConfirmationTitle(confirm, MESSAGES.dialogConfirmation()));
        this.iMessage = response.getConfirmations(confirm, " \n");
        this.iCommand = callback;
        P panel = new P("unitime-ConfirmationPanel");
        this.setEscapeToHide(true);
        P bd = new P("body-panel");
        panel.add((Widget)bd);
        P ic = new P("icon-panel");
        bd.add((Widget)ic);
        this.iImage = new Image(RESOURCES.statusWarning());
        ic.add((Widget)this.iImage);
        P cp = new P("content-panel");
        bd.add((Widget)cp);
        P mp = new P("message-panel");
        cp.add((Widget)mp);
        P ctab = null;
        String last = null;
        for (final CourseRequestInterface.CourseMessage cm : response.getMessages()) {
            if (confirm != cm.getConfirm()) continue;
            if (cm.hasCourse()) {
                if (ctab == null) {
                    ctab = new P("course-table");
                    last = null;
                }
                P cn = new P("course-name");
                if (last == null || !last.equals(cm.getCourse())) {
                    cn.setText(cm.getCourse());
                }
                P m = new P("course-message");
                m.setText(SCT_MESSAGES.courseMessage(cm.getMessage()));
                P crow = new P("course-row");
                if (last == null || !last.equals(cm.getCourse())) {
                    crow.addStyleName("first-course-line");
                }
                crow.add((Widget)cn);
                crow.add((Widget)m);
                ctab.add((Widget)crow);
                last = cm.getCourse();
                continue;
            }
            if ("REQUEST_NOTE".equals(cm.getCode())) {
                this.iNote = new TextArea();
                this.iNote.setStyleName("unitime-TextArea");
                this.iNote.addStyleName("request-note");
                this.iNote.setVisibleLines(5);
                this.iNote.setCharacterWidth(80);
                if (cm.getMessage() != null) {
                    this.iNote.setText(cm.getMessage());
                }
                this.iNote.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        cm.setMessage((String)event.getValue());
                    }
                });
                mp.add((Widget)this.iNote);
                continue;
            }
            if ("CHECK_BOX".equals(cm.getCode())) {
                if (ctab != null) {
                    mp.add((Widget)ctab);
                    ctab = null;
                }
                this.iCheckBox = new CheckBox(cm.getMessage());
                this.iCheckBox.addStyleName("message");
                mp.add((Widget)this.iCheckBox);
                continue;
            }
            if (ctab != null) {
                mp.add((Widget)ctab);
                ctab = null;
            }
            P m = new P("message");
            m.setHTML(cm.getMessage());
            mp.add((Widget)m);
        }
        if (ctab != null) {
            mp.add((Widget)ctab);
            ctab = null;
        }
        P bp = new P("buttons-panel");
        panel.add((Widget)bp);
        this.iYes = new AriaButton(response.getConfirmationYesButton(confirm, MESSAGES.buttonConfirmYes()));
        this.iYes.addStyleName("yes");
        String yesTitle = response.getConfirmationYesButtonTitle(confirm, null);
        if (yesTitle != null && !yesTitle.isEmpty()) {
            this.iYes.setTitle(yesTitle);
        }
        bp.add((Widget)this.iYes);
        this.iYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CourseRequestsConfirmationDialog.this.submit();
            }
        });
        if (this.iCheckBox != null) {
            this.iYes.setEnabled(false);
            this.iCheckBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    CourseRequestsConfirmationDialog.this.iYes.setEnabled((Boolean)event.getValue());
                }
            });
        }
        this.iNo = new AriaButton(response.getConfirmationNoButton(confirm, MESSAGES.buttonConfirmNo()));
        this.iNo.addStyleName("no");
        String noTitle = response.getConfirmationNoButtonTitle(confirm, null);
        if (noTitle != null && !noTitle.isEmpty()) {
            this.iNo.setTitle(noTitle);
        }
        bp.add((Widget)this.iNo);
        this.iNo.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CourseRequestsConfirmationDialog.this.hide();
            }
        });
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                if (CourseRequestsConfirmationDialog.this.iCommand != null) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            CourseRequestsConfirmationDialog.this.iCommand.onSuccess((Object)CourseRequestsConfirmationDialog.this.iValue);
                        }
                    });
                }
            }
        });
        this.setWidget((Widget)panel);
    }

    public CourseRequestsConfirmationDialog withImage(ImageResource image) {
        if (image != null) {
            this.iImage.setResource(image);
        }
        return this;
    }

    @Override
    public void center() {
        super.center();
        if (this.iMessage != null && !this.iMessage.isEmpty()) {
            AriaStatus.getInstance().setText(ARIA.dialogOpened(this.getText()) + " " + this.iMessage + " " + ARIA.confirmationEnterToAcceptEscapeToReject());
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                if (CourseRequestsConfirmationDialog.this.iNote != null) {
                    CourseRequestsConfirmationDialog.this.iNote.setFocus(true);
                } else {
                    CourseRequestsConfirmationDialog.this.iYes.setFocus(true);
                }
            }
        });
    }

    protected void submit() {
        this.iValue = true;
        this.hide();
    }

    public String getNote() {
        return this.iNote == null ? null : this.iNote.getText();
    }

    public static void confirm(CourseRequestInterface.CheckCoursesResponse response, int confirm, AsyncCallback<Boolean> callback) {
        new CourseRequestsConfirmationDialog(response, confirm, callback).center();
    }

    public static void confirm(CourseRequestInterface.CheckCoursesResponse response, int confirm, ImageResource image, AsyncCallback<Boolean> callback) {
        new CourseRequestsConfirmationDialog(response, confirm, callback).withImage(image).center();
    }
}

