/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.dao.LocationDAO;

public class RoomGroupEditForm
extends ActionForm {
    private String id;
    private String name;
    private String abbv;
    private boolean global;
    private boolean deft;
    private String desc;
    private Collection assignedRooms;
    private Collection notAssignedRooms;
    private String[] assignedSelected = new String[0];
    private String[] notAssignedSelected = new String[0];
    private String doit;
    private String deptCode;
    private String deptName;
    private Long sessionId;
    private static final long serialVersionUID = -82818547444631422L;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.name == null || this.name.equalsIgnoreCase("")) {
            errors.add("roomGroup", new ActionMessage("errors.required", (Object)"Name"));
        }
        if (this.abbv == null || this.abbv.equalsIgnoreCase("")) {
            errors.add("roomGroup", new ActionMessage("errors.required", (Object)"Abbreviation"));
        }
        try {
            Department dept;
            for (RoomGroup rg : RoomGroup.getAllGlobalRoomGroups(this.getSessionId())) {
                if (!rg.getName().equalsIgnoreCase(this.name) || rg.getUniqueId().toString().equals(this.id)) continue;
                errors.add("name", new ActionMessage("errors.exists", (Object)this.name));
            }
            Department department = dept = this.deptCode == null ? null : Department.findByDeptCode(this.deptCode, this.getSessionId());
            if (dept != null) {
                for (RoomGroup rg : RoomGroup.getAllDepartmentRoomGroups(dept)) {
                    if (!rg.getName().equalsIgnoreCase(this.name) || rg.getUniqueId().toString().equals(this.id)) continue;
                    errors.add("name", new ActionMessage("errors.exists", (Object)this.name));
                }
            }
        }
        catch (Exception e) {
            Debug.error(e);
            errors.add("name", new ActionMessage("errors.generic", (Object)e.getMessage()));
        }
        if (!this.global && (this.deptCode == null || this.deptCode.equalsIgnoreCase(""))) {
            errors.add("Department", new ActionMessage("errors.required", (Object)"Department"));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.name = "";
        this.abbv = null;
        this.sessionId = null;
    }

    public void setRooms() {
        int i = 0;
        Iterator iter = null;
        if (this.assignedRooms != null) {
            String[] assignedSelection = new String[this.assignedRooms.size()];
            for (Location r : this.assignedRooms) {
                assignedSelection[i] = r.getUniqueId().toString();
                ++i;
            }
            this.assignedSelected = assignedSelection;
        }
    }

    public Collection getAssignedRooms() {
        return this.assignedRooms;
    }

    public void setAssignedRooms(Collection assignedRooms) {
        this.assignedRooms = assignedRooms;
    }

    public boolean isDeft() {
        return this.deft;
    }

    public void setDeft(boolean deft) {
        this.deft = deft;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection getNotAssignedRooms() {
        return this.notAssignedRooms;
    }

    public void setNotAssignedRooms(Collection notAssignedRooms) {
        this.notAssignedRooms = notAssignedRooms;
    }

    public String[] getAssignedSelected() {
        return this.assignedSelected;
    }

    public void setAssignedSelected(String[] assignedSelected) {
        this.assignedSelected = assignedSelected;
    }

    public String[] getNotAssignedSelected() {
        return this.notAssignedSelected;
    }

    public void setNotAssignedSelected(String[] notAssignedSelected) {
        this.notAssignedSelected = notAssignedSelected;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDoit() {
        return this.doit;
    }

    public void setDoit(String doit) {
        this.doit = doit;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getAbbv() {
        return this.abbv;
    }

    public void setAbbv(String abbv) {
        this.abbv = abbv;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public String getFeatures(String locationId) {
        Location location = (Location)LocationDAO.getInstance().get(Long.valueOf(locationId));
        if (location == null) {
            return "";
        }
        String features = "";
        for (GlobalRoomFeature globalRoomFeature : location.getGlobalRoomFeatures()) {
            if (!features.isEmpty()) {
                features = features + ", ";
            }
            features = features + "<span title='" + globalRoomFeature.getLabel() + "' style='white-space:nowrap;'>" + globalRoomFeature.getLabelWithType() + "</span>";
        }
        for (DepartmentRoomFeature departmentRoomFeature : location.getDepartmentRoomFeatures()) {
            if (!features.isEmpty()) {
                features = features + ", ";
            }
            features = features + "<span title='" + departmentRoomFeature.getLabel() + "' style='white-space:nowrap;'>" + departmentRoomFeature.getLabelWithType() + "</span>";
        }
        return features;
    }
}

