/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;

public class DatePatternEditForm
extends ActionForm {
    private static final long serialVersionUID = -929558620061783652L;
    private String iOp;
    private String iName;
    private Long iUniqueId;
    private String iType;
    private boolean iIsUsed;
    private boolean iIsDefault;
    private boolean iVisible;
    private Vector iDepartmentIds = new Vector();
    private Long iDepartmentId;
    private Vector iParentIds = new Vector();
    private Long iParentId;
    private Long iSessionId;
    private String iNumberOfWeeks;
    private Long iPreviousId;
    private Long iNextId;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iName == null || this.iName.trim().length() == 0) {
            errors.add("name", new ActionMessage("errors.required", (Object)""));
        } else {
            try {
                DatePattern pat = DatePattern.findByName(this.iSessionId, this.iName);
                if (pat != null && !pat.getUniqueId().equals(this.iUniqueId)) {
                    errors.add("name", new ActionMessage("errors.exists", (Object)this.iName));
                }
            }
            catch (Exception e) {
                errors.add("name", new ActionMessage("errors.generic", (Object)e.getMessage()));
            }
        }
        if (this.getTypeInt() < 0) {
            errors.add("type", new ActionMessage("errors.required", (Object)""));
        }
        if (this.getTypeInt() != 3 && !this.iDepartmentIds.isEmpty() && this.getTypeInt() != 4) {
            errors.add("type", new ActionMessage("errors.generic", (Object)"Only extended pattern and alternative pattern set can contain relations with departments."));
        }
        if (this.getNumberOfWeeks() != null && !this.getNumberOfWeeks().isEmpty()) {
            DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
            try {
                df.parse(this.getNumberOfWeeks());
            }
            catch (ParseException e) {
                errors.add("numberOfWeeks", new ActionMessage("errors.generic", (Object)"Not a number."));
            }
        }
        try {
            DatePattern dp = this.getDatePattern(request);
            if (this.getTypeInt() == 4) {
                if (dp.size() != 0) {
                    errors.add("type", new ActionMessage("errors.generic", (Object)"Alternative pattern set date pattern can not have any dates selected."));
                }
                if (this.getParentIds() != null && !this.getParentIds().isEmpty()) {
                    errors.add("type", new ActionMessage("errors.generic", (Object)"Alternative pattern set date pattern can not have a pattern set."));
                }
            } else if (dp.size() == 0) {
                errors.add("pattern", new ActionMessage("errors.required", (Object)""));
            }
            if (dp.getPattern().length() > 366) {
                errors.add("pattern", new ActionMessage("errors.generic", (Object)"Date Patterns cannot contain more than 1 year."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iUniqueId = new Long(-1L);
        this.iType = DatePattern.sTypes[0];
        this.iIsUsed = false;
        this.iVisible = false;
        this.iName = "";
        this.iIsDefault = false;
        this.iNumberOfWeeks = null;
        this.iDepartmentId = null;
        this.iDepartmentIds.clear();
        this.iParentId = null;
        this.iParentIds.clear();
        this.iPreviousId = null;
        this.iNextId = null;
    }

    public void load(DatePattern dp) {
        if (dp == null) {
            this.reset(null, null);
            this.iOp = "Save";
            this.iVisible = true;
            this.iIsUsed = false;
            this.iIsDefault = false;
        } else {
            this.setName(dp.getName());
            this.setVisible(dp.isVisible());
            this.setIsUsed(dp.isUsed());
            this.setTypeInt(dp.getType());
            this.setUniqueId(dp.getUniqueId());
            this.setIsDefault(dp.isDefault());
            this.setSessionId(dp.getSession().getUniqueId());
            DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
            this.setNumberOfWeeks(dp.getNumberOfWeeks() == null ? "" : df.format(dp.getNumberOfWeeks()));
            this.iParentIds.clear();
            TreeSet<DatePattern> parents = new TreeSet<DatePattern>(dp.getParents());
            for (DatePattern d : parents) {
                this.iParentIds.add(d.getUniqueId());
            }
            this.iDepartmentIds.clear();
            TreeSet<Department> depts = new TreeSet<Department>(dp.getDepartments());
            for (Department d : depts) {
                this.iDepartmentIds.add(d.getUniqueId());
            }
            this.iOp = "Update";
        }
    }

    public void update(DatePattern dp, HttpServletRequest request, org.hibernate.Session hibSession) throws Exception {
        dp.setName(this.getName());
        dp.setVisible(new Boolean(this.getVisible()));
        dp.setType(new Integer(this.getTypeInt()));
        dp.setPatternAndOffset(request);
        if (this.getNumberOfWeeks() != null && !this.getNumberOfWeeks().isEmpty()) {
            try {
                DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
                dp.setNumberOfWeeks(Float.valueOf(df.parse(this.getNumberOfWeeks()).floatValue()));
            }
            catch (ParseException e) {
                dp.setNumberOfWeeks(null);
            }
        } else {
            dp.setNumberOfWeeks(null);
        }
        HashSet<DatePattern> oldParents = new HashSet<DatePattern>(dp.getParents());
        Enumeration e = this.iParentIds.elements();
        while (e.hasMoreElements()) {
            Long parentId = (Long)e.nextElement();
            DatePattern datePattern = (DatePattern)new DatePatternDAO().get(parentId, hibSession);
            if (datePattern == null || oldParents.remove(datePattern)) continue;
            dp.getParents().add(datePattern);
            hibSession.saveOrUpdate((Object)dp);
        }
        for (DatePattern d : oldParents) {
            dp.getParents().remove(d);
            hibSession.saveOrUpdate((Object)d);
        }
        HashSet<Department> oldDepts = new HashSet<Department>(dp.getDepartments());
        Enumeration e2 = this.iDepartmentIds.elements();
        while (e2.hasMoreElements()) {
            Long l = (Long)e2.nextElement();
            Department d = (Department)new DepartmentDAO().get(l, hibSession);
            if (d == null || oldDepts.remove(d)) continue;
            dp.getDepartments().add(d);
            d.getDatePatterns().add(dp);
            hibSession.saveOrUpdate((Object)d);
        }
        for (Department department : oldDepts) {
            dp.getDepartments().remove(department);
            department.getDatePatterns().remove(dp);
            hibSession.saveOrUpdate((Object)department);
        }
        hibSession.saveOrUpdate((Object)dp);
    }

    public DatePattern create(HttpServletRequest request, org.hibernate.Session hibSession) throws Exception {
        DatePattern dp = new DatePattern();
        dp.setName(this.getName());
        dp.setSession((Session)SessionDAO.getInstance().get(this.getSessionId(), hibSession));
        dp.setVisible(new Boolean(this.getVisible()));
        dp.setType(new Integer(this.getTypeInt()));
        dp.setPatternAndOffset(request);
        if (this.getNumberOfWeeks() != null && !this.getNumberOfWeeks().isEmpty()) {
            try {
                DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
                dp.setNumberOfWeeks(Float.valueOf(df.parse(this.getNumberOfWeeks()).floatValue()));
            }
            catch (ParseException e) {
                dp.setNumberOfWeeks(null);
            }
        } else {
            dp.setNumberOfWeeks(null);
        }
        HashSet<DatePattern> newParents = new HashSet<DatePattern>();
        Enumeration e = this.iParentIds.elements();
        while (e.hasMoreElements()) {
            Long parentId = (Long)e.nextElement();
            DatePattern datePattern = (DatePattern)new DatePatternDAO().get(parentId, hibSession);
            if (datePattern == null) continue;
            newParents.add(datePattern);
        }
        dp.setParents(newParents);
        HashSet<Department> newDepts = new HashSet<Department>();
        Enumeration e2 = this.iDepartmentIds.elements();
        while (e2.hasMoreElements()) {
            Long l = (Long)e2.nextElement();
            Department d = (Department)new DepartmentDAO().get(l, hibSession);
            if (d == null) continue;
            newDepts.add(d);
        }
        dp.setDepartments(newDepts);
        hibSession.save((Object)dp);
        for (Department department : newDepts) {
            department.getDatePatterns().add(dp);
            hibSession.saveOrUpdate((Object)department);
        }
        this.setUniqueId(dp.getUniqueId());
        return dp;
    }

    public DatePattern saveOrUpdate(HttpServletRequest request, org.hibernate.Session hibSession) throws Exception {
        DatePattern dp = null;
        if (this.getUniqueId() >= 0L) {
            dp = (DatePattern)new DatePatternDAO().get(this.getUniqueId());
        }
        if (dp == null) {
            dp = this.create(request, hibSession);
        } else {
            this.update(dp, request, hibSession);
        }
        return dp;
    }

    public void delete(org.hibernate.Session hibSession) throws Exception {
        if (this.getUniqueId() < 0L) {
            return;
        }
        if (this.getIsUsed()) {
            return;
        }
        DatePattern dp = (DatePattern)new DatePatternDAO().get(this.getUniqueId(), hibSession);
        for (Department department : dp.getDepartments()) {
            department.getDatePatterns().remove(dp);
            hibSession.saveOrUpdate((Object)department);
        }
        for (DatePattern datePattern : dp.findChildren()) {
            datePattern.getParents().remove(dp);
            hibSession.saveOrUpdate((Object)datePattern);
        }
        dp.getParents().clear();
        hibSession.saveOrUpdate((Object)dp);
        hibSession.delete((Object)dp);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    public String[] getTypes() {
        return DatePattern.sTypes;
    }

    public int getTypeInt() {
        for (int i = 0; i < DatePattern.sTypes.length; ++i) {
            if (!DatePattern.sTypes[i].equals(this.iType)) continue;
            return i;
        }
        return -1;
    }

    public void setTypeInt(int type) {
        this.iType = type < 0 ? "" : DatePattern.sTypes[type];
    }

    public boolean getIsUsed() {
        return this.iIsUsed;
    }

    public void setIsUsed(boolean isUsed) {
        this.iIsUsed = isUsed;
    }

    public boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(boolean visible) {
        this.iVisible = visible;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public boolean getIsDefault() {
        return this.iIsDefault;
    }

    public void setIsDefault(boolean isDefault) {
        this.iIsDefault = isDefault;
    }

    public Vector getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(Vector departmentIds) {
        this.iDepartmentIds = departmentIds;
    }

    public Long getDepartmentId() {
        return this.iDepartmentId;
    }

    public void setDepartmentId(Long deptId) {
        this.iDepartmentId = deptId;
    }

    public Long getParentId() {
        return this.iParentId;
    }

    public void setParentId(Long parentId) {
        this.iParentId = parentId;
    }

    public Vector getParentIds() {
        return this.iParentIds;
    }

    public void setParentIds(Vector parentIds) {
        this.iParentIds = parentIds;
    }

    public String getNumberOfWeeks() {
        return this.iNumberOfWeeks;
    }

    public void setNumberOfWeeks(String numberOfWeeks) {
        this.iNumberOfWeeks = numberOfWeeks;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getNextId() {
        return this.iNextId;
    }

    public void setNextId(Long nextId) {
        this.iNextId = nextId;
    }

    public boolean getHasNext() {
        return this.iNextId != null && this.iNextId >= 0L;
    }

    public Long getPreviousId() {
        return this.iPreviousId;
    }

    public void setPreviousId(Long previousId) {
        this.iPreviousId = previousId;
    }

    public boolean getHasPrevious() {
        return this.iPreviousId != null && this.iPreviousId >= 0L;
    }

    public DatePattern getDatePattern(HttpServletRequest request) throws Exception {
        BaseDatePattern dp = null;
        if (this.getUniqueId() != null && (dp = (DatePattern)new DatePatternDAO().get(this.getUniqueId())) != null) {
            dp = (DatePattern)((DatePattern)dp).clone();
        }
        if (dp == null) {
            dp = new DatePattern();
        }
        if (dp.getSession() == null) {
            dp.setSession((Session)SessionDAO.getInstance().get(this.getSessionId()));
        }
        if (request.getParameter("cal_select") != null) {
            dp.setName(this.getName());
            dp.setVisible(new Boolean(this.getVisible()));
            dp.setType(new Integer(this.getTypeInt()));
            ((DatePattern)dp).setPatternAndOffset(request);
            if (this.getNumberOfWeeks() != null && !this.getNumberOfWeeks().isEmpty()) {
                try {
                    DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
                    dp.setNumberOfWeeks(Float.valueOf(df.parse(this.getNumberOfWeeks()).floatValue()));
                }
                catch (ParseException e) {
                    dp.setNumberOfWeeks(null);
                }
            } else {
                dp.setNumberOfWeeks(null);
            }
        }
        return dp;
    }
}

