/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class CrossListsModifyForm
extends ActionForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 3638385556572422628L;
    private String op;
    private Long subjectAreaId;
    private Long instrOfferingId;
    private Long addCourseOfferingId;
    private Long ctrlCrsOfferingId;
    private String instrOfferingName;
    private Boolean ownedInstrOffr;
    private List courseOfferingIds;
    private List courseOfferingNames;
    private List ownedCourse;
    private List resvId;
    private List limits;
    private List requested;
    private List projected;
    private List lastTerm;
    private List canDelete;
    private Integer ioLimit;
    private Boolean unlimited;
    private Long readOnlyCrsOfferingId;
    private String originalOfferings;
    protected DynamicListObjectFactory factoryCourseOfferings = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String("");
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.op.equals(MSG.actionAddCourseToCrossList()) && (this.addCourseOfferingId == null || this.addCourseOfferingId.intValue() <= 0)) {
            errors.add("addCourseOfferingId", new ActionMessage("errors.generic", (Object)MSG.errorRequiredCourseOffering()));
        }
        if (this.op.equals(MSG.actionUpdateCrossLists()) && (this.ctrlCrsOfferingId == null || this.ctrlCrsOfferingId.intValue() <= 0)) {
            errors.add("ctrlCrsOfferingId", new ActionMessage("errors.generic", (Object)MSG.errorRequiredControllingCourse()));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.subjectAreaId = null;
        this.instrOfferingId = null;
        this.ctrlCrsOfferingId = null;
        this.readOnlyCrsOfferingId = null;
        this.instrOfferingName = null;
        this.courseOfferingIds = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.courseOfferingNames = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.ownedCourse = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.resvId = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.limits = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.requested = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.projected = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.lastTerm = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.canDelete = DynamicList.getInstance(new ArrayList(), this.factoryCourseOfferings);
        this.originalOfferings = "";
        this.ioLimit = null;
        this.unlimited = null;
    }

    public List getCourseOfferingIds() {
        return this.courseOfferingIds;
    }

    public String getCourseOfferingIds(int key) {
        return this.courseOfferingIds.get(key).toString();
    }

    public void setCourseOfferingIds(int key, Object value) {
        this.courseOfferingIds.set(key, value);
    }

    public void setCourseOfferingIds(List courseOfferingIds) {
        this.courseOfferingIds = courseOfferingIds;
    }

    public List getCourseOfferingNames() {
        return this.courseOfferingNames;
    }

    public String getCourseOfferingNames(int key) {
        return this.courseOfferingNames.get(key).toString();
    }

    public void setCourseOfferingNames(int key, Object value) {
        this.courseOfferingNames.set(key, value);
    }

    public void setCourseOfferingNames(List courseOfferingNames) {
        this.courseOfferingNames = courseOfferingNames;
    }

    public List getOwnedCourse() {
        return this.ownedCourse;
    }

    public String getOwnedCourse(int key) {
        return this.ownedCourse.get(key).toString();
    }

    public void setOwnedCourse(int key, Object value) {
        this.ownedCourse.set(key, value);
    }

    public void setOwnedCourse(List ownedCourse) {
        this.ownedCourse = ownedCourse;
    }

    public List getLimits() {
        return this.limits;
    }

    public String getLimits(int key) {
        return this.limits.get(key).toString();
    }

    public void setLimits(int key, Object value) {
        this.limits.set(key, value);
    }

    public void setLimits(List limits) {
        this.limits = limits;
    }

    public List getResvId() {
        return this.resvId;
    }

    public String getResvId(int key) {
        return this.resvId.get(key).toString();
    }

    public void setResvId(int key, Object value) {
        this.resvId.set(key, value);
    }

    public void setResvId(List resvId) {
        this.resvId = resvId;
    }

    public List getRequested() {
        return this.requested;
    }

    public String getRequested(int key) {
        return this.requested.get(key).toString();
    }

    public void setRequested(int key, Object value) {
        this.requested.set(key, value);
    }

    public void setRequested(List requested) {
        this.requested = requested;
    }

    public List getProjected() {
        return this.projected;
    }

    public String getProjected(int key) {
        return this.projected.get(key).toString();
    }

    public void setProjected(int key, Object value) {
        this.projected.set(key, value);
    }

    public void setProjected(List projected) {
        this.projected = projected;
    }

    public List getLastTerm() {
        return this.lastTerm;
    }

    public String getLastTerm(int key) {
        return this.lastTerm.get(key).toString();
    }

    public void setLastTerm(int key, Object value) {
        this.lastTerm.set(key, value);
    }

    public void setLastTerm(List lastTerm) {
        this.lastTerm = lastTerm;
    }

    public List getCanDelete() {
        return this.canDelete;
    }

    public Boolean getCanDelete(int key) {
        return (Boolean)this.canDelete.get(key);
    }

    public void setCanDelete(int key, Boolean value) {
        this.canDelete.set(key, value);
    }

    public void setCanDelete(List canDelete) {
        this.canDelete = canDelete;
    }

    public Long getCtrlCrsOfferingId() {
        return this.ctrlCrsOfferingId;
    }

    public void setCtrlCrsOfferingId(Long ctrlCrsOfferingId) {
        this.ctrlCrsOfferingId = ctrlCrsOfferingId;
    }

    public Long getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public Long getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(Long subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public Long getAddCourseOfferingId() {
        return this.addCourseOfferingId;
    }

    public void setAddCourseOfferingId(Long addCourseOfferingId) {
        this.addCourseOfferingId = addCourseOfferingId;
    }

    public Long getReadOnlyCrsOfferingId() {
        return this.readOnlyCrsOfferingId;
    }

    public void setReadOnlyCrsOfferingId(Long readOnlyCrsOfferingId) {
        this.readOnlyCrsOfferingId = readOnlyCrsOfferingId;
    }

    public String getOriginalOfferings() {
        return this.originalOfferings;
    }

    public void setOriginalOfferings(String originalOfferings) {
        this.originalOfferings = originalOfferings;
    }

    public Boolean getOwnedInstrOffr() {
        return this.ownedInstrOffr;
    }

    public void setOwnedInstrOffr(Boolean ownedInstrOffr) {
        this.ownedInstrOffr = ownedInstrOffr;
    }

    public Integer getIoLimit() {
        return this.ioLimit;
    }

    public void setIoLimit(Integer ioLimit) {
        this.ioLimit = ioLimit;
    }

    public Boolean getUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(Boolean unlimited) {
        this.unlimited = unlimited;
    }

    public void addToOriginalCourseOfferings(CourseOffering co) {
        this.originalOfferings = this.originalOfferings + " " + co.getUniqueId().toString();
    }

    public void addToCourseOfferings(CourseOffering co, Boolean isOwner, Boolean canDelete) {
        this.courseOfferingIds.add(co.getUniqueId().toString());
        this.courseOfferingNames.add(co.getCourseNameWithTitle());
        this.ownedCourse.add(isOwner);
        this.resvId.add("");
        this.limits.add(co.getReservation() == null ? "" : co.getReservation().toString());
        this.requested.add("");
        this.projected.add(co.getProjectedDemand() == null ? "" : co.getProjectedDemand().toString());
        this.lastTerm.add(co.getDemand() == null ? "" : co.getDemand().toString());
        this.canDelete.add(canDelete);
    }

    public void removeFromCourseOfferings(String courseOfferingId) {
        int ct = 0;
        ListIterator i = this.courseOfferingIds.listIterator();
        while (i.hasNext()) {
            String co1 = i.next().toString();
            if (co1.equals(courseOfferingId)) {
                i.remove();
                this.courseOfferingNames.remove(ct);
                this.ownedCourse.remove(ct);
                this.resvId.remove(ct);
                this.limits.remove(ct);
                this.requested.remove(ct);
                this.projected.remove(ct);
                this.lastTerm.remove(ct);
                this.canDelete.remove(ct);
                break;
            }
            ++ct;
        }
    }

    public int getIndex(String courseOfferingId) {
        for (int i = 0; i < this.courseOfferingIds.size(); ++i) {
            String co1 = (String)this.courseOfferingIds.get(i);
            if (!co1.equals(courseOfferingId)) continue;
            return i;
        }
        return -1;
    }
}

