/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.base.BaseClassInstructor;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class ClassInstructorAssignmentForm
extends ActionForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String op;
    private Integer subjectAreaId;
    private Long instrOfferingId;
    private String instrOfferingName;
    private Integer instrOffrConfigLimit;
    private Long instrOffrConfigId;
    private String deletedInstrRowNum;
    private String nextId;
    private String previousId;
    private ClassAssignmentProxy proxy;
    private String addInstructorId;
    private Boolean displayExternalId;
    private String defaultTeachingResponsibilityId;
    private String coordinators;
    private List classIds;
    private List classLabels;
    private List classLabelIndents;
    private List instructorUids;
    private List percentShares;
    private List leadFlags;
    private List displayFlags;
    private List times;
    private List rooms;
    private List allowDeletes;
    private List readOnlyClasses;
    private List classHasErrors;
    private List showDisplay;
    private List externalIds;
    private List responsibilities;
    private static final long serialVersionUID = -203441190483028649L;
    protected DynamicListObjectFactory factoryClasses = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String("-");
        }
    };

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        this.op = "";
        this.previousId = null;
        this.nextId = null;
        this.subjectAreaId = new Integer(0);
        this.instrOfferingId = new Long(0L);
        this.instrOfferingName = null;
        this.instrOffrConfigLimit = new Integer(0);
        this.instrOffrConfigId = new Long(0L);
        this.deletedInstrRowNum = null;
        this.displayExternalId = new Boolean(false);
        this.coordinators = null;
        TeachingResponsibility tr = TeachingResponsibility.getDefaultInstructorTeachingResponsibility();
        this.defaultTeachingResponsibilityId = tr == null ? "" : tr.getUniqueId().toString();
        this.proxy = null;
        this.resetLists();
    }

    private void resetLists() {
        this.classIds = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.classLabels = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.classLabelIndents = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.instructorUids = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.percentShares = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.leadFlags = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.displayFlags = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.times = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.rooms = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.allowDeletes = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.readOnlyClasses = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.classHasErrors = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.showDisplay = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.externalIds = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.responsibilities = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
    }

    public ActionErrors validate(ActionMapping arg0, HttpServletRequest arg1) {
        ActionErrors errors = new ActionErrors();
        if (this.op.equals(MSG.actionUpdateClassInstructorsAssignment()) || this.op.equals(MSG.actionNextIO()) || this.op.equals(MSG.actionPreviousIO())) {
            for (int i = 0; i < this.classIds.size(); ++i) {
                String classId = (String)this.classIds.get(i);
                String instrUid = (String)this.instructorUids.get(i);
                String resp = (String)this.responsibilities.get(i);
                for (int j = i + 1; j < this.classIds.size(); ++j) {
                    if (((String)this.instructorUids.get(j)).length() <= 0 || !this.classIds.get(j).equals(classId) || !this.instructorUids.get(j).equals(instrUid) || !this.responsibilities.get(j).equals(resp)) continue;
                    errors.add("duplicateInstructor", new ActionMessage("errors.generic", (Object)MSG.errorDuplicateInstructorForClass()));
                }
            }
        }
        return errors;
    }

    public void addToClasses(Class_ cls, Boolean isReadOnly, String indent) {
        ArrayList<ClassInstructor> instructors = new ArrayList<ClassInstructor>(cls.getClassInstructors());
        Collections.sort(instructors, new InstructorComparator());
        ClassInstructor instructor = null;
        int i = 0;
        do {
            if (instructors.size() > 0) {
                instructor = instructors.get(i);
            }
            if (i == 0) {
                this.classLabels.add(cls.htmlLabel());
                this.showDisplay.add(new Boolean(true));
                this.times.add(cls.buildAssignedTimeHtml(this.getProxy()));
                this.rooms.add(cls.buildAssignedRoomHtml(this.getProxy()));
                this.externalIds.add(cls.getClassSuffix() == null ? "" : cls.getClassSuffix());
            } else {
                this.classLabels.add("");
                this.showDisplay.add(new Boolean(false));
                this.times.add("");
                this.rooms.add("");
                this.externalIds.add("");
            }
            this.classLabelIndents.add(indent);
            this.classIds.add(cls.getUniqueId().toString());
            this.readOnlyClasses.add(isReadOnly.toString());
            this.classHasErrors.add(new Boolean(false));
            this.displayFlags.add(cls.isDisplayInstructor());
            if (instructors.size() > 0) {
                this.instructorUids.add(instructor.getInstructor().getUniqueId().toString());
                this.percentShares.add(instructor.getPercentShare().toString());
                this.leadFlags.add(instructor.isLead());
                this.responsibilities.add(instructor.getResponsibility() == null ? "" : instructor.getResponsibility().getUniqueId().toString());
            } else {
                this.instructorUids.add("");
                this.percentShares.add("100");
                this.leadFlags.add(new Boolean(true));
                this.responsibilities.add(this.getDefaultTeachingResponsibilityId());
            }
            this.allowDeletes.add(new Boolean(instructors.size() > 1));
        } while (++i < instructors.size());
    }

    public void deleteInstructor() {
        int index;
        int firstIndex;
        for (firstIndex = index = Integer.parseInt(this.deletedInstrRowNum); firstIndex > 0 && this.classIds.get(firstIndex - 1).equals(this.classIds.get(index)); --firstIndex) {
        }
        int lastIndex = index;
        while (lastIndex + 1 < this.classIds.size() && this.classIds.get(lastIndex + 1).equals(this.classIds.get(index))) {
            ++lastIndex;
        }
        this.classIds.remove(index);
        this.classLabels.remove(index == firstIndex ? index + 1 : index);
        this.classLabelIndents.remove(index == firstIndex ? index + 1 : index);
        this.classHasErrors.remove(index);
        this.instructorUids.remove(index);
        this.percentShares.remove(index);
        if (index < this.leadFlags.size()) {
            this.leadFlags.remove(index);
        }
        this.responsibilities.remove(index);
        this.times.remove(index == firstIndex ? index + 1 : index);
        this.rooms.remove(index == firstIndex ? index + 1 : index);
        this.allowDeletes.remove(index);
        if (firstIndex + 1 == lastIndex) {
            this.allowDeletes.set(firstIndex, Boolean.FALSE);
        }
        if ((index == firstIndex ? index + 1 : index) < this.displayFlags.size()) {
            this.displayFlags.remove(index == firstIndex ? index + 1 : index);
        }
        this.showDisplay.remove(index == firstIndex ? index + 1 : index);
        this.readOnlyClasses.remove(index);
        this.externalIds.remove(index == firstIndex ? index + 1 : index);
    }

    public void addInstructor() {
        int pos = new Integer(this.getAddInstructorId());
        this.classLabels.add(pos + 1, "");
        this.showDisplay.add(pos + 1, Boolean.FALSE);
        this.times.add(pos + 1, "");
        this.rooms.add(pos + 1, "");
        this.classLabelIndents.add(pos + 1, this.classLabelIndents.get(pos));
        this.classIds.add(pos + 1, this.classIds.get(pos));
        this.readOnlyClasses.add(pos + 1, this.readOnlyClasses.get(pos));
        this.classHasErrors.add(pos + 1, Boolean.FALSE);
        this.displayFlags.add(pos + 1, this.displayFlags.get(pos));
        this.instructorUids.add(pos + 1, "");
        this.percentShares.add(pos + 1, "0");
        this.allowDeletes.set(pos, Boolean.TRUE);
        this.allowDeletes.add(pos + 1, Boolean.TRUE);
        this.externalIds.add(pos + 1, "");
        this.leadFlags.add(pos + 1, this.leadFlags.get(pos));
        this.responsibilities.add(pos + 1, this.defaultTeachingResponsibilityId);
    }

    public void updateClasses() throws Exception {
        InstrOfferingConfig config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(this.instrOffrConfigId);
        boolean assignTeachingRequest = Department.isInstructorSchedulingCommitted(config.getInstructionalOffering().getControllingCourseOffering().getDepartment().getUniqueId());
        Class_DAO cdao = new Class_DAO();
        int i = 0;
        while (i < this.classIds.size()) {
            boolean sameClass;
            if ("true".equals(this.getReadOnlyClasses().get(i))) {
                ++i;
                continue;
            }
            String classId = (String)this.classIds.get(i);
            Class_ c = (Class_)cdao.get(new Long(classId));
            Session hibSession = cdao.getSession();
            Transaction tx = hibSession.beginTransaction();
            HashSet<ClassInstructor> classInstrs = new HashSet<ClassInstructor>(c.getClassInstructors());
            c.setDisplayInstructor(new Boolean("on".equals(this.getDisplayFlags().get(i))));
            while (i < this.classIds.size() && (sameClass = ((String)this.classIds.get(i)).equals(classId))) {
                String instrId = (String)this.getInstructorUids().get(i);
                if (instrId.length() > 0 && !"-".equals(instrId)) {
                    String pctShare = (String)this.getPercentShares().get(i);
                    Boolean lead = new Boolean("on".equals(this.getLeadFlags().get(i)));
                    String responsibility = (String)this.getResponsibilities().get(i);
                    DepartmentalInstructor deptInstr = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(new Long(instrId));
                    BaseClassInstructor classInstr = null;
                    Iterator<Object> j = classInstrs.iterator();
                    while (j.hasNext()) {
                        ClassInstructor adept = (ClassInstructor)j.next();
                        if (!adept.getInstructor().equals(deptInstr)) continue;
                        classInstr = adept;
                        j.remove();
                        break;
                    }
                    if (classInstr == null) {
                        classInstr = new ClassInstructor();
                        deptInstr.getClasses().add((ClassInstructor)classInstr);
                        c.getClassInstructors().add((ClassInstructor)classInstr);
                        classInstr.setClassInstructing(c);
                        classInstr.setInstructor(deptInstr);
                        if (assignTeachingRequest) {
                            for (TeachingClassRequest tcr : c.getTeachingRequests()) {
                                if (!tcr.getAssignInstructor().booleanValue() || !tcr.getTeachingRequest().getAssignedInstructors().contains(deptInstr)) continue;
                                classInstr.setTeachingRequest(tcr.getTeachingRequest());
                                break;
                            }
                        }
                    }
                    classInstr.setLead(lead);
                    classInstr.setPercentShare(new Integer(pctShare));
                    try {
                        classInstr.setResponsibility((TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.valueOf(responsibility)));
                    }
                    catch (NumberFormatException e) {
                        classInstr.setResponsibility(null);
                    }
                    hibSession.saveOrUpdate((Object)deptInstr);
                }
                ++i;
            }
            for (ClassInstructor ci : classInstrs) {
                DepartmentalInstructor instr = ci.getInstructor();
                instr.getClasses().remove(ci);
                c.getClassInstructors().remove(ci);
                hibSession.saveOrUpdate((Object)instr);
                hibSession.delete((Object)ci);
            }
            try {
                hibSession.saveOrUpdate((Object)c);
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
        }
    }

    public void unassignAllInstructors() throws Exception {
        Class_DAO cdao = new Class_DAO();
        for (int i = 0; i < this.classIds.size(); ++i) {
            if ("true".equals(this.getReadOnlyClasses().get(i))) {
                ++i;
                continue;
            }
            String classId = (String)this.classIds.get(i);
            Class_ c = (Class_)cdao.get(new Long(classId));
            Session hibSession = cdao.getSession();
            Transaction tx = hibSession.beginTransaction();
            try {
                c.deleteClassInstructors(hibSession);
                hibSession.saveOrUpdate((Object)c);
                tx.commit();
                continue;
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
        }
        this.getInstructorUids().clear();
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List getAllowDeletes() {
        return this.allowDeletes;
    }

    public void setAllowDeletes(List allowDeletes) {
        this.allowDeletes = allowDeletes;
    }

    public List getClassIds() {
        return this.classIds;
    }

    public void setClassIds(List classIds) {
        this.classIds = classIds;
    }

    public List getClassLabelIndents() {
        return this.classLabelIndents;
    }

    public void setClassLabelIndents(List classLabelIndents) {
        this.classLabelIndents = classLabelIndents;
    }

    public List getClassLabels() {
        return this.classLabels;
    }

    public void setClassLabels(List classLabels) {
        this.classLabels = classLabels;
    }

    public List getDisplayFlags() {
        return this.displayFlags;
    }

    public void setDisplayFlags(List displayFlags) {
        this.displayFlags = displayFlags;
    }

    public List getInstructorUids() {
        return this.instructorUids;
    }

    public void setInstructorUids(List instructorUids) {
        this.instructorUids = instructorUids;
    }

    public List getLeadFlags() {
        return this.leadFlags;
    }

    public void setLeadFlags(List leadFlags) {
        this.leadFlags = leadFlags;
    }

    public List getPercentShares() {
        return this.percentShares;
    }

    public void setPercentShares(List percentShares) {
        this.percentShares = percentShares;
    }

    public List getRooms() {
        return this.rooms;
    }

    public void setRooms(List rooms) {
        this.rooms = rooms;
    }

    public List getTimes() {
        return this.times;
    }

    public void setTimes(List times) {
        this.times = times;
    }

    public Long getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public Long getInstrOffrConfigId() {
        return this.instrOffrConfigId;
    }

    public void setInstrOffrConfigId(Long instrOffrConfigId) {
        this.instrOffrConfigId = instrOffrConfigId;
    }

    public Integer getInstrOffrConfigLimit() {
        return this.instrOffrConfigLimit;
    }

    public void setInstrOffrConfigLimit(Integer instrOffrConfigLimit) {
        this.instrOffrConfigLimit = instrOffrConfigLimit;
    }

    public List getReadOnlyClasses() {
        return this.readOnlyClasses;
    }

    public void setReadOnlyClasses(List readOnlyClasses) {
        this.readOnlyClasses = readOnlyClasses;
    }

    public List getClassHasErrors() {
        return this.classHasErrors;
    }

    public void setClassHasErrors(List classHasErrors) {
        this.classHasErrors = classHasErrors;
    }

    public Integer getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(Integer subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public ClassAssignmentProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(ClassAssignmentProxy proxy) {
        this.proxy = proxy;
    }

    public String getNextId() {
        return this.nextId;
    }

    public void setNextId(String nextId) {
        this.nextId = nextId;
    }

    public String getPreviousId() {
        return this.previousId;
    }

    public void setPreviousId(String previousId) {
        this.previousId = previousId;
    }

    public String getDeletedInstrRowNum() {
        return this.deletedInstrRowNum;
    }

    public void setDeletedInstrRowNum(String deletedInstrRowNum) {
        this.deletedInstrRowNum = deletedInstrRowNum;
    }

    public List getShowDisplay() {
        return this.showDisplay;
    }

    public void setShowDisplay(List showDisplay) {
        this.showDisplay = showDisplay;
    }

    public String getAddInstructorId() {
        return this.addInstructorId;
    }

    public void setAddInstructorId(String addInstructorId) {
        this.addInstructorId = addInstructorId;
    }

    public List getExternalIds() {
        return this.externalIds;
    }

    public void setExternalIds(List externalIds) {
        this.externalIds = externalIds;
    }

    public Boolean getDisplayExternalId() {
        return this.displayExternalId;
    }

    public void setDisplayExternalId(Boolean displayExternalId) {
        this.displayExternalId = displayExternalId;
    }

    public List getResponsibilities() {
        return this.responsibilities;
    }

    public void setResponsibilities(List responsibilities) {
        this.responsibilities = responsibilities;
    }

    public String getDefaultTeachingResponsibilityId() {
        return this.defaultTeachingResponsibilityId;
    }

    public void setDefaultTeachingResponsibilityId(String defaultTeachingResponsibilityId) {
        this.defaultTeachingResponsibilityId = defaultTeachingResponsibilityId;
    }

    public String getCoordinators() {
        return this.coordinators;
    }

    public void setCoordinators(String coordinators) {
        this.coordinators = coordinators;
    }
}

