/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;

public class ApplicationConfigForm
extends ActionForm {
    private static final long serialVersionUID = 4677371360700536609L;
    private String op;
    private String key;
    private String value;
    private String description;
    private boolean allSessions;
    private Long[] sessions = null;
    private boolean showAll = false;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.key == null || this.key.trim().length() == 0) {
            errors.add("key", new ActionMessage("errors.required", (Object)""));
        }
        if (this.value == null) {
            this.value = "";
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.op = "list";
        this.key = "";
        this.value = "";
        this.description = "";
        this.allSessions = false;
        this.sessions = null;
        this.showAll = false;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public boolean isAllSessions() {
        return this.allSessions;
    }

    public void setAllSessions(boolean allSessions) {
        this.allSessions = allSessions;
    }

    public Set<Session> getListSessions() {
        return new TreeSet<Session>(SessionDAO.getInstance().findAll());
    }

    public Long[] getSessions() {
        return this.sessions;
    }

    public void setSessions(Long[] sessions) {
        this.sessions = sessions;
    }

    public String getType() {
        ApplicationProperty p = ApplicationProperty.fromKey(this.key);
        if (p == null) {
            return null;
        }
        Class type = p.type();
        if (type == null || type.equals(String.class)) {
            return null;
        }
        if (type.equals(Class.class) && p.implementation() != null) {
            if (p.implementation().isInterface()) {
                return "class implementing " + p.implementation().getSimpleName();
            }
            return "class extending " + p.implementation().getSimpleName();
        }
        return type.getSimpleName().toLowerCase();
    }

    public String getValues() {
        ApplicationProperty p = ApplicationProperty.fromKey(this.key);
        if (p == null) {
            return null;
        }
        String[] vals = p.availableValues();
        if (vals != null && vals.length > 0) {
            String ret = "";
            for (int i = 0; i < vals.length; ++i) {
                if (i > 0) {
                    ret = ret + ", ";
                }
                ret = ret + vals[i];
            }
            return ret;
        }
        return null;
    }

    public String getDefault() {
        ApplicationProperty p = ApplicationProperty.fromKey(this.key);
        return p != null ? p.defaultValue() : null;
    }

    public boolean getShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }
}

