/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.io.text.ICalWriter;
import biweekly.property.CalendarScale;
import biweekly.property.Method;
import biweekly.property.Status;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.unitime.commons.CalendarVTimeZoneGenerator;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventDetailBackend;
import org.unitime.timetable.export.events.EventsExportEventsToICal;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameFormat;

public class EventEmail {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static Map<Long, String> sMessageId = new Hashtable<Long, String>();
    private static Logger sLog = Logger.getLogger(EventEmail.class);
    private EventInterface.SaveOrApproveEventRpcRequest iRequest = null;
    private EventInterface.SaveOrApproveEventRpcResponse iResponse = null;
    private DataSource iAttachment = null;
    private InternetAddress iReplyTo = null;

    public EventEmail(EventInterface.SaveOrApproveEventRpcRequest request, EventInterface.SaveOrApproveEventRpcResponse response, DataSource attachment, InternetAddress replyTo) {
        this.iRequest = request;
        this.iResponse = response;
        this.iAttachment = attachment;
        this.iReplyTo = replyTo;
    }

    public EventEmail(EventInterface.SaveOrApproveEventRpcRequest request, EventInterface.SaveOrApproveEventRpcResponse response) {
        this(request, response, null, null);
    }

    public EventEmail() {
    }

    public EventInterface.SaveOrApproveEventRpcRequest request() {
        return this.iRequest;
    }

    public EventInterface.SaveOrApproveEventRpcResponse response() {
        return this.iResponse;
    }

    public DataSource attachment() {
        return this.iAttachment;
    }

    public InternetAddress replyTo() {
        return this.iReplyTo;
    }

    public void send(SessionContext context) throws UnsupportedEncodingException, MessagingException {
        try {
            String messageId;
            Long l;
            FileItem fileItem;
            if (!this.request().isEmailConfirmation()) {
                return;
            }
            if (ApplicationProperty.EmailConfirmationEvents.isFalse()) {
                this.response().info(MESSAGES.emailDisabled());
                return;
            }
            Email email = Email.createEmail();
            if (this.event().hasContact() && this.event().getContact().getEmail() != null && !this.event().getContact().getEmail().isEmpty()) {
                email.addRecipient(this.event().getContact().getEmail(), this.event().getContact().getName(MESSAGES));
            }
            if (this.event().hasAdditionalContacts()) {
                for (EventInterface.ContactInterface contactInterface : this.event().getAdditionalContacts()) {
                    if (contactInterface.getEmail() == null || contactInterface.getEmail().isEmpty()) continue;
                    email.addRecipient(contactInterface.getEmail(), contactInterface.getName(MESSAGES));
                }
            }
            if (this.event().hasSponsor() && this.event().getSponsor().hasEmail()) {
                email.addRecipientCC(this.event().getSponsor().getEmail(), this.event().getSponsor().getName());
            }
            if (this.event().hasEmail()) {
                Iterator<EventInterface.ContactInterface> suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                for (String address : this.event().getEmail().split("[\n,]")) {
                    if (address.trim().isEmpty()) continue;
                    if (suffix != null && address.indexOf(64) < 0) {
                        email.addRecipientCC(address.trim() + suffix, null);
                        continue;
                    }
                    email.addRecipientCC(address.trim(), null);
                }
            }
            if (this.event().hasInstructors() && ApplicationProperty.EmailConfirmationEventInstructors.isTrue()) {
                for (EventInterface.ContactInterface contactInterface : this.event().getInstructors()) {
                    if (contactInterface.getEmail() == null || contactInterface.getEmail().isEmpty()) continue;
                    email.addRecipientCC(contactInterface.getEmail(), contactInterface.getName(MESSAGES));
                }
            }
            if (this.event().hasCoordinators() && ApplicationProperty.EmailConfirmationEventCoordinators.isTrue()) {
                for (EventInterface.ContactInterface contactInterface : this.event().getCoordinators()) {
                    if (contactInterface.getEmail() == null || contactInterface.getEmail().isEmpty()) continue;
                    email.addRecipientCC(contactInterface.getEmail(), contactInterface.getName(MESSAGES));
                }
            }
            TreeSet<EventInterface.EventServiceProviderInterface> providers = new TreeSet<EventInterface.EventServiceProviderInterface>();
            if (this.response().hasRemovedServices() && (this.event().hasMeetingsOfStatus(EventInterface.ApprovalStatus.Approved) || this.response().hasCancelledMeetings())) {
                providers.addAll(this.response().getRemovedServices());
            }
            if (this.response().hasAddedServices() && this.event().hasMeetingsOfStatus(EventInterface.ApprovalStatus.Approved)) {
                providers.addAll(this.response().getAddedServices());
            }
            if (this.event().hasRequestedServices() && (this.request().getOperation() == EventInterface.SaveOrApproveEventRpcRequest.Operation.APPROVE || this.request().getOperation() == EventInterface.SaveOrApproveEventRpcRequest.Operation.CANCEL)) {
                providers.addAll(this.event().getRequestedServices());
            }
            if (this.event().hasRequestedServices() && this.response().hasCreatedMeetings()) {
                for (EventInterface.MeetingInterface meeting : this.response().getCreatedMeetings()) {
                    if (!meeting.isApproved()) continue;
                    providers.addAll(this.event().getRequestedServices());
                    break;
                }
            }
            if (this.event().hasRequestedServices() && this.response().hasCancelledMeetings()) {
                providers.addAll(this.event().getRequestedServices());
            }
            for (EventInterface.EventServiceProviderInterface provider : providers) {
                if (!provider.hasEmail()) continue;
                email.addRecipientCC(provider.getEmail(), provider.getLabel());
            }
            if (ApplicationProperty.EmailConfirmationEventManagers.isTrue()) {
                HashSet<Long> hashSet = new HashSet<Long>();
                if (this.event().hasMeetings()) {
                    for (EventInterface.MeetingInterface m : this.event().getMeetings()) {
                        if (!m.hasLocation()) continue;
                        hashSet.add(m.getLocation().getId());
                    }
                }
                if (this.response().hasDeletedMeetings()) {
                    for (EventInterface.MeetingInterface m : this.response().getDeletedMeetings()) {
                        if (!m.hasLocation()) continue;
                        hashSet.add(m.getLocation().getId());
                    }
                }
                org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
                NameFormat nf = NameFormat.fromReference(context.getUser().getProperty(UserProperty.NameFormat));
                for (TimetableManager m : hibSession.createQuery("select distinct m from Location l inner join l.eventDepartment.timetableManagers m inner join m.managerRoles r where l.uniqueId in :locationIds and m.emailAddress is not null and r.receiveEmails = true and :permission in elements (r.role.rights)").setParameterList("locationIds", hashSet, (Type)new LongType()).setString("permission", Right.EventLookupContact.name()).list()) {
                    email.addRecipientCC(m.getEmailAddress(), nf.format(m));
                }
            }
            if (this.replyTo() != null) {
                email.setReplyTo(this.replyTo().getAddress(), this.replyTo().getPersonal());
            } else if (context != null && context.isAuthenticated() && context.getUser().getEmail() != null) {
                email.setReplyTo(context.getUser().getEmail(), context.getUser().getName());
            } else {
                email.setReplyTo(this.event().getContact().getEmail(), this.event().getContact().getName(MESSAGES));
            }
            if (this.event().getId() != null && ApplicationProperty.InboundEmailsEnabled.isTrue() && ApplicationProperty.InboundEmailsReplyToAddress.value() != null) {
                email.setSubject("[EVENT-" + Long.toHexString(this.event().getId()) + "] " + this.event().getName() + " (" + this.event().getType().getName(CONSTANTS) + ")");
                email.addReplyTo(ApplicationProperty.InboundEmailsReplyToAddress.value(), ApplicationProperty.InboundEmailsReplyToAddressName.value());
            } else {
                email.setSubject(this.event().getName() + " (" + this.event().getType().getName(CONSTANTS) + ")");
            }
            if (context != null && (fileItem = (FileItem)context.getAttribute(SessionAttribute.LastUploadedFile)) != null) {
                email.addAttachment(new DataSource(){

                    public OutputStream getOutputStream() throws IOException {
                        throw new IOException("No output stream.");
                    }

                    public String getName() {
                        return fileItem.getName();
                    }

                    public InputStream getInputStream() throws IOException {
                        return fileItem.getInputStream();
                    }

                    public String getContentType() {
                        return fileItem.getContentType();
                    }
                });
            }
            if (this.attachment() != null) {
                email.addAttachment(this.attachment());
            }
            if (ApplicationProperty.EmailConfirmationIncludeCalendar.isTrue()) {
                try {
                    final String string = this.icalendar();
                    if (string != null) {
                        email.addAttachment(new DataSource(){

                            public OutputStream getOutputStream() throws IOException {
                                throw new IOException("No output stream.");
                            }

                            public String getName() {
                                return "event.ics";
                            }

                            public InputStream getInputStream() throws IOException {
                                return new ByteArrayInputStream(string.getBytes("UTF-8"));
                            }

                            public String getContentType() {
                                return "text/calendar; charset=UTF-8";
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    sLog.warn((Object)("Failed to export calendar: " + exception.getMessage()));
                }
            }
            email.setHTML(this.message());
            Long l2 = l = this.response().hasEventWithId() ? this.response().getEvent().getId() : this.request().getEvent().getId();
            if (l != null && (messageId = sMessageId.get(l)) != null) {
                email.setInReplyTo(messageId);
            }
            email.send();
            if (l != null && (messageId = email.getMessageId()) != null) {
                sMessageId.put(l, messageId);
            }
            this.response().info(MESSAGES.infoConfirmationEmailSent(this.event().hasContact() ? this.event().getContact().getName(MESSAGES) : "?"));
        }
        catch (Exception e) {
            this.response().error(MESSAGES.failedToSendConfirmationEmail(e.getMessage()));
            sLog.warn((Object)MESSAGES.failedToSendConfirmationEmail(e.getMessage()), (Throwable)e);
        }
    }

    private EventInterface event() {
        return this.response().getEvent() != null ? this.response().getEvent() : this.request().getEvent();
    }

    private String subject() {
        switch (this.request().getOperation()) {
            case CREATE: {
                return MESSAGES.emailSubjectCreate(this.event().getName());
            }
            case UPDATE: {
                return MESSAGES.emailSubjectUpdate(this.event().getName());
            }
            case DELETE: {
                return MESSAGES.emailSubjectDelete(this.event().getName());
            }
            case APPROVE: {
                return MESSAGES.emailSubjectApprove(this.event().getName());
            }
            case INQUIRE: {
                return MESSAGES.emailSubjectInquire(this.event().getName());
            }
            case REJECT: {
                return MESSAGES.emailSubjectReject(this.event().getName());
            }
            case CANCEL: {
                return MESSAGES.emailSubjectCancel(this.event().getName());
            }
        }
        return MESSAGES.emailSubjectUpdate(this.event().getName());
    }

    private String message() throws IOException, TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
        cfg.setClassForTemplateLoading(EventEmail.class, "");
        cfg.setLocale(Localization.getJavaLocale());
        cfg.setOutputEncoding("utf-8");
        Template template = cfg.getTemplate("confirmation.ftl");
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("msg", MESSAGES);
        input.put("const", CONSTANTS);
        input.put("subject", this.subject());
        input.put("event", this.event());
        input.put("eventGridStartDay", ApplicationProperty.EventGridStartDay.intValue());
        input.put("operation", this.request().getOperation() == null ? "NONE" : this.request().getOperation().name());
        if (this.response().hasCreatedMeetings()) {
            input.put("created", EventInterface.getMultiMeetings(this.response().getCreatedMeetings(), true, false));
        }
        if (this.response().hasDeletedMeetings()) {
            input.put("deleted", EventInterface.getMultiMeetings(this.response().getDeletedMeetings(), true, false));
        }
        if (this.response().hasCancelledMeetings()) {
            input.put("cancelled", EventInterface.getMultiMeetings(this.response().getCancelledMeetings(), true, false));
        }
        if (this.response().hasUpdatedMeetings()) {
            input.put("updated", EventInterface.getMultiMeetings(this.response().getUpdatedMeetings(), true, false));
        }
        if (this.request().hasMessage()) {
            input.put("message", this.request().getMessage());
        }
        if (this.request().getEvent().getId() != null) {
            if (this.event().hasMeetings()) {
                input.put("meetings", EventInterface.getMultiMeetings(this.event().getMeetings(), true, false));
            } else {
                input.put("meetings", new TreeSet());
            }
        }
        input.put("version", MESSAGES.pageVersion(Constants.getVersion(), Constants.getReleaseDate()));
        input.put("ts", new Date());
        input.put("link", ApplicationProperty.UniTimeUrl.value());
        if (this.iRequest.hasSessionId()) {
            Session session = (Session)SessionDAO.getInstance().get(this.iRequest.getSessionId());
            if (session != null) {
                input.put("sessionId", session.getReference());
            } else {
                input.put("sessionId", this.iRequest.getSessionId());
            }
        }
        StringWriter s = new StringWriter();
        template.process(input, (Writer)new PrintWriter(s));
        s.flush();
        s.close();
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String icalendar() throws IOException {
        ICalendar ical = new ICalendar();
        ical.setVersion(ICalVersion.V2_0);
        ical.setCalendarScale(CalendarScale.gregorian());
        ical.setMethod(new Method("PUBLISH"));
        ical.setExperimentalProperty("X-WR-CALNAME", "UniTime Schedule");
        ical.setExperimentalProperty("X-WR-TIMEZONE", TimeZone.getDefault().getID());
        ical.setProductId("-//UniTime LLC/UniTime " + Constants.getVersion() + " Events//EN");
        boolean exp = new EventsExportEventsToICal().print(ical, this.response().hasEventWithId() && this.response().getEvent().hasMeetings() ? this.response().getEvent() : this.request().getEvent(), (Status)(this.response().hasEventWithId() && this.response().getEvent().hasMeetings() ? null : Status.cancelled()));
        if (exp) {
            StringWriter ret = new StringWriter();
            ICalWriter writer = new ICalWriter(ret, ICalVersion.V2_0);
            try {
                writer.getTimezoneInfo().setGenerator(new CalendarVTimeZoneGenerator());
                writer.getTimezoneInfo().setDefaultTimeZone(TimeZone.getDefault());
            }
            catch (IllegalArgumentException e) {
                sLog.warn((Object)("Failed to set default time zone: " + e.getMessage()));
            }
            try {
                writer.write(ical);
                writer.flush();
            }
            finally {
                writer.close();
            }
            return ret.toString();
        }
        return null;
    }

    public static void eventExpired(Event cancelledEvent, Set<Meeting> cancelledMeetings) throws Exception {
        if (ApplicationProperty.EmailConfirmationEvents.isFalse()) {
            return;
        }
        Session session = cancelledEvent.getSession();
        if (session == null) {
            for (Meeting m : cancelledEvent.getMeetings()) {
                if (m.getLocation() == null) continue;
                session = m.getLocation().getSession();
                break;
            }
        }
        EventInterface event = EventDetailBackend.getEventDetail(session, cancelledEvent, null);
        EventInterface.ApproveEventRpcRequest request = new EventInterface.ApproveEventRpcRequest();
        request.setOperation(EventInterface.SaveOrApproveEventRpcRequest.Operation.CANCEL);
        request.setMessage(MESSAGES.noteEventExpired());
        request.setEmailConfirmation(true);
        request.setSessionId(session == null ? null : session.getUniqueId());
        request.setEvent(event);
        EventInterface.SaveOrApproveEventRpcResponse response = new EventInterface.SaveOrApproveEventRpcResponse();
        response.setEvent(event);
        for (Meeting metting : cancelledMeetings) {
            for (EventInterface.MeetingInterface m : event.getMeetings()) {
                if (!m.getId().equals(metting.getUniqueId())) continue;
                response.addUpdatedMeeting(m);
            }
        }
        new EventEmail(request, response).send(null);
    }

    public static void eventUpdated(Event updatedEvent, String message, InternetAddress replyTo, DataSource attachment) throws Exception {
        if (ApplicationProperty.EmailConfirmationEvents.isFalse()) {
            return;
        }
        Session session = updatedEvent.getSession();
        if (session == null) {
            for (Meeting m : updatedEvent.getMeetings()) {
                if (m.getLocation() == null) continue;
                session = m.getLocation().getSession();
                break;
            }
        }
        EventInterface event = EventDetailBackend.getEventDetail(session, updatedEvent, null);
        EventInterface.ApproveEventRpcRequest request = new EventInterface.ApproveEventRpcRequest();
        request.setOperation(EventInterface.SaveOrApproveEventRpcRequest.Operation.UPDATE);
        if (message != null && !message.isEmpty()) {
            request.setMessage(message);
        }
        request.setEmailConfirmation(true);
        request.setSessionId(session == null ? null : session.getUniqueId());
        request.setEvent(event);
        EventInterface.SaveOrApproveEventRpcResponse response = new EventInterface.SaveOrApproveEventRpcResponse();
        response.setEvent(event);
        new EventEmail(request, response, attachment, replyTo).send(null);
    }
}

