/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.DateUtils;

@GwtRpcImplements(value=EventInterface.RequestSessionDetails.class)
public class DateSelectorBackend
extends EventAction<EventInterface.RequestSessionDetails, GwtRpcResponseList<EventInterface.SessionMonth>> {
    @Override
    public GwtRpcResponseList<EventInterface.SessionMonth> execute(EventInterface.RequestSessionDetails command, EventAction.EventContext context) {
        Session session = (Session)SessionDAO.getInstance().get(command.getSessionId());
        return DateSelectorBackend.listMonths(session, context.hasPermission(Right.EventDateMappings), context);
    }

    public static GwtRpcResponseList<EventInterface.SessionMonth> listMonths(Session session, boolean includeEventDateMappings, EventAction.HasPastOrOutside check) {
        return DateSelectorBackend.listMonths(session, includeEventDateMappings, check, 0, true);
    }

    public static GwtRpcResponseList<EventInterface.SessionMonth> listMonths(Session session, boolean includeEventDateMappings, EventAction.HasPastOrOutside check, int extraMonths, boolean disableOutsideEventDates) {
        return DateSelectorBackend.listMonths(session, includeEventDateMappings, check, extraMonths, extraMonths, disableOutsideEventDates);
    }

    public static GwtRpcResponseList<EventInterface.SessionMonth> listMonths(Session session, boolean includeEventDateMappings, EventAction.HasPastOrOutside check, int monthsBefore, int monthsAfter, boolean disableOutsideEventDates) {
        GwtRpcResponseList<EventInterface.SessionMonth> response = new GwtRpcResponseList<EventInterface.SessionMonth>();
        Calendar calendar = Calendar.getInstance();
        ArrayList<Date> finals = new ArrayList<Date>();
        for (Object dateOffset : SessionDAO.getInstance().getSession().createQuery("select distinct dateOffset from ExamPeriod where session.uniqueId = :sessionId and examType.type = :finalType and examType.highlightInEvents = true").setLong("sessionId", session.getUniqueId().longValue()).setInteger("finalType", 0).setCacheable(true).list()) {
            calendar.setTime(session.getExamBeginDate());
            calendar.add(6, ((Number)dateOffset).intValue());
            finals.add(calendar.getTime());
        }
        ArrayList<Date> midterms = new ArrayList<Date>();
        for (Number dateOffset : SessionDAO.getInstance().getSession().createQuery("select distinct dateOffset from ExamPeriod where session.uniqueId = :sessionId and examType.type = :midtermType and examType.highlightInEvents = true").setLong("sessionId", session.getUniqueId().longValue()).setInteger("midtermType", 1).setCacheable(true).list()) {
            calendar.setTime(session.getExamBeginDate());
            calendar.add(6, dateOffset.intValue());
            midterms.add(calendar.getTime());
        }
        EventDateMapping.Class2EventDateMap class2eventDateMap = includeEventDateMappings ? EventDateMapping.getMapping(session.getUniqueId()) : null;
        int firstDayOfWeek = ApplicationProperty.EventGridStartDay.intValue();
        int firstDay = 2;
        switch (firstDayOfWeek) {
            case 0: {
                firstDay = 2;
                break;
            }
            case 1: {
                firstDay = 3;
                break;
            }
            case 2: {
                firstDay = 4;
                break;
            }
            case 3: {
                firstDay = 5;
                break;
            }
            case 4: {
                firstDay = 6;
                break;
            }
            case 5: {
                firstDay = 7;
                break;
            }
            case 6: {
                firstDay = 1;
            }
        }
        for (int month = session.getStartMonth() - monthsBefore; month <= session.getEndMonth() + monthsAfter; ++month) {
            calendar.setTime(DateUtils.getDate(1, month, session.getSessionStartYear()));
            EventInterface.SessionMonth m = new EventInterface.SessionMonth(calendar.get(1), calendar.get(2));
            int nrDays = calendar.getActualMaximum(5);
            for (int i = 0; i < nrDays; ++i) {
                switch (session.getHoliday(1 + i, month)) {
                    case 2: {
                        m.setFlag(i, EventInterface.SessionMonth.Flag.BREAK);
                        break;
                    }
                    case 1: {
                        m.setFlag(i, EventInterface.SessionMonth.Flag.HOLIDAY);
                    }
                }
                if (DateSelectorBackend.compare(calendar.getTime(), session.getSessionBeginDateTime()) == 0) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.START);
                }
                if (DateSelectorBackend.compare(calendar.getTime(), session.getClassesEndDateTime()) == 0) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.END);
                }
                if (DateSelectorBackend.compare(calendar.getTime(), session.getSessionBeginDateTime()) >= 0 && DateSelectorBackend.compare(calendar.getTime(), session.getClassesEndDateTime()) <= 0) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.CLASSES);
                }
                for (Date finalDate : finals) {
                    if (DateSelectorBackend.compare(calendar.getTime(), finalDate) != 0) continue;
                    m.setFlag(i, EventInterface.SessionMonth.Flag.FINALS);
                }
                for (Date midtermDate : midterms) {
                    if (DateSelectorBackend.compare(calendar.getTime(), midtermDate) != 0) continue;
                    m.setFlag(i, EventInterface.SessionMonth.Flag.MIDTERMS);
                }
                if (disableOutsideEventDates && (DateSelectorBackend.compare(calendar.getTime(), session.getEventBeginDate()) < 0 || DateSelectorBackend.compare(calendar.getTime(), session.getEventEndDate()) > 0)) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.DISABLED);
                } else if (check.isPastOrOutside(calendar.getTime())) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.PAST);
                }
                int dayInv = (7 + calendar.get(7) - firstDay) % 7;
                if (dayInv >= 5) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.WEEKEND);
                }
                if (class2eventDateMap != null && class2eventDateMap.hasClassDate(calendar.getTime())) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.DATE_MAPPING_CLASS);
                }
                if (class2eventDateMap != null && class2eventDateMap.hasEventDate(calendar.getTime())) {
                    m.setFlag(i, EventInterface.SessionMonth.Flag.DATE_MAPPING_EVENT);
                }
                calendar.add(6, 1);
            }
            response.add(m);
        }
        return response;
    }

    private static int compare(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        int cmp = DateSelectorBackend.compare(c1, c2, 1);
        if (cmp != 0) {
            return cmp;
        }
        return DateSelectorBackend.compare(c1, c2, 6);
    }

    private static int compare(Calendar c1, Calendar c2, int field) {
        return new Integer(c1.get(field)).compareTo(c2.get(field));
    }
}

