/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;

public class ScriptImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        try {
            this.beginTransaction();
            if (root.getName().equalsIgnoreCase("script")) {
                this.importScript(root);
            } else if (root.getName().equalsIgnoreCase("scripts")) {
                Iterator i = root.elementIterator("script");
                while (i.hasNext()) {
                    this.importScript((Element)i.next());
                }
            } else {
                throw new Exception("Given XML file is not a script file.");
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected void importScript(Element scriptEl) {
        String name = scriptEl.attributeValue("name");
        if (name == null) {
            this.error("String name is not provided.");
            return;
        }
        Script script = (Script)this.getHibSession().createQuery("from Script where name = :name").setString("name", name).uniqueResult();
        if (script == null) {
            script = new Script();
            script.setParameters(new HashSet<ScriptParameter>());
            script.setName(name);
        }
        script.setEngine(scriptEl.attributeValue("engine", "ECMAScript"));
        script.setPermission(scriptEl.attributeValue("permission"));
        HashMap<String, ScriptParameter> params = new HashMap<String, ScriptParameter>();
        for (ScriptParameter parameter : script.getParameters()) {
            params.put(parameter.getName(), parameter);
        }
        Iterator i = scriptEl.elementIterator("parameter");
        while (i.hasNext()) {
            Element paramEl = (Element)i.next();
            String pName = paramEl.attributeValue("name");
            if (pName == null) continue;
            ScriptParameter parameter = (ScriptParameter)params.remove(pName);
            if (parameter == null) {
                parameter = new ScriptParameter();
                parameter.setName(pName);
                parameter.setScript(script);
                script.getParameters().add(parameter);
            }
            parameter.setLabel(paramEl.attributeValue("label"));
            parameter.setType(paramEl.attributeValue("type"));
            parameter.setDefaultValue(paramEl.attributeValue("default"));
        }
        for (ScriptParameter parameter : params.values()) {
            this.getHibSession().delete((Object)parameter);
            script.getParameters().remove(parameter);
        }
        Element bodyEl = scriptEl.element("body");
        if (bodyEl != null) {
            script.setScript(bodyEl.getText());
        } else {
            script.setScript(null);
        }
        Element descriptionEl = scriptEl.element("description");
        if (descriptionEl != null) {
            script.setDescription(descriptionEl.getText());
        } else {
            script.setDescription(null);
        }
        this.getHibSession().saveOrUpdate((Object)script);
    }
}

