/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.CourseCatalog;
import org.unitime.timetable.model.CourseSubpartCredit;
import org.unitime.timetable.model.Session;

public class CourseCatalogImport
extends BaseImport {
    private static final int MIN_CREDIT = 0;
    private static final int MAX_CREDIT = 16;

    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("courseCatalog")) {
            throw new Exception("Given XML file is not a Course Catalog load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                CourseCatalog catalog = new CourseCatalog();
                catalog.setCourseNumber(element.attributeValue("courseNumber"));
                catalog.setApprovalType(element.attributeValue("approvalType"));
                catalog.setExternalUniqueId(element.attributeValue("externalId"));
                catalog.setPermanentId(element.attributeValue("permanentId"));
                catalog.setPreviousCourseNumber(element.attributeValue("previousCourseNumber"));
                catalog.setPreviousSubject(element.attributeValue("previousSubject"));
                catalog.setSession(session);
                catalog.setSubject(element.attributeValue("subject"));
                catalog.setTitle(element.attributeValue("title"));
                Element credit = element.element("courseCredit");
                if (credit == null) {
                    this.error("Course credit not provided for " + catalog.getSubject() + " " + catalog.getCourseNumber() + ".");
                    continue;
                }
                catalog.setCreditFormat(credit.attributeValue("creditFormat"));
                catalog.setCreditType(credit.attributeValue("creditType"));
                catalog.setCreditUnitType(credit.attributeValue("creditUnitType"));
                catalog.setFractionalCreditAllowed(Boolean.valueOf(credit.attributeValue("fractionalCreditAllowed")));
                String minCredit = credit.attributeValue("fixedCredit");
                if (minCredit != null) {
                    catalog.setFixedMinimumCredit(Float.valueOf(Float.parseFloat(minCredit)));
                } else {
                    minCredit = credit.attributeValue("minimumCredit");
                    if (minCredit != null) {
                        catalog.setFixedMinimumCredit(Float.valueOf(Float.parseFloat(minCredit)));
                    } else {
                        catalog.setFixedMinimumCredit(new Float(0.0f));
                    }
                    String maxCredit = credit.attributeValue("maximumCredit");
                    if (maxCredit != null) {
                        catalog.setMaximumCredit(Float.valueOf(Float.parseFloat(maxCredit)));
                    } else {
                        catalog.setMaximumCredit(new Float(16.0f));
                    }
                }
                this.getHibSession().saveOrUpdate((Object)catalog);
                this.loadCredits(element, catalog);
                this.getHibSession().saveOrUpdate((Object)catalog);
                this.flushIfNeeded(false);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    private void loadCredits(Element course, CourseCatalog catalog) throws Exception {
        Iterator it = course.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (element.getName().equals("courseCredit")) continue;
            CourseSubpartCredit credit = new CourseSubpartCredit();
            credit.setCourseCatalog(catalog);
            credit.setCreditFormat(element.attributeValue("creditFormat"));
            credit.setCreditType(element.attributeValue("creditType"));
            credit.setCreditUnitType(element.attributeValue("creditUnitType"));
            String minCredit = element.attributeValue("fixedCredit");
            if (minCredit != null) {
                credit.setFixedMinimumCredit(Float.valueOf(Float.parseFloat(minCredit)));
            } else {
                minCredit = element.attributeValue("minimumCredit");
                if (minCredit != null) {
                    credit.setFixedMinimumCredit(Float.valueOf(Float.parseFloat(minCredit)));
                } else {
                    credit.setFixedMinimumCredit(new Float(0.0f));
                }
                String maxCredit = element.attributeValue("maximumCredit");
                if (maxCredit != null) {
                    credit.setMaximumCredit(Float.valueOf(Float.parseFloat(maxCredit)));
                } else {
                    credit.setMaximumCredit(new Float(16.0f));
                }
            }
            credit.setFractionalCreditAllowed(Boolean.valueOf(element.attributeValue("fractionalCreditAllowed")));
            credit.setSubpartId(element.attributeValue("subpartId"));
            catalog.addTosubparts(credit);
        }
    }
}

